import requests
import prodat
import ctypes
import json
import os
from windialog import *
from MPySqlParse import PySqlParse
Sql = PySqlParse()

class ImnooArticleAPI:
    def __init__(self, base_url, token):
        self.base_url = base_url
        self.headers_json = {
            "Authorization": f"Bearer {token}",
            "Content-Type": "application/json"
        }
        self.headers = {
            "Authorization": f"Bearer {token}"
        }

    def create_article(self, article_data, prodat_ak_nr):
        url = f"{self.base_url}/api/v2/articles"
        response = requests.post(url, json=article_data, headers=self.headers_json)

        if response.status_code == 201:
            data = response.json()
            article_key = data.get("articleKey")
            # Artikelmapping imnoo <-> Prodat schreiben
            prodat.DBExecute(f"INSERT INTO x_10_interfaces.interfaces_mapping_id ( imi_connector, imi_table, imi_column, imi_value, imi_parameter_id, imi_parameter_value ) VALUES ('imnoo-API', 'art', 'ak_nr', {Sql.escape_string(prodat_ak_nr)}, 'articleKey', '{article_key}')")
            # Materialform als Eigenschaft schreiben
            prodat.DBExecute(f"""SELECT trecnoparam.set('imnoo.materialshape'::varchar, dbrid::varchar, '{article_data['MaterialShape']}'::varchar)
                                   FROM art
                                  WHERE ak_nr = {Sql.escape_string(prodat_ak_nr)}""")
            return article_key
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def upload_3d_model(self, article_key, file_path=""):
        url = f"{self.base_url}/api/v2/articles/{article_key}/files/3d-model"

        if file_path == "":
            # wenn kein Pfad angegeben wurde muss Datei ausgewählt werden
            filetypes = (("3D Modell", "*.stp;*.step;*.igs;*.iges"),) # nur CAD-Files zulassen
            title   = "Datei des 3D Modells auswählen" # explorer window title (in title bar)
            #initdir = "c:\\users\\john\\documents" # default folder where start the explorer
            ok_text = "3D Modell übernehmen" # text on the OK button
            file_text = "Datei auswählen" # text next to the text-field
            file_path = getfile(0, *filetypes, title = title, multi = False, ok_text = ok_text, file_text = file_text)[0]

        files = {"file": (os.path.basename(file_path), open(file_path, "rb"), 'multipart/form-data')}
        response = requests.put(url, files=files, headers=self.headers)

        if response.status_code == 204:
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def delete_3d_model(self, article_key):
        url = f"{self.base_url}/api/v2/articles/{article_key}/files/3d-model"
        response = requests.delete(url, headers=self.headers_json)

        if response.status_code == 204:
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def upload_2d_model(self, article_key, file_path="", autofillArticleWithDrawingData=True):
        url = f"{self.base_url}/api/v2/articles/{article_key}/files/2d-drawing"

        if file_path == "":
            # wenn kein Pfad angegeben wurde muss Datei ausgewählt werden
            filetypes = (("Zeichnung", "*.pdf;*.dwg;*.dxf;*.png;*.jpg;*.tif;*.tiff"),) # nur Zeichnungen zulassen
            title   = "Zeichnung auswählen" # explorer window title (in title bar)
            #initdir = "c:\\users\\john\\documents" # default folder where start the explorer
            ok_text = "Zeichnung übernehmen" # text on the OK button
            file_text = "Datei auswählen" # text next to the text-field
            file_path = getfile(0, *filetypes, title = title, multi = False, ok_text = ok_text, file_text = file_text)[0]

        files = {"file": (os.path.basename(file_path), open(file_path, "rb"), 'multipart/form-data')}
        params = {
            "autofillArticleWithDrawingData": autofillArticleWithDrawingData
        }
        response = requests.put(url, files=files, params=params, headers=self.headers)

        if response.status_code == 204:
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def delete_2d_model(self, article_key):
        url = f"{self.base_url}/api/v2/articles/{article_key}/files/2d-drawing"
        response = requests.delete(url, headers=self.headers_json)

        if response.status_code == 204:
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def get_article_info(self, article_key):
        url = f"{self.base_url}/api/v2/articles/{article_key}"
        response = requests.get(url, headers=self.headers_json)

        if response.status_code == 200:
            data = response.json()
            return data
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def start_estimation(self, article_key, machine_key, quantity):
        url = f"{self.base_url}/api/v2/articles/{article_key}/estimates"
        data = {
            "machineKey": machine_key,
            "quantity": quantity
        }
        response = requests.post(url, json=data, headers=self.headers_json)

        if response.status_code == 200:
            data = response.json()
            estimation_id = data.get("estimationId")
            # Schätzung zum Artikel ablegen
            dbrid = prodat.DBSelect(f"""INSERT INTO x_10_interfaces.interfaces_mapping_id ( imi_connector, imi_table, imi_column, imi_value, imi_parameter_id, imi_parameter_value )
                                        VALUES ('imnoo-API', 'art', 'ak_nr', (SELECT imi_value
                                                                                FROM x_10_interfaces.interfaces_mapping_id
                                                                               WHERE imi_connector = 'imnoo-API'
                                                                                 AND imi_table = 'art'::regclass
                                                                                 AND imi_column = 'ak_nr'
                                                                                 AND imi_parameter_id = 'articleKey'
                                                                                 AND imi_parameter_value = '{article_key}' ), 'estimationId', '{estimation_id}')
                                                                               RETURNING dbrid""")
            prodat.DBExecute(f"""SELECT trecnoparam.set('imnoo.machine'::varchar, '{dbrid}'::varchar, '{machine_key}'::varchar),
                                        trecnoparam.set('imnoo.quantity'::varchar, '{dbrid}'::varchar, '{quantity}'::varchar)""")
            return estimation_id
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def get_estimation_result(self, article_key, estimation_id, set_param=False):
        url = f"{self.base_url}/api/v2/articles/{article_key}/estimates/{estimation_id}"
        response = requests.get(url, headers=self.headers_json)

        if response.status_code == 200:
            #ctypes.windll.user32.MessageBoxW(0, f"Abrufstatus: {response.json()}", "imnoo Plugin", 0)

            while response.json()["status"] == "Pending":
                message = "Die Kalkulation läuft noch. Status erneut versuchen abzurufen?"
                response = show_yes_no_dialog(message, "Kalkulation in Arbeit")

                if response == 6:  # 6: Ja
                    response = requests.get(url, headers=self.headers_json)
                else:
                    return None

            if response.json()["status"] == "Succeeded":
                data = response.json()
                if set_param:
                    prodat.DBExecute(f"""SELECT trecnoparam.set('imnoo.machining'::varchar,   dbrid::varchar, {round(data['result']['costUnits']['machining']['time'] / 60, 2)}::varchar,   'min/Stk'::varchar),
                                                trecnoparam.set('imnoo.setup'::varchar,       dbrid::varchar, {round(data['result']['costUnits']['setup']['time'] / 3600, 2)}::varchar,       'h/Los'::varchar),
                                                trecnoparam.set('imnoo.programming'::varchar, dbrid::varchar, {round(data['result']['costUnits']['programming']['time'] / 3600, 2)}::varchar, 'h/Los'::varchar)
                                          FROM ( SELECT imi_value as ak_nr
                                                    FROM x_10_interfaces.interfaces_mapping_id
                                                  WHERE imi_connector = 'imnoo-API'
                                                    AND imi_table = 'art'::regclass
                                                    AND imi_column = 'ak_nr'
                                                    AND imi_parameter_id = 'articleKey'
                                                    AND imi_parameter_value = '{article_key}' ) AS artikel
                                          JOIN art ON artikel.ak_nr = art.ak_nr""")
                return data
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def search_articles(self, article_number=None, drawing_number=None, limit=3):
        url = f"{self.base_url}/api/v2/articles/matchAny"
        params = {
            "articleNumber": article_number,
            "drawingNumber": drawing_number,
            "limit": limit
        }
        response = requests.get(url, params=params, headers=self.headers_json)

        if response.status_code == 200:
            data = response.json()
            articles = data.get("articles")
            return articles
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def create_production_run(self, article_key, production_run):
        url = f"{self.base_url}/api/v2/articles/{article_key}/production-runs"

        production_run = json.loads(production_run)
        response = requests.post(url, json=production_run, headers=self.headers_json)

        if production_run['batchNumber'].split("-")[0] == "ASK":
            table = "opl"
            column = "op_ix"
            batch = production_run['batchNumber'].split("-")[1]
        else:
            table = "abk"
            column = "ab_ix"
            batch = production_run['batchNumber']

        if response.status_code == 201:
            data = response.json()
            prodat.DBExecute(f"""INSERT INTO x_10_interfaces.interfaces_mapping_id ( imi_connector, imi_table, imi_column, imi_value, imi_parameter_id, imi_parameter_value )
                                        VALUES ('imnoo-API', '{table}', '{column}', '{batch}', 'productionRunId', '{data['id']}')""")
            return data
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def update_production_run(self, article_key, production_run_id, batch_number, quantity, production_date):
        url = f"{self.base_url}/api/v2/articles/{article_key}/production-runs/{production_run_id}"
        data = {
            "batchNumber": batch_number,
            "quantity": quantity,
            "productionDate": production_date
        }
        response = requests.put(url, json=data, headers=self.headers_json)

        if response.status_code == 200:
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def delete_production_run(self, article_key, production_run_id):
        url = f"{self.base_url}/api/v2/articles/{article_key}/production-runs/{production_run_id}"
        response = requests.delete(url, headers=self.headers_json)

        if response.status_code == 204:
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def update_article(self, article_key, data):
        url = f"{self.base_url}/api/v2/articles/{article_key}"
        response = requests.put(url, json=data, headers=self.headers_json)

        if response.status_code == 204:
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

    def delete_article(self, article_key):
        url = f"{self.base_url}/api/v2/articles/{article_key}"
        response = requests.delete(url, headers=self.headers_json)

        if response.status_code == 204:
            #print("Article deleted successfully")
            prodat.DBExecute(f"""DELETE FROM x_10_interfaces.interfaces_mapping_id
                                       WHERE imi_connector = 'imnoo-API'
                                         AND imi_table = 'art'::regclass
                                         AND imi_column = 'ak_nr'
                                         AND imi_value = ( SELECT imi_value as ak_nr
                                                             FROM x_10_interfaces.interfaces_mapping_id
                                                            WHERE imi_connector = 'imnoo-API'
                                                              AND imi_table = 'art'::regclass
                                                              AND imi_column = 'ak_nr'
                                                              AND imi_parameter_id = 'articleKey'
                                                              AND imi_parameter_value = '{article_key}'
                                                          ) """)
            return True
        else:
            show_failure_dialog(f"Fehler {response.status_code}: {response.json()}",response.status_code)
            return None

def show_yes_no_dialog(message, title):
    user32 = ctypes.windll.user32
    response = user32.MessageBoxW(None, message, title, 4 | 0x30)  # 4: Ja/Nein Schaltflächen, 0x30: Fragezeichen-Icon
    return response

def show_failure_dialog(message, title):
    user32 = ctypes.windll.user32
    user32.MessageBoxW(0, message, title, 0)