
/***** Lizenzfunktionen für unsere Syncro-Datenbank *****

  https://redmine.prodat-sql.de/issues/5937    Prodat-Lizenzen über Abfrage; Lock Datenbank über Vorsatz am Passwort
  https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Lizenzmanagement 
  https://redmine.prodat-sql.de/issues/10925   [Prodat-Lizenzierung] DB-Funktionen umbenennen

  -- S:\Prodat2005\Tools und Testprojekte\LicenseKeyGen\...\LicenseKeyGenerator.exe
  SELECT TSystem.settings__get('KUNDE') AS kunde, current_database(), LicenseKey, TSystem.settings__set('LicenseKey', LicenseKey)
  FROM dblink('host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro',
    'SELECT TSystem.CreateKey(' || quote_literal(TSystem.settings__get('KUNDE')) || ', ' ||  quote_literal(current_database()) || ', ' ||| :anzahl ||')')
  AS temp (LicenseKey VARCHAR(50));

*/



-- Mandant von Datenbankname erhalten
/* siehe "A System.sql"
CREATE OR REPLACE FUNCTION TSystem.GetMandant(name VARCHAR DEFAULT current_database()) RETURNS VARCHAR AS $$
DECLARE
  res VARCHAR;
BEGIN
  --'LOLL-MT'              -> 'LOLL-MT'
  --'LOLL-MT-BKP-20170828' -> 'LOLL-MT'
  --'LOLL-LIVE-TECHPLAN'   -> 'LOLL'
  --'PRODAT-DEMO'          -> 'PRODAT'

  SELECT (regexp_matches(name, E'(\\mLOLL-MT\\M|\\w+)(?:-(.*))?'))[1] INTO res;
  RETURN COALESCE(res, '');
END $$ LANGUAGE plpgsql;
*/


-- Packt Lizenzenanzahl von Lizenzschlüssel aus
/* Funktion für Kunden-Datenbank, siehe "A System.sql"
CREATE OR REPLACE FUNCTION TSystem.LicenseCount(Kunde VARCHAR, Datenbank VARCHAR, Key VARCHAR) RETURNS INTEGER AS $$
DECLARE
  ku INTEGER;
  hi INTEGER;
  lo INTEGER;
  db INTEGER;
  fl INTEGER;
  buf INTEGER[12];
BEGIN
  IF (length(Key) <> 27) OR (substr(Key, 7, 1) <> '-') OR (substr(Key, 14, 1) <> '-') OR (substr(Key, 21, 1) <> '-') THEN
    --RAISE EXCEPTION 'Fehler: Lizenzschlüssel ist falsch';
    RETURN 0;
  END IF;
  Key = translate(Key, '-', '');
  --RAISE NOTICE 'key: %', key;
  FOR i IN 0..11 LOOP
    buf[i] := ('x' || lpad(substr(Key,  i * 2 + 1, 2), 8, '0'))::bit(32)::int;
  END LOOP;

  --Index-Konstanten
  ku = 4; lo = 5; hi = 6; db = 7; fl = 11;

  FOR i IN 0..3 LOOP
    buf[ku] = buf[ku] # buf[i];
    buf[lo] = buf[lo] # buf[i];
    buf[fl] = buf[fl] # buf[i];
    IF i <> 3 THEN
      buf[hi] = buf[hi] # buf[i + 8];
      buf[db] = buf[db] # buf[i + 8];
      buf[fl] = buf[fl] # buf[i + 8];
    END IF;
  END LOOP;

  buf[fl] = buf[fl] # buf[ku] # buf[lo] # buf[hi] # buf[db];
  buf[hi] = buf[hi] # 165;
  buf[lo] = buf[lo] # 90;

  IF (TSystem.License__Checksum__Get(Kunde) <> buf[ku]) OR       --Kunde ist falsch oder
     (TSystem.License__Checksum__Get(TSystem.GetMandant(Datenbank)) <> buf[db]) THEN --Datenbank ist falsch
    --RAISE NOTICE 'kunde: %, datenbank: %', UPPER(lpad(to_hex(buf[ku]), 2, '0')), UPPER(lpad(to_hex(buf[db]), 2, '0'));
    RETURN 0;
  END IF;

  IF buf[fl] <> 0 THEN
    --RAISE NOTICE 'checkflag: %', UPPER(lpad(to_hex(buf[fl]), 2, '0'));
    RETURN 0; --Checkflag stimmt nicht
  END IF;
  RETURN buf[lo] + buf[hi] * 256;
END $$ LANGUAGE plpgsql;
*/

-- Prüft ob Lizenzschlüssel gültig ist
CREATE OR REPLACE FUNCTION TSystem.CheckLicense(Kunde VARCHAR, Datenbank VARCHAR, Key VARCHAR, OUT Result BOOLEAN, OUT Error VARCHAR) AS $$
BEGIN
  Result := (SELECT TSystem.CreateKey(Kunde, Datenbank, TSystem.LicenseCount(Kunde, Datenbank, Key)) = Key);
  Error  := NULL;
  RETURN;
END $$ LANGUAGE plpgsql VOLATILE;

-- Erstellt gültige Lizenzschlüssel für bestimmten Kunde, Datenbank und Verbindungsanzahl
CREATE OR REPLACE FUNCTION TSystem.CreateKey(Kunde VARCHAR, Datenbank VARCHAR, LicCount INTEGER) RETURNS VARCHAR AS $$
DECLARE
  ku INTEGER;
  hi INTEGER;
  lo INTEGER;
  db INTEGER;
  fl INTEGER;
  i INTEGER;
  buf INTEGER[16];
  Key VARCHAR;
BEGIN
  IF (Kunde = '') OR (Datenbank = '') OR (LicCount < 1) THEN
    --RAISE EXCEPTION 'Fehler: Lizenzschlüssel ist falsch';
    RETURN 'undefined';
  END IF;
  
  Datenbank = TSystem.GetMandant(Datenbank);
  Key =  md5('license-key: {customer: ' || Kunde || '; database: ' || Datenbank || '; count: ' || LicCount ||'}');

  FOR i IN 0..15 LOOP
    buf[i] := ('x' || lpad(substr(Key,  i * 2 + 1, 2), 8, '0'))::bit(32)::int; 
  END LOOP;

  FOR i IN 0..7 LOOP
    buf[i] := buf[i] # buf[i + 8];
  END LOOP;

  FOR i IN 0..3 LOOP
    buf[7 - i + 4] := buf[7 - i];
  END LOOP;

  --Index-Konstanten
  ku = 4; lo = 5; hi = 6; db = 7; fl = 11;
  
  buf[ku] := TSystem.License__Checksum__Get(Kunde);
  buf[lo] := (LicCount % 256) # 90;
  buf[hi] := (LicCount / 256) # 165;
  buf[db] := License__Checksum__Get(Datenbank);

  buf[fl] := buf[ku] # buf[lo] # buf[hi] # buf[db]; --Checkflag bilden
  FOR i IN 0..3 LOOP
    buf[ku] := buf[ku] # buf[i];
    buf[lo] := buf[lo] # buf[i];
    buf[fl] := buf[fl] # buf[i];
    IF i <> 3 THEN
      buf[hi] := buf[hi] # buf[i + 8];
      buf[db] := buf[db] # buf[i + 8];
      buf[fl] := buf[fl] # buf[i + 8];
    END IF;
  END LOOP;

  Key := '';
  FOR i IN 0..11 LOOP
    Key := Key || UPPER(lpad(to_hex(buf[i]), 2, '0'));
    IF (i % 3 = 2) AND (i <> 11) THEN
      Key := Key || '-';
    END IF;  
  END LOOP;

  RETURN Key;
END $$ LANGUAGE plpgsql;
