-- this is only applicable for the ci testing environment
CREATE SCHEMA IF NOT EXISTS ci;

SELECT TSystem.grant__table_funktion_sequence_schema_privileg__to__rolle('SYS.Prodat-User');


CREATE UNLOGGED TABLE ci.vars (
  id serial PRIMARY KEY NOT NULL,
  name text UNIQUE NOT NULL,
  type text NOT NULL,
  content text
);


CREATE OR REPLACE FUNCTION ci.version() RETURNS varchar AS $$
    SELECT 'unset'::varchar
  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION ci.branch() RETURNS varchar AS $$
    SELECT 'unset'::varchar
  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION ci.sync_systemsqlstatement( _dbcode integer = 0 ) RETURNS void AS $$
  DECLARE
      _dbstring varchar;
  BEGIN

      CASE _dbcode
        WHEN 0 THEN _dbstring = 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro';
        WHEN 1 THEN _dbstring = 'host=pg.prodat-erp.de port=5434 dbname=PRODAT-DEMO-21.11 user=syncro password=syncro';
        ELSE RAISE EXCEPTION 'Nur DBCodes 0 (syncro) und 1 (DEMO-21.11) sind zulässig.';
      END CASE;

      TRUNCATE systemsqlstatement;

      INSERT INTO systemsqlstatement (sql_stamp, sql_name, sql_descr, sql_sql, sql_minver )
      SELECT *
      FROM dblink(
          _dbstring,
          'select sql_stamp, sql_name, sql_descr, sql_sql, sql_minver from systemsqlstatement where sql_deleted is distinct from true;')
       AS sql (sql_stamp timestamp, sql_name text,sql_descr text,sql_sql text, sql_minver text);

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ci.systemsqlstatement__get( _ssql_name varchar, _ssql_version varchar = null ) RETURNS text AS $$
  DECLARE
    _sql text;
  BEGIN

      IF NOT EXISTS( SELECT 1 FROM systemsqlstatement ) THEN
        RAISE EXCEPTION 'Keine SSQLs vorhanden, bitte ci.sync_systemsqlstatement ausführen.';
      END IF;

      SELECT sql_sql INTO _sql FROM systemsqlstatement
      WHERE
          sql_name = _ssql_name
        AND ( _ssql_version IS null OR sql_minver = _ssql_version )
      ORDER BY sql_minver DESC
      LIMIT 1;

      RETURN _sql;

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ci.sync_fieldalias() RETURNS void AS $$
  BEGIN

      TRUNCATE fieldalias;

      INSERT INTO fieldalias ( fa_fieldname, fa_tablename, fa_textno, fa_wawipos_map )
      SELECT *
      FROM dblink('host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro',
                  'SELECT fa_fieldname, fa_tablename, fa_textno, fa_wawipos_map FROM fieldalias')
      AS ( fa_fieldname text, fa_tablename text, fa_textno integer, fa_wawipos_map text);

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ci.grant_docker_bderights() RETURNS void AS $$
  BEGIN
    INSERT INTO
      adk   (ad_krz,   ad_name,  ad_vorn,  ad_ort,   ad_landiso, ad_land)
      VALUES('docker', 'docker', 'docker', 'docker', 'DE',       'Deutschland')
    ;
    INSERT INTO
      llv   (ll_minr,          ll_ad_krz, ll_abteilung, ll_abteilungsleiter, ll_db_usename, ll_urlaub_bewill_vorl, ll_urlaub_bewill, ll_urlaub_bewill_notself)
      VALUES(x'FFFFFFFF'::int, 'docker',  'docker',     true,                'docker',      true,                  true,             false)
    ;
  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION ci.generate_default_stammdaten() RETURNS void AS $$
  BEGIN
      PERFORM ci.grant_docker_bderights();

      -- wird im DEMO fall von DemoDaten.0050.LoginsUserConfig.sql gesetzt.
      INSERT INTO adk  ( ad_krz ) VALUES ( '#' );

      INSERT INTO adk  ( ad_krz ) VALUES ( 'LIEF' );
      INSERT INTO adk  ( ad_krz ) VALUES ( 'KUNDE' );

      INSERT INTO adk2 ( a2_krz, a2_wuco, a2_knr ) VALUES ( 'LIEF', 9, 70000 );
      INSERT INTO adk1 ( a1_krz, a1_wuco, a1_knr ) VALUES ( 'KUNDE', 3, 10000 );

      INSERT INTO art (    ak_ac,    ak_nr,     ak_bez, ak_standard_mgc, ak_bestxt, ak_auftxt )
      VALUES          ( 'KT1001', 'ART-KT', 'Kaufteil',               1,   'E-TXT',   'V-TXT' );

      INSERT INTO art (    ak_ac,    ak_nr,       ak_bez )
      VALUES          ( 'PR1001', 'ART-PT', 'Produktion' );

      -- Adressen für Mitarbeiter
      INSERT INTO adk
        (ad_krz)
      VALUES
        ('MA1'),
        ('MA2'),
        ('MA3');

      -- Mitarbeiter
      INSERT INTO llv
        ( ll_minr, ll_ad_krz )
      VALUES
        ( 2001,       'MA1' ),
        ( 2002,       'MA2' ),
        ( 2003,       'MA3' );

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ci.systemsqlstatement__format__params_macros__for__execute( _name varchar ) RETURNS varchar AS $$
  DECLARE
      _func text;
  BEGIN

      _func := sql_sql FROM systemsqlstatement_current WHERE sql_name = _name;

      -- cleanup for params binding
      _func := replace( _func, '%', '%%' );
      _func := regexp_replace( _func, '(?<!:):[a-zA-Z0-9_]+', '%L', 'g' );
      _func := regexp_replace( _func, '(?<!&)&[a-zA-Z0-9_]+', '--macro', 'g' );

      RETURN _func;

  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION ci.format_systemsqlstatement_as_execute( _name varchar ) RETURNS varchar
  AS $$

      SELECT ci.systemsqlstatement__format__params_macros__for__execute( _name );

  $$ LANGUAGE sql;

-- Führt ein StandardSQL aus (SELECT) und gibt Ergebnis als JSON zurück.
-- Bsp: SELECT ci.systemsqlstatement__execute__return__jsonb('Einkauf.BestVorschlagPos.Class.Query', 'BV')->'lieferadressen'::varchar(50) AS lieferadressen
-- https://ci.prodat-sql.de/sources/tests/suite/30/runner/1200
CREATE OR REPLACE FUNCTION ci.systemsqlstatement__execute__return__jsonb( _name varchar, _params variadic varchar[]) RETURNS SETOF jsonb AS $$
  DECLARE r record;
  BEGIN
     --CREATE TEMP TABLE bestvorschlagpos__check(liefadress varchar);
     --INSERT INTO bestvorschlagpos__check (liefadress) (SELECT liefadress FROM (EXECUTE format( ci.format_systemsqlstatement_as_execute( 'Einkauf.BestVorschlagPos.Class.Query' ), 'BV')) AS sub ) as s);
     FOR r IN EXECUTE format( ci.systemsqlstatement__format__params_macros__for__execute( 'Einkauf.BestVorschlagPos.Class.Query' ), variadic _params )
     LOOP
         RETURN NEXT row_to_json(r);
     END LOOP;
     RETURN;
  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ci.systemsqlstatement__einkauf_bestellvorschlag__execute(
      _bvnr                    varchar,
      _flagsenum               text,
      _ac                      varchar,
      _bisdat                  date,
      _bvs_bvsk_id             integer = 1,
      _auftg                   varchar = '',
      _lgort                   varchar = '', -- ACHTUNG für Melde-Artikel muss das % sein. Für Melde Lag einen Wert <> '%' haben
      _round_to_los            boolean = true
  ) RETURNS void AS $$

  DECLARE
      _sql text := ci.format_systemsqlstatement_as_execute( 'Einkauf.BestVorschlag' );
  BEGIN

      -- macros aus der oberfläche müssen gelöscht werden.
      -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/StandardSQL-Macros
      _sql := regexp_replace( _sql, '&CONDITION_WHERE_AUTO', '', 'g' );

      RAISE NOTICE '%', format( _sql, _bvnr, _flagsenum, _ac, _bisdat, _auftg, _lgort, _round_to_los, _bvnr );

      INSERT INTO BestVorschlag ( bvs_nr,     bvs_dolos, bvs_bedarfdat,  bvs_bvsk_id )
      VALUES                    (  _bvnr, _round_to_los,       _bisdat, _bvs_bvsk_id );

      EXECUTE           format( _sql, _bvnr, _flagsenum, _ac, _bisdat, _auftg, _lgort, _round_to_los, _bvnr );

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ci.generate_random_string( _length int = 5 ) RETURNS varchar AS $$

      SELECT array_to_string(
        array_cat_agg(
          array[ chr( 97 + round( random() * 25 )::int ) ]
        ),''
      ) FROM generate_series( 1, _length );

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION ci.timestamp_faker() RETURNS timestamp AS $$
  DECLARE
      -- Start-Zeitpunkt
      -- override with ci.set('timestamp_faker_start', '2020-01-01 00:00:00')
      _timestamp_faker_start  timestamp = nullif( ci.get( 'timestamp_faker_start', '2020-01-01 00:00:00' ), '' );

      -- Zeitabstand
      -- override with ci.set('timestamp_faker_offset', '1 hour')
      _timestamp_faker_offset interval  = nullif( ci.get( 'timestamp_faker_offset', '1 hour' ), '' );
  BEGIN

      -- this function is useful for mocking timedata during inserts, when the insertvalue
      -- is not controlled by the query directly
      -- exmpale:
      --    ALTER TABLE tlog.auditlog ALTER COLUMN l_time SET DEFAULT ci.timestamp_faker;
      --
      -- after insert we get - with the default settings -
      --
      -- ┌─────────────┬─────────────────────┐
      -- │ l_tablename │       l_time        │
      -- ╞═════════════╪═════════════════════╡
      -- │ exmpale     │ 2020-01-01 02:00:00 │
      -- │ example     │ 2020-01-01 03:00:00 │
      -- └─────────────┴─────────────────────┘
      --
      -- no we testable timeseries data

      IF _timestamp_faker_start IS NULL OR _timestamp_faker_offset IS NULL THEN
          RAISE EXCEPTION 'no start or no offset provided';
      END IF;

      -- nächste Ausgabe ist entspr. Offset weiter.
      PERFORM ci.set( 'timestamp_faker_start', _timestamp_faker_start + _timestamp_faker_offset );

      RETURN _timestamp_faker_start;

  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION ci.import_skipped_sql(_psqlfilename varchar) RETURNS void AS $$
  DECLARE
    _sql varchar;

  BEGIN

    SELECT
      filecontentsql
    FROM
      ci.skipped_sql
    WHERE
      fullfilename IN ( 'psql/' || _psqlfilename, _psqlfilename )
    INTO
      _sql
    ;

    IF _sql IS null THEN
        RAISE EXCEPTION 'Zu importierende Datei "%" wurde nicht gefunden!', _psqlfilename;
    END IF;

    EXECUTE _sql;

  END $$ LANGUAGE plpgsql;
