/************* MOVIT *****************/

    -- 7400 Artikelstamm - Suchbegriff aus EAV-Daten bilden
    -- ak_such hat VARCHAR(100) siehe Ticket
    CREATE OR REPLACE FUNCTION recnokeyword__a_iu__movit_ak_such() RETURNS TRIGGER AS $$
      DECLARE new_value VARCHAR;
              old_value VARCHAR;
      BEGIN
        -- WHEN (new.r_tablename = 'art' AND new.r_reg_pname IS NOT NULL AND new.r_descr IS DISTINCT FROM 'keywordsearch')
        IF new.r_reg_pname <> 'art.aknr.save' THEN -- Wert ist nicht die gesicherte Artikelnummer aus Altsystem.
            IF TG_OP = 'INSERT' THEN
                new_value:= nullif(new.r_value, '');
            ELSE -- UPDATE
                old_value:= nullif(old.r_value, '');
                new_value:= nullif(new.r_value, '');
            END IF;
            IF old_value IS DISTINCT FROM new_value THEN
                UPDATE art SET
                  ak_such = new_such
                FROM (
                    SELECT
                      r_dbrid AS art_dbrid,
                      -- Begrenzung auf 100 Zeichen durch Eintrag des kompletten Strings in recnokeyword.r_value (Suche)
                      -- Sortierung: alle Werte kleiner 16 zuerst nach Paramterbez., dann nach Länge und Parameterbez.
                      string_agg(r_value, '-' ORDER BY length(r_value) > 15, reg_bez, length(r_value), reg_bez)::VARCHAR(100) AS new_such
                    FROM recnokeyword
                      JOIN recnogroup ON r_reg_pname = reg_pname
                    WHERE r_tablename = 'art' AND r_dbrid = new.r_dbrid
                      AND nullif(r_value, '') IS NOT NULL
                      AND r_reg_pname <> 'art.aknr.save'
                    GROUP BY r_dbrid
                ) AS sub
                WHERE art.dbrid = art_dbrid;
            END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER recnokeyword__a_iu__movit_ak_such
        AFTER INSERT OR UPDATE
        OF r_value -- , r_txt -- noch nicht berücksichtigt
        ON recnokeyword
        FOR EACH ROW
        WHEN (new.r_tablename = 'art' AND new.r_reg_pname IS NOT NULL AND new.r_descr IS DISTINCT FROM 'keywordsearch')
        EXECUTE PROCEDURE recnokeyword__a_iu__movit_ak_such();
    --
    --- #8034 Einführung Normenverwaltung : Programmerweiterung Nummernkreisauswahl, Custom Trigger
    CREATE OR REPLACE FUNCTION artcod__a_iu_movit() RETURNS TRIGGER AS $$
        DECLARE msg VARCHAR;
       BEGIN
        IF (SELECT true FROM pre_NormZertTyp WHERE pnzt_type LIKE new.ac_n) THEN
           msg := concat_ws(' ', 'Achtung dieser AC entspricht einer Norm (Normenverzeichnis) ', new.ac_n);
           PERFORM PRODAT_MESSAGE(msg, lang_text(29191) /*'Meldung'*/);
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

     CREATE TRIGGER artcod__a_iu_movit
       AFTER INSERT OR UPDATE
       OF ac_n
       ON artcod
       FOR EACH ROW
       EXECUTE PROCEDURE artcod__a_iu_movit();
    ---