/************* HET *******************/

/*** START: Anbindung Toolflakes #21169 ***/

    -- Importtabelle für Rückmeldung von Maschinenlaufzeiten
    CREATE TABLE x_950_import.bdea_het(
        het_id                  serial PRIMARY KEY,
        het_ba_ks               varchar(9) not null,    --- Maschine
        het_ba_ksap             varchar(25),            --- Maschine
        het_ba_stk              numeric(12,4),          --- Gutstück
        het_ba_anf              timestamp(0) without time zone not null,    --- Laufzeitstart
        het_ba_end              timestamp(0) without time zone,             --- Laufzeitende
        het_ba_efftime          numeric(12,4),          --- Laufzeit
        het_ba_ix               integer not null,       --- Auftragsnummer / Barcode / Arbeitsgangposition
        het_ba_op               integer not null,       --- Auftragsnummer / Barcode / Arbeitsgangposition
        het_ba_minr             integer,                --- Mitarbeiter
        het_foreign_id          integer,                --- ID
        het_ba_id               integer,                --- Prodat ba_id
        het_ba_import_status    varchar(20),            --- Import-Status
        het_ba_import_hinweis   varchar                 --- Import-Hinweis
    );


    -- Importfunktion für Übertragung der Maschinenlaufzeiten in die bdea
    CREATE OR REPLACE FUNCTION z_50_customer.bdea_het__import__by_het_id(
        _het_id integer
    )
    RETURNS void AS $$
    DECLARE
        EXCEPTION_TEXT     varchar;
        EXCEPTION_DETAIL   varchar;
        EXCEPTION_HINT     varchar;
        _ba_id             integer;
    BEGIN

        IF het_ba_import_status = 'importiert' FROM x_950_import.bdea_het WHERE het_ba_id = _ba_id THEN
          RETURN;
        END IF;

        -- Gesonderter Block zur Fehlerbehandlung weil Funktion in INSERT-Trigger aufgerufen wird und das Insert nicht verworfen werden darf
        BEGIN

            -- Stempelung in bdea-Tabelle übernehmen
            INSERT INTO bdea( ba_ks    , ba_ksap    , ba_stk    , ba_stk_time                                        , ba_anf    , ba_end                                             , ba_ix    , ba_op    , ba_minr                    )
                   SELECT     het_ba_ks, het_ba_ksap, het_ba_stk, het_ba_efftime / coalesce(nullif(het_ba_stk, 0), 1), het_ba_anf, het_ba_anf + (het_ba_efftime || ' hours')::interval, het_ba_ix, het_ba_op, coalesce(het_ba_minr, 900)
                     FROM x_950_import.bdea_het
                    WHERE het_id = _het_id
                   RETURNING ba_id INTO _ba_id;

            -- Import-Status zurückschreiben
            UPDATE x_950_import.bdea_het
               SET het_ba_import_status  = 'importiert',
                   het_ba_import_hinweis = null,
                   het_ba_id             = _ba_id
             WHERE het_id = _het_id;

        EXCEPTION WHEN others THEN
            --raise exception 'EXCEPTION WHEN others';
            GET STACKED DIAGNOSTICS EXCEPTION_TEXT   = MESSAGE_TEXT ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL ,EXCEPTION_HINT = PG_EXCEPTION_HINT;

            -- Fehler-Status zurückschreiben
            UPDATE x_950_import.bdea_het
               SET het_ba_import_status  = lang_text( 12843 ),  --- 'Fehler'
                   het_ba_import_hinweis = substr( coalesce( EXCEPTION_DETAIL, EXCEPTION_TEXT, EXCEPTION_HINT, 'FEHLER!!! z_50_customer.bdea_het__b_i__het()' ), 1, 150 )
             WHERE het_id = _het_id;

        END;

    END $$ LANGUAGE plpgsql;


    -- Trigger importiert neue Rückmeldung automatisch über Importfunktion
    CREATE OR REPLACE FUNCTION x_950_import.bdea_het__a_i__het()
      RETURNS TRIGGER AS $$
      BEGIN

        PERFORM z_50_customer.bdea_het__import__by_het_id( new.het_id );

        RETURN new;

      END $$ LANGUAGE plpgsql;

    CREATE TRIGGER bdea_het__a_i__het
      AFTER INSERT
      ON x_950_import.bdea_het
      FOR EACH ROW
      EXECUTE PROCEDURE x_950_import.bdea_het__a_i__het();


    -- Importtabelle für Übertragung von Maschinenausfall
    CREATE TABLE x_950_import.maschausf_het(
        het_id                  serial PRIMARY KEY,
        het_ma_ks               varchar(9) not null,   --- Maschine
        het_ma_ksap             varchar(25),           --- Maschine
        het_ma_anf              timestamp(0) without time zone,   --- Störzeitstart
        het_ma_end              timestamp(0) without time zone,   --- Störzeitende
        het_ma_efftime          numeric(12,4),         --- Störzeit
        het_ma_minr             integer,               --- Mitarbeiter
        het_ma_aus_id           integer,               --- Ausfallgrund
        het_ma_ausftext         text,                  --- Hinweis/Freitext
        het_foreign_id          integer,               --- Bezug zur Rückmeldung
        het_ma_id               integer,               --- Prodat maschausf-ID
        het_ma_import_status    varchar(20),           --- Import-Status
        het_ma_import_hinweis   varchar                --- Import-Hinweis
    );


    -- Importfunktion für Übertragung der Ausfallzeiten in die maschausf
    CREATE OR REPLACE FUNCTION z_50_customer.maschausf_het__import__by_het_id(
        _het_id integer
    )
    RETURNS void AS $$
    DECLARE
        EXCEPTION_TEXT     varchar;
        EXCEPTION_DETAIL   varchar;
        EXCEPTION_HINT     varchar;
        _ma_id             integer;
        _ba_id             integer;
    BEGIN

        IF het_ma_import_status IS NOT DISTINCT FROM 'importiert' FROM x_950_import.maschausf_het WHERE het_id = _het_id THEN
        RETURN;
        END IF;

        -- Gesonderter Block zur Fehlerbehandlung weil Funktion in INSERT-Trigger aufgerufen wird und das Insert nicht verworfen werden darf
        BEGIN

            -- Maschinenausfall in maschausf-Tabelle übernehmen
            INSERT INTO maschausf( ma_ks    , ma_ksap    , ma_anf                                              , ma_end    , ma_efftime    , ma_minr                   , ma_ba_id  , ma_aus_id                  , ma_ausftext    )
                   SELECT          het_ma_ks, het_ma_ksap, het_ma_end - (het_ma_efftime || ' hours')::interval , het_ma_end, het_ma_efftime, coalesce(het_ma_minr, 900), het_ba_id , coalesce(het_ma_aus_id, 90), het_ma_ausftext
                     FROM x_950_import.maschausf_het AS ma_het
                     LEFT JOIN x_950_import.bdea_het AS b_het ON b_het.het_foreign_id = ma_het.het_foreign_id  -- zugehörige Stempelung (ba_id) finden
                     WHERE ma_het.het_id = _het_id
                   RETURNING ma_id INTO _ma_id;

            -- Import-Status zurückschreiben
            UPDATE x_950_import.maschausf_het
               SET het_ma_import_status  = 'importiert',
                   het_ma_import_hinweis = null,
                   het_ma_id = _ma_id
             WHERE het_id = _het_id;

        EXCEPTION WHEN others THEN
            --raise exception 'EXCEPTION WHEN others';
            GET STACKED DIAGNOSTICS EXCEPTION_TEXT   = MESSAGE_TEXT ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL ,EXCEPTION_HINT = PG_EXCEPTION_HINT;

            -- Fehler-Status zurückschreiben
            UPDATE x_950_import.maschausf_het
               SET het_ma_import_status  = lang_text( 12843 ),  --- 'Fehler'
                   het_ma_import_hinweis = substr( coalesce( EXCEPTION_DETAIL, EXCEPTION_TEXT, EXCEPTION_HINT, 'FEHLER!!! z_50_customer.maschausf_het__a_i__het()' ), 1, 150 )
             WHERE het_id = _het_id;

        END;

    END $$ LANGUAGE plpgsql;


    -- Trigger importiert neue Ausfallzeiten automatisch über Importfunktion
    CREATE OR REPLACE FUNCTION x_950_import.maschausf_het__a_i__het()
    RETURNS TRIGGER AS $$
    BEGIN

        PERFORM z_50_customer.maschausf_het__import__by_het_id( new.het_id );

        RETURN new;

    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER maschausf_het__a_i__het
      AFTER INSERT
      ON x_950_import.maschausf_het
      FOR EACH ROW
      EXECUTE PROCEDURE x_950_import.maschausf_het__a_i__het();


    -- Funktion zur Erstelung von Views für Toolflakes
    CREATE OR REPLACE FUNCTION z_50_customer.het__toolflakes_views__recreate()
      RETURNS VOID AS $$
      BEGIN

        -- Artikel-Daten
        CREATE OR REPLACE VIEW z_50_customer.art__het AS
            SELECT
                ak_nr,     --- Artikelnummer
                ak_bez,    --- Bezeichnung
                ak_znr,    --- Zeichnungsnummer
                ak_idx,    --- Zeichnungsrevision
                ak_hest,   --- Preis
                e_lkn,     --- Lieferant
                e_best     --- Bestellnummer
              FROM art
              LEFT JOIN LATERAL (SELECT * FROM epreis
                                  WHERE e_aknr = ak_nr
                                  ORDER BY e_stal DESC
                                  LIMIT 1) AS lief_preis ON true
        ;

        -- ABK-Daten
        CREATE OR REPLACE VIEW z_50_customer.abk__het AS
            SELECT
                ab_ix,                     --- Auftragsnummer (eindeutig)
                ab_ix AS barcode_abk,      --- Barcode
                concat_ws( ' | ', ag_astat, ag_nr, ag_pos )::varchar AS auftragsposition,   --- Auftragsposition
                a1_knr,                    --- Kundennummer
                ab_st_uf1,                 --- Planmenge
                ab_st_uf1_soll,            --- Sollmenge
                ab_at,                     --- Anfangstermin
                ab_et,                     --- Endtermin
                ld_aknr,                   --- Artikelnummer
                ld_aknr_idx                --- Revision
              FROM abk
              LEFT JOIN LATERAL (SELECT * FROM auftg
                                  WHERE ag_id = tplanterm.abk_main_auftg_id(ab_ix)) AS auftrag ON true
              LEFT JOIN ldsdok ON ld_id = ab_ld_id
              LEFT JOIN adk1 ON ag_lkn = a1_krz
        ;

        -- Arbeitsgangdaten
        CREATE OR REPLACE VIEW z_50_customer.ab2__het AS
            SELECT
                a2_ab_ix,                      --- Auftragsnummer
                a2_id AS barcode_ab2,          --- Barcode (evt. in Kombination mit a2_n)
                concat_ws( ' | ', ag_astat, ag_nr, ag_pos )::varchar AS auftragsposition,       --- Auftragsposition
                a2_n,                          --- Arbeitsgangposition
                ab_st_uf1,                     --- Planmenge
                a2_tr_sek,                     --- Plan-Rüstzeit
                ( coalesce( a2_ta * 3600, 0 ) - coalesce( a2_tr_sek, 0 ) ) AS plan_laufzeit, --- Plan-Laufzeit
                a2_ks,                         --- Kostenstelle
                a2_ksap,                       --- Arbeitsplatz
                a2_subject,                    --- Bezeichnung
                a2_txt                         --- Beschreibung
              FROM ab2
              LEFT JOIN abk ON ab_ix = a2_ab_ix
              LEFT JOIN LATERAL (SELECT * FROM auftg
                                  WHERE ag_id = tplanterm.abk_main_auftg_id(ab_ix)) AS auftrag ON true
        ;

    END $$ LANGUAGE plpgsql;


    -- Hinterlegung eines Standard Ausfallgrundes
    INSERT INTO bdeausgruende (aus_id, aus_txt)
           SELECT 90, 'Toolflakes-Maschinenunterbrechung'
            WHERE NOT EXISTS (SELECT 1 FROM bdeausgruende WHERE aus_id = 90);

/*** ENDE: Anbindung Toolflakes #21169 ***/
