/************* FETZEL ****************/

    -- http://redmine.prodat-sql.de/issues/4885 Organisatorischer AG für Plantafel
    CREATE OR REPLACE FUNCTION ab2__a_i__add_autoag5__fetzel() RETURNS TRIGGER AS $$
      BEGIN
        -- (new.a2_n = 10 AND new.a2_ks IN (20, 21, 23, 24, 25, 26, 40, 41, 42, 43, 44, 45))

        IF EXISTS(SELECT TRUE FROM ab2 WHERE a2_ab_ix = new.a2_ab_ix AND a2_n = 5) THEN
            RAISE EXCEPTION '%', Format(lang_text(29185), new.a2_ab_ix, (SELECT ab_askix FROM abk WHERE ab_ix = new.a2_ab_ix)); -- Automatisch generierter AG 5 "Material bereitgestellt (AutoAG)" kann nicht erstellt werden. Es ist schon ein AG 5 vergeben.\n\nABK: %, ASK: %
        END IF;

        INSERT INTO ab2 (a2_ab_ix, a2_n, a2_ks, a2_tr, a2_zeinh_tr, a2_txt, a2_subject)
        SELECT new.a2_ab_ix , 5, '66', 0.1, 1, 'Material bereitgestellt (AutoAG)', 'Material bereitgestellt (AutoAG)';

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER ab2__a_i__add_autoag5__fetzel
        AFTER INSERT
        ON ab2
        FOR EACH ROW
        WHEN (new.a2_n = 10 AND new.a2_ks IN (20, 21, 23, 24, 25, 26, 40, 41, 42, 43, 44, 45))
        EXECUTE PROCEDURE ab2__a_i__add_autoag5__fetzel();
    --