Option Explicit


 ' -----------------------------------------------------
 ' ------------------  GExitCode  -----------------------
 ' -----------------------------------------------------
 ' 999 - Falsche Anzahl von Argumenten
 ' 998 - Argument (Arg1) fr auszufhrende 
 '       GOperation fehlerhaft
 ' 987 - Datei (Arg 2) existiert nicht
 ' 900 - Shortcut existiert bereits
 ' 901 - Shortcut existiert nicht
 ' -----------------------------------------------------
 

 
 ' =================================================================
 ' =================================================================
 '
 ' Wegen der beiden unterschiedlichen Scripthosts (CScript/WScript 
 ' und der unterschiedlichen Handhabung von Ausgabeziel 
 ' (STDOUT/Dialoge) bei Print/Echo ist die Klasse cCONSOLE ntig
 '
 ' =================================================================
 
 
 
' =================================================================
' =================================================================
' 
'  This class provides automatic switch to CScript and has methods
'  to write to and read from the CSCript console. It transparently
'  switches to CScript if the script has been started in WScript.
'
' =================================================================
CLASS cCONSOLE
  Private oOUT
  Private oIN


  Private Sub Class_Initialize()
    ' Run on creation of the cCONSOLE object, checks for cScript GOperation

    ' Check to make sure we are running under CScript, if not restart
    ' then run using CScript and terminate this instance.
    dim oShell
    set oShell = CreateObject("WScript.Shell")

    If InStr( LCase( WScript.FullName ), "cscript.exe" ) = 0 Then
      ' Not running under CSCRIPT

      ' Get the arguments on the command line and build an argument list
      dim ArgList, IX
      ArgList = ""

      For IX = 0 to wscript.arguments.count - 1
        ' Add the argument to the list, enclosing it in quotes
        argList = argList & " """ & wscript.arguments.item(IX) & """"
      next

      ' Now restart with CScript and terminate this instance
      oShell.Run "cscript.exe //NoLogo """ & WScript.ScriptName & """ " & arglist
      WScript.Quit
    End If

    ' Running under CScript so OK to continue
    set oShell = Nothing

    ' Save references to stdout and stdin for use with Print, Read and Prompt
    set oOUT = WScript.StdOut
    set oIN = WScript.StdIn

    ' Print out the startup box 
    StartBox
    BoxLine Wscript.ScriptName
    BoxLine "Started at " & Now()
    EndBox
  End Sub

  ' Utility methods for writing a box to the console with text in it
  Public Sub StartBox()
    Print "  " & String(73, "_") 
    Print " |" & Space(73) & "|"
  End Sub

  Public Sub BoxLine(sText)
    Print Left(" |" & Centre( sText, 74) , 75) & "|"
  End Sub

  Public Sub EndBox()
    Print " |" & String(73, "_") & "|"
    Print ""
  End Sub

  Public Sub Box(sMsg)
    StartBox
    BoxLine sMsg
    EndBox
  End Sub
  ' END OF Box utility methods

  ' Utility to center given text padded out to a certain width of text
  ' assuming font is monospaced
  Public Function Centre(sText, nWidth)
    dim iLen
    iLen = len(sText)

    ' Check for overflow
    if ilen > nwidth then Centre = sText : exit Function

    ' Calculate padding either side
    iLen = ( nWidth - iLen ) / 2

    ' Generate text with padding
    Centre = left( space(iLen) & sText & space(ilen), nWidth )
  End Function

  ' Method to write a line of text to the console
  Public Sub Print( sText )
    oOUT.WriteLine sText
  End Sub

  ' Method to prompt user input from the console with a message
  Public Function Prompt( sText )
    oOUT.Write sText
    Prompt = Read()
  End Function

  ' Method to read input from the console with no prompting
  Public Function Read()
    Read = oIN.ReadLine
  End Function

  ' Method to provide wait for n seconds
  Public Sub Wait(nSeconds)
    WScript.Sleep  nSeconds * 1000 
  End Sub

  ' Method to pause for user to continue
  Public Sub Pause
    Prompt "Hit enter to continue..."
  End Sub
END CLASS

' USAGE of  cCONSOLE(GCon Instanz)
'
'
' Simply write a line
' GCon.print "CSCRIPT Console demo script"
'
' Arguments are passed through correctly, if present
' GCon.Print "Arg count=" & wscript.arguments.count
'
' List all the arguments on the console log
' dim ix
' for ix = 0 to wscript.arguments.count -1
'  GCon.print "Arg(" & ix & ")=" & wscript.arguments(ix)
' next
'
' Prompt for some text from the user
' dim sMsg : sMsg = GCon.prompt( "Enter any text:" )
'
' Write out the text in a box
' GCon.Box sMsg
'
' Pause with the message "Hit enter to continue"
' GCon.Pause
' -----------------------------------------------------------------
' =================================================================


'------------------------------------------------------------------------------
'------------------------------------------------------------------------------
'------------------------------------------------------------------------------
' Instantiate the console object, this automatically switches to CSCript if required
DIM GCon: Set GCon = New cCONSOLE
DIM GWSHShell
DIM GExitCode

DIM GOperation
DIM GDestFilename
DIM GDesktopPath
DIM GShortcutName
DIM GShortcutFilename
DIM GShortcutFullFilename
DIM GShortcutIconFilename

'------------------------------------------------------------------------------
FUNCTION FolderExists(AFolder)
  DIM FSO
  
  SET FSO = CreateObject("Scripting.FileSystemObject")
	IF FSO.FolderExists(AFolder) THEN
    FolderExists = True	  
	Else
    FolderExists = False
	END IF  
END FUNCTION

FUNCTION FileExists(AFile)
  DIM FSO
  
  SET FSO = CreateObject("Scripting.FileSystemObject")
	IF FSO.FileExists(AFile) THEN
    FileExists = True	  
	Else
    FileExists = False
	END IF  
END FUNCTION

'------------------------------------------------------------------------------
FUNCTION Shortcut_Exists  
  DIM FSO
  
	SET FSO = CreateObject("Scripting.FileSystemObject")
	IF (FSO.FileExists(GShortcutFullFilename)) THEN
    Shortcut_Exists = True
	ELSE
    Shortcut_Exists = False
	END IF  
END FUNCTION

'------------------------------------------------------------------------------
SUB Shortcut_Create
  DIM WSHShell
  DIM MyShortcut
  
  SET WSHShell = CreateObject("WScript.Shell")
  
  IF NOT(Shortcut_Exists) THEN    
    Set MyShortcut = WSHShell.CreateShortCut(GShortcutFullFilename)
    MyShortcut.TargetPath = GDestFilename
    MyShortcut.WorkingDirectory = Left(GDestFilename, InStrRev(GDestFilename, "\"))
    MyShortcut.IconLocation = GShortcutIconFilename
    MyShortcut.WindowStyle = 1
    MyShortcut.Arguments = ""
    MyShortcut.Save
    SET MyShortcut = NOTHING
    GExitCode = 0
    GCon.Print "Shortcut '" & GShortcutFullFilename & "' erstellt"
  ELSE 
    GExitCode = 900
    GCon.Print "Shortcut '" & GShortcutFullFilename & "' existiert bereits"
  END IF
END SUB

'------------------------------------------------------------------------------
SUB Shortcut_Delete
  DIM FSO
  
  IF (Shortcut_Exists) THEN
    SET FSO = CreateObject("Scripting.FileSystemObject")
    FSO.DeleteFile(GShortcutFullFilename)
    GCon.Print "Shortcut '" & GShortcutFullFilename & "' gelscht"
  ELSE 
    GExitCode = 901
    GCon.Print "Shortcut '" & GShortcutFullFilename & "' existiert nicht"
  END IF
END SUB

'------------------------------------------------------------------------------
SUB Shortcut_DeleteSilent
  DIM FSO
  
  IF (Shortcut_Exists) THEN
    SET FSO = CreateObject("Scripting.FileSystemObject")
    FSO.DeleteFile(GShortcutFullFilename)    
  ELSE 
    GExitCode = 901
  END IF
END SUB



'------------------------------------------------------------------------------
'------------------------------------------------------------------------------
'------------------------------------------------------------------------------
SET GWSHShell = CreateObject("WScript.Shell")
GDesktopPath = GWSHShell.SpecialFolders("Desktop")
GShortcutName = "Prodat Lokal - Aktualisieren und neustarten"
GShortcutFilename = GShortcutName & ".lnk"
GShortcutFullFilename = GDesktopPath & "\" & GShortcutFilename
GExitCode = 0

IF WScript.Arguments.Count < 2 THEN
	GExitCode = 999
  GCon.Print "Falsche Anzahl von Argumenten!"
	WScript.Quit(GExitCode)
END IF


GDestFilename = WScript.Arguments.Item(1)
IF NOT FileExists(GDestFilename) THEN
  GExitCode = 998
  GCon.Print "Datei (" & GDestFilename & ") existiert nicht"
	WScript.Quit(GExitCode)
END IF

GShortcutIconFilename = ""
IF WScript.Arguments.Count > 2 THEN
  IF FileExists(WScript.Arguments.Item(2)) THEN
    GShortcutIconFilename = WScript.Arguments.Item(2) & ",0"
  END IF
END IF


GOperation = WScript.Arguments.Item(0)
IF GOperation = "CREATE" THEN
	CALL Shortcut_Create
ELSE
	IF GOperation = "DELETE" THEN
		CALL Shortcut_Delete
	ELSE
    IF GOperation = "DELETESILENT" THEN
      CALL Shortcut_DeleteSilent
    ELSE
  	  GExitCode = 997
    END IF
	END IF
END IF



WScript.Quit(GExitCode)