-- ################################################################################ Nirschl
-- SHOP Gruppen für Webshops : Bindung an AC
CREATE TABLE tartikel.artcod_shopgroups (
  acsg_id        SERIAL NOT NULL PRIMARY KEY,
   acsg_ac_n      VARCHAR NOT NULL,-- Ohne References damit freier verwendbar
   acsg_spr_key   VARCHAR(5) NOT NULL CONSTRAINT xtt4089 REFERENCES sprach,
   acsg_txt       VARCHAR(100)
  );
 --

 --jeder Sprachschlüssel darf nur einmal zur Gruppe zugeordnet werden
  CREATE UNIQUE INDEX acsg_spr_key ON tartikel.artcod_shopgroups (acsg_ac_n, acsg_spr_key);

--Bezeichnung der Shopgruppe mit Übersetzung
CREATE OR REPLACE FUNCTION tartikel.lang_artcod_shopgroups(acn VARCHAR, lang VARCHAR) RETURNS VARCHAR(100) AS $$
 DECLARE  acn ALIAS FOR $1;
        lang ALIAS FOR $2;
        s VARCHAR;
 BEGIN
  IF acn IS NULL OR acn = '' THEN
    RETURN 'n.a.';
  END IF;
  s:=acsg_txt FROM artcod_shopgroups WHERE acsg_ac_n=acn AND acsg_spr_key=lang;
  RETURN COALESCE(s, 'n.a.');
  --
 END $$  LANGUAGE plpgsql STABLE;
-- ################################################################################

 -- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
 SELECT TRUE;