--Airbus Angebote  ä

-- Blechtafelverschachtelung LOLL
  CREATE TABLE blech
   (b_id                SERIAL PRIMARY KEY,
    b_bez               VARCHAR(75),
    b_eb                NUMERIC NOT NULL,
    b_el                NUMERIC NOT NULL,
    b_restab            NUMERIC,
    b_kzart             VARCHAR(10),
    b_kzkrz             VARCHAR(10),
    b_fzug              NUMERIC NOT NULL,
    b_mb                NUMERIC NOT NULL,
    b_ml                NUMERIC NOT NULL,
    b_folie             NUMERIC DEFAULT 0.3,
    b_robozeit          NUMERIC(12,4) NOT NULL DEFAULT 0 --Zusatzzeit die der Roboter braucht, gilt generell erstmal für alle Tafelgrößen
   );

 INSERT INTO blech (b_bez, b_eb, b_el, b_kzart, b_kzkrz, b_fzug, b_mb, b_ml) VALUES ('KN 500x500', 461, 475, 'DB', 'DB', 5, 500, 500) ;
 INSERT INTO blech (b_bez, b_eb, b_el, b_kzart, b_kzkrz, b_fzug, b_mb, b_ml) VALUES ('KN 250x1000', 235, 980, 'DB', 'DB', 5, 250, 1000) ;

  --funktion die einem den x-wert des artikels gibt

 CREATE OR REPLACE FUNCTION blech_artikel_x(ak_dim VARCHAR) RETURNS INTEGER AS $$
  DECLARE S VARCHAR;
          I INTEGER;
  BEGIN
   IF NOT lower(ak_dim) LIKE '%x%x%' THEN
      RETURN 0;
   END IF;
   S:=SubStr(lower(ak_dim), 0, StrPos(lower(ak_dim), 'x'));
   S:=COALESCE(S, '0');
   IF S='' THEN
      S:='0';
   END IF;
   BEGIN
    I:=CAST(S AS INTEGER);
   EXCEPTION
         WHEN invalid_character_value_for_cast THEN I:=-1;
   END;
   RETURN I;
  END $$ LANGUAGE plpgsql IMMUTABLE;

 --nächste Tafelnummer (fortlaufend)

 CREATE SEQUENCE blechtafel_nummer_seq;

 --Blechtafelverschachtelung berechnet
  CREATE TABLE blechberech
   (br_id               SERIAL PRIMARY KEY,
    br_aufid            VARCHAR(50),
    br_tafel            INTEGER,
    br_strang           INTEGER,
    br_strangb          NUMERIC,
    br_ag_id            INTEGER REFERENCES auftg,
    br_anz              INTEGER,
    br_rest_anz         INTEGER,
    br_rest             NUMERIC,
    br_matnr            VARCHAR(50),
    br_airbussend       BOOL NOT NULL DEFAULT FALSE,
    br_blech            INTEGER REFERENCES blech
   );

  CREATE INDEX blechberech_br_tafel ON blechberech(br_tafel);
  CREATE INDEX blechberech_br_aufid ON blechberech(br_aufid);
  CREATE INDEX blechberech_br_ag_id ON blechberech(br_ag_id);

  CREATE OR REPLACE FUNCTION blechberech__b_i() RETURNS TRIGGER AS $$
   BEGIN
    IF new.br_tafel IS NULL THEN--es wird eine neue Tafel begonnen
       new.br_tafel:=max(br_tafel)+1 FROM blechberech WHERE br_aufid=new.br_aufid;
       new.br_tafel:=COALESCE(new.br_tafel, 1);
    END IF;
    --
    new.br_strang:=max(br_strang)+1 FROM blechberech WHERE br_aufid=new.br_aufid AND br_tafel=new.br_tafel;
    new.br_strang:=COALESCE(new.br_strang, 1);--nächsten Strang eintragen
    RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER blechberech__b_i
    BEFORE INSERT
    ON blechberech
    FOR EACH ROW
    EXECUTE PROCEDURE blechberech__b_i();

--

 CREATE TABLE blechverbrauch
  (id                   SERIAL PRIMARY KEY,
   bruttoverbrauch      NUMERIC,
   br_matnr             VARCHAR(50),
   ag_nr                VARCHAR(20),
   ag_post5             VARCHAR(70),
   ag_post6             VARCHAR(70),
   lfdnr                SERIAL,
   blechberech_am       DATE
  );


 CREATE OR REPLACE FUNCTION create_blechverbrauch(startdat DATE, enddat DATE) RETURNS VOID AS $$
  BEGIN
   --
   insert into blechverbrauch (bruttoverbrauch, br_matnr, ag_nr, ag_post5, ag_post6, blechberech_am)
   select
    CAST(((sum(br_strangb*l_dim2))+((sum(br_strangb*l_dim2)/((SELECT sum(br_strangb*l_dim2) FROM blechberech JOIN lifsch ON l_br_tafel=br_tafel WHERE br_tafel IN (SELECT br_tafel FROM blechberech WHERE br_ag_id=ag_id GROUP BY br_tafel))))*(((SELECT sum(l_dim1*l_dim2) FROM lifsch WHERE l_br_tafel IN (SELECT br_tafel FROM blechberech WHERE br_ag_id=ag_id GROUP BY br_tafel)))-(SELECT sum(br_strangb*l_dim2) FROM blechberech JOIN lifsch ON l_br_tafel=br_tafel WHERE br_tafel IN (SELECT br_tafel FROM blechberech WHERE br_ag_id=ag_id GROUP BY br_tafel)))))/1000000 AS NUMERIC) AS bruttoverbrauch,
    br_matnr,
    ag_nr,
    ag_post5,
    ag_post6,
    MAX(blechberech.insert_date) -- Übergabe Eintrag in Berechnungstabelle, relavant für Listenausgabe
   from
    blechberech join lifsch on l_br_tafel=br_tafel
                join auftg on ag_id=br_ag_id
                join art on ak_nr=br_matnr
   where
    blechberech.insert_date between startdat and enddat
   AND
    NOT br_airbussend
   AND
    br_aufid NOT LIKE '%current'
   AND
    (ak_ac<>4 AND ak_ac<>5)
   group by ag_id,ag_nr,br_matnr,ag_post6,ag_post5;
   --
   UPDATE blechberech SET br_airbussend=TRUE WHERE blechberech.insert_date between startdat and enddat;
   --
   RETURN;
  END $$ LANGUAGE plpgsql;


  CREATE SEQUENCE bz_sort_nr_seq;

 -- Zuordnung der Blechtafeln zu einem Wagenzug
 CREATE TABLE blechzuweisung
  (bz_id                SERIAL PRIMARY KEY,
   bz_br_tafel          INTEGER UNIQUE NOT NULL,        -- Tafelnummer des zugewiesenen Blechs
   bz_wagennr           INTEGER,                        -- Wagen auf dem das Blech liegt
   bz_ausgeloest        BOOL NOT NULL DEFAULT FALSE,    -- Wagen ist unterwegs, kann nicht mehr verändert werden
   bz_gesperrt          BOOL NOT NULL DEFAULT FALSE,    -- Wagen ist gesperrt, keine neuen Tafeln drauf, nicht auslösbar
   bz_dim1              NUMERIC NOT NULL DEFAULT 0,     -- Dimensionen der Tafel
   bz_dim2              NUMERIC NOT NULL DEFAULT 0,
   bz_dim3              NUMERIC NOT NULL DEFAULT 0,
   bz_folie             NUMERIC,
   bz_sort_nr           INTEGER DEFAULT nextval('bz_sort_nr_seq')                       -- Nr. fuer Sortierreihenfolge beim Zuweisen auf Wagen
  );

 CREATE SEQUENCE wagen_nummer_seq;


  CREATE TABLE airbusk
   (ai_id               SERIAL PRIMARY KEY,
    ai_kun              VARCHAR(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,
    ai_akz              VARCHAR(2),
    ai_ank              VARCHAR(40) NOT NULL,
    ai_anp              VARCHAR(40) NOT NULL,
    ai_bez              VARCHAR(75),
    ai_znr              VARCHAR(75),
    ai_mat              VARCHAR(75),
    ai_dil              NUMERIC NOT NULL DEFAULT 0,
    ai_dib              NUMERIC NOT NULL DEFAULT 0,
    ai_did              NUMERIC NOT NULL DEFAULT 0,
    ai_bpz              NUMERIC,
    ai_str              VARCHAR(38),
    ai_tmm              NUMERIC,
    ai_sta              NUMERIC NOT NULL CONSTRAINT xtt5136__ag_stk CHECK (ai_sta>0),
    ai_pr1              NUMERIC,
    ai_pr2              NUMERIC,
    ai_pr3              NUMERIC,
    ai_pf1              NUMERIC,
    ai_pf2              NUMERIC,
    ai_pf3              NUMERIC,
    ai_pgk              NUMERIC,
    ai_tek              NUMERIC,
    ai_vok              NUMERIC,
    ai_lda              DATE,
    ai_dok              INTEGER,
    ai_erl              BOOL NOT NULL DEFAULT FALSE,
    ai_agn              VARCHAR(20)
   );


  CREATE UNIQUE INDEX airbusk__ai_dok ON airbusk (ai_dok);




    -- #6435 LOLL Wenn Plan-ABK gelöscht wird, werden NC-Parameter in die Auftrags-ABK-AGs übernommen
    -- Ausgangspunkt: Es gibt eine Plan-ABK und eine Fertigungs-ABK > Die Plan-ABK wird gelöscht > Es werden alle
    -- NC-Parameter der Plan-ABK zur Fertigungs-ABK kopiert
    CREATE OR REPLACE FUNCTION z_50_customer.abk__b_d_ncparams_loll()
          RETURNS trigger AS
        $BODY$
        DECLARE srcDBRID VARCHAR;
                trgDBRID VARCHAR;
                r RECORD;
          BEGIN
            -- SELECT dbrids der ab2-Sätze der Plan-ABK, die gelöscht werden soll
            FOR r in (SELECT ab2.dbrid AS srcDBRID FROM ab2 JOIN abk ON ab_ix=a2_ab_ix JOIN ksv ON a2_ks=ks_abt
                            WHERE ab_ix = old.ab_ix
                            AND ks_mitnc --nur Kostenstellen, bei denen "NC-Programmierung" gesetzt ist
                            AND NOT ks_ausw) --keine Auswärtskostenstellen
            LOOP
              -- SELECT dbrid der ab2 der Fertingungs-ABK, für die der Parameter kopiert werden soll
              trgDBRID:=(SELECT ab2.dbrid FROM ab2 JOIN abk ON ab_ix=a2_ab_ix JOIN ksv ON a2_ks=ks_abt
                            WHERE ab_ix = ( SELECT tplanterm.auftg_get_abk((SELECT ag_id FROM auftg JOIN abk ON ag_id=ab_plan_ag_id  AND ab_ix = old.ab_ix LIMIT 1)) )
                            AND a2_n = ( SELECT a2_n FROM ab2 ab2source WHERE ab2source.dbrid=r.srcDBRID )
                            AND ks_mitnc --nur Kostenstellen, bei denen "NC-Programmierung" gesetzt ist
                            AND NOT ks_ausw); --keine Auswärtskostenstellen
              -- CopyFunktion #7135
              PERFORM TRecnoParam.CopyGroup('Programmieraufträge', r.srcDBRID, trgDBRID);
            END LOOP;

            RETURN old;
          END $BODY$
          LANGUAGE plpgsql;

          CREATE TRIGGER abk__b_d_ncparams_loll
            BEFORE DELETE
            ON abk
            FOR EACH ROW
            WHEN ( old.ab_plan_ag_id IS NOT NULL ) --nur Ausführen, wenn es sich um eine Plan-ABK handelt
            EXECUTE PROCEDURE z_50_customer.abk__b_d_ncparams_loll();
    --

    -- #6336 http://redmine.prodat-sql.de/issues/6336
    CREATE OR REPLACE FUNCTION z_50_customer.cocpos__b_i__loll()
          RETURNS trigger AS
        $BODY$
          BEGIN
            --Wenn Bestelleradresse KIDS, dann wird die in DMF/Seriennummer die Charge aus dem Lagerabgang übernommen
            SELECT l_lgchnr INTO new.cocp_sn FROM lifsch WHERE l_nr = new.cocp_l_nr AND l_krz = 'KIDS';
             --SELECT l_lgchnr INTO new.cocp_sn FROM lifsch WHERE l_belp_id = new.cocp_belp_id AND l_krz = 'KIDS';
            RETURN new;
          END $BODY$
          LANGUAGE plpgsql;

          CREATE TRIGGER cocpos__b_i__loll
            BEFORE INSERT
            ON cocpos
            FOR EACH ROW
            EXECUTE PROCEDURE z_50_customer.cocpos__b_i__loll();
    --

    -- #1904 Angabe Umfang der Zertifizierung ist Pflichtfeld, vorerst nur Lieferantenzertifikate
    CREATE OR REPLACE FUNCTION z_50_customer.NormZert__a_iu___loll() RETURNS TRIGGER AS $$
      BEGIN
        IF (new.noz_descr IS NULL) AND (new.noz_iskred) AND (SELECT qs_pnzt_type FROM qsnorm WHERE new.noz_qs_ident = qs_ident) = 'FN' THEN
            RAISE EXCEPTION 'xtt15926';
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER NormZert__a_iu___loll
        AFTER INSERT OR UPDATE
        ON NormZert
        FOR EACH ROW
        EXECUTE PROCEDURE z_50_customer.NormZert__a_iu___loll();
    --

    -- #4770 automatische Erzeugung von interner Bestellung und ABK für MB-DA-Aufträge sowie Schließen/Storno aus Auftrag, Nur Fertigungsartikel, keine NC-Kosten usw.
    -- #6476 Erweiterung im Zusammenhang mit automatisch angelegten ASK
    CREATE OR REPLACE FUNCTION z_50_customer.auftg__a_iu___loll() RETURNS TRIGGER AS $$
      DECLARE ldid INTEGER;
              ix INTEGER;
              r RECORD;
              in_ab_askix INTEGER;
              in_ab_st_uf1 NUMERIC;
      BEGIN
        -- WHEN (ag_astat = 'E' AND ag_lkn = 'MB' AND ag_nr like 'DA%')
        IF TG_OP='INSERT' THEN
            --Hinweis: wird über EDI/vom APPS ausgelöst, kein Insert_By/Date etc pp
            INSERT INTO ldsdok
                        (ld_code, ld_auftg, ld_ekref, ld_kn,
                         ld_aknr, ld_stk, ld_mce,
                         ld_term,
                         ld_ag_id,
                         ld_stat,
                         ld_txtint
                         )
                 SELECT 'I', new.ag_nr, new.ag_nr||'-P-'||new.ag_pos, '#',
                        new.ag_aknr, tartikel.me__menge__in__menge_uf1(new.ag_mcv, new.ag_stk), tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(new.ag_aknr),
                        timediff_substdays(coalesce(new.ag_ldatum, new.ag_kdatum, new.ag_datum), 3, true, true),
                        new.ag_id,
                        'AIRB',
                        'automatisch erzeugte interne Bestellung für MB-DA-Aufträge'
                  WHERE NOT EXISTS(SELECT TRUE FROM ldsdok WHERE ld_ag_id = new.ag_id)
                    AND (SELECT ak_fertigung FROM art WHERE ak_nr = new.ag_aknr) -- Keine NC-Kosten usw.
              RETURNING ld_id INTO ldid;

            IF EXISTS(SELECT true FROM opl WHERE op_n = new.ag_aknr AND op_standard) THEN
                -- ABK aus ASK-Fertigungsvariante anlegen

                --INSERT INTO abk (ab_ld_id, ab_inplantaf, ab_st_uf1, ab_ap_txt, ab_askix, ab_txt, ab_op_stat, ab_stat) -- wird automatisch in ld_abk zurückgeschrieben
                SELECT tartikel.me__menge__in__menge_uf1(new.ag_mcv, new.ag_stk) AS stk, ak_auftxt, op_ix, op_txt
                  INTO r
                  FROM opl JOIN art ON ak_nr=op_n
                 WHERE op_n = new.ag_aknr AND op_standard
                   AND NOT EXISTS(SELECT TRUE FROM abk WHERE ab_ld_id = ldid);
                --
                 ix := tabk.abk__create(new.ag_aknr,  r.op_ix, r.stk, NULL, NULL, ldid);
                 UPDATE abk
                    SET ab_stat = TSystem.Enum_SetValue(ab_stat, 'AIRB'), ab_txt = r.op_txt, ab_ap_txt = r.ak_auftxt
                  WHERE ab_ix = ix;
            END IF;
        ELSE -- UPDATE
            --
            IF (new.ag_done IS DISTINCT FROM old.ag_done) AND new.ag_done THEN
                UPDATE ldsdok SET -- Bestellung aus Auftrag schließen, ABK wird automatisch mitgezogen
                  ld_done   = true,
                  ld_storno = new.ag_storno
                WHERE
                  ld_ag_id  = new.ag_id
                AND
                  NOT ld_done;
            END IF;

            --Neuen Termin aus Auftrag in Bestellung Übertragen bei Änderung
            UPDATE ldsdok
               SET ld_term   = timediff_substdays(new.ag_ldatum, 3, true, true)
             WHERE ld_ag_id  = new.ag_id
               AND NOT ld_done
               AND ld_term IS DISTINCT FROM timediff_substdays(new.ag_ldatum, 3, true, true);
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftg__a_iu___loll
        AFTER INSERT OR UPDATE OF ag_done, ag_storno, ag_ldatum
        ON auftg
        FOR EACH ROW
        WHEN (new.ag_astat = 'E' AND new.ag_lkn = 'MB' AND new.ag_nr LIKE 'DA%')
        EXECUTE PROCEDURE z_50_customer.auftg__a_iu___loll();

    --- #21271 [Auftragsbearbeitung] 3D-Modell automatisch auf erledigt setzen
    CREATE OR REPLACE FUNCTION z_50_customer.auftg__a_i__RecNoKeyword___loll() RETURNS TRIGGER AS $$
      DECLARE _art_dbrid      varchar;
      BEGIN
        --- wenn in auftg 'auftg.bearbtg.p5' nicht existiert und in art existiert, dann anlegen
        SELECT dbrid INTO _art_dbrid FROM art WHERE ak_nr =  new.ag_aknr;

        IF not trecnoparam.getbool( 'auftg.bearbtg.p5', new.dbrid, false )
           AND trecnoparam.getbool( 'auftg.bearbtg.p5', _art_dbrid, false )
         THEN

            --- RecNoKeyword erstellen
            PERFORM trecnoparam.copy( pname => 'auftg.bearbtg.p5',
                                      srcdbrid => _art_dbrid,
                                      trgdbrid => new.dbrid,
                                      trgtable => 'auftg'
                                      );
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftg__a_i__RecNoKeyword___loll
        AFTER INSERT
        ON auftg
        FOR EACH ROW
        EXECUTE PROCEDURE z_50_customer.auftg__a_i__RecNoKeyword___loll();
    ---

    --

    DROP TRIGGER IF EXISTS ldsdok__a_90_iu__airbus_loll ON ldsdok;
    CREATE OR REPLACE FUNCTION z_50_customer.ldsdok__a_90_iu__airbus_loll() RETURNS TRIGGER AS $$
      DECLARE doterm BOOLEAN;
      BEGIN
        --
        doterm:=FALSE;
        --automatisch terminieren
        IF tg_op = 'INSERT' AND new.ld_term IS NOT NULL THEN
            doterm := TRUE;
        END IF;
        IF tg_op = 'UPDATE' THEN
            IF new.ld_term IS DISTINCT FROM old.ld_term THEN
                doterm := TRUE;
            END IF;
        END IF;
        --
        IF doterm THEN
            --Kreisaufruf vermeiden
            doterm := TSystem.Settings__GetBool( 'ABK.Datum.geplant.erhalten' );
            PERFORM TSystem.Settings__Set( 'ABK.Datum.geplant.erhalten', 'T' );
            --
            PERFORM tplanterm.abk_term( new.ld_abk, new.ld_term, FALSE, _dlz_terminiation => true ); -- Rückwärtsterminierung, automatisch in Plantafel
            --
            PERFORM TSystem.Settings__Set( 'ABK.Datum.geplant.erhalten', doterm );
        END IF;
        --
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER ldsdok__a_90_iu__airbus_loll
        AFTER INSERT OR UPDATE OF ld_term, ld_abk
        ON ldsdok
        FOR EACH ROW
        WHEN (    TSystem.ENUM_GetValue(new.ld_stat, 'AIRB')
              AND (new.ld_abk IS NOT NULL)
              AND (NOT new.ld_done)
              AND (new.ld_term IS NOT NULL)
              AND (NOT TSystem.Settings__GetBool('tplanterm.abk_abg_term.inTerminierung' || pg_backend_pid()::varchar) )
              )
        EXECUTE PROCEDURE z_50_customer.ldsdok__a_90_iu__airbus_loll();
    --





    -- #5085 Kontierung ist Pflicht für externe Bestellung mit 23er Nummern
    SELECT TSystem.Settings__Set('LOLL.Einkauf.23er.Pflichtkonto', 'true');
    CREATE OR REPLACE FUNCTION z_50_customer.ldsdok__b_iu___loll__fbe()
          RETURNS trigger AS
        $BODY$
              BEGIN
                -- WHEN (new.ld_code = 'E' AND new.ld_auftg ~* '^23[0-9]{6}$')
                IF TSystem.Settings__GetBool('LOLL.Einkauf.23er.Pflichtkonto') THEN
                    IF NOT EXISTS(SELECT true FROM erloes WHERE er_kto = new.ld_konto AND COALESCE(er_aufkto, NOT er_erlkto, true)) THEN
                        RAISE EXCEPTION '%', lang_text(16327)||E'\n\n'||new.ld_code||' '||new.ld_auftg||' '||new.ld_pos;
                    END IF;
                END IF;
                RETURN new;
              END $BODY$
          LANGUAGE plpgsql;

          CREATE TRIGGER ldsdok__b_iu___loll
            BEFORE INSERT OR UPDATE
            OF ld_konto
            ON ldsdok
            FOR EACH ROW
            WHEN (new.ld_code = 'E' AND NOT (new.ld_auftg LIKE '%.QS') AND ( (new.ld_auftg ~* '^23[0-9]{6}$') OR (new.ld_auftg LIKE 'FBE%') ) ) --Umstellung 23er Nummer auf FBE: https://redmine.prodat-sql.de/issues/13619
            EXECUTE PROCEDURE z_50_customer.ldsdok__b_iu___loll__fbe();
    --



    -- #6476 Nach ASK-Freigabe entspr. ABKs in den offenen DA-Aufträge erzeugen
    CREATE OR REPLACE FUNCTION z_50_customer.opl__a_iu__loll() RETURNS TRIGGER AS $$
      DECLARE r RECORD;
              ix INTEGER;
      BEGIN
        -- WHEN (new.op_standard)
        IF TG_OP = 'UPDATE' THEN
            IF new.op_standard IS NOT DISTINCT FROM old.op_standard THEN -- ASK wurde nicht wirklich freigegeben
                RETURN new;
            END IF;
        END IF;

        -- Für alle automatisch erzeugten, offenen internen Bestellungen des ASK-Artikels, die noch keine ABK haben, diese anlegen.
        -- Hinweis: wird manuell durch Benutzer ausgelöst > Insert_By, Date usw. werden geführt

        FOR r IN SELECT ld_id, ld_aknr, ld_stk, ak_auftxt, new.op_ix, new.op_txt, new.op_stat
        FROM ldsdok LEFT JOIN art ON ak_nr=ld_aknr
        WHERE ld_code = 'I' AND ld_auftg LIKE 'DA%'
          AND ld_aknr = new.op_n
          AND NOT EXISTS(SELECT true FROM abk WHERE ab_ld_id = ld_id)
          AND NOT ld_done
        LOOP

         ix := tabk.abk__create(r.ld_aknr,  r.op_ix, r.ld_stk, NULL, NULL, r.ld_id);
         UPDATE abk SET ab_inplantaf=TRUE, ab_txt=r.op_txt, ab_ap_txt=r.ak_auftxt WHERE ab_ix=ix;
         SELECT TSystem.ENUM_setValue(ab_stat,'AIRB') FROM abk WHERE ab_ix = ix;

        END LOOP;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER opl__a_iu__loll
        AFTER INSERT OR UPDATE
        OF op_standard
        ON opl
        FOR EACH ROW
        WHEN (new.op_standard)
        EXECUTE PROCEDURE z_50_customer.opl__a_iu__loll();
    --

    --
    DROP TABLE IF EXISTS loll_airbus_fsl;
    CREATE TABLE loll_airbus_fsl (
      fsl_id                      SERIAL PRIMARY KEY,
      fsl_import_stamp            VARCHAR,
      fsl_new_liefdat             DATE,    --vom Bediener eingegebenes, neue Plantadatum geliefert
      fsl_FA_PA                   VARCHAR,
      fsl_Auftrag                 VARCHAR,
      fsl_Material_ID             VARCHAR,
      fsl_HTZ                     VARCHAR,
      fsl_Material_Kurztext       VARCHAR,
      fsl_Kenner                  VARCHAR,
      fsl_Verwender               VARCHAR,
      fsl_Lieferant               VARCHAR,
      fsl_Bestellnummer           VARCHAR,
      fsl_Bestelldatum            DATE,
      fsl_Lieferdatum             DATE,
      fsl_Bestell_Auftragsmenge   NUMERIC(12,4),
      fsl_EP                      NUMERIC(12,4),
      fsl_GP                      NUMERIC(12,4),
      fsl_Prio_SAP                INTEGER,
      fsl_Sondereinstufung        VARCHAR,
      fsl_Bedarfstermin_3_KW      DATE,
      fsl_Bedarfstermin_2_KW      DATE,
      fsl_Bedarfstermin_1_KW      DATE,
      fsl_Bedarfstermin           DATE,
      fsl_Forderungstermin        DATE, --ausgeblendet?
      fsl_Liefertermin_2_KW       DATE,
      fsl_Liefertermin_1_KW       DATE,
      fsl_Bemerkung_PAG           VARCHAR,
      fsl_Auftragsnummer          VARCHAR, --steht "geliefert" drin, oder ein Termin?
      fsl_Liefertermin            DATE,
      fsl_Bemerkung               VARCHAR,
      fsl_Versanddatum            DATE,
      fsl_in_Arbeit_seit          VARCHAR,
      fsl_Ref1_nicht_andern       VARCHAR,
      fsl_Ref2_nicht_andern       VARCHAR,
      fsl_Prio_E2E                VARCHAR,
      fsl_Gelieferte_Menge        VARCHAR
    );

    --

    -- 9851 Loll-spezifischer web_status > Verwendung in TSystem.wareneingangskontrolle_status
    CREATE OR REPLACE FUNCTION TSystem.wareneingangskontrolle_status_custom(IN _wek_nr INTEGER DEFAULT 0) RETURNS INTEGER AS $$
       DECLARE lagort VARCHAR;
       BEGIN
         lagort:=(SELECT w_lagort FROM wareneingangskontrolle JOIN wendat ON wek_w_wen = w_wen WHERE wek_nr = _wek_nr AND NOT wek_def);

         -- 9851 Status 'Zegnis fehlt' Lagerort = ZEUGNIS FEHLT
         IF (lagort = 'ZEUGNIS FEHLT') THEN
           RETURN 25461; --Zeugnis fehlt
         ELSEIF (lagort = 'REKLAMATION') THEN
           RETURN 25463; --Reklamation
         END IF;
         RETURN NULL;
       END $$ LANGUAGE plpgsql STABLE;

    --
    CREATE OR REPLACE FUNCTION z_50_customer.TFormLagerAbSofort__ab_ix__by__agnr__customfunction(ident VARCHAR) RETURNS INTEGER AS $$
     DECLARE result INTEGER;
     BEGIN
      result := tplanterm.auftg_get_abk(ag_id, false) FROM auftg WHERE ag_post6 = ident; -- Auftragsnummer Airbus, welche über Barcode vom Airbus-Dokument kommt
      -- Airbus Nummer: ABK gefunden => raus
      IF result IS NOT NULL THEN
         RETURN result;
       END IF;
      -- Versuchen, ob eine DB-DA-MB Auftragsnummer direkt eingegeben wurden
      result := tplanterm.auftg_get_abk(ag_id, false) FROM auftg
         WHERE (ag_nr LIKE 'DB%' OR ag_nr LIKE 'DA%' OR ag_nr LIKE 'MB%')
              AND ag_nr LIKE '%'||ident||'%'
              AND NOT ag_done; -- Direkteingabe Auftragsnummer
      IF result IS NOT NULL THEN
         RETURN result;
       END IF;
      -- Versuchen, ob eine Auftragsnummer eingegeben wurde (Function Default)
      RETURN tplanterm.auftg_get_abk(ag_id, false) FROM auftg WHERE ag_astat = 'E' AND ag_nr = ident AND NOT ag_done ORDER BY ag_pos LIMIT 1; -- Auftragsnummer Airbus, welche über Barcode vom Airbus-Dokument kommt
     END $$ LANGUAGE plpgsql;
    --

    -- #6476 automatisch ASK anlegen und Zeit anhand Kostenvorgabe in AG 20
    CREATE OR REPLACE FUNCTION TSystem.ExecuteCustomScript(param1 VARCHAR) RETURNS VOID AS $$
      DECLARE r RECORD;
      BEGIN
        IF TSystem.Settings__Get('KUNDE') = 'LOLL' THEN
            SELECT ag_nr, ag_aknr, trim(substr(ak_dim, 29, 20)) AS cat, ak_rust, ak_fertk, NULL::VARCHAR AS src_opn, NULL::INTEGER AS src_ask, NULL::INTEGER AS new_ask INTO r FROM auftg JOIN art ON ak_nr = ag_aknr WHERE ag_id = param1;
            IF NOT EXISTS(SELECT true FROM opl WHERE op_n = r.ag_aknr) THEN
                IF r.ag_nr LIKE 'DA%' THEN
                    IF r.cat = 'RA' THEN
                        r.src_opn:= 'PAG-DA-NH4000RA2-ABLAUF';
                    ELSIF r.cat = 'NH5000' THEN
                        r.src_opn:= 'PAG-DA-NH5000-ABLAUF';
                    ELSIF r.cat ~ '[0-9]+[[:alpha:]]+' THEN -- Zahl und Buchstabe
                        r.src_opn:= 'PAG-DA-NH4000B-ABLAUF';
                    ELSIF r.cat ~ '.*-.*' THEN -- Minuszeichen
                        r.src_opn:= 'PAG-DA-NH4000C-ABLAUF';
                    ELSE
                        r.src_opn:= 'PAG-DA-ABLAUF';
                    END IF;
                    r.src_ask:= op_ix FROM opl WHERE op_n = r.src_opn AND op_standard;
                ELSIF r.ag_nr LIKE 'DB%' THEN
                    r.src_ask:= op_ix FROM opl WHERE op_n = 'PAG-DB-ABLAUF' AND op_standard;
                END IF;
                r.new_ask:= TArtikel.opl__copy__ASK(r.src_ask, r.ag_aknr, NULL, NULL, false); -- Bei Kopie keine Fertigungsvariante, muss freigegeben werden

                -- AG 20 der neue ASK umschreiben auf Vorgabezeiten laut Artikelstamm
                UPDATE op2 SET
                  -- Rüstzeit
                  o2_tr =
                      coalesce(
                          -- Rüstzeit in Sekunden anhand Rüstkosten / Stundensatz
                          r.ak_rust / coalesce( ks_stsr, ks_sts ) * 3600 /
                          -- in Zeiteinheit umrechnen
                          CASE op2.o2_zeinh_tr
                              WHEN 1 THEN 3600
                              WHEN 2 THEN 60
                              WHEN 4 THEN 28800
                              ELSE 1
                          END
                          -- Fallback
                          , op2.o2_tr
                      ),

                  -- Hauptzeit
                  o2_th =
                      coalesce(
                          -- Hauptzeit in Sekunden anhand Fertigungskosten / Stundensatz
                          r.ak_fertk / ks_sts * 3600 /
                          -- in Zeiteinheit umrechnen
                          CASE op2.o2_zeinh_tx
                              WHEN 1 THEN 3600
                              WHEN 2 THEN 60
                              WHEN 4 THEN 28800
                              ELSE 1
                          END
                          -- Fallback
                          , op2.o2_th
                      )

                FROM
                      -- Zugriff auf eigenen Datensatz in Update notwendig für Verwendung der KS-Data-Funktion
                      op2 AS this_op2
                  JOIN tartikel.ksv__data__by__table__get( this_op2 ) ON true

                WHERE this_op2.o2_id = op2.o2_id
                  AND op2.o2_ix = r.new_ask
                  AND op2.o2_n = 20
                ;

            END IF;
        END IF;
        RETURN;
      END $$ LANGUAGE plpgsql VOLATILE;
    --
---

  CREATE TABLE priol
   (pl_id               SERIAL PRIMARY KEY,
    pl_insert           TIMESTAMP(0) DEFAULT now(),
    pl_ps               VARCHAR(6),
    pl_htz              VARCHAR(17),
    pl_bnr              VARCHAR(11),
    pl_bpos             VARCHAR(8),
    pl_menge            INTEGER,
    pl_prio             INTEGER,
    pl_lollt            VARCHAR(30),
    pl_verzug           INTEGER,
    pl_airt             VARCHAR(30),
    pl_notizen          VARCHAR(30)
   );
---
CREATE TABLE bestueb
  (bu_id                SERIAL PRIMARY KEY,
   bu_bnr               VARCHAR,
   bu_bdat              VARCHAR,
   bu_pos               VARCHAR,
   bu_htz               VARCHAR,
   bu_airt              VARCHAR,
   bu_offen             VARCHAR,
   bu_ftprio            VARCHAR,
   bu_ntprio            VARCHAR,
   bu_notizen           VARCHAR,
   bu_nt                VARCHAR,
   bu_bemerk            VARCHAR
  );
---
 CREATE TABLE loll_oorcam
  (oo_id                SERIAL PRIMARY KEY,
   oo_bda               VARCHAR(100),
   oo_pos               VARCHAR(20),
   oo_dat               DATE
  );
---
CREATE OR REPLACE FUNCTION z_50_customer.belkopf__b_i_loll() RETURNS TRIGGER AS $$
  BEGIN
      IF new.be_rkrz LIKE 'MB%' OR new.be_rkrz LIKE 'DB%' THEN
         -- Eveline Brundert
         new.be_apint := 279;
      END IF;

      RETURN new;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER belkopf__b_i_loll
  BEFORE INSERT
  ON belkopf
  FOR EACH ROW
  EXECUTE PROCEDURE z_50_customer.belkopf__b_i_loll();
---
-- Ordnet alle freien Tafeln einem Wagen zu - ALT
 CREATE OR REPLACE FUNCTION tafelnZuweisen(maxTafeln INTEGER, tafNr INTEGER DEFAULT 0) RETURNS VOID AS $$
  DECLARE
    _maxWagenNr INTEGER; -- Hoechste vergebene Wagennummer
    _NrTafWagen INTEGER; -- Anz. Tafeln auf Wagen _maxWagenNr
    _maxTafeln  INTEGER; -- Höchstanzahl an Tafeln auf einem Wagen (Wird in Oberflaeche festgelegt)

    _abgelegt   BOOLEAN;

    _Dim1       NUMERIC; -- Blechdimensionen
    _Dim2       NUMERIC;
    _Dim3       NUMERIC; -- Blechdicke für Anzahl der Tafeln auf Wagen
    _maxDim3    NUMERIC;

    _Tafel      RECORD;
    _Wagen      RECORD;
  BEGIN
    --Sequenz abfragen welches die letzte vergebene Wagennr. ist
    SELECT last_value INTO _maxWagenNr FROM wagen_nummer_seq;
    _maxTafeln:=maxTafeln;

    -- Über alle freien Tafeln iterieren
    FOR _Tafel IN (SELECT * FROM blechzuweisung WHERE bz_wagennr IS NULL ORDER BY bz_sort_nr) LOOP

      --Wenn eine Tafelnummer gegeben ist, sollen wir nur die eine Tafel einsortieren. Wenn die Nummer also nich übereinstimmt,
      -- überspringen wir das ablegen.
      IF (tafNr <> 0) AND ( _Tafel.bz_br_tafel <> tafNr) THEN
        CONTINUE;
      END IF;

      _abgelegt:=FALSE;
      -- Über alle noch nicht ausgelösten Wagen-Nummern iterieren
      FOR _Wagen IN (SELECT DISTINCT bz_wagennr FROM blechzuweisung WHERE NOT (bz_ausgeloest OR bz_gesperrt) ) LOOP


        -- Anzahl der Tafeln auf Wagen ermitteln
        SELECT COUNT(*) INTO _nrTafWagen FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;

        -- Dimensionen der Tafeln auf Wagen ermitteln
        SELECT DISTINCT bz_dim1 INTO _Dim1 FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;
        SELECT DISTINCT bz_dim2 INTO _Dim2 FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;
        SELECT DISTINCT bz_dim3 INTO _Dim3 FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;

        SELECT COALESCE(max(bz_dim3),0) INTO _maxDim3 FROM blechzuweisung  WHERE bz_wagennr = _Wagen.bz_wagennr;

        -- 8mm dicke Tafeln passen weniger drauf => Entfaellt. In Oberflaeche festgelegt)
        --_maxTafeln:= ifthen((_Dim3 >= 8),15,20);


        IF   ((_nrTafWagen <> 0 )               -- Wagen existiert (es gibt keine leeren Wagen)
          AND (_nrTafWagen < _maxTafeln)        -- Da ist noch Platz
          AND (_Tafel.bz_dim1 = _Dim1)          -- Dimensionen stimmen auch
          AND (_Tafel.bz_dim2 = _Dim2)
          AND (
                ((_Tafel.bz_dim3 < 8) AND (_maxDim3<8))
                OR
                ((_maxDim3 >= 8) AND (_Tafel.bz_dim3 >=8))

               ) -- Tafel mit 8.0 nicht ablegen, falls da nicht schon 8.0er liegen
             )
        THEN
          --Zu _Wagen hinzufügen, Tafel als abgelegt markieren
          UPDATE blechzuweisung SET bz_wagennr = _Wagen.bz_wagennr WHERE bz_id = _Tafel.bz_id;
          _abgelegt:=True;

        END IF;

        -- Andere Wagen nicht mehr durchgehen
        IF (_abgelegt) THEN EXIT; END IF;

      END LOOP;

      --Wenn nicht ablegt => keiner der bisherigen Wagen war passend => Neuer Wagen
      IF (NOT _abgelegt) THEN
        --Nächste Nummer aus Sequenz als neue Wagennummer
        SELECT nextval('wagen_Nummer_seq') INTO _maxWagenNR;
        UPDATE blechzuweisung SET bz_wagenNr = _maxWagenNr WHERE bz_id = _Tafel.bz_id;
      END IF;

    END LOOP;

    RETURN;
  END $$ LANGUAGE plpgsql;

  /* Ordnet alle freien Tafeln einem Wagen zu - ALT

 CREATE OR REPLACE FUNCTION tafelnZuweisen(maxTafeln INTEGER) RETURNS VOID AS $$
 DECLARE
   _maxWagenNr  INTEGER; -- Hoechste vergebene Wagennummer
   _NrTafWagen  INTEGER; -- Anz. Tafeln auf Wagen _maxWagenNr
   _maxTafeln   INTEGER; -- Höchstanzahl an Tafeln auf einem Wagen (Wird in Oberflaeche festgelegt)

   _abgelegt    BOOLEAN;

   _Dim1        NUMERIC; -- Blechdimensionen
   _Dim2        NUMERIC;
   _Dim3        NUMERIC; -- Blechdicke für Anzahl der Tafeln auf Wagen
   _maxDim3     NUMERIC;

   _Tafel       RECORD;
   _Wagen       RECORD;
 BEGIN
   --Sequenz abfragen welches die letzte vergebene Wagennr. ist
   SELECT last_value INTO _maxWagenNr FROM wagen_nummer_seq;
   _maxTafeln:=maxTafeln;

   -- Über alle freien Tafeln iterieren
   FOR _Tafel IN (SELECT * FROM blechzuweisung WHERE bz_wagennr IS NULL ORDER BY bz_sort_nr) LOOP

     _abgelegt:=FALSE;
     -- Über alle noch nicht ausgelösten Wagen-Nummern iterieren
     FOR _Wagen IN (SELECT DISTINCT bz_wagennr FROM blechzuweisung WHERE NOT (bz_ausgeloest OR bz_gesperrt) ) LOOP


        -- Anzahl der Tafeln auf Wagen ermitteln
        SELECT COUNT(*) INTO _nrTafWagen FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;

        -- Dimensionen der Tafeln auf Wagen ermitteln
        SELECT DISTINCT bz_dim1 INTO _Dim1 FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;
        SELECT DISTINCT bz_dim2 INTO _Dim2 FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;
        SELECT DISTINCT bz_dim3 INTO _Dim3 FROM blechzuweisung WHERE bz_wagennr = _Wagen.bz_wagennr;

        SELECT COALESCE(max(bz_dim3),0) INTO _maxDim3 FROM blechzuweisung  WHERE bz_wagennr = _Wagen.bz_wagennr;

        -- 8mm dicke Tafeln passen weniger drauf => Entfaellt. In Oberflaeche festgelegt)
        --_maxTafeln:= ifthen((_Dim3 >= 8),15,20);


        IF   ((_nrTafWagen <> 0 )               -- Wagen existiert (es gibt keine leeren Wagen)
          AND (_nrTafWagen < _maxTafeln)        -- Da ist noch Platz
          AND (_Tafel.bz_dim1 = _Dim1)          -- Dimensionen stimmen auch
          AND (_Tafel.bz_dim2 = _Dim2)
          AND (
                ((_Tafel.bz_dim3 < 8) AND (_maxDim3<8))
                OR
                ((_maxDim3 >= 8) AND (_Tafel.bz_dim3 >=8))

               ) -- Tafel mit 8.0 nicht ablegen, falls da nicht schon 8.0er liegen
             )
        THEN
          --Zu _Wagen hinzufügen, Tafel als abgelegt markieren
          UPDATE blechzuweisung SET bz_wagennr = _Wagen.bz_wagennr WHERE bz_id = _Tafel.bz_id;
          _abgelegt:=True;

        END IF;

        -- Andere Wagen nicht mehr durchgehen
        IF (_abgelegt) THEN EXIT; END IF;

     END LOOP;

     --Wenn nicht ablegt => keiner der bisherigen Wagen war passend => Neuer Wagen
     IF (NOT _abgelegt) THEN
       --Nächste Nummer aus Sequenz als neue Wagennummer
       SELECT nextval('wagen_Nummer_seq') INTO _maxWagenNR;
       UPDATE blechzuweisung SET bz_wagenNr = _maxWagenNr WHERE bz_id = _Tafel.bz_id;
     END IF;

   END LOOP;

   RETURN;
 END $$ LANGUAGE plpgsql;
*/

 CREATE OR REPLACE FUNCTION volleWagenAusloesen(maxTafeln INTEGER) RETURNS VOID AS $$
  DECLARE
   _t RECORD;
   _nrTafWagen INTEGER;
  BEGIN

   FOR _t IN (SELECT DISTINCT bz_wagenNr,bz_dim3 FROM blechzuweisung WHERE bz_wagennr IS NOT NULL AND NOT (bz_ausgeloest OR bz_gesperrt) ) LOOP
     SELECT INTO _nrTafWagen COUNT(*) FROM blechzuweisung WHERE bz_wagennr = _t.bz_wagenNr;

     --Wagen mit dicken Tafeln sind bei 15 schon voll
     --_maxTafeln:= ifthen((_t.bz_dim3 = 8),15,20);

     IF(_nrTafWagen = maxTafeln) THEN
       UPDATE blechzuweisung SET bz_ausgeloest=TRUE WHERE bz_wagennr = _t.bz_WagenNr;
     END IF;
   END LOOP;

   RETURN;
  END $$ LANGUAGE plpgsql;


--KTI - Artikelnr. Anfang => Assoziiert mit bestimmter Kategorienbezeichnung
CREATE TABLE art_praefix
(
  artp_krz      VARCHAR(3) NOT NULL PRIMARY KEY,
  artp_bez      VARCHAR(40)
);

CREATE UNIQUE INDEX art_praefix_krz_bez ON art_praefix (artp_krz,artp_bez);

--Großschreibung erzwingen
CREATE OR REPLACE FUNCTION art_praefix__b_iu() RETURNS TRIGGER AS $$
BEGIN
  new.artp_krz:=UPPER(new.artp_krz);
  RETURN new;
END $$ LANGUAGE plpgsql;

CREATE TRIGGER art_praefix__b_iu
  BEFORE INSERT OR UPDATE
  ON art_praefix
  FOR EACH ROW
EXECUTE PROCEDURE art_praefix__b_iu();

--- #21271 [Auftragsbearbeitung] 3D-Modell automatisch auf erledigt setzen
CREATE OR REPLACE FUNCTION Z_50_customer.recnokeyword__a_99_u__auftg_bearbtg_p5___loll() RETURNS TRIGGER AS $$
 DECLARE _r_dbrid     varchar;
 BEGIN

    SELECT dbrid INTO _r_dbrid FROM art WHERE ak_nr = ( SELECT ag_aknr FROM auftg WHERE dbrid = new.r_dbrid );

    --- wenn in r_value geändert ist
    IF new.r_value::boolean IS DISTINCT FROM trecnoparam.getbool( new.r_reg_pname, _r_dbrid ) THEN
        PERFORM trecnoparam.set( pname => new.r_reg_pname,
                                 rdbrid => _r_dbrid,
                                 rvalue => new.r_value,
                                 rtablename => 'art'
                               );
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER recnokeyword__a_99_iu__auftg_bearbtg_p5___loll
    AFTER INSERT OR UPDATE
    OF r_value
    ON recnokeyword
    FOR EACH ROW
    WHEN ( new.r_reg_pname::text = 'auftg.bearbtg.p5'::text AND new.r_tablename = 'auftg' )
    EXECUTE FUNCTION Z_50_customer.recnokeyword__a_99_u__auftg_bearbtg_p5___loll();
---
-- ##############################################################################


-- #21455 Für Webshops soll die Referenznummer als Bestellnummer genommen werden.
-- Das klappt, wenn
--   - die Referenznummer nach Entfernung von Leerzeichen und Bindestrichen mindestens sechs Zeichen lang ist und
--   - ausschließlich aus Ziffern besteht (von Leerzeichen und Bindestrichen abgesehen) und
--   - das laufende oder das letzte Jahr enthält.
-- Trifft dies nicht zu wird die Bestellnummer aus dem übergebenen Nummernkreis genommen.
-- Gibt es den nicht, dann wird null zurückgegeben.
CREATE OR REPLACE FUNCTION z_50_customer.loll__edi__ld_auftg__get( _bestrefnr varchar, _ld_auftg_setting varchar ) RETURNS varchar AS $$
DECLARE
  _ld_auftg varchar;
  _this_year varchar;
  _last_year varchar;
BEGIN

  _ld_auftg := replace( _bestrefnr, ' ', '' );
  _ld_auftg := replace(  _ld_auftg, '-', '' );
  _this_year := date_part( 'year', current_date) :: varchar;
  _last_year := ( date_part( 'year', current_date) - 1 ) :: varchar;
  
  IF   
      _ld_auftg ~ '^[0-9]{6,}$'
    AND ( 
      _ld_auftg LIKE '%' || _this_year || '%'
   OR _ld_auftg LIKE '%' || _last_year || '%'
    )
  THEN 
   
    RETURN _ld_auftg;
   
  ELSE
  
    RETURN tsystem.settings__gettext( _ld_auftg_setting );
  
  END IF;

END $$ LANGUAGE plpgsql STABLE;
--


-- #21667 LOLL-EDI Impot Auftragsbestätigungen
-- Artikelanlage wird von mitgesendeten E-Class-Nummern auf bestehende ACs abgebildet
-- LOLL-Tabelle Für das Mapping von E-Class-Nummern der Lieferanten auf Artikelcodes für den EDI-Import von Artikeldaten
CREATE TABLE z_50_customer.loll_eclass_ac (
  lea_id serial PRIMARY KEY,                   -- technischer Primärschlüssel
  lea_adk2 varchar NOT null REFERENCES adk2,   -- betroffener Lieferant
  lea_eclass integer NOT null,                 -- die ersten zwei Ziffern der E-Klasse
  lea_ac varchar NOT null REFERENCES artcod,   -- AC, mit der der betroffene Artikel angelegt werden soll
  lea_bem varchar(200),                        -- Freitext
  
  UNIQUE( lea_adk2, lea_eclass )               -- nur ein Mapping pro Lieferant und E-Klasse
);

-- #21667 Liefert zu einem Lieferanten und einer E-Klasse den passenden Artikelcode
CREATE OR REPLACE FUNCTION z_50_customer.loll__eclass__ac__map( _adk2 varchar, _eclass varchar) RETURNS varchar AS $$
DECLARE
  _ac varchar;
  _ecl integer;
BEGIN

  -- Die ersten beiden Zeichen einer E-Klasse sind eine Zahl, nur dieser Teil ist hier interessant.
  _ecl := asNumeric( substring( _eclass, 1, 2 ))::integer;

  -- Auslesen der AC
  _ac := lea_ac FROM z_50_customer.loll_eclass_ac WHERE lea_adk2 = _adk2 AND lea_eclass = _ecl;
  
  -- Nichts gefunden? Dann auf Standard ausweichen: AC zur Pseudo-E-Klasse 0
  IF _ac IS null THEN
    _ac := lea_ac FROM z_50_customer.loll_eclass_ac WHERE lea_adk2 = _adk2 AND lea_eclass = 0;
  END IF;
  
  -- Immer noch nichts gefunden? Dann Exception.
  IF _ac IS null THEN
    RAISE EXCEPTION 'Kein passender Artikelcode gefunden für Lieferanten %, E-Klasse %', _adk2, _eclass;
  END IF;
  
  RETURN _ac;

END $$ LANGUAGE plpgsql STABLE;
--
    -- bei Fa. Loll werden auf das jahr gesehen nur 5 Gleitzeittage (Abwesenheit Freizeitausgleich) genehmigt 
    -- Custom Trigger wirft Fehler, wenn 5 Tage Stundenausgleich überschritten werden > nur beim Beantragen 
    -- analog tpersonal.llv__abw__geplant__by__currentyear__get
    CREATE OR REPLACE FUNCTION z_50_customer.bdepabbe__b_iu__limit_zeitausgleich__loll() RETURNS TRIGGER AS $$
      DECLARE
          _docyear INTEGER;  --days of current year
          _doa     INTEGER;  --days of application
          _doapy   INTEGER;  --days of application per year          
      BEGIN
          
          _doapy := 5; -- Es dürfen maximal 5 Tage beantragt werden.
          
          -- Anzahl Tage des diesjährigen Stundenausgleichs ermitteln (genehmigt)
          _docyear := SUM ( -- ohne Feiertage und Wochenenden als Zeitspanne
                            timediff( bdab_anf, bdab_end, true, true, true )                       
                          )          
                      FROM bdepab
                      WHERE
                            bdab_minr = new.bdabb_minr
                        AND bdab_aus_id = 153 --Zeitausgleich loll-id                     
                        AND date_part('year', bdab_anf) = date_part('year', current_date) -- könnte verbessert für Fall wenn Stundenausgleich bereits im Vorjahr beginnen würde
                      ;
          
          -- Anzahl Tage des beantragten Stundenausgleichs ermitteln
          _doa     := timediff( new.bdabb_anf, new.bdabb_end, true, true, true ) -- ohne Feiertage und Wochenenden als Zeitspanne                      
                      -- könnte verbessert für Fall wenn Stundenausgleich bereits im Vorjahr beginnen würde
                      ;                   
          -- Bei mehr als 5 Tagen wird die Nutzeraktion abgebrochen und Hinweis des bereits genehmigten Stundenausgleichs gegeben.         
          IF ( ( COALESCE( _docyear, 0 ) + _doa ) > _doapy ) THEN
              
              --Es dürfen maximal %s Tage Stundenausgleich beantragt werden. Sie haben bereits %s genehmigte Tage im laufenden Jahr.  
              RAISE EXCEPTION USING MESSAGE = Format( lang_text(25570), _doapy, COALESCE( _docyear, 0) );
              
          END IF;

          RETURN new;
        END $$ LANGUAGE plpgsql;

        CREATE TRIGGER bdepabbe__b_iu__limit_zeitausgleich__loll
          BEFORE INSERT OR UPDATE 
          ON bdepabbe      
          FOR EACH ROW
          WHEN ( new.bdabb_aus_id = 153 ) --Zeitausgleich loll-id
          EXECUTE PROCEDURE z_50_customer.bdepabbe__b_iu__limit_zeitausgleich__loll();
    --
