/************* HYDRO *****************/
    /* NUR ZUR ERINNERUNG, DAS WIR BEI HYDRO DIE SETTINGS BRAUCHEN DAMIT DAS EDI LÄUFT. ZUMINDEST DAS ERSTE.*/
    --SELECT ConditionalExecute( TSystem.Settings__Get('KUNDE') = 'HYDRO', 'INSERT INTO SETTINGS(s_vari, s_inha) VALUES (''HYDRO_KNR'',''99999''); ',TRUE);
    --SELECT ConditionalExecute( TSystem.Settings__Get('KUNDE') = 'HYDRO', 'INSERT INTO SETTINGS(s_vari, s_inha) VALUES (''HYDRO_EDILOG_USER'',''6''); ',TRUE);

    CREATE TABLE IF NOT EXISTS z_50_customer.hydro_bosch_bdep_daten (
        hbd_id            SERIAL PRIMARY KEY,
        hbd_mpl_id        INTEGER REFERENCES mitpln ON UPDATE CASCADE ON DELETE CASCADE,
        hbd_bosch_id      INTEGER,
        hbd_bosch_mitnr   INTEGER,
        hbd_saldodatum    DATE,
        hbd_saldo         NUMERIC(12,4)
    );

    CREATE OR REPLACE FUNCTION z_50_customer.mitpln__get__mpl_id_hydro(mitnr VARCHAR, datum DATE, saldo NUMERIC) RETURNS INTEGER AS $$
      DECLARE mplid INTEGER;
          llminr INTEGER;
      BEGIN

        datum  := datum::DATE;
        saldo  := saldo::NUMERIC(12,4);

        SELECT ll_minr INTO llminr FROM llv WHERE TRIM(ll_allg1)::INTEGER = TRIM(mitnr)::INTEGER;
        IF llminr IS null THEN
            SELECT ll_minr INTO llminr FROM llv WHERE ll_minr = TRIM(mitnr)::INTEGER;
        END IF;
        IF llminr IS null THEN
            RAISE EXCEPTION 'Mitarbeiter-Nr. = % ist nicht existiert', mitnr;
        END IF;
        SELECT mpl_id INTO mplid FROM mitpln WHERE mpl_minr = llminr AND mpl_date = datum;

        IF mplid IS null THEN
            INSERT INTO mitpln (mpl_minr, mpl_date, mpl_saldo)
             VALUES (llminr, datum, saldo)
            RETURNING mpl_id INTO mplid;
        END IF;
        RETURN mplid;
      END $$ LANGUAGE plpgsql;
    --
--- **************************************
-- HYDRO: DLP-Listen (Durchlaufplan) ABKs zu Auftrag
CREATE OR REPLACE FUNCTION hydro_dlp(
    IN ldauftg VARCHAR,
    IN weekv VARCHAR,
    IN weekb VARCHAR,
    OUT ix INTEGER,
    OUT agid INTEGER
  ) RETURNS SETOF RECORD AS $$
  DECLARE r   RECORD;
          r1  RECORD;
  BEGIN
    ix := NULL;

    FOR r IN
        SELECT
          ld_abk, ag_id
        FROM auftg
          JOIN ldsdok ON ld_ag_id = ag_id
        WHERE CASE WHEN ldauftg IS NULL THEN true ELSE ld_auftg LIKE ldauftg END
          AND ag_astat = 'E'
          AND NOT ag_done
          AND CASE WHEN weekv IS NULL THEN true ELSE ag_twa BETWEEN weekv AND weekb END
    LOOP
        agid := r.ag_id;

        FOR r1 IN SELECT DISTINCT * FROM tplanterm.get_all_child_abk(r.ld_abk) LOOP
            ix := r1.get_all_child_abk;
            RETURN next;
        END LOOP;
    END LOOP;

    IF ix IS NULL THEN
        FOR r IN SELECT ld_abk FROM ldsdok WHERE ld_code = 'I' AND ld_auftg LIKE ldauftg AND ld_pos = 1 LOOP
            agid := NULL;
            FOR r1 IN SELECT DISTINCT * FROM tplanterm.get_all_child_abk(r.ld_abk) LOOP
                ix := r1.get_all_child_abk;
                RETURN next;
            END LOOP;
        END LOOP;
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql;
--

-- HYDRO: DLP-Listen (Durchlaufplan) Kostenstellen-Summen
CREATE OR REPLACE FUNCTION hydro_dlpkssum(ldauftg VARCHAR, ks VARCHAR) RETURNS NUMERIC AS $$
  BEGIN
    RETURN (
      SELECT DISTINCT trunc(round(a2_ta_ks, 0), 0)
      FROM (
        SELECT a2_n, a2_ta, a2_ks,
          (SUM(a2_ta) OVER (PARTITION BY a2_ks)) * 60 AS a2_ta_ks -- in Minuten
        FROM ldsdok
          JOIN ab2 ON a2_ab_ix = ld_abk AND NOT a2_ende AND a2_ks = ks
        WHERE ld_auftg = ldauftg
      ) AS AgTimeSumKsv
    );
  END $$ LANGUAGE plpgsql STABLE;
--

-- HYDRO: DLP-Listen (Durchlaufplan) einzelne KS #8617
CREATE OR REPLACE FUNCTION hydro_dlpksagg(
    IN ldauftg  VARCHAR,
    IN ks       VARCHAR,
    IN awks     BOOLEAN DEFAULT NULL
  ) RETURNS VARCHAR(75) AS $$
  BEGIN
    IF awks IS NULL THEN -- Außer Auswärts-KS
        --RETURN (SELECT DISTINCT  trunc(round(a2_ta_ks,0),0)::VARCHAR FROM
        RETURN COALESCE(( -- '0' zurückgeben wegen Summenberechnung im Report
          SELECT DISTINCT trunc(round(a2_ta_ks, 0), 0)::VARCHAR
          FROM (
            SELECT a2_n, a2_ta, a2_ks,
              (SUM(a2_ta) OVER (PARTITION BY a2_ks)) * 60 AS a2_ta_ks -- in Minuten
            FROM ldsdok
              JOIN LATERAL (SELECT DISTINCT get_all_child_abk AS all_abk FROM tplanterm.get_all_child_abk(ld_abk)) AS complete_abk_structure ON ld_abk IS NOT NULL
              JOIN ab2 ON a2_ab_ix = all_abk AND NOT a2_ende AND NOT a2_ausw AND a2_ks = ks
            WHERE ld_auftg = ldauftg
              AND ld_abk IS NOT NULL
          ) AS AgTimeSumKsv
        ), '0');
    END IF;

    IF awks THEN -- Nur Auswärts-KS separierte Darstellung aller Auswärtskostenstellen mit Bestellinfo
        -- Ausschluss von KS angeben getrennt durch Leerzeichen im Parameter ks; ohne Einschränkung ''
        RETURN (
          SELECT string_agg(awinfo, ' | ')
          FROM (
            SELECT a2_ab_ix, a2_n, a2_ks,
              concat_ws(',', a2_ks, IFTHEN(aw.ld_auftg IS NOT NULL, 'B', NULL), IFTHEN(aw.ld_done, 'E', NULL)) AS awinfo -- B: bestellt; E: erledigt
            FROM ldsdok
              JOIN LATERAL (SELECT DISTINCT get_all_child_abk AS all_abk FROM tplanterm.get_all_child_abk(ldsdok.ld_abk)) AS complete_abk_structure ON ldsdok.ld_abk IS NOT NULL
              JOIN ab2 ON a2_ab_ix = all_abk AND a2_ausw
              LEFT JOIN ldsdok AS aw ON aw.ld_a2_id = a2_id -- Bestellinformation
            WHERE ldsdok.ld_auftg = ldauftg
              AND ldsdok.ld_abk IS NOT NULL
              AND a2_ks NOT IN (SELECT regexp_split_to_table(ks, E'\\s+')) -- Ausschluss von KS
            ORDER BY a2_ab_ix, a2_n
          ) AS awinfo
        );
    END IF;
  END $$ LANGUAGE plpgsql;
--    