-- https://redmine.prodat-sql.de/issues/8908

-- REVOKE ALL ON SCHEMA tkta_connection FROM "KTA-SHOP";

-- DROP ROLE "KTA-SHOP";

-- KTA-SHOP als Nutzer anlegen PW entspricht 'KTA'

CREATE ROLE "KTA-SHOP" LOGIN

  ENCRYPTED PASSWORD 'md5268aa6ff5347affa1bd42fb67d74cafb' -- KTA

  NOSUPERUSER NOINHERIT NOCREATEDB NOCREATEROLE;

GRANT CONNECT ON DATABASE "HPCHO" TO "KTA-SHOP";

-- Schema tka_connection anlegen

CREATE SCHEMA tkta_connection

  AUTHORIZATION postgres;

-- Berechtigungen f?r Schema anpassen:

--    SYS.Administratorn -> Vollzugriff

--    KTA-SHOP -> Lesezugriff

GRANT ALL ON SCHEMA tkta_connection     TO "SYS.Administratoren" WITH GRANT OPTION;

GRANT USAGE ON SCHEMA tkta_connection   TO "KTA-SHOP";

GRANT USAGE ON SCHEMA z_50_customer  TO "KTA-SHOP";

-- GRANT SELECT ON TABLE tkta_connection.product_main_groups TO "KTA-SHOP";



-- SHOP Gruppen für Webshops : Bindung an AC
CREATE TABLE z_50_customer.artcod_shopgroups (
   acsg_id        SERIAL NOT NULL PRIMARY KEY,
   acsg_ac_n      VARCHAR NOT NULL,-- Ohne References damit freier verwendbar
   acsg_spr_key   VARCHAR(5) NOT NULL CONSTRAINT xtt4089 REFERENCES sprach,
   acsg_txt       VARCHAR(100)
  );
 --

 --jeder Sprachschlüssel darf nur einmal zur Gruppe zugeordnet werden
  CREATE UNIQUE INDEX acsg_spr_key ON z_50_customer.artcod_shopgroups (acsg_ac_n, acsg_spr_key);

--Bezeichnung der Shopgruppe mit Übersetzung
CREATE OR REPLACE FUNCTION z_50_customer.lang_artcod_shopgroups(_acn VARCHAR, _lang VARCHAR) RETURNS VARCHAR(100) AS $$
 DECLARE s    VARCHAR;
 BEGIN
  IF _acn IS NULL OR _acn = '' THEN
    RETURN 'n.a.';
  END IF;
  s := acsg_txt FROM z_50_customer.artcod_shopgroups WHERE acsg_ac_n = _acn AND acsg_spr_key = _lang;
  RETURN COALESCE(s, 'n.a.');
  --
 END $$  LANGUAGE plpgsql STABLE;






 CREATE OR REPLACE FUNCTION TSystem.views__customer__drop() RETURNS VOID AS $$
    --
    -- BITTE UNBEDINGT DIE HINWEISE BEACHTEN ---------------------------------------------------------------------------------------
    --
    -- Diese Funktion darf niemals in ein DB-Update aufgenommen werden! Die Funktion immer vor Ort beim Kunden ändern!
    --
    -- Dies ist eine Funktion, um kundenspezifische Views zu löschen. Sie werden noch vor den PORDAT-Views gelöscht.
    -- Diese Funktion darf niemals in einem DB-Update überschrieben werden. Damit würden Einstellungen beim Kunden verloren gehen!
    -- Die hier gelöschten Views müssen in FUNCTION TSystem.views__customer__create erzeugt werden.
    --
    -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/CustomView
    --
    --------------------------------------------------------------------------------------------------------------------------------
    --
  BEGIN

    --Products VIEW
    DROP VIEW IF EXISTS tkta_connection.products_webshop;--

    --Product Main-Group VIEW
    DROP VIEW IF EXISTS tkta_connection.product_main_groups;--

    --Product Group VIEW
    DROP VIEW IF EXISTS tkta_connection.product_groups;

    --Product Sub Group VIEW
    DROP VIEW IF EXISTS tkta_connection.product_sub_groups;

    --Product-Stock-Status VIEW
    DROP VIEW IF EXISTS tkta_connection.product_stock_status;

    --Product-Stock-Status VIEW Version 2
    DROP VIEW IF EXISTS tkta_connection.product_stock;
    --
    RETURN;
  END $$ LANGUAGE plpgsql;



---------



CREATE OR REPLACE FUNCTION TSystem.views__customer__create() RETURNS VOID AS $$
    --
    -- BITTE UNBEDINGT DIE HINWEISE BEACHTEN ---------------------------------------------------------------------------------------
    --
    -- Diese Funktion darf niemals in ein DB-Update aufgenommen werden! Die Funktion immer vor Ort beim Kunden ändern!
    --
    -- Dies ist eine Funktion, um kundenspezifische Views zu erzeugen. Sie werden nach den PRODAT-Views erstellt.
    -- Diese Funktion darf niemals in einem DB-Update überschrieben werden. Damit würden Einstellungen beim Kunden verloren gehen!
    -- Die hier erzeugten Views müssen in FUNCTION TSystem.views__customer__drop wieder gelöscht werden.
    --
    -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/CustomView
    --
    --------------------------------------------------------------------------------------------------------------------------------
    --
  BEGIN

   -- nötige Funktionen für LIVE-System
   --

   --
   --

   --Products VIEW
   CREATE OR REPLACE VIEW tkta_connection.products_webshop AS

     SELECT
      art.ak_nr AS Product_Code,
      (lang_artbez(art.ak_nr, 'EN')) AS Product_Name,
      art.ak_bez AS Product_Name_DE,
      --art.ak_ac,  -- Bsp:40-40-10 : Group '-' Subgroup '-' Subsubgroup
      (substring(art.ak_ac, '[^-]*')) AS Product_Main_Group,
      (substring(art.ak_ac, '-(.*)-')) AS Product_Group,
      (substring(art.ak_ac, '(?!.*-).*')) AS Product_Sub_Group,
      art.ak_vkpbasfix::numeric(9,2) AS Price,   -- Number XXXXXX.XX
      art.ak_gewicht::numeric(10,3) AS Weight, -- in kg  Number XXXXXX.XXX
      art.insert_date::timestamp AS Insert_Date_Time --  DateTime
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
     ;
   --

   --Product Main-Group VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_main_groups AS

     SELECT DISTINCT
      (substring(art.ak_ac, '[^-]*')) AS Product_Main_Group_Code,
      (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '[^-]*')), 'EN')) AS Product_Main_Group_Desc,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '[^-]*')), 'D')) AS Product_Main_Group_Desc_DE
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
     ORDER BY 1
     ;
   --

   --Product Group VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_groups AS

     SELECT DISTINCT
      (substring(art.ak_ac, '-(.*)-')) AS Product_Group_Code,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '-(.*)-')), 'EN')) AS Product_Group_Desc,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '-(.*)-')), 'D')) AS Product_Group_Desc_DE
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)-') IS NOT NULL)
     ORDER BY 1
     ;
   --

   --Product Sub Group VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_sub_groups AS

     SELECT DISTINCT
      (substring(art.ak_ac, '(?!.*-).*')) AS Product_Sub_Group_Code,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '(?!.*-).*')), 'EN')) AS Product_Sub_Group_Desc,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '(?!.*-).*')), 'D')) AS Product_Sub_Group_Desc_DE
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
     ORDER BY 1
     ;
   --

   --Product-Stock-Status VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_stock_status AS
   SELECT
        art.ak_nr AS Product_Code,
        art.ak_tot-art.ak_res AS Stock,
        IFTHEN(art.ak_tot-art.ak_res>5,'Available','Not available') AS Stock_Status, --( Available / Not Available)
        IFTHEN(art.ak_tot-art.ak_res>5,'Verfügbar','Nicht verfügbar') AS Stock_Status_DE,
        NULL::date AS Stock_Available,
        (SELECT modified_date FROM lag WHERE lg_aknr=ak_nr ORDER BY modified_date DESC LIMIT 1)::timestamp AS Update_Date_Time -- DateTime
       FROM art
       WHERE NOT art.ak_ac LIKE 'ZZ-%'
       AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
       UNION SELECT
        lg_aknr AS Product_Code,
        lg_anztot AS Stock,
        NULL AS Stock_Status, --( Available / Not Available)
        NULL AS Stock_Status_DE,
        lg_lagzudat::date+44 AS Stock_Available, -- including 6 weeks shipping
        lag.modified_date AS Update_Date_Time
       FROM lag
       JOIN art ON lg_aknr=ak_nr
       WHERE lg_ort LIKE 'INVO%'
       AND NOT art.ak_ac LIKE 'ZZ-%'
       AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
       ORDER BY Product_Code, Stock_Status
     ;

    --Product-Stock-Status VIEW Version 2
    CREATE OR REPLACE VIEW tkta_connection.product_stock AS
    SELECT
         art.ak_nr AS Product_Code,
         art.ak_tot AS Stock,
         art.ak_res AS Customer_Orders,
         NULL::date AS Stock_Available,
         (SELECT modified_date FROM lag WHERE lg_aknr=ak_nr ORDER BY modified_date DESC LIMIT 1)::timestamp AS Update_Date_Time -- DateTime
        FROM art
        WHERE NOT art.ak_ac LIKE 'ZZ-%'
        AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
        UNION SELECT
         lg_aknr AS Product_Code,
         lg_anztot AS Stock,
         art.ak_res AS Customer_Orders,
         lg_lagzudat::date+44 AS Stock_Available, -- including 6 weeks shipping
         lag.modified_date AS Update_Date_Time
        FROM lag
        JOIN art ON lg_aknr=ak_nr
        WHERE lg_ort LIKE 'INVO%'
        AND NOT art.ak_ac LIKE 'ZZ-%'
        AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
        ORDER BY Product_Code
      ;

      -- Zugriffe auf VIEWS und Tabellen f?r KTA-SHOP

      GRANT SELECT ON tkta_connection.products_webshop  TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_main_groups   TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_groups    TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_sub_groups  TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_stock_status  TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_stock   TO "KTA-SHOP";

      GRANT SELECT ON TABLE  art            TO "KTA-SHOP";

      GRANT SELECT ON TABLE  artblang           TO "KTA-SHOP";

      GRANT SELECT ON TABLE  lag      TO "KTA-SHOP";

      GRANT SELECT ON TABLE  z_50_customer.artcod_shopgroups TO "KTA-SHOP";

    --
    RETURN;
  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TSystem.RecNoKeyword__create__verpackungsmasse(
  IN _net_weight_kg    varchar,
  IN _length_mm        varchar,
  IN _width_mm         varchar,
  IN _height_mm        varchar,
  IN _rkategorie       varchar,
  IN _rtablename       varchar,
  IN _rdbrid           varchar
 ) RETURNS VOID AS $$
 BEGIN

raise notice '_rdbrid = %, _length_mm = %, _width_mm = %, _height_mm = %, _height_mm = % ', _rdbrid, _length_mm, _width_mm, _height_mm, _height_mm;
        PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(29894),    --- Nettogewicht
                                       rdbrid     => _rdbrid,
                                       rvalue     => _net_weight_kg,
                                       pname      => 'art.verpackungsmasse.net_weight_kg'
                   );

        PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(516),      --- Länge
                                       rdbrid     => _rdbrid,
                                       rvalue     => _length_mm,
                                       pname      => 'art.verpackungsmasse.length_mm'
                   );

    PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(322),      --- Breite
                                       rdbrid     => _rdbrid,
                                       rvalue     => _width_mm,
                                       pname      => 'art.verpackungsmasse.width_mm'
                   );

    PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(26482),    --- Höhe
                                       rdbrid     => _rdbrid,
                                       rvalue     => _height_mm,
                                       pname      => 'art.verpackungsmasse.height_mm'
                   );

  RETURN;
 END $$ LANGUAGE plpgsql;

--############################################## #20216 Seriennummerngenerierung ohne Standardseriennummernformat

-- Generierung von Seriennummern nach https://redmine.prodat-sql.de/issues/16985
-- Muster der Seriennummern #11118, #11173
CREATE OR REPLACE FUNCTION tlager.lagsernr__presetting__create( _ld_id integer, _count integer, _w_wen integer DEFAULT null ) RETURNS SETOF VARCHAR AS $$

  -- alle vorhandenen Vorgebeseriennummer zur Bestellposition, welche keinem LZ zugeordnet sind
  WITH

    -- nicht zugewiesene, noch vorhandene Vorgabeseriennummern
    ld_sernr AS (
      SELECT lgs_sernr
      FROM lagsernr
      JOIN mapsernr ON     ms_lgs_id = lgs_id
                       AND ms_pkey::INTEGER = _ld_id
                       AND ms_table = 'ldsdok'::REGCLASS
      WHERE lgs_w_wen IS null -- Nur nicht zugewiesene SN ausgeben
    ),

    -- Artikelnummer der Bestellung
    ld_data AS (
        SELECT ld_aknr AS aknr FROM ldsdok WHERE ld_id = _ld_id
    ),

    -- Artikelformat beim Wareneingang (true) oder das Standardformat mit führendem ~~ (false)
    -- ################# HPCHO: niemals Standardformat
    sn_vorgabe AS (

        SELECT true AS ac_sn_vorgabe FROM artcod
        JOIN art ON ak_ac = ac_n
        JOIN ld_data ON ld_data.aknr = ak_nr
    ),

    -- die Anzahl der zurückzugebenen Seriennummer wird bestimmt:
    -- entweder der übegebene Parameter _count oder die noch nicht eingelagerte Bestellmenge
    anzahl AS (
      SELECT max(
          ( SELECT count(*)::integer FROM ld_sernr ),
            coalesce( _count, ( SELECT ld_stk - ld_stkl FROM ldsdok WHERE ld_id = _ld_id ), 0 )
      ) AS anz
    ),

    -- erster Teil einer Seriennummer im Standardformat
    ident AS (
        SELECT coalesce( _w_wen :: varchar, -- Bei WE
                      ( SELECT aknr FROM ld_data ), -- Bei Vorgabeseriennummer (im Einkauf)
                        to_char( current_date, 'YYYYMMDD' ) -- Fallback auf heutiges Datum
       ) AS id
    ),

    -- kundenbezogenes Seriennummernformat
    customer_sernr AS (
        SELECT customer_lagsernr__presetting__create AS lgs_sernr
        FROM z_50_customer.customer_lagsernr__presetting__create( _ld_id, ( SELECT anz::integer FROM anzahl ) - ( SELECT count(*)::integer FROM ld_sernr ), _w_wen )
        CROSS JOIN sn_vorgabe
        WHERE _w_wen IS null OR ac_sn_vorgabe
    ),

    -- artikelbezogenens Seriennummernformat
    default_sernr AS (
        SELECT tlager.sernr__ak_nr__create( aknr, ( SELECT anz::integer FROM anzahl ) - ( SELECT count(*)::integer FROM ld_sernr ) ) AS lgs_sernr
        FROM ld_data
        CROSS JOIN sn_vorgabe
        WHERE _w_wen IS null OR ac_sn_vorgabe
    )

  SELECT lgs_sernr FROM (

    -- alle vorhandenen Vorgabeseriennummern
    SELECT
      0 AS sort,
      lgs_sernr
    FROM ld_sernr


    UNION

    -- alle Kunden-Vorgabeseriennummern
    SELECT
      1 AS sort,
      lgs_sernr
    FROM customer_sernr

    UNION

    -- alle Default-Vorgabeseriennummern
    SELECT
      2 AS sort,
      lgs_sernr
    FROM default_sernr

/*
    -- Für HPCHO sollen diese Legacy-Seriennummern nicht mehr erzeugt werden.

    UNION

    -- Alle generierten Seriennummern im Standardformat bestehen aus Ident + einer laufenden Nummer
    -- Der Ident kann sein (siehe WITH Query 'ident'):
    --   1. die aktuelle WE-Nummer,
    --   2. Vorgabeseriennummer (Bestellung) oder
    --   3. das aktuelle Datum
    -- Hier prüfen wir, ob ausreichend Seriennummern generiert waren. Im Fall nein, zB es waren 10 bestellt aber 12 Lagzugang werden 2 zusätzliche erstellt.

    SELECT
      3 AS sort,
      '~~' || ident || ' #' || lpad((start_nr + generate_series( 1, ( SELECT anz FROM anzahl )))::varchar, 3, '0' )
    FROM (
           SELECT
              id AS ident,
              CASE WHEN _w_wen IS NULL
                                -- Abfrage der maximalen laufenden Nummer (nicht bei WE)
                THEN COALESCE(( SELECT
                                  RIGHT(lgs_sernr, LENGTH(lgs_sernr) - LENGTH('~~'|| id ||' #'))::INT -- Extrahieren der laufenden Nummer
                                FROM lagsernr
                                WHERE lgs_sernr LIKE '~~'|| id ||' #%'
                                ORDER BY lgs_sernr DESC
                                LIMIT 1 ),
                               0)
                ELSE 0
                END AS start_nr
           FROM ident
         ) AS q1
  */

    EXCEPT

    -- aussortiert wird alles was bereits mit einem passenden WE in Verbindung gebracht wird
    SELECT generate_series AS sort, lgs_sernr FROM generate_series( 1, 2 ), lagsernr WHERE
           lgs_w_wen = _w_wen
        OR lgs_w_wen IN (SELECT w_wen FROM wendat WHERE w_lds_id = _ld_id )
  ) AS x
  -- Sortierung: Vorgabeseriennummern haben Priorität
  ORDER BY sort ASC, lgs_sernr ASC
  -- Anzahl der Seriennummern:
  -- Maximum aus Anzahl der Vorgabeseriennummern, Bestellmenge und WE-Menge (soweit übergeben)
  LIMIT ( SELECT anz FROM anzahl )

$$ LANGUAGE sql STABLE;
