/************* DÖBLER ****************/

    /*  #7089 Stücklistenimport aus CSV z.B. '16-9999-00-000.csv' --
        EDI
        Funktion ordnet 'AC' bei Import aus CSV-Datei --
        Parameter:
          lfkurz - Spalte 'Kunde'
          abk_kl - Spalte 'Klassifikation'
     */
    CREATE OR REPLACE FUNCTION ak_ac_r_DOEBLER(lfkurz VARCHAR, abk_kl VARCHAR) RETURNS VARCHAR AS $$
      BEGIN
        IF abk_kl = 'K' THEN
            RETURN 'KT1001';        --  keine Stammkarte
        ELSE
            CASE lfkurz             --  Kundekurzname
              WHEN 'Tomra' THEN
                RETURN 'PR1010';    --  AC für Kunde 'Tomra'
              WHEN 'SLM' THEN
                RETURN 'PR1025';    --  AC für Kunde 'SLM'
              WHEN 'Atlas' THEN
                RETURN 'PR1027';    --  AC für Kunde 'Atlas'
              WHEN 'Medac' THEN
                RETURN 'PR1030';
              WHEN 'Airbus' THEN
                RETURN 'PR1031';
              WHEN 'ALH' THEN
                RETURN 'PR1032';
              WHEN 'ANG' THEN
                RETURN 'PR1033';
              WHEN 'ARO' THEN
                RETURN 'PR1034';
              WHEN 'ALS' THEN
                RETURN 'PR1035';
              WHEN 'NHA' THEN
                RETURN 'PR1036';
              WHEN 'ATR' THEN
                RETURN 'PR1037';
              WHEN 'ISW' THEN
                RETURN 'PR1038';
              WHEN 'ALBIS' THEN
                RETURN 'PR1039';
              WHEN 'KORN' THEN
                RETURN 'PR1008';
              ELSE
                RAISE EXCEPTION '%', Format(lang_text(29186) /*'Fehler beim Datenimport - unbekannte Zuordnung AC durch Spalte Kunde, Wert: %'*/, lfkurz);
            END CASE;
        END IF;
    END $$ LANGUAGE plpgsql IMMUTABLE;
    --

    /*  #7089 Stücklistenimport aus CSV z.B. '16-9999-00-000.csv' --
        EDI
        Funktion ordnet 'AVOR-Karte' bei Import aus CSV-Datei --
        Parameter:
          abk_kl - Spalte 'Klassifikation'
     */
    CREATE OR REPLACE FUNCTION opl_r_DOEBLER(abk_kl VARCHAR) RETURNS INTEGER AS $$
      BEGIN
        IF nullif(abk_kl, '') <> 'K' THEN -- NULL oder '' geben NULL zurück
            CASE abk_kl -- Klassifikation
              WHEN 'A' THEN
                RETURN 6861;
              WHEN 'B' THEN
                RETURN 6036;
              WHEN 'C' THEN
                RETURN 6057;
              WHEN 'D' THEN
                RETURN 6034;
              WHEN 'F' THEN
                RETURN 6035;
              ELSE
                RAISE EXCEPTION '%', Format(lang_text(29187) /*'Fehler beim Datenimport - unbekannte Zuordnung ASK durch Spalte Klassifikation, Wert: %'*/, abk_kl);
            END CASE;
        ELSE
            RETURN NULL;
        END IF;
    END $$ LANGUAGE plpgsql IMMUTABLE;
    --