-- Special Functions für TestComplete.
-- Erstellen von Testdaten für Oberflächentests.

SET client_min_messages TO WARNING;

CREATE SCHEMA IF NOT EXISTS z_05_testcomplete;


CREATE OR REPLACE FUNCTION z_05_testcomplete.cleanup(
    ) RETURNS void AS $$
    BEGIN

      DELETE
        FROM wareneingangskontrolle
        WHERE wek_ak_nr like 'TC_AK%';

      DELETE
        FROM wendat
        WHERE w_lds_id IN (
                            SELECT p_id
                            FROM TWawi.ldsdok_pos
                            WHERE p_aknr LIKE 'TC_AK%'
                          );

      DELETE
         FROM picndoku
         WHERE pd_dokident IN ( SELECT DISTINCT ld_dokunr
              FROM  ldsdok
              WHERE ld_aknr LIKE 'TC_AK%');

      UPDATE ldsdok
      SET ld_dokunr = null
      WHERE ld_aknr like 'TC_AK%';

      DELETE
        FROM TWawi.ldsdok_pos
        WHERE p_nummer LIKE 'TC_LDS%';

      DELETE
        FROM ldsdok
        WHERE ld_aknr LIKE 'TC_AK%';

      DELETE
        FROM beleg
        WHERE bel_nummer like 'LFS-TC-00%';

      DELETE
        FROM belegdokument_keys
        WHERE beld_key = 999;

      DELETE
        FROM belegpos
        WHERE belp_aknr like 'TC_AK%';

      DELETE
        FROM belegdokument
        WHERE beld_dokunr like 'LFS-TC-00%';

      DELETE
        FROM bestvorschlagpos
        WHERE bvp_aknr like 'TC_AK%';

      DELETE
        FROM belzeil_grund
        WHERE bz_aknr LIKE 'TC_AK%';

      DELETE
        FROM lifsch
        WHERE l_aknr LIKE 'TC_AK%';

      DELETE
        FROM picndoku
        WHERE pd_dokident IN (
          SELECT DISTINCT ag_dokunr
          FROM auftg
          WHERE ag_nr LIKE 'TC_AUFTG%'
        );

      UPDATE auftg SET
          ag_dokunr = null
          WHERE ag_nr LIKE 'TC_AUFTG%';

      DELETE
        FROM auftg
        WHERE ag_nr LIKE 'TC_AUFTG%'
           OR ag_aknr LIKE 'TC_AK%';

      DELETE
        FROM epreis
        WHERE e_aknr LIKE 'TC_AK%';

      DELETE
        FROM lag
        WHERE lg_ort LIKE 'TC_LGO_%'
           OR lg_aknr like 'TC_AK%';

      DELETE
        FROM lagerorte
        WHERE lgo_name LIKE 'TC_LGO_%';

      DELETE
        FROM invlag
        WHERE il_aknr LIKE 'TC_AK%';

      ALTER TABLE artpruefung
      disable TRIGGER artpruefung__b_id_checkUserRights;

      DELETE
        FROM artpruefung
        WHERE apr_aknr LIKE 'TC_AK%';

      ALTER TABLE artpruefung
      ENABLE trigger artpruefung__b_id_checkUserRights;

      DELETE
        FROM adk
        WHERE ad_krz LIKE 'TC_ADK%';

      DELETE
        FROM art
        WHERE ak_nr LIKE 'TC_AK%';

      DELETE
        FROM bdea
        WHERE ba_ix IN (
                        SELECT ab_ix
                        FROM abk
                        WHERE ab_ap_nr LIKE 'TC_ABK%'
                       );

      DELETE
        FROM abk
        WHERE ab_ap_nr LIKE 'TC_ABK%';

      DELETE
        FROM ksv
        WHERE ks_abt LIKE 'TC_KS_%';

    END $$ LANGUAGE plpgsql;


-- Artikel anlegen
--SELECT tsystem.function__drop_by_regex('artikel_insert', 'z_05_testcomplete', true, true);
CREATE OR REPLACE FUNCTION z_05_testcomplete.artikel_insert(
      _aknr varchar,
      _ac   varchar = 'KT1001'
  ) RETURNS varchar AS $$

    INSERT INTO art (  ak_ac,   ak_nr,  ak_bez,                   ak_standard_mgc )
    VALUES          ( _ac,      _aknr,  'Testcomplete ' || _aknr , 1)
    RETURNING ak_nr;

  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION z_05_testcomplete.artikel__mit_kontrollm__insert(
      _aknr varchar,
      _pos  integer
  ) RETURNS varchar AS $$
  BEGIN

    INSERT INTO art (  ak_ac,   ak_nr,  ak_bez,                   ak_standard_mgc)
    VALUES          ( 'KT1001', _aknr,  'Testcomplete ' || _aknr , 1) ;

    IF _aknr IS NOT null THEN
      INSERT INTO artpruefung (apr_pos, apr_aknr, apr_bez,         apr_eing, apr_ausg)
      VALUES                  (_pos,    _aknr,    'APR_TC_'||_pos, true,     true);
    END IF;

    RETURN _aknr;

  END $$ LANGUAGE plpgsql;

-- Lagerort anlegen
CREATE OR REPLACE FUNCTION z_05_testcomplete.lagerort_insert(
      _lgoname varchar
  ) RETURNS varchar AS $$

    INSERT INTO lagerorte ( lgo_name, lgo_desc,               lgo_verfgbar )
    VALUES                ( _lgoname, 'Lager - ' || _lgoname, true )
    RETURNING lgo_name;

  $$ LANGUAGE sql;

-- Lagerbestand anlegen
CREATE OR REPLACE FUNCTION z_05_testcomplete.lagerbestand_insert(
      _aknr  varchar,
      _lgo   varchar,
      _menge integer
  ) RETURNS void AS $$

    INSERT INTO lag ( lg_aknr, lg_ort, lg_anztot, lg_chnr )
    VALUES          ( _aknr,   _lgo,   _menge,    'TC' );

  $$ LANGUAGE sql;

-- Anlegen einer Bestellposition
CREATE OR REPLACE FUNCTION z_05_testcomplete.lds_insert(
      _bez        varchar,
      _pos        integer,
      _art        varchar,
      _menge      integer,
      _preis      numeric,
      _chk_artprf boolean default false
    ) RETURNS varchar AS $$
    DECLARE
     _pid integer;
     _pnr varchar;
    BEGIN
      INSERT INTO  twawi.ldsdok_pos ( p_code, p_nummer, p_pos, p_aknr, p_me,
                                      p_adkrz, p_menge, p_preis, p_waer )
      VALUES                        ( 'E',    _bez ,    _pos , _art,   tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( _art ),
                                      '#',     _menge,  _preis, 'EUR')
      RETURNING p_id, p_nummer INTO _pid, _pnr;

      IF _chk_artprf THEN
        INSERT INTO artPruefungTest ( aprt_pos , aprt_apr_id, aprt_bez, aprt_ldid )
        SELECT                        _pos,      apr_id,      apr_bez,  _pid
        FROM artpruefung
        WHERE apr_aknr = _art;
      END IF;

      RETURN _pnr;
    END $$ LANGUAGE plpgsql;


  CREATE OR REPLACE FUNCTION z_05_testcomplete.auftg_insert(
      _agnr       varchar,
      _pos        integer,
      _aknr       varchar,
      _menge      integer,
      _preis      numeric,
      _chk_artprf boolean,
      _ag_astat   varchar default 'E',   --- Erweiterung: neue Eingangsparameter #18058
      _ag_lkn     varchar default '#',
      _ag_krzl    varchar default '#',
      _ag_krzf    varchar default '#'
    ) RETURNS varchar AS $$
    DECLARE
     agid integer;
     agnr varchar;
    BEGIN
      IF _ag_krzl = '#' AND _ag_lkn <> '#' THEN
           _ag_krzl := _ag_lkn;
      END IF;

      IF _ag_krzf = '#' AND _ag_lkn <> '#' THEN
           _ag_krzf := _ag_lkn;
      END IF;

      INSERT INTO auftg ( ag_astat, ag_nr, ag_pos, ag_lkn , ag_krzl , ag_krzf , ag_aknr,
                          ag_stk, ag_mcv,
                          ag_preis, ag_vkp, ag_prkl, ag_kukl )
      VALUES            ( _ag_astat,_agnr, _pos  , _ag_lkn, _ag_krzl, _ag_krzf, _aknr,
                          _menge, Tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( _aknr ),
                          _preis,   _preis, 1,       1 )
      RETURNING ag_nr, ag_id INTO agnr, agid;

      IF _chk_artprf THEN
        INSERT INTO artPruefungTest ( aprt_pos , aprt_apr_id, aprt_bez, aprt_agid )
        SELECT                        _pos,      apr_id,      apr_bez,  agid
        FROM artpruefung
        WHERE apr_aknr = _aknr;
      END IF;

      RETURN agnr;

    END $$ LANGUAGE plpgsql;


-- Anlegen von Artikel und Bestellung abhängig von Positonszahl
CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__bestellung_anlegen(
      _anz_pos      integer = 1,
      _start_menge  integer = 1,
      _start_preis  integer = 1
    ) RETURNS varchar AS $$
    DECLARE
      i    integer;
      aknr varchar;
      p_nr varchar;
    BEGIN

      -- aufräumen
      PERFORM z_05_testcomplete.cleanup();
      -- Lagerort anlegen
      PERFORM  z_05_testcomplete.lagerort_insert( 'TC_LGO_' || current_date );

      -- Abhängig von Positionsanzahl auch Artikel und Bestellposition anlegen
      FOR i  IN 1 .. _anz_pos LOOP
        aknr := z_05_testcomplete.artikel_insert( 'TC_AK_'|| i || '_' || current_date );
        p_nr := z_05_testcomplete.lds_insert(
                    'TC_LDS_LAGZU_' || current_date,
                    i,
                    aknr,
                    _start_menge + ( i -1 ),
                    _start_preis + (i-1)
                );
      END LOOP;

      -- Rückgabe der Bestellnummer
      RETURN p_nr;
    END $$ LANGUAGE plpgsql;



-- Anlegen von Artikel, Lagerbeständen und Bestellung abhängig von Positionsanzahl
CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__bestellung_anlegen__mit_lagerbestand(
      _anz_pos     integer = 1,
      _start_menge integer = 1,
      _start_preis integer = 1
    ) RETURNS varchar AS $$
    DECLARE
      i           integer;
      aknr        varchar;
      lagermenge  integer := 50;
      lgo         varchar;
      p_nr        varchar;
    BEGIN

      -- aufräumen
      PERFORM z_05_testcomplete.cleanup();
      -- Lagerort anlegen
      lgo := z_05_testcomplete.lagerort_insert( 'TC_LGO_' || current_date );

      -- Abhängig von Positionsanzahl Artikel mit Lagerbestand anlegen und dazugehörige Bestellposition
      FOR i  IN 1 .. _anz_pos LOOP
        aknr := z_05_testcomplete.artikel_insert( 'TC_AK_' || i || '_' || current_date );
        PERFORM z_05_testcomplete.lagerbestand_insert(
                    aknr,
                    lgo,
                    lagermenge + (_start_menge + ( i -1 )) * 5
                );
        p_nr := z_05_testcomplete.lds_insert(
                    'TC_LDS_LAGAB_' || current_date,
                    i,
                    aknr,
                    _start_menge + ( i -1 ),
                    _start_preis + (i-1)
                );
      END LOOP;

      -- Rückgabe Bestellnummer
      RETURN p_nr;

    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__bestellung_mit_kontrollm__anlegen(
      _anz_pos     integer DEFAULT 1,
      _start_menge integer DEFAULT 1,
      _start_preis integer DEFAULT 1
    ) RETURNS varchar AS $$
    DECLARE
      aknr varchar;
      p_nr varchar;
    BEGIN
      -- aufräumen
      PERFORM z_05_testcomplete.cleanup();

      FOR i  IN 1 .. _anz_pos LOOP
        aknr := z_05_testcomplete.artikel__mit_kontrollm__insert( 'TC_AK_' || i || '_' || current_date , i);
        p_nr := z_05_testcomplete.lds_insert(
                    'TC_LDS_LAGAB_' || current_date,
                    i,
                    aknr,
                    _start_menge + ( i -1 ),
                    _start_preis + (i-1)
                );

      END LOOP;

      -- Rückgabe Bestellnummer
      RETURN p_nr;
    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__bestellung_mit_kontrollm_lagerbestand__anlegen(
      _anz_pos     integer DEFAULT 1,
      _start_menge integer DEFAULT 1,
      _start_preis integer DEFAULT 1
    ) RETURNS varchar AS $$
    DECLARE
      aknr        varchar;
      p_nr        varchar;
      lagermenge  integer := 50;
      lgo         varchar;

    BEGIN
      -- aufräumen
      PERFORM z_05_testcomplete.cleanup();

      -- Lagerort anlegen
      lgo :=  z_05_testcomplete.lagerort_insert( 'TC_LGO_' || current_date );


      FOR i  IN 1 .. _anz_pos LOOP
        aknr := z_05_testcomplete.artikel__mit_kontrollm__insert( 'TC_AK_' || i || '_' || current_date , i);
      PERFORM z_05_testcomplete.lagerbestand_insert(
          aknr,
          lgo,
          lagermenge + (_start_menge + ( i -1 )) * 5
            );
        p_nr := z_05_testcomplete.lds_insert(
                    'TC_LDS_LAGAB_' || current_date,
                    i,
                    aknr,
                    _start_menge + ( i -1 ),
                    _start_preis + (i-1) ,
                    true
                );

      END LOOP;

      -- Rückgabe Bestellnummer
      RETURN p_nr;
    END $$ LANGUAGE plpgsql;

  -- Auftragsanlage zu bereits vorhandenem Artikel!!
  -- anderer Auftragsname, kein automatisches Löschen vorgesehen
  CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__auftg(
      _aknr       varchar,
      _menge      integer,
      _preis      numeric
    ) RETURNS varchar AS $$
    DECLARE
      agid varchar;
    BEGIN
       -- aufräumen
      PERFORM z_05_testcomplete.cleanup();

      -- Artikel muss vorhanden sein
       agid := z_05_testcomplete.auftg_insert(
                    'AUFTG_TC_' || current_date || '_' || localtime(0),
                    1,
                    _aknr,
                    _menge,
                    _preis,
                    false
                );
    RETURN agid;
  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__auftg_ohne_lagermenge__anlegen(
      _anz_pos     integer DEFAULT 1,
      _start_menge integer DEFAULT 1,
      _start_preis integer DEFAULT 1
    ) RETURNS varchar AS $$
    DECLARE
      aknr        varchar;
      agid        varchar;
    BEGIN
      -- aufräumen
      PERFORM z_05_testcomplete.cleanup();

      FOR i  IN 1 .. _anz_pos LOOP
        aknr := z_05_testcomplete.artikel_insert( 'TC_AK_' || i || '_' || current_date);

       -- zusätzlichen Lieferanten anlegen
        INSERT INTO adk(ad_krz) VALUES ('TC_ADK');
        INSERT INTO epreis (e_aknr, e_lkn, e_mcv) VALUES (aknr, 'TC_ADK', tartikel.me__art__artmgc__m_id__by__ak_standard_mgc( aknr ));

        agid := z_05_testcomplete.auftg_insert(
                    'TC_AUFTG_LAGAB_' || current_date,
                    i,
                    aknr,
                    _start_menge + ( i - 1 ),
                    _start_preis + ( i - 1 ),
                    false
                );
      END LOOP;

      -- Rückgabe Bestellnummer
      RETURN agid;
    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__auftg_mit_lagermenge__anlegen(
      _anz_pos     integer DEFAULT 1,
      _start_menge integer DEFAULT 1,
      _start_preis integer DEFAULT 1
    ) RETURNS varchar AS $$
    DECLARE
      aknr        varchar;
      agnr        varchar;
      lagermenge  integer := 50;
      lgo         varchar;
    BEGIN
    -- aufräumen
      PERFORM z_05_testcomplete.cleanup();

      -- Lagerort anlegen
      lgo := z_05_testcomplete.lagerort_insert( 'TC_LGO_' || current_date );


      FOR i  IN 1 .. _anz_pos LOOP
        aknr := z_05_testcomplete.artikel_insert( 'TC_AK_' || i || '_' || current_date);
        PERFORM z_05_testcomplete.lagerbestand_insert(
          aknr,
          lgo,
          lagermenge + (_start_menge + ( i -1 )) * 5
        );
        agnr := z_05_testcomplete.auftg_insert(
                    'TC_AUFTG_LAGAB_' || current_date,
                    i,
                    aknr,
                    _start_menge + ( i - 1 ),
                    _start_preis + ( i - 1 ),
                    false
                );
      END LOOP;

      -- Rückgabe Bestellnummer
      RETURN agnr;
    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__auftg_mit_lagermenge_kontrollm__anlegen(
      _anz_pos     integer DEFAULT 1,
      _start_menge integer DEFAULT 1,
      _start_preis integer DEFAULT 1
    ) RETURNS varchar AS $$
    DECLARE
      aknr        varchar;
      agid        varchar;
      lagermenge  integer := 50;
      lgo         varchar;
    BEGIN
      -- aufräumen
      PERFORM z_05_testcomplete.cleanup();

      -- Lagerort anlegen
      lgo := z_05_testcomplete.lagerort_insert( 'TC_LGO_' || current_date );


      FOR i  IN 1 .. _anz_pos LOOP
        aknr := z_05_testcomplete.artikel__mit_kontrollm__insert( 'TC_AK_' || i || '_' || current_date, i );
        PERFORM z_05_testcomplete.lagerbestand_insert(
          aknr,
          lgo,
          lagermenge + ( _start_menge + ( i -1 ) ) * 5
        );
        agid := z_05_testcomplete.auftg_insert(
                    'TC_AUFTG_LAGAB_' || current_date,
                    i,
                    aknr,
                    _start_menge + ( i - 1 ),
                    _start_preis + ( i - 1 ),
                    true
                );
       END LOOP;

      -- Rückgabe Auftragsnummer
      RETURN agid;
    END $$ LANGUAGE plpgsql;

-- SQL Funktion die eine ABK anlegt und die ABK-Nr. zurück gibt damit ich die Zeiterfassung testen kann. -> mind. 1 Arbeitsgang in der ABK muss vorhanden sein
CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__abk__Create(
      _anzahl_ag integer default 1
    ) RETURNS integer AS $$
    DECLARE
      _abix integer;
    BEGIN

      -- aufräumen
      PERFORM z_05_testcomplete.cleanup();

      -- ABK anlegen
      INSERT INTO abk ( ab_ap_nr )
      VALUES          ( 'TC_ABK_ ' || current_date )
      RETURNING ab_ix INTO _abix;

      -- Kostenstellen und Arbeitsgänge

      FOR i in 1 .. _anzahl_ag LOOP
        PERFORM z_05_testcomplete.ks__insert('TC_KS_'|| i);

        INSERT INTO ab2(a2_ab_ix, a2_ks) VALUES (_abix, 'TC_KS_'|| i);
      END LOOP;

      RETURN _abix;
    END $$ language plpgsql;

-- Kostenstelle anlegen
CREATE OR REPLACE FUNCTION z_05_testcomplete.ks__insert(
      _ksabt varchar
    ) RETURNS void AS $$

      INSERT INTO ksv (  ks_abt )
      VALUES          ( _ksabt) ;

    $$ LANGUAGE sql volatile;



-- Anlage Parameter für die Gruppe COC.ART (#15113)
CREATE OR REPLACE FUNCTION z_05_testcomplete.recnogroup__insert(

  ) RETURNS void as $$
  BEGIN
      INSERT INTO recnogroup (reg_pos, reg_pname, reg_tablename, reg_bez, reg_gruppe, reg_field_name, reg_field_value, reg_vorgabenliste, reg_paramtype,reg_exclusive, reg_default, reg_autoinsert)
      VALUES ( 1, 'coc.sonstiges',   'art', 'Sonstiges',   'COC.ART', 'ak_ac', 'KT1001', false, 'ptVARCHAR', true, null, true),
             ( 1, 'coc.unbehandelt', 'art', 'Unbehandelt', 'COC.ART', 'ak_ac', 'KT1001', false, 'ptBOOLEAN', true, true, true),
             ( 1, 'coc.gueteklasse', 'art', 'Güteklasse',  'COC.ART', 'ak_ac', 'KT1001', false, 'ptENUM',    true, 'A',  true),
             ( 1, 'coc.Lackfarbe',   'art', 'Lackfarbe',   'COC.ART', 'ak_ac', 'KT1001', false, 'ptENUM',    true, null, true)
      ON CONFLICT DO NOTHING;


      INSERT INTO recnoenums (rege_reg_pname, rege_code, rege_bez, rege_pos)
      VALUES
        ('coc.lackfarbe', 'B',  'Blau',    2),
        ('coc.lackfarbe', 'SW', 'Schwarz', 1),
        ('coc.gueteklasse', 'A', 'Supertoll',  1),
        ('coc.gueteklasse', 'B', 'Geht schon', 2)
      ON CONFLICT DO NOTHING;
  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION z_05_testcomplete.lieferschein__insert(
      _aknr varchar
  ) RETURNS varchar AS $$
  DECLARE
      _beld_dok_key integer := 999;
      _bel_id       integer;
      _beld_dokunr  varchar;
  BEGIN

      INSERT INTO belegdokument_keys(beld_key)
      VALUES (_beld_dok_key);

      INSERT INTO belegdokument ( beld_belegtyp, beld_belegart, beld_dokunr, beld_krzbesteller, beld_krzlieferung, beld_krzrechnung)
      VALUES ('LFS', 3, 'LFS-TC-00'||current_date, '#', '#', '#')
      RETURNING beld_dokunr INTO _beld_dokunr;

      _bel_id :=
         bel_id
         FROM beleg
         WHERE bel_nummer = 'LFS-TC-00'||current_date
         AND bel_belegtyp = 'LFS';

      INSERT INTO belegpos ( belp_belegtyp, belp_dokument_id, belp_krzbesteller, belp_krzrechnung, belp_krzlieferung, belp_aknr, belp_mce, belp_beleg_id, belp_pos, belp_waehr)
      VALUES ('LFS', _beld_dok_key,  '#', '#', '#', _aknr, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_aknr) , _bel_id, 1, 'EUR');

      RETURN _beld_dokunr;
  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION z_05_testcomplete.lieferschein__get(
  ) RETURNS varchar as $$

  BEGIN
      PERFORM z_05_testcomplete.cleanup();

      -- Recnos anlegen
      PERFORM z_05_testcomplete.recnogroup__insert();

      -- Artikel mit Parametern anlegen
      PERFORM z_05_testcomplete.artikel_insert( 'TC_AK_'||  current_date );

      -- freien Lieferschein dazu anlegen
      RETURN z_05_testcomplete.lieferschein__insert('TC_AK_'||  current_date);

  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__bestanf__anlegen(IN _ak_nr varchar(40), IN _menge integer DEFAULT 1)  RETURNS VARCHAR AS $$
    DECLARE
         ba_nr_ varchar;
    BEGIN
  INSERT INTO bestanftxt(
      ba_nr,
      ba_titel,
      ba_termweek,
      ba_dat
    )
    VALUES (
      'TC_BESTANF_' || current_date || '_' || localtime(0),
      'TC_BESTANF Titel',
      null,
      current_date + 14
    )
    RETURNING ba_nr INTO ba_nr_;

  INSERT INTO bestanfpos(
     bap_pos,
     bap_banr,
     bap_aknr,
     bap_menge,
     bap_mecod,
     bap_termin
  )
  VALUES (
     1,                   --- bap_pos,
     ba_nr_,              --- bap_banr,
     _ak_nr,              --- bap_aknr,
     _menge,              --- bap_menge,
     1,                   --- bap_mecod,
     current_date + 14    --- bap_termin,
       );

      -- Rückgabe Nr. der Bestellanforderung
      RETURN ba_nr_;
    END $$ LANGUAGE plpgsql;

---  GEO (Anfang)
CREATE OR REPLACE FUNCTION z_05_testcomplete.testszenario__angebot__insert(
      _ag_nr    varchar,
      _ag_pos   integer,
      _ag_lkn   varchar,
      _ag_aknr  varchar,
      _ag_stk   numeric(14,6)
  ) RETURNS varchar AS $$

  DECLARE ag_nr_  varchar;

  BEGIN

    INSERT INTO auftg
      (ag_astat, ag_nr, ag_pos, ag_lkn, ag_krzl, ag_krzf, ag_bdat, ag_aknr, ag_stk, ag_kdatum, ag_prkl, ag_kukl)
    VALUES
      ('A', _ag_nr, _ag_pos, _ag_lkn, _ag_lkn, _ag_lkn, current_date, _ag_aknr, _ag_stk, current_date + 14, 1, 1)
    RETURNING ag_nr INTO ag_nr_;

    RETURN ag_nr_;

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.recnogroup_insert(
      _reg_tablename      varchar,
      _reg_gruppe_textno  integer,
      _reg_bez_textno     integer,
      _reg_paramtype      varchar,
      _reg_pname          varchar
  ) RETURNS varchar AS $$

    INSERT INTO recnogroup (reg_tablename, reg_gruppe_textno, reg_bez_textno, reg_paramtype, reg_autoinsert, reg_pname)    -- , reg_default
                 SELECT _reg_tablename, _reg_gruppe_textno, _reg_bez_textno, _reg_paramtype, false, _reg_pname             -- , false
    WHERE NOT EXISTS(SELECT true FROM recnogroup WHERE reg_bez_textno = _reg_bez_textno AND reg_tablename = _reg_tablename)
    RETURNING reg_pname;

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_05_testcomplete.recnogroup__coc__create() RETURNS VOID AS $$
  DECLARE
      arr__reg_bez_textno integer[] = array[25214, 26097, 26103, 26102, 26096, 26101, 26100, 26099];
      arr__reg_pname      varchar[] = array['None', 'Zeugn_Waermbehandl', 'ErstMusterPruefBericht', 'Art_PruefBeschein', 'BemText', 'MatZeignis', 'Zeugn_OberflBechandl', 'MessProtokoll'];
      i bigint;
  BEGIN

    FOR i IN 1 .. array_upper(arr__reg_bez_textno, 1)
    LOOP
       ---                                          reg_tablename                                                         reg_pname
       PERFORM z_05_testcomplete.recnogroup_insert('art'   , 29351, arr__reg_bez_textno[i], 'ptVARCHAR', lang_text(29351) || '.' || arr__reg_pname[i]);
       PERFORM z_05_testcomplete.recnogroup_insert('cocpos', 15973, arr__reg_bez_textno[i], 'ptVARCHAR', lang_text(15973) || '.' || arr__reg_pname[i]);
    END LOOP;
    -- 15973  29351
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.TC_ART__ak_nr__delete(IN _ak_nr VARCHAR) RETURNS VOID AS $$

  BEGIN
    IF EXISTS (SELECT true FROM art WHERE ak_nr = _ak_nr) THEN

        PERFORM tartikel.art__ak_nr__delete(_ak_nr);

        RAISE NOTICE 'Artikel % ist erforderlich gelöscht', _ak_nr;

    END IF;
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.TC_art_opl_op2_op6_abk__anlegen() RETURNS INTEGER AS $$
 DECLARE
    --last_id int;
    art_      VARCHAR := 'TC_ART__GETRIEBE';
    rart_     VARCHAR := 'TC_ART__RMAT';
    art_mgc_  INTEGER;
    rart_mgc_ INTEGER;
    w_lgort_  VARCHAR := 'H2 | R1';
    op_ix_    INTEGER;
    ab2_id_   INTEGER;
    op2_id_   INTEGER;
    abk_ix_   INTEGER;
    ld_id_    INTEGER;
    w_wen_    INTEGER;
    ag_id_    INTEGER;
    l_nr_     INTEGER;

    p_menge_  INTEGER := 5;
 BEGIN

          DELETE FROM lagsernr WHERE lgs_l_nr  IN (SELECT l_nr  FROM lifsch WHERE l_aknr   iLIKE 'TC_ART__%');
          DELETE FROM lagsernr WHERE lgs_lg_id IN (SELECT lg_id FROM lag    WHERE lg_aknr  iLIKE 'TC_ART__%');
          DELETE FROM lagsernr WHERE lgs_w_wen IN (SELECT w_wen FROM wendat WHERE w_aknr   iLIKE 'TC_ART__%');
          --- Artikellöschen CASCADE
    PERFORM z_05_testcomplete.TC_ART__ak_nr__delete(art_);
    PERFORM z_05_testcomplete.TC_ART__ak_nr__delete(rart_);
    ---

    INSERT INTO adk ( ad_krz ) SELECT 'AWKRZ' WHERE NOT EXISTS(SELECT true FROM adk WHERE ad_krz = 'AWKRZ');

    INSERT INTO art  (ak_ac, ak_nr, ak_bez, ak_standard_mgc)               VALUES  ('KT1001',  art_ , 'Artikel',  1);
    INSERT INTO art  (ak_ac, ak_nr, ak_bez, ak_standard_mgc, ak_sernrreq)  VALUES  ('RM1001',  rart_, 'Artikel',  1, true);

    art_mgc_  := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_);
          rart_mgc_ := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(rart_);

    INSERT INTO ksv ( ks_abt )
      SELECT          'MON'
      WHERE NOT EXISTS(SELECT true FROM ksv WHERE ks_abt = 'MON');
    INSERT INTO ksv ( ks_abt, ks_krzl, ks_ausw )
      SELECT          'AW'  , 'AWKRZ', True
      WHERE NOT EXISTS(SELECT true FROM ksv WHERE ks_abt = 'AW' AND ks_krzl = 'AWKRZ' AND ks_ausw = True);

    INSERT INTO opl (op_n, op_vi)
      VALUES        (art_, 1)
    RETURNING op_ix INTO op_ix_;

    INSERT INTO op2 ( o2_ix , o2_n, o2_ks, o2_txt )
      VALUES        ( op_ix_, '10', 'MON',  'Mon' );

    INSERT INTO op2 ( o2_ix, o2_n, o2_ks, o2_aw,   o2_aknr,     o2_txt )
      VALUES        (op_ix_, '20',  'AW',  True, 'AW.0001', 'Auswärts' );

    INSERT INTO op6 ( o6_ix , o6_aknr, o6_m, o6_mce )
      VALUES        ( op_ix_, rart_  ,    1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(rart_));

    --- Materialbestellung
    INSERT INTO twawi.ldsdok_pos ( p_code, p_nummer                                   , p_pos, p_aknr , p_me     , p_adkrz  , p_menge , p_preis, p_waer, p_status, p_status1, p_status2)
    VALUES                      ( 'E'   , 'TC_' || (SELECT coalesce( max(ld_id) + 1, 1 ) FROM ldsdok), 1    , rart_  , rart_mgc_, 'AUTO-AG', p_menge_, 100    , 'EUR' , 'E'     , NULL     , 'W')
      RETURNING p_id INTO ld_id_;

    -- Lagerzugang auf Bestellung
    INSERT INTO wendat (w_aknr,  w_zug_mec                                                 , w_lds_id, w_zugang, w_lgchnr, w_lgort)
    VALUES            (rart_  ,  tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(rart_), ld_id_  , p_menge_, '123'   , w_lgort_)
    RETURNING w_wen INTO w_wen_;
    ---

    INSERT INTO twawi.ldsdok_pos ( p_code, p_nummer, p_pos, p_adkrz, p_aknr, p_menge )
      VALUES                     (    'I',    'PA' ,     1,     '#',  art_ , p_menge_ )
    RETURNING p_id into ld_id_;

    PERFORM tabk.abk__create( p_aknr, op_ix_, p_menge, NULL, NULL, ld_id_) FROM twawi.ldsdok_pos WHERE p_id = ld_id_;
    abk_ix_ := ( select max(ab_ix) from abk );

    ab2_id_ := (Select max(a2_id) from ab2);
    op2_id_ := (select max(o2_id) from op2);

  --
   INSERT INTO ldsdok (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_a2_id)
           VALUES ('E', 'AWB', 1,  'AWKRZ', 'AW.0001', 10, ab2_id_);
  ---
  --- Lagerabgang
  SELECT ag_id INTO ag_id_ FROM auftg WHERE ag_mainabk = abk_ix_;
  --- Lagerabgang, Menge = 1
  INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_aknr, l_ag_id, l_ldat       , l_lgort  , l_lgchnr, l_abg_mec, l_abgg)
          VALUES           ('#'  , '#'   , '#'   , rart_ , ag_id_ , currenttime(), w_lgort_ , '123'   , rart_mgc_, 1)
          RETURNING l_nr INTO l_nr_;

        CREATE SEQUENCE serien_nr START 1;
        UPDATE lagsernr SET lgs_l_nr = l_nr_, lgs_sernr = nextval('serien_nr') WHERE lgs_id IN (SELECT lgs_id FROM lagsernr WHERE lgs_w_wen = w_wen_ AND lgs_l_nr IS null ORDER BY lgs_id LIMIT 1);

        --- Lagerabgang, Restmenge
  INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_aknr, l_ag_id, l_ldat       , l_lgort  , l_lgchnr, l_abg_mec, l_abgg)
          VALUES           ('#'  , '#'   , '#'   , rart_ , ag_id_ , currenttime(), w_lgort_ , '123'   , rart_mgc_, p_menge_ - 1)
        RETURNING l_nr INTO l_nr_;
        UPDATE lagsernr SET lgs_l_nr = l_nr_, lgs_sernr = nextval('serien_nr') WHERE lgs_w_wen = w_wen_ AND lgs_l_nr IS null;
        DROP SEQUENCE serien_nr;
  ---
        RETURN abk_ix_;

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.TC_ART__all__delete() RETURNS VOID AS $$

  DECLARE rec RECORD;
  BEGIN

    DELETE FROM cocpos WHERE insert_by IN ('TC', 'TC-ADMIN');
    DELETE FROM coc    WHERE insert_by IN ('TC', 'TC-ADMIN');

    DELETE FROM belegdokument WHERE beld_id IN (SELECT belp_dokument_id FROM lieferschein_pos WHERE belp_aknr iLIKE 'TC_ART_%') AND insert_by IN ('TC', 'TC-ADMIN');
    DELETE FROM lieferschein_pos WHERE belp_aknr iLIKE 'TC_ART_%' AND insert_by IN ('TC', 'TC-ADMIN');

    DELETE FROM lagsernr WHERE lgs_l_nr  IN (SELECT l_nr  FROM lifsch WHERE l_aknr   iLIKE 'TC_ART__%');
    DELETE FROM lagsernr WHERE lgs_lg_id IN (SELECT lg_id FROM lag    WHERE lg_aknr  iLIKE 'TC_ART__%');
    DELETE FROM lagsernr WHERE lgs_w_wen IN (SELECT w_wen FROM wendat WHERE w_aknr   iLIKE 'TC_ART__%');

    DELETE FROM lifsch   WHERE l_aknr    iLIKE 'TC_ART_%' AND insert_by IN ('TC', 'TC-ADMIN');
    DELETE FROM lagsernr WHERE lgs_l_nr  IN (SELECT l_nr FROM lifsch WHERE l_aknr iLIKE 'TC_ART__RMAT' AND insert_by IN ('TC', 'TC-ADMIN'));
    DELETE FROM lifsch   WHERE l_aknr    iLIKE 'TC_ART__RMAT'      AND insert_by IN ('TC', 'TC-ADMIN');

    DELETE FROM wendat   WHERE w_aknr    iLIKE 'TC_ART_ZÄHLSTANGE' AND insert_by IN ('TC', 'TC-ADMIN');

    FOR rec IN (
        SELECT ak_nr FROM art WHERE insert_by IN ('TC', 'TC-ADMIN') OR ak_nr iLIKE '%TC_ART_%'  OR ak_nr iLIKE '%AG_TC-%' ORDER BY 1 /*LIMIT 2*/
      ) LOOP

        --- RAISE NOTICE '%', rec.ak_nr;
        PERFORM tartikel.art__ak_nr__delete(rec.ak_nr);

    END LOOP;

  END $$ LANGUAGE plpgsql;
---
--- Funktion zieht aus  rtf_textdfm Formularname heraus. Verwendung beim RTF-Formular.Caption

CREATE OR REPLACE FUNCTION z_05_testcomplete.runtimeforms__form_name__get(IN _rtf_textdfm text DEFAULT '') RETURNS varchar AS $$
 DECLARE result     varchar;
        pos_end    integer;
 BEGIN

    _rtf_textdfm := trim(_rtf_textdfm);

    result := trim(substr(split_part(_rtf_textdfm, E'\n', 1), 7));
    --result := replace( result, E'\n', '*' );

    result := replace( result, '_0:', '' );
    result := replace( result, '_0a', '' );
    result := replace( result, 'frmToDesign', 'FormSelect' );

    IF strpos(result, 'FormSelectAdk_0a') > 0 THEN
        RETURN 'FormSelectAdk';
    ELSEIF strpos(result, 'FormLagSerNr_0a') > 0 THEN
        RETURN 'FormLagSerNr';
    ELSEIF strpos(result, 'FormSearchLifSch_0a_0a:') > 0 THEN
        RETURN 'FormSearchLifSch';
    ELSEIF strpos(result, '_2_1_1_1_1_1_1_1_1_1_1_1_1_1_1_1_1_1:') > 0 THEN
        pos_end := strpos(result, '_2_1_1_1_1_1_1_1_1_1_1_1_1_1_1_1_1_1:');
        RETURN substr(result, 1, pos_end - 1);
    ELSEIF strpos(result, '3_1_1_1_1_1_1:') > 0 THEN
        pos_end := strpos(result, '3_1_1_1_1_1_1:');
        RETURN substr(result, 1, pos_end - 1);
    ELSEIF strpos(result, '_1_1_1_1_1_1:') > 0 THEN
        pos_end := strpos(result, '_1_1_1_1_1_1:');
        RETURN substr(result, 1, pos_end - 1);
    ELSEIF strpos(result, '_1_1_1_1_1:') > 0 THEN
        pos_end := strpos(result, '_1_1_1_1_1:');
        RETURN substr(result, 1, pos_end - 1);
    ELSEIF strpos(result, '3_1_') > 0 THEN
        pos_end := strpos(result, '3_1_');
        RETURN substr(result, 1, pos_end - 11);
    ELSEIF strpos(result, '_neu') > 0 THEN
        pos_end := strpos(result, ' ');
        RETURN substr(result, 1, pos_end + 3);
    ELSEIF strpos(result, 'FormArtLag1') > 0 THEN
        RETURN 'FormArtLag';
    ELSEIF strpos(result, 'bd_minr') > 0 THEN
        RETURN 'bd_minr';
    ELSEIF strpos(result, '_') > 0 THEN
        pos_end := strpos(result, '_');
        RETURN substr(result, 1, pos_end - 1);
    ELSEIF strpos(result, ':') > 0 THEN
        pos_end := strpos(result, ':');
        RETURN substr(result, 1, pos_end - 1);
    ELSEIF strpos(result, ' ') > 0 THEN
        pos_end := strpos(result, ' ');
        RETURN substr(result, 1, pos_end - 1);
    END IF;

    RETURN 'nicht gefunden';

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.recnokeyword__CoC_ART__create(IN _ak_nr varchar(40)) RETURNS VOID AS $$
 DECLARE r_tablename varchar := 'art';
         r_dbrid     varchar := (SELECT dbrid FROM art WHERE ak_nr = _ak_nr);
 BEGIN

    INSERT INTO recnokeyword (r_tablename, r_dbrid, r_descr, r_reg_pname)
     SELECT * FROM (
        SELECT
          'art'::varchar AS reg_tablename,
          r_dbrid AS r_dbrid,
          COALESCE(reg_bez, lang_text(reg_bez_textno)) AS reg_descr,
          reg_pname
        FROM recnogroup
        WHERE reg_tablename = 'art'
          AND reg_pname IN ('CoC.ART.MatZg', 'CoC.ART.Messprotokoll', 'CoC.ART.Sonstiges')
        ORDER BY
          reg_pos
        --LIMIT 5
        ) AS sub
        WHERE NOT exists(SELECT true
                         FROM recnokeyword
                         WHERE true
                           AND recnokeyword.r_tablename = sub.reg_tablename
                           AND recnokeyword.r_dbrid     = sub.r_dbrid
                           AND recnokeyword.r_descr     = sub.reg_descr
                           AND recnokeyword.r_reg_pname = sub.reg_pname
                         LIMIT 1
                        );
 END $$ LANGUAGE plpgsql;
---
--- CoC.ART-Eigenschaften löschen
CREATE OR REPLACE FUNCTION z_05_testcomplete.TC_ART__CoC_recnokeyword__delete(IN _ak_nr varchar) RETURNS VOID AS $$
  BEGIN

    DELETE FROM recnokeyword
    WHERE r_dbrid = (SELECT dbrid FROM art WHERE ak_nr = _ak_nr)
      AND r_reg_pname iLIKE 'CoC.ART.%';

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.TC_art_ldsdok_wendat__anlegen(IN _ak_nr varchar) RETURNS void AS $$
 DECLARE
    --last_id int;
    w_lgort_  varchar := 'H2 | R1';
    w_lgchnr_ varchar := '123';
    ld_id_    integer;
    art_mgc_  integer;

    p_menge_  INTEGER := 50;
 BEGIN

    art_mgc_ := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr);
    --- Bestellung anlegen
    INSERT INTO twawi.ldsdok_pos ( p_code, p_nummer                                   , p_pos, p_aknr, p_me    , p_adkrz  , p_menge , p_preis, p_waer, p_status, p_status1, p_status2)
    VALUES                      ( 'E'   , 'TC_' || (coalesce( ( SELECT max(ld_id) + 1 FROM ldsdok), 1 ) ), 1    , _ak_nr, art_mgc_, 'AUTO-AG', p_menge_, 100    , 'EUR' , 'E'     , NULL     , 'W')
      RETURNING p_id INTO ld_id_;

    -- Lagerzugang auf Bestellung
    INSERT INTO wendat (w_aknr,  w_zug_mec                                                  , w_lds_id, w_zugang, w_lgchnr , w_lgort)
    VALUES             (_ak_nr,  tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr), ld_id_  , p_menge_, w_lgchnr_, w_lgort_);
    ---
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.TC_ART__delete(IN _ak_nr varchar) RETURNS VOID AS $$
  BEGIN

    DELETE FROM cocpos WHERE insert_by IN ('TC', 'TC-ADMIN');
    DELETE FROM coc    WHERE insert_by IN ('TC', 'TC-ADMIN');

    DELETE FROM lagsernr WHERE lgs_l_nr IN ( SELECT l_nr FROM lifsch WHERE l_aknr = 'TC_ART__RMAT' );

    DELETE FROM belegdokument WHERE beld_id IN (SELECT belp_dokument_id FROM lieferschein_pos WHERE belp_aknr iLIKE _ak_nr) AND insert_by IN ('TC', 'TC-ADMIN');
    DELETE FROM lieferschein_pos WHERE belp_aknr iLIKE _ak_nr AND insert_by IN ('TC', 'TC-ADMIN');

    DELETE FROM lagsernr WHERE lgs_l_nr  IN (SELECT l_nr  FROM lifsch WHERE l_aknr   iLIKE _ak_nr);
    DELETE FROM lagsernr WHERE lgs_lg_id IN (SELECT lg_id FROM lag    WHERE lg_aknr  iLIKE _ak_nr);
    DELETE FROM lagsernr WHERE lgs_w_wen IN (SELECT w_wen FROM wendat WHERE w_aknr   iLIKE _ak_nr);

    DELETE FROM lifsch   WHERE l_aknr    iLIKE 'TC_ART_%' AND insert_by IN ('TC', 'TC-ADMIN');
    --- DELETE FROM lagsernr WHERE lgs_l_nr  IN (SELECT l_nr FROM lifsch WHERE l_aknr iLIKE 'TC_ART__RMAT' AND insert_by IN ('TC', 'TC-ADMIN'));
    DELETE FROM lifsch   WHERE l_aknr    iLIKE 'TC_ART__RMAT'      AND insert_by IN ('TC', 'TC-ADMIN');

    DELETE FROM wendat   WHERE w_aknr    iLIKE 'TC_ART_ZÄHLSTANGE' AND insert_by IN ('TC', 'TC-ADMIN');

    PERFORM tartikel.art__ak_nr__delete(_ak_nr);

  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION z_05_testcomplete.grant__on__large_object__set( _name VARCHAR ) RETURNS VOID AS $$
  DECLARE rec   record;

  BEGIN
    FOR rec IN (
        SELECT pd_blob::bigint AS loid      FROM picndoku      WHERE pd_blob IS NOT null
        UNION
      ---  SELECT pd_blobprv::bigint           FROM picndoku      WHERE pd_blobprv IS NOT null
      ---  UNION
      ---  SELECT pd_cmmnt::bigint             FROM picndoku      WHERE pd_cmmnt IS NOT null
      ---  UNION
        SELECT pdp_blob::bigint             FROM picndokupages WHERE pdp_blob IS NOT null
        UNION
        SELECT pdp_blobprv::bigint          FROM picndokupages WHERE pdp_blobprv IS NOT null
        UNION
        SELECT pdp_cmmnt::bigint            FROM picndokupages WHERE pdp_cmmnt IS NOT null
        UNION
        SELECT mm_picture::bigint           FROM mainmenu      WHERE mm_picture IS NOT null
        UNION
        SELECT r_blob::bigint               FROM reports       WHERE r_blob IS NOT null           --- 533 rows

        --- SELECT loid FROM pg_largeobject                                                       --- 5678 rows
      ) LOOP

        EXECUTE 'GRANT ALL ON LARGE OBJECT ' || rec.loid || ' TO "' || _name || '";';  ---"SYS.Prodat-User";

      END LOOP;
    RETURN;
 END $$ LANGUAGE plpgsql;

---   Artikel VK-Preis mit Berücksichtigung auf Kundenpreis
CREATE OR REPLACE FUNCTION z_05_testcomplete.artikel__preis__az_kupr__ak_vkpbas( IN _ak_nr varchar, IN _az_prokrz varchar DEFAULT null, IN _datum date DEFAULT current_date ) RETURNS numeric( 12, 4 ) AS $$
 DECLARE result  numeric( 12, 4 ) := null;
 BEGIN
    IF _az_prokrz IS NOT null THEN
        SELECT
          az_kupr
        FROM artzuo
        WHERE az_pronr = _ak_nr
          AND az_prokrz = _az_prokrz
          AND current_date BETWEEN az_gdatum AND CASE WHEN az_bisdatum IS null THEN '31.12.2100'::date END
        INTO result;
    END IF;

    If result IS null THEN
        SELECT ak_vkpbas FROM art WHERE ak_nr = _ak_nr INTO result;
    END IF;

    RETURN coalesce( result, 0 )::numeric( 12, 4 );

 END $$ LANGUAGE plpgsql;
---
--- Rolle zum User übergeben
CREATE OR REPLACE FUNCTION z_05_testcomplete.grant__to__user(
    IN _user varchar
  ) RETURNS VOID
  AS $$
  DECLARE _arr_grant       varchar[];
  BEGIN
    _arr_grant := array[ 'SYS.Faktura.Kreditoren',
                         'SYS.Faktura',
                         'SYS.Faktura.AR-Freigabe',
                         'SYS.Lager',
                         'SYS.Controlling, Umsatzzahlen',
                         'SYS.Administratoren',
                         'SYS.Personaldaten',
                         'SYS.Personaldaten.PrivTel',
                         'SYS.Personaldaten.QM',
                         'SYS.Personaldaten.AbwBewill.ALohneRecht',
                         'SYS.Adressen.Umschreiben',
                         'Dokumente-Admin',
                         'SYS.PT.Plantafel-Admin',
                         'SYS.PT.Plantafel-Worker',
                         'SYS.PT.Plantafel-Fixwoche-Admin',
                         'ER-Freigabe',
                         'SYS.Lager-Haenel',
                         'SYS.Lager-Lagerort',
                         'SYS.DebiKrediDat',
                         'QAB-Admin',
                         'QAB-Neu-Infomail',
                         'QAB-Wirksam-Infomail',
                         'QAB-Extern-Neu-Infomail',
                         'QAB-Auswaerts-Neu-Infomail',
                         'QAB-Retoure-Infomail',
                         'QAB-Kontrolle',
                         'WEB-Pruefer',
                         'WEB-Admin'
                       ];

   FOR i IN 1 .. array_upper( _arr_grant, 1 )
   LOOP
      RAISE NOTICE 'i = %  -> %', i, _arr_grant[i];
      EXECUTE 'GRANT ' || quote_ident( _arr_grant[i] ) || ' TO ' || quote_ident( _user ) || ';';
   END LOOP;

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.auftg__ag_id__delete( IN _ag_id integer ) RETURNS VOID AS $$
  DECLARE rec          record;
          _ag_astat    varchar;
          _ag_nr       varchar;
  BEGIN

    SELECT ag_astat, ag_nr INTO _ag_astat, _ag_nr FROM auftg WHERE ag_id = _ag_id;

    ALTER TABLE oplpm_data DISABLE TRIGGER oplpm_data__pm_part__b_ud;

    DELETE FROM abk WHERE ab_plan_ag_id = _ag_id OR ab_ld_id IN ( SELECT ld_id FROM ldsdok WHERE ld_ag_id = _ag_id );

    DELETE FROM cocpos WHERE cocp_belp_id IN ( SELECT belp_id FROM belegpos WHERE  belp_id IN ( SELECT l_belp_id FROM lifsch WHERE l_ag_id = _ag_id ) );

    DELETE FROM belegpos WHERE  belp_id IN ( SELECT l_belp_id FROM lifsch WHERE l_ag_id = _ag_id );

    DELETE FROM lagsernr WHERE lgs_l_nr IN ( SELECT l_nr FROM lifsch WHERE l_ag_id = _ag_id );

    DELETE FROM lifsch WHERE l_ag_id = _ag_id;

    DELETE FROM ldsdok WHERE ld_ag_id = _ag_id;

    DELETE FROM auftgdokutxt WHERE atd_dokunr IN ( SELECT ag_dokunr FROM auftg WHERE ag_id = _ag_id  AND ag_dokunr IS NOT null);

    UPDATE auftg SET ag_dokunr = null WHERE ag_id = _ag_id AND ag_dokunr IS NOT null;

    DELETE FROM auftgtxt WHERE at_astat = _ag_astat AND at_nr = _ag_nr;

    DELETE FROM auftgstp WHERE auftgstp_agid = _ag_id;

    DELETE FROM auftgposlog WHERE agplog_ag_id = _ag_id;

    DELETE FROM auftg WHERE ag_id = _ag_id;

    ALTER TABLE oplpm_data ENABLE TRIGGER oplpm_data__pm_part__b_ud;

 END $$ LANGUAGE plpgsql;
---

CREATE OR REPLACE FUNCTION z_05_testcomplete.auftg__insert_by__TC__delete(  ) RETURNS VOID AS $$
  DECLARE rec          record;
  BEGIN
    FOR rec IN SELECT ag_id, ag_astat, ag_nr, ag_aknr, insert_by
               FROM auftg
               WHERE insert_by IN ( 'TC', 'TC-ADMIN' )
    LOOP
        RAISE NOTICE '%, %, %, %, %,', rec.ag_id, rec.ag_astat, rec.ag_nr, rec.ag_aknr, rec.insert_by;

        PERFORM z_05_testcomplete.auftg__ag_id__delete( rec.ag_id );

    END LOOP;

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.auftg__ag_id__delete( IN _ag_id integer ) RETURNS VOID AS $$
  DECLARE rec          record;
          _ag_astat    varchar;
          _ag_nr       varchar;
  BEGIN

    SELECT ag_astat, ag_nr INTO _ag_astat, _ag_nr FROM auftg WHERE ag_id = _ag_id;

    ALTER TABLE oplpm_data DISABLE TRIGGER oplpm_data__pm_part__b_ud;
    ALTER TABLE oplpm_mw   DISABLE TRIGGER oplpm_mw__b_d;

    DELETE FROM abk WHERE ab_plan_ag_id = _ag_id OR ab_ld_id IN ( SELECT ld_id FROM ldsdok WHERE ld_ag_id = _ag_id );

    DELETE FROM cocpos WHERE cocp_belp_id IN ( SELECT belp_id FROM belegpos WHERE  belp_id IN ( SELECT l_belp_id FROM lifsch WHERE l_ag_id = _ag_id ) );

    DELETE FROM belegpos WHERE  belp_id IN ( SELECT l_belp_id FROM lifsch WHERE l_ag_id = _ag_id );

    DELETE FROM lagsernr WHERE lgs_l_nr IN ( SELECT l_nr FROM lifsch WHERE l_ag_id = _ag_id );

    DELETE FROM lifsch WHERE l_ag_id = _ag_id;

    UPDATE ldsdok SET ld_dokunr = null WHERE ld_ag_id = _ag_id AND ld_dokunr IS NOT null;
    DELETE FROM ldsdok WHERE ld_ag_id = _ag_id;

    DELETE FROM auftgdokutxt WHERE atd_dokunr IN ( SELECT ag_dokunr FROM auftg WHERE ag_id = _ag_id  AND ag_dokunr IS NOT null );

    UPDATE auftg SET ag_dokunr = null WHERE ag_id = _ag_id AND ag_dokunr IS NOT null;

    DELETE FROM auftgtxt WHERE at_astat = _ag_astat AND at_nr = _ag_nr;

    DELETE FROM auftgstp WHERE auftgstp_agid = _ag_id;

    DELETE FROM auftgposlog WHERE agplog_ag_id = _ag_id;

    DELETE FROM auftg WHERE ag_id = _ag_id;

    ALTER TABLE oplpm_data ENABLE TRIGGER oplpm_data__pm_part__b_ud;
    ALTER TABLE oplpm_mw   ENABLE TRIGGER oplpm_mw__b_d;

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.auftg__insert_by__TC__delete() RETURNS VOID AS $$
  DECLARE rec          record;
  BEGIN
    FOR rec IN SELECT ag_id, ag_astat, ag_nr, ag_aknr, insert_by
               FROM auftg
               WHERE insert_by IN ( 'TC', 'TC-ADMIN' )
               ORDER BY ag_id
    LOOP
        RAISE NOTICE '%, %, %, %, %,', rec.ag_id, rec.ag_astat, rec.ag_nr, rec.ag_aknr, rec.insert_by;

        PERFORM z_05_testcomplete.auftg__ag_id__delete( rec.ag_id );

    END LOOP;

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.ldsdok_ld_id__delete() RETURNS VOID AS $$
  DECLARE rec          record;
  BEGIN
    FOR rec IN SELECT ld_id, ld_code, ld_auftg, ld_aknr, ld_a2_id, insert_by
               FROM ldsdok
               WHERE insert_by IN ( 'TC', 'TC-ADMIN' )
               ORDER BY ld_id
    LOOP
        RAISE NOTICE '%, %, %, %, %,', rec.ld_id, rec.ld_code, rec.ld_auftg, rec.ld_aknr, rec.insert_by;

        DELETE FROM lagsernr
        WHERE lgs_l_nr IN ( SELECT l_nr  FROM lifsch WHERE l_w_wen IN ( SELECT w_wen FROM wendat WHERE w_lds_id = rec.ld_id ) )
          OR lgs_w_wen IN ( SELECT w_wen FROM wendat WHERE w_lds_id = rec.ld_id );

        DELETE FROM cocpos  WHERE cocp_belp_id IN ( SELECT l_belp_id FROM lifsch WHERE l_w_wen IN ( SELECT w_wen FROM wendat WHERE w_lds_id = rec.ld_id ) );

        DELETE FROM belegpos WHERE belp_id IN ( SELECT l_belp_id FROM lifsch WHERE l_w_wen IN ( SELECT w_wen FROM wendat WHERE w_lds_id = rec.ld_id ) );

        DELETE FROM lifsch WHERE l_w_wen IN ( SELECT w_wen FROM wendat WHERE w_lds_id = rec.ld_id );

        DELETE FROM wendat WHERE w_lds_id = rec.ld_id;

        DELETE FROM ab2 WHERE a2_ab_ix IN ( SELECT ab_ix FROM abk WHERE ab_ld_id = rec.ld_a2_id );
        DELETE FROM abk WHERE ab_ld_id = rec.ld_id;


        UPDATE ldsdok SET ld_dokunr = null WHERE ld_id = rec.ld_id AND ld_dokunr IS NOT null;
        DELETE FROM ldsdok WHERE ld_id = rec.ld_id;

    END LOOP;

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.TC__art__delete() RETURNS VOID AS $$
  DECLARE rec          record;
  BEGIN

    DELETE FROM wendat WHERE w_aknr = 'TC_RT_ART';

    ALTER TABLE oplpm_data DISABLE TRIGGER oplpm_data__pm_part__b_ud;
    ALTER TABLE oplpm_mw   DISABLE TRIGGER oplpm_mw__b_d;

    FOR rec IN SELECT ak_nr, ak_bez, insert_by
               FROM art
               WHERE insert_by IN ( 'TC', 'TC-ADMIN' )
               ORDER BY ak_nr
    LOOP
        RAISE NOTICE '%, %, %', rec.ak_nr, rec.ak_bez, rec.insert_by;

        PERFORM tartikel.art__ak_nr__delete( rec.ak_nr );

    END LOOP;

    ALTER TABLE oplpm_data ENABLE TRIGGER oplpm_data__pm_part__b_ud;
    ALTER TABLE oplpm_mw   ENABLE TRIGGER oplpm_mw__b_d;

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.insert_by__TC__komplette__delete() RETURNS VOID AS $$

  BEGIN

    UPDATE ldsdok SET ld_a2_id = null WHERE ld_a2_id IS NOT null AND insert_by IN ( 'TC', 'TC-ADMIN' );

    PERFORM z_05_testcomplete.TC__art__delete();
    PERFORM z_05_testcomplete.auftg__insert_by__TC__delete();
    PERFORM z_05_testcomplete.ldsdok_ld_id__delete();


    DELETE FROM wendat        WHERE insert_by IN ( 'TC', 'TC-ADMIN' );
    DELETE FROM opl           WHERE insert_by IN ( 'TC', 'TC-ADMIN' );

    DELETE FROM tlog.Auditlog WHERE l_user    IN ( 'TC', 'TC-ADMIN' );
    DELETE FROM bdep          WHERE insert_by IN ( 'TC', 'TC-ADMIN' );
    DELETE FROM beleg         WHERE insert_by IN ( 'TC', 'TC-ADMIN' );
    DELETE FROM belkopf       WHERE insert_by IN ( 'TC', 'TC-ADMIN' );
    DELETE FROM bestanfpos    WHERE insert_by IN ( 'TC', 'TC-ADMIN' );

 END $$ LANGUAGE plpgsql;
---

--- Betriebsdatenerfassung, Testdaten löschen
CREATE OR REPLACE FUNCTION z_05_testcomplete.bdepab__benutzer_DEMO_loeschen() RETURNS VOID AS $$
  BEGIN

    IF exists( SELECT true FROM bdepab WHERE insert_by = 'TC' AND (SELECT ll_ad_krz FROM llv WHERE ll_minr = bdab_minr) = 'DEMO' ) THEN
        ALTER TABLE bdepab DISABLE TRIGGER bdepab__b_05_iud__rights;
        DELETE FROM bdepab WHERE insert_by = 'TC' AND (SELECT ll_ad_krz FROM llv WHERE ll_minr = bdab_minr) = 'DEMO';
        ALTER TABLE bdepab ENABLE TRIGGER bdepab__b_05_iud__rights;
    END IF;

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION z_05_testcomplete.into_adk1(
      IN _a1_krz varchar,
      IN _a1_knr integer = null
    ) RETURNS void AS $$
  BEGIN

    SET SESSION AUTHORIZATION 'DEMODATA';

    IF _a1_knr IS NULL THEN
      SELECT coalesce( ( max( a1_knr ) + 1 ), 10000 ) FROM adk1 INTO _a1_knr;
    END IF;

    INSERT INTO adk1 (a1_krz, a1_knr)
      SELECT _a1_krz, coalesce( _a1_knr, 10001 )
      WHERE NOT EXISTS ( SELECT true FROM adk1 WHERE a1_krz = _a1_krz );

    RESET SESSION AUTHORIZATION;

  END $$ LANGUAGE plpgsql;
  --select z_05_testcomplete.into_adk1('#');
---
/*--- alle ROLE Zuordnung zum User
CREATE OR REPLACE FUNCTION z_05_testcomplete.User_TC_Set_all_GRANT_ROLE( IN _is_revoke boolean = false ) RETURNS void AS $$
 DECLARE rec     record;
 BEGIN

    FOR rec IN SELECT groname FROM pg_group WHERE groname NOT iLIKE 'pg_%' LOOP
        --- raise notice '%', 'GRANT "' || rec.rolname || '" TO "TC";';
    IF _is_revoke THEN
        EXECUTE 'REVOKE "' || rec.groname || '" FROM "TC";';
    ELSE
            EXECUTE 'GRANT "' || rec.groname || '" TO "TC";';
    END IF;

    END LOOP;
 END $$ LANGUAGE plpgsql;
*/
---  GEO  (Ende)

SELECT true;