CREATE OR REPLACE FUNCTION twawi.ldsdok__ld_stat__w(
      _dbrid varchar,
      _has_w boolean = null
  ) RETURNS varchar AS $$ 
  DECLARE 
      _rows_affected integer;
      _status varchar;
      _pnummer varchar;
  BEGIN
  
      SELECT concat( 'postgraphile:pos:', p_nummer ) 
        INTO _pnummer 
        FROM twawi.ldsdok_pos 
       WHERE dbrid = _dbrid;
      
      IF _has_w IS NULL THEN
          SELECT tsystem.enum_flipvalue( p_status, 'W' ) INTO _status FROM twawi.ldsdok_pos WHERE dbrid = _dbrid;
      ELSEIF _has_w THEN
          SELECT tsystem.enum_setvalue( p_status, 'W' ) INTO _status FROM twawi.ldsdok_pos WHERE dbrid = _dbrid;
      ELSE
          SELECT tsystem.enum_delvalue( p_status, 'W' ) INTO _status FROM twawi.ldsdok_pos WHERE dbrid = _dbrid;
      END IF;

      IF NOT FOUND THEN
          RAISE EXCEPTION 'twawi.ldsdok__ld_stat__w: NOT FOUND dbrid = %', _dbrid;
      END IF;
      
      UPDATE twawi.ldsdok_pos 
         SET p_status = upper( _status ) 
       WHERE dbrid = _dbrid;
       
      GET DIAGNOSTICS _rows_affected = ROW_COUNT;
        
      IF _rows_affected > 1 THEN
          RAISE EXCEPTION 'twawi.ldsdok__ld_stat__w: more than one row affected dbrid = %', _dbrid;
      END IF;
      
      PERFORM pg_notify(
          _pnummer,
          '{}'
      );
      
      PERFORM pg_notify(
          'postgraphile:orders',
          '{}'
      );
      
      RETURN _status;
      
  END $$ LANGUAGE plpgsql;
