@ECHO OFF

REM -----------------------------------------------------
REM ------------------  EXITCODE  -----------------------
REM -----------------------------------------------------
REM 999 - Argument fuer auszufuehrende Operation fehlerhaft
REM 998 - Excludes-File (Arg2) existiert nicht
REM 997 - Quell-Verzeichniss (Arg3) existiert nicht
REM 996 - Ziel-Verzeichniss (Arg4) existiert nicht
REM -----------------------------------------------------


REM -----------------------------------------------------
REM -----------------------------------------------------
REM Arg3 und Arg4 (Quell-/Ziel-Verzeichniss)
REM MUESSEN mit Trailing Backslash uebergeben werden!!!
REM ODER es wird die Konfiguration benutzt und Local wird
REM automatisch ermittelt
REM Fuer Arg3 und Arg4 kann auch NULL angegeben werden um
REM ebenfalls Arg5 angeben zu koennen
REM in diesem Fall wird die Konfiguration benutzt und
REM Local wird automatisch ermittelt
REM -----------------------------------------------------


REM -----------------------------------------------------
REM -----------------------------------------------------
REM /EFSRAW /COPY:DATSOU /COPYALL /SECFIX
REM Diese robocopy Optionen funktionnieren nur mit
REM einem Windows Account mit entsprechenden Rechten.
REM Daher werden diese momentan nicht verwendet
REM -----------------------------------------------------
REM /IM is undocumented and stands for
REM - Include Modified files (Includes same files with
REM different times).
REM -----------------------------------------------------



REM ECHO "%~dp0" %1 %~f2 %~dp3 %~dp4 %5
SET /A VarMyERRORLEVEL=0

IF [%2] EQU [] GOTO ERR_Argument2Missing
IF NOT EXIST %~f2 (
  GOTO ERR_ExcludeFileDoesNotExist
)

IF %1 EQU ALL (
  SET Var_UL_NextGOTOLABEL=COPY_All
) ELSE (
  IF %1 EQU UPDATEONLY (
    SET Var_UL_NextGOTOLABEL=COPY_UpdateOnly
  ) ELSE (
    IF %1 EQU SYNC (
      SET Var_UL_NextGOTOLABEL=COPY_Sync
    ) ELSE (
      IF %1 EQU TESTROBOCOPY (
        SET Var_UL_NextGOTOLABEL=COPY_TESTROBOCOPY
      ) ELSE (
        GOTO ERR_WrongOp
      )
    )
  )
)

IF [%5] EQU [DONTSTARTPRODAT] (
  SET /A VarStartProdat=0
) ELSE (
  SET /A VarStartProdat=1
)

:LOADCFGPREPARESRCDST
REM Config in Root-Dir\Administration
REM ECHO %~dp0

SET Var_ScriptDir=%~dp0
for %%B in (%Var_ScriptDir%.) do set Var_ScriptDir_Parent=%%~dpB
for %%B in (%Var_ScriptDir_Parent%.) do set Var_ScriptDir_Grandparent=%%~dpB
SET Var_LocalDir=%Var_ScriptDir_Grandparent%
SET Var_CfgFile=%Var_ScriptDir_Parent%RunLocal_SetCfgVariables.bat
ECHO(
ECHO Konfigurations-Datei:     "%Var_CfgFile%"

IF EXIST %Var_CfgFile% (
  CALL %Var_CfgFile%
  ECHO   Konfiguration geladen
) ELSE (
  ECHO   Konfigurations-Datei nicht gefunden
)
SET Var_RemoteDir=%VarCfg_RemoteDir%

IF [%3] NEQ [] (
  IF NOT "%3" == "NULL" (
    IF NOT EXIST %~dp3 (
      GOTO ERR_SourceDoesNotExist
    )
    SET Var_RemoteDir=%~dp3
    ECHO   benutze Arg3 fuer Quell-Verzeichniss: %~dp3
  )
)

IF [%4] NEQ [] (
  IF NOT "%~4" == "NULL" (
    IF NOT EXIST %~dp4 (
      GOTO ERR_DestinationDoesNotExist
    )
    SET Var_LocalDir=%~dp4
    ECHO   benutze Arg4 fuer Ziel-Verzeichniss:  %~dp4
  )
)

IF NOT EXIST %Var_RemoteDir% GOTO ERR_SourceDoesNotExist
IF NOT EXIST %Var_LocalDir% GOTO ERR_DestinationDoesNotExist

SET Var_LocalPythonDir=%Var_LocalDir%Python3\
SET Var_RemotePythonDir=%Var_RemoteDir%Python3\

ECHO(
ECHO   %1
ECHO     Quelle:   %Var_RemoteDir%
ECHO     Ziel:     %Var_LocalDir%
ECHO     Excludes: %~f2
ECHO     QP:       %Var_RemotePythonDir%
ECHO     DP:       %Var_LocalPythonDir%
IF [%5] NEQ [] ECHO     %5
ECHO(


IF %1 EQU TESTROBOCOPY (
  GOTO COPY_TESTROBOCOPY
)

:TERMINATEPRODAT
ECHO Beende Prodat Programm-Instanzen ...
TASKKILL /F /IM %VarCfg_StartProdat_Prog% 2>NUL
GOTO %Var_UL_NextGOTOLABEL%



:STARTPRODAT
IF %VarStartProdat% NEQ 1 GOTO _EXIT

SET StartCMD=%Var_LocalDir%
SET StartCMD="%StartCMD%%VarCfg_StartProdat_Prog%" %VarCfg_StartProdat_Params%
ECHO Starte: %StartCMD%
START "" %StartCMD%
GOTO _EXIT



:COPY_TESTROBOCOPY
REM Zum Testen ob RoboCopy korrekt arbeitet, darf nur 1 Kommando ausgefhrt werden (ExitCode)
robocopy %Var_RemoteDir%       %Var_LocalDir%       /MIR /Z /job:%~f2                  /COPY:DAT /DCOPY:DAT /MT:2 /R:5 /W:2 /ETA /IT /IM /IS >nul 2>&1
SET /A VarMyERRORLEVEL=%ERRORLEVEL%
GOTO _EXIT



:COPY_Sync
ECHO COPY_Sync
DEL /Q %Var_LocalDir%_*.zip %Var_LocalDir%_*.7z
robocopy %Var_RemoteDir%       %Var_LocalDir%       /MIR /Z /job:%~f2                  /COPY:DAT /DCOPY:DAT /MT:2 /R:5 /W:2 /ETA /IT /IM /IS
robocopy %Var_RemotePythonDir% %Var_LocalPythonDir% /MIR /Z /job:exclude_noexclude.rcj /COPY:DAT /DCOPY:DAT /MT:2 /R:5 /W:2 /ETA /IT /IM /IS
SET /A VarMyERRORLEVEL=%ERRORLEVEL%
GOTO STARTPRODAT



:COPY_All
ECHO COPY_All
DEL /Q %Var_LocalDir%_*.zip %Var_LocalDir%_*.7z
robocopy %Var_RemoteDir%       %Var_LocalDir%       /MIR /Z /job:%~f2                  /COPY:DAT /DCOPY:DAT /MT:2 /R:5 /W:2 /ETA /IT /IM /IS /XX
robocopy %Var_RemotePythonDir% %Var_LocalPythonDir% /MIR /Z /job:exclude_noexclude.rcj /COPY:DAT /DCOPY:DAT /MT:2 /R:5 /W:2 /ETA /IT /IM /IS /XX
SET /A VarMyERRORLEVEL=%ERRORLEVEL%
GOTO STARTPRODAT



:COPY_UpdateOnly
ECHO COPY_UpdateOnly
DEL /Q %Var_LocalDir%_*.zip %Var_LocalDir%_*.7z
robocopy %Var_RemoteDir%       %Var_LocalDir%       /MIR /Z /job:%~f2                  /COPY:DAT /DCOPY:DAT /MT:2 /R:5 /W:2 /ETA /XX /XO
robocopy %Var_RemotePythonDir% %Var_LocalPythonDir% /MIR /Z /job:exclude_noexclude.rcj /COPY:DAT /DCOPY:DAT /MT:2 /R:5 /W:2 /ETA /XX /XO
SET /A VarMyERRORLEVEL=%ERRORLEVEL%
GOTO STARTPRODAT



:ERR_Argument2Missing
GOTO ERR_ExcludeFileDoesNotExist



:ERR_Argument3Missing
GOTO ERR_SourceDoesNotExist



:ERR_Argument4Missing
GOTO ERR_DestinationDoesNotExist



:ERR_WrongOp
SET /A VarMyERRORLEVEL=999
ECHO Argument fuer auszufuehrende Operation fehlerhaft
GOTO _EXIT



:ERR_ExcludeFileDoesNotExist
SET /A VarMyERRORLEVEL=998
ECHO Exclude-Datei (%~f2) exisitiert nicht
GOTO _EXIT



:ERR_SourceDoesNotExist
SET /A VarMyERRORLEVEL=997
ECHO Quell-Verzeichniss (%~3) exisitiert nicht oder nicht erreichbar
::GOTO _EXIT
REM bei Netzwerkproblemen dennoch starten
TIMEOUT /t 120
GOTO STARTPRODAT



:ERR_DestinationDoesNotExist
SET /A VarMyERRORLEVEL=996
ECHO Ziel-Verzeichniss (%~4) exisitiert nicht oder nicht erreichbar
GOTO _EXIT



:_EXIT
EXIT /B %VarMyERRORLEVEL%
