@ECHO OFF

REM -----------------------------------------------------
REM ------------------  EXITCODE  -----------------------
REM -----------------------------------------------------
REM 999 - Argument fr auszufhrende Operation fehlerhaft
REM 998 - Datei fr Task (Arg2) existiert nicht
REM 901 - Task existiert bereits
REM -----------------------------------------------------

REM ECHO %1 %~f2 %~dp3 %~dp4

SET VarTaskName=CIMPCS\Prodat - Run Lokal - Update
SET /A VarMyERRORLEVEL=0
SET VarIdentity=%userdomain%\%username%

IF %1 EQU CREATE (
  GOTO Task_CreateIfNotExists
) ELSE (
  IF %1 EQU DELETE (
    GOTO Task_Delete
  ) ELSE (
    IF %1 EQU CREATESILENT (
      GOTO Task_Create
    ) ELSE (
      IF %1 EQU DELETESILENT (
        GOTO Task_DeleteSilent
      ) ELSE (
        SET /A VarMyERRORLEVEL=999
        ECHO Argument fr auszufhrende Operation fehlerhaft
        GOTO _EXIT
      )
    )
  )
)

IF NOT EXIST %~f2 (
  GOTO ERR_FILEDOESNOTEXIST
)



:Task_Check
SCHTASKS /query /TN "%VarTaskName%" >NUL 2>&1
IF %errorlevel% NEQ 0 (
  ECHO Task "%VarTaskName%" existiert nicht
  GOTO %VarNextGOTOLABEL%
) ELSE (
  SET /A VarMyERRORLEVEL=901
  ECHO Task "%VarTaskName%" existiert bereits. Zum Konfigurieren taskschd.msc starten.	
  GOTO _EXIT
)



:Task_CreateIfNotExists
SET VarNextGOTOLABEL=Task_Create
GOTO Task_Check



:Task_Create
SET VarTaskScriptFilename=%~f2
SCHTASKS /CREATE /SC DAILY /TN "%VarTaskName%" /TR "%VarTaskScriptFilename%" /ST 23:00
SET /A VarMyERRORLEVEL=%ERRORLEVEL%
ECHO Task "%VarTaskName%" wird nur unter folgendem Benutzer gestartet (wenn eingelogged): %VarIdentity%
GOTO _EXIT



:Task_Delete
CHOICE /N /C JN /M "Task \"%VarTaskName%\" wirklich lschen? [J][N]"
IF %ERRORLEVEL% EQU 1 (
  SCHTASKS /DELETE /F /TN "%VarTaskName%"
  SET /A VarMyERRORLEVEL=%ERRORLEVEL%
) ELSE (
  SET /A VarMyERRORLEVEL=0
)
GOTO _EXIT



:Task_DeleteSilent
SCHTASKS /query /TN "%VarTaskName%" >NUL 2>&1
if %ERRORLEVEL% EQU 0 (
  SCHTASKS /DELETE /F /TN "%VarTaskName%" >NUL 2>&1
)
SET /A VarMyERRORLEVEL=%ERRORLEVEL%
GOTO _EXIT



:ERR_FILEDOESNOTEXIST
ECHO Datei [%~f2] existiert nicht
SET /A VarMyERRORLEVEL=998
GOTO _EXIT



:_EXIT
EXIT /B %VarMyERRORLEVEL%