@ECHO OFF

ECHO(
ECHO Gestartet von: %~dp0

REM ===========================================================================
REM ===========================================================================
REM Das lokale Ziel-Verzeichniss (Prodat)
REM Wird vom Benutzer abgefragt
SET VarLocalDir=NOT-SET

REM ===========================================================================
REM ===========================================================================
REM Dies sind die Defaults, werden durch Cfg-File beschrieben
REM
REM Das Quell-Verzeichnisss, von wo Prodat nach lokal kopiert werden soll.
REM Wird vom Benutzer abgefragt und dann in Konfiguration-Datei geschrieben
REM Default ist Verzeichniss\..\.. dieses Scripts
SET VarCfg_RemoteDir=%~dp0
for %%B in (%VarCfg_RemoteDir%.) do set VarCfg_RemoteDir_Parent=%%~dpB
for %%B in (%VarCfg_RemoteDir_Parent%.) do set VarCfg_RemoteDir_Grandparent=%%~dpB
SET VarCfg_RemoteDir=%VarCfg_RemoteDir_Grandparent%
REM Programm welches zu starten ist
REM Wird vom Benutzer abgefragt und dann in Konfiguration-Datei geschrieben
SET VarCfg_StartProdat_Prog=ProdatSQL.exe
REM Paramter mit denen Programm zu starten ist
REM Wird vom Benutzer abgefragt und dann in Konfiguration-Datei geschrieben
SET VarCfg_StartProdat_Params=-REMEMBER_SERVER:1

REM ===========================================================================
REM ===========================================================================
REM Script(Library/Modul) welches das tatschliche Update ausfhrt
SET VarUpdateLocalScript=RunLocal_UpdateLocal.bat






REM ===========================================================================
REM ========================= BEGIN MENU BEGIN ================================
REM ===========================================================================
:MENU
TYPE NUL

REM ===========================================================================
REM Return Label / Caller
REM Default, MENU
SET Var_S_ReturnGOTOLABEL=MENU

REM ===========================================================================
REM Next Label / Sub
REM Default, Beende Script
SET Var_S_NextGOTOLABEL=_EXIT

REM ===========================================================================
REM Meldung ausgeben, wenn Konfigurations-Datei erstellt wird
SET /A VarDoPrintMsg_WriteCfg=1

REM ===========================================================================
REM Meldung ausgeben, wenn Script fr Shortcut erstellt wird
SET /A VarDoPrintMsg_CreateShortcutScript=1

REM ===========================================================================
REM Meldung ausgeben, wenn Script fr Windows-Task erstellt wird
SET /A VarDoPrintMsg_CreateWinTaskScript=1

ECHO(
ECHO(
ECHO ----------------------------------------------------------------------
ECHO [1] Komplette Einrichtung mit Standard-Werten
ECHO [2] Komplette Einrichtung mit Standard-Werten fr BDE (Stempeln)
ECHO     ------------------------------------------------------------------
ECHO [S] Setze lokales Verzeichniss fr weitere Ops
ECHO [Q] Setze (cfg) Quell-Verzeichniss (Remote-Directory)
ECHO [P] Setze (cfg) Programm
ECHO [A] Setze (cfg) Programm-Paramter
ECHO [Z] Zeige Konfiguration und lokales Verzeichniss
ECHO [M] Schreibe Konfiguration-Datei
ECHO [N] Lade Konfiguration-Datei
ECHO     ------------------------------------------------------------------
ECHO [K] Kopiere Prodat nach lokal (Down-Sync)
ECHO [E] Erstelle Windows-Task (Prodat Instanzen beenden, Updaten, Starten)
ECHO [L] Lsche Windows-Task
ECHO [C] Erstelle Shortcut (Prodat Instanzen beenden, Updaten, Starten)
ECHO [D] Lsche Shortcut
ECHO     ------------------------------------------------------------------
ECHO [0] Bildschirmausgaben lschen
ECHO [X] Exit
CHOICE /N /M "Bitte Menu-Option whlen" /C:12SQPAZMNKELCD0X
ECHO(


IF %ERRORLEVEL% EQU 1 GOTO Install_Automatic_Default
IF %ERRORLEVEL% EQU 2 GOTO Install_Automatic_BDE

REM ===========================================================================
REM Default ist MENU, fr alle folgenden Menu-Optionen
SET Var_S_NextGOTOLABEL=MENU

IF %ERRORLEVEL% EQU 3 GOTO Setup_SetLocalDir
IF %ERRORLEVEL% EQU 4 GOTO Setup_Cfg_SetRemoteDir
IF %ERRORLEVEL% EQU 5 GOTO Setup_Cfg_SetProg
IF %ERRORLEVEL% EQU 6 GOTO Setup_Cfg_SetParams
IF %ERRORLEVEL% EQU 7 GOTO Setup_ViewCfg
IF %ERRORLEVEL% EQU 8 GOTO Setup_WriteCfg
IF %ERRORLEVEL% EQU 9 GOTO Setup_LoadCfg
IF %ERRORLEVEL% EQU 10 GOTO CopyToLocal
IF %ERRORLEVEL% EQU 11 GOTO Task_Install
IF %ERRORLEVEL% EQU 12 GOTO Task_Delete
IF %ERRORLEVEL% EQU 13 GOTO Shortcut_Install
IF %ERRORLEVEL% EQU 14 GOTO Shortcut_Delete
IF %ERRORLEVEL% EQU 15 GOTO _CLEARSCREEN
IF %ERRORLEVEL% EQU 16 GOTO _EXIT
REM ============================ END MENU END =================================
REM ===========================================================================



REM ===========================================================================
REM ================ BEGIN Install Automatic Default BEGIN ====================
REM ===========================================================================
:Install_Automatic_Default

SET VarLocalDir=C:\ProdatERP\
SET VarCfg_StartProdat_Prog=ProdatSQL.exe
SET VarCfg_StartProdat_Params=

GOTO Install_Automatic
REM ================== END Install Automatic Default END ======================
REM ===========================================================================



REM ===========================================================================
REM =================== BEGIN Install Automatic BDE BEGIN =====================
REM ===========================================================================
:Install_Automatic_BDE
SET VarLocalDir=C:\ProdatERP\
SET VarCfg_StartProdat_Prog=ProdatSQL.exe
SET VarCfg_StartProdat_Params=-REMEMBER_SERVER 1 -L -U "BDE" -M 11 -UniqueName PRODAT-BDE-UNIQUEHANDLE

GOTO Install_Automatic
REM ===================== END Install Automatic BDE END =======================
REM ===========================================================================



REM ===========================================================================
REM =================== BEGIN Install Automatic BEGIN =========================
REM ===========================================================================
:Install_Automatic
ECHO "Lokales Prodat" wird mit folgender Konfiguration eingerichtet:
SET Var_S_ReturnGOTOLABEL=Install_Automatic_Step_Confirm
GOTO Setup_ViewCfg

:Install_Automatic_Step_Confirm
CHOICE /N /C JN /M "Fortfahren? [J][N]"
IF %ERRORLEVEL% EQU 2 GOTO MENU
ECHO(

:Install_Automatic_Step_CreateFolders
SET Var_S_NextGOTOLABEL=Install_Automatic_Step_CreateCfgFile
GOTO Create_Folders

:Install_Automatic_Step_CreateCfgFile
SET Var_S_ReturnGOTOLABEL=Install_Automatic_Step_CreateShortcutScript
GOTO Setup_WriteCfg

:Install_Automatic_Step_CreateShortcutScript
SET /A VarDoPrintMsg_WriteCfg=0

SET Var_S_NextGOTOLABEL=Install_Automatic_Step_CreateWinTaskScript
GOTO Create_ShortcutScript

:Install_Automatic_Step_CreateWinTaskScript
SET /A VarDoPrintMsg_CreateShortcutScript=0

SET Var_S_NextGOTOLABEL=Install_Automatic_Step_CopyToLocal
GOTO Create_WinTaskScript

:Install_Automatic_Step_CopyToLocal
SET /A VarDoPrintMsg_CreateWinTaskScript=0

SET Var_S_ReturnGOTOLABEL=Install_Automatic_Step_TaskInstall
GOTO CopyToLocal_1

:Install_Automatic_Step_TaskInstall
CALL %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_Setup_Task.bat DELETESILENT %VarLocalDir%
SET Var_S_ReturnGOTOLABEL=Setup_DefaultFull_Step_ShortcutInstall
GOTO Task_Install

:Setup_DefaultFull_Step_ShortcutInstall
ECHO(
REM Second Argument is just dummy, so the called script doesnt complain
CALL CSCript.exe %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_Setup_Shortcut.vbs DELETESILENT "%VarLocalDir%Administration\RunLocal\RunLocal_WinTaskScript.bat"
SET Var_S_ReturnGOTOLABEL=MENU
GOTO Shortcut_Install
REM ====================== END Install Automatic END ==========================
REM ===========================================================================






REM ===========================================================================
REM ===================== BEGIN SUB-PROGRAMS BEGIN ============================
REM ===========================================================================

:Create_Folders
ECHO Erstelle Ordner:          "%VarLocalDir%Administration\RunLocal\"

TYPE NUL
IF NOT EXIST %VarLocalDir% (
  MKDIR %VarLocalDir% >NUL 2>&1
)
IF %ERRORLEVEL% EQU 1 (
  ECHO Kann Ordner "%VarLocalDir%" nicht erstellen
  GOTO MENU
)

TYPE NUL
IF NOT EXIST %VarLocalDir%Administration\ (
  MKDIR %VarLocalDir%Administration\ >NUL 2>&1
)
IF %ERRORLEVEL% EQU 1 (
  ECHO Kann Ordner "%VarLocalDir%Administration\" nicht erstellen
  GOTO MENU
)

TYPE NUL
IF NOT EXIST %VarLocalDir%Administration\RunLocal\ (
  MKDIR %VarLocalDir%Administration\RunLocal\ >NUL 2>&1
)
IF %ERRORLEVEL% EQU 1 (
  ECHO Kann Ordner "%VarLocalDir%Administration\RunLocal\" nicht erstellen
  GOTO MENU
)

GOTO %Var_S_NextGOTOLABEL%



:Create_ShortcutScript
SET VarShortcut_ScriptName=%VarLocalDir%Administration\RunLocal\RunLocal_ShortcutScript.bat

IF %VarDoPrintMsg_CreateShortcutScript% EQU 1 (
  ECHO Erstelle ShortcutScript:  "%VarShortcut_ScriptName%"
)

(
  ECHO @ECHO OFF
  ECHO CALL RunLocal_UpdateLocal.bat UPDATEONLY exclude_default.rcj NULL NULL
  ECHO TIMEOUT 3
  ECHO EXIT
)>%VarShortcut_ScriptName%

GOTO %Var_S_NextGOTOLABEL%



:Create_WinTaskScript
SET VarWinTask_ScriptName=%VarLocalDir%Administration\RunLocal\RunLocal_WinTaskScript.bat
SET VarShortcut_ScriptName=%VarLocalDir%Administration\RunLocal\RunLocal_ShortcutScript.bat

IF %VarDoPrintMsg_CreateWinTaskScript% EQU 1 (
  ECHO Erstelle WinTaskScript:   "%VarWinTask_ScriptName%"
)

(
  ECHO @ECHO OFF
  ECHO START /WAIT /B /D "%VarLocalDir%Administration\RunLocal\" %VarShortcut_ScriptName%
  ECHO EXIT
)>%VarWinTask_ScriptName%

GOTO %Var_S_NextGOTOLABEL%



:Setup_ViewCfg
ECHO Konfiguration - Remote-Directory:   "%VarCfg_RemoteDir%"
ECHO Konfiguration - Programm/Parameter: "%VarCfg_StartProdat_Prog% %VarCfg_StartProdat_Params%"
ECHO Lokales Verzeichnis:                "%VarLocalDir%"
GOTO %Var_S_ReturnGOTOLABEL%



:Setup_WriteCfg
IF %VarLocalDir% EQU NOT-SET (
  GOTO Setup_ViewLocalDir
)
REM Config in Root-Dir
REM IF NOT EXIST %VarLocalDir%Administration\RunLocal\ (
REM   MKDIR %VarLocalDir%Administration\RunLocal\
REM )

SET VarCfg_Filename=%VarLocalDir%Administration\RunLocal_SetCfgVariables.bat
IF %VarDoPrintMsg_WriteCfg% EQU 1 (
  ECHO Erstelle Konfiguration:   "%VarCfg_Filename%"
)

(
  ECHO @ECHO OFF
  ECHO SET VarCfg_RemoteDir=%VarCfg_RemoteDir%
  ECHO SET VarCfg_StartProdat_Prog=%VarCfg_StartProdat_Prog%
  ECHO SET VarCfg_StartProdat_Params=%VarCfg_StartProdat_Params%
)>%VarCfg_Filename%

GOTO %Var_S_ReturnGOTOLABEL%



:Setup_LoadCfg
IF %VarLocalDir% EQU NOT-SET (
  GOTO Setup_ViewLocalDir
) ELSE (
REM Config in Root-Dir
REM   ECHO Lade Konfiguration: "%VarLocalDir%Administration\RunLocal\RunLocal_SetCfgVariables.bat"
REM   CALL %VarLocalDir%Administration\RunLocal\RunLocal_SetCfgVariables.bat
  ECHO Lade Konfiguration: "%VarLocalDir%Administration\RunLocal_SetCfgVariables.bat"
  CALL %VarLocalDir%Administration\RunLocal_SetCfgVariables.bat
)
GOTO %Var_S_ReturnGOTOLABEL%



:Setup_CheckCfg
ECHO Remote-Directory:   "%VarCfg_RemoteDir%"
ECHO Programm/Parameter: "%VarCfg_StartProdat_Prog% %VarCfg_StartProdat_Params%"
CHOICE /N /C JN /M "Konfiguration korrekt und fortfahren? [J][N]"
IF %ERRORLEVEL% EQU 1 GOTO %Var_S_NextGOTOLABEL%
GOTO %Var_S_ReturnGOTOLABEL%



:Setup_SetLocalDir
SET /P VarLocalDir=Lokales Verzeichniss angeben: || SET VarLocalDir=NOT-SET
IF %VarLocalDir% EQU NOT-SET GOTO %Var_S_ReturnGOTOLABEL%
IF NOT [%VarLocalDir:~-1%] EQU [\] SET VarLocalDir=%VarLocalDir%\

SET Var_S_NextGOTOLABEL=Setup_SetLocalDir_1
GOTO Create_Folders
:Setup_SetLocalDir_1
PUSHD %VarLocalDir% && (SET /A IsDir=1 & POPD) || (SET /A IsDir=0) 2>NUL
IF %IsDir% EQU 0 (
	ECHO %VarLocalDir% ist kein Verzeichniss
	SET VarLocalDir=NOT-SET
)
GOTO %Var_S_ReturnGOTOLABEL%



:Setup_ViewLocalDir
ECHO Lokales Verzeichniss ist: %VarLocalDir%
GOTO %Var_S_ReturnGOTOLABEL%



:Setup_Cfg_SetRemoteDir
SET /P VarCfg_RemoteDir=Quell-Verzeichniss (Remote-Directory) angeben:
IF NOT [%VarCfg_RemoteDir:~-1%] EQU [\] SET VarCfg_RemoteDir=%VarCfg_RemoteDir%\
GOTO %Var_S_ReturnGOTOLABEL%



:Setup_Cfg_SetProg
SET /P VarCfg_StartProdat_Prog=Programm angeben:
GOTO %Var_S_ReturnGOTOLABEL%



:Setup_Cfg_SetParams
SET /P VarCfg_StartProdat_Params=Programm-Parameter angeben: || SET VarCfg_StartProdat_Params=
GOTO %Var_S_ReturnGOTOLABEL%



:CopyToLocal_CheckRobocopy
TYPE NUL
CALL %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_UpdateLocal.bat TESTROBOCOPY %VarCfg_RemoteDir%Administration\RunLocal\exclude_default.rcj "%VarCfg_RemoteDir%Administration\RunLocal\" "%VarLocalDir%Administration\RunLocal\"
IF %ERRORLEVEL% EQU 16 (
  ECHO(
  ECHO RoboCopy Version veraltet. Setup funktioniert nur mit Versionen ab Windows 10
  PAUSE
  GOTO _EXIT
)
GOTO %Var_S_NextGOTOLABEL%



:CopyToLocal
SET Var_S_NextGOTOLABEL=CopyToLocal_1
IF %VarLocalDir% EQU NOT-SET (
	GOTO Setup_ViewLocalDir
) ELSE (
  GOTO Setup_CheckCfg
)
:CopyToLocal_1
SET Var_S_NextGOTOLABEL=CopyToLocal_2
GOTO CopyToLocal_CheckRobocopy
:CopyToLocal_2
ECHO(
ECHO Synchronisiere:           "%VarCfg_RemoteDir%" ^=^> "%VarLocalDir%"
CALL %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_UpdateLocal.bat SYNC %VarCfg_RemoteDir%Administration\RunLocal\exclude_default.rcj "%VarCfg_RemoteDir%" "%VarLocalDir%" DONTSTARTPRODAT
GOTO %Var_S_ReturnGOTOLABEL%



:Task_Install
SET Var_S_NextGOTOLABEL=Task_Install_1
IF %VarLocalDir% EQU NOT-SET (
	GOTO Setup_ViewLocalDir
) ELSE (
  GOTO Create_ShortcutScript
)
:Task_Install_1
SET Var_S_NextGOTOLABEL=Task_Install_2
GOTO Create_WinTaskScript
:Task_Install_2
CALL %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_Setup_Task.bat CREATESILENT "%VarLocalDir%Administration\RunLocal\RunLocal_WinTaskScript.bat"
GOTO %Var_S_ReturnGOTOLABEL%



:Task_Delete
IF %VarLocalDir% EQU NOT-SET (
	GOTO Setup_ViewLocalDir
) ELSE (
  REM Second Argument is just dummy, so the called script doesnt complain
  CALL %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_Setup_Task.bat DELETE %VarLocalDir%
)
GOTO %Var_S_ReturnGOTOLABEL%



:Shortcut_Install
SET Var_S_NextGOTOLABEL=Shortcut_Install_1
IF %VarLocalDir% EQU NOT-SET (
	GOTO Setup_ViewLocalDir
) ELSE (
  GOTO Create_ShortcutScript
)
:Shortcut_Install_1
CALL CSCript.exe %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_Setup_Shortcut.vbs CREATE "%VarLocalDir%Administration\RunLocal\RunLocal_ShortcutScript.bat" "%VarLocalDir%%VarCfg_StartProdat_Prog%"
GOTO %Var_S_ReturnGOTOLABEL%



:Shortcut_Delete
IF %VarLocalDir% EQU NOT-SET (
	GOTO Setup_ViewLocalDir
)
CHOICE /N /C JN /M "Shortcut wirklich lschen? [J][N]"
IF %ERRORLEVEL% EQU 1 (
  REM Second Argument is just dummy, so the called script doesnt complain
  CALL CSCript.exe %VarCfg_RemoteDir%Administration\RunLocal\RunLocal_Setup_Shortcut.vbs DELETE "%VarLocalDir%Administration\RunLocal\RunLocal_WinTaskScript.bat"
)
GOTO %Var_S_ReturnGOTOLABEL%
REM ======================== END SUB-PROGRAMS END =============================
REM ===========================================================================



:_CLEARSCREEN
cls
GOTO %Var_S_ReturnGOTOLABEL%



:_EXIT
ECHO EXIT