-- Datei muss im Prodat Verzeichniss liegen.

-- Zurücksetzen der Einstellungen auf TEST_DB (%TEST%)

BEGIN;

DO $$

 DECLARE

    DMSStandardPath_Value  VARCHAR;

    NX_VORLAGE_DATEI_Value VARCHAR;

    NX_DATEN_PFAD_Value    VARCHAR;

 BEGIN

    DMSStandardPath_Value  := null;

    NX_VORLAGE_DATEI_Value := null;

    NX_DATEN_PFAD_Value    := null;

    -- Datenbank (wo das hier ausgeführt wird) muss irgendwas mit TEST heißen

    IF current_database() NOT iLIKE '%TEST%' THEN

      RETURN;

    END IF;

    IF TSystem.Settings__Get('KUNDE')                              = 'APUS'         THEN

        DMSStandardPath_Value  := '';                                                     -- todo

        NX_VORLAGE_DATEI_Value := '';                                                     -- todo

        NX_DATEN_PFAD_Value    := '';                                                     -- todo

    ELSEIF TSystem.Settings__Get('KUNDE')                          = 'KREYENBERG'   THEN

        DMSStandardPath_Value := E'D:\\ProdatERP\\ProdatDMS-Test';

    ELSEIF TSystem.Settings__Get('KUNDE')                          = 'LOLL'         THEN

        DMSStandardPath_Value   := TSystem.Settings__Get('DMSStandardPath'); -- Pfad wird beibehalten. Im Testsystem sollen normale Dokumente verfügbar sein.

    END IF;

    --- Standardpfad DMS

    PERFORM TSystem.Settings__Set('DMSStandardPath', DMSStandardPath_Value);

    --- NX

    PERFORM TSystem.Settings__Set('NX_VORLAGE_DATEI', NX_VORLAGE_DATEI_Value);

    PERFORM TSystem.Settings__Set('NX_DATEN_PFAD', NX_DATEN_PFAD_Value);

    --- Hänel-Lift

    DELETE FROM haenel;

    --- EDI

    UPDATE edi_do_edi

        SET edd_active = FALSE;

    --- FIBU

    UPDATE settings

        SET s_inha = null

    WHERE UPPER(s_vari) IN ('EXPORT_FAK_DATEV', 'EXPORT_FAK_SESAM', 'EXPORT_FAK_ADDISON', 'EXPORT_FAK_SBS', 'EXPORT_FAK_ABA', 'EXPORT_FAK_SIMBA', 'CHECKEDIFAK');

    --- NX

    UPDATE settings

        SET s_inha = null

    WHERE UPPER(s_vari) IN ('NX_VERWENDEN');

END $$;

COMMIT; -- Bestätigung der Änderungen per Hand
