﻿var cim_extension;
if (!cim_extension)
  cim_extension = {};
(function() {

  cim_extension.mouseover = function(a) {
    native function mouseover();

    document.body.addEventListener("mouseover", function(evt){
                          function getpath(n){
                            var ret = "<" + n.nodeName + ">";
                            if (n.parentNode){return getpath(n.parentNode) + ret} else
                            return ret
                          };
                         cim_extension.mouseover(getpath(evt.target))}
                        )

    mouseover(a);
  };

  cim_extension.sendresulttobrowser = function(b,c) {
    native function sendresulttobrowser();
    sendresulttobrowser(b,c);
  };

  //=== prodat_version_show ==================================================
  //'var__prodat_client_version' wurde im Delphi als globale JS-Variable gesetzt, siehe uCEFCommon -> GlobalCEFApp_OnContextCreated
  cim_extension.prodat_version_show = function() {
    native function prodat_version_show();
    console.info("ProdatClientVersion = " + var__prodat_client_version);
    prodat_version_show();
  };

  //=== formvalues_get =======================================================
  //gibt Elle elements (sehe Filter unten) mit Attribute 'prodat' zurück
  cim_extension.formvalues_get = function() {
    native function formvalues_get();
    var result = [];
    const elements = document.querySelectorAll("input, textarea, select");

    console.info("[formvalues_get()]");

    elements.forEach(function(el) {
      var attr_prodat = el.getAttribute("prodat") || "";
      if (attr_prodat == "") return;

      // --- Auswertung von SELECT ---
      if (el.tagName.toLowerCase() === "select") {
        var selectedIndex = el.selectedIndex;
        var selectedOption = el.options[selectedIndex];

        result.push({
          id: el.id || "",
          name: el.name || "",
          prodat: attr_prodat,
          value: selectedIndex,
          typ: el.type || ""
        });
        result.push({
          id: el.id || "",
          name: el.name || "",
          prodat: attr_prodat + "_char",
          value: selectedIndex.toString().padStart(2, '0'),
          typ: el.type || ""
        });
        result.push({
          id: el.id || "",
          name: el.name || "",
          prodat: attr_prodat + "_text",
          value: selectedOption ? selectedOption.text : "",
          typ: el.type || ""
        });

      // --- Auswertung von CHECKBOX ---
      } else if (el.tagName.toLowerCase() === "input" && el.type === "checkbox") {
        result.push({
          id: el.id || "",
          name: el.name || "",
          prodat: attr_prodat,
          value: +el.checked, // 1 oder 0
          typ: el.type || ""
        });

      // --- Auswertung von DATE ---
      } else if (el.tagName.toLowerCase() === "input" && el.type === "date") {
        console.info("DATE FIELD: id=" + el.id);
        let val = "00000000";
        if (el.value) {
          console.info("value = " + el.value);
          // value ist im Format "yyyy-mm-dd"
          const parts = el.value.split("-");
          if (parts.length === 3) {
            const yyyy = parts[0];
            const mm = parts[1].padStart(2, "0");
            const dd = parts[2].padStart(2, "0");
            val = yyyy + mm + dd;  // YYYYMMDD
            console.info(">>> val = " + val);
          }
        }
        result.push({
          id: el.id || "",
          name: el.name || "",
          prodat: attr_prodat,
          value: val,
          typ: el.type || ""
        });


      // --- Alle andere Felder ---
      } else {
        result.push({
          id: el.id || "",
          name: el.name || "",
          prodat: attr_prodat,
          value: el.value,
          typ: el.type || ""
        });
      }
    });

    var json = JSON.stringify(result, null, 2);
    console.info("output: " + json + '\n' + '-'.repeat(64));
    formvalues_get(json);
  };

  //=== formvalues_set =======================================================
  //Parameterübergabe: füllt alle Felder im document mit übergebenen Werten
  cim_extension.formvalues_set = function(values) {
    native function formvalues_set();

    console.info("[formvalues_set(" + JSON.stringify(values) + ")]");

    var result = [];

    if (Array.isArray(values)) {
      for (var i = 0; i < values.length; i++) {
        var item = values[i];
        var el = document.querySelector("[prodat='" + item.field_name + "']");

        if (el) {
          el.value = item.field_value;
          el.dispatchEvent(new Event('input', { bubbles: true })); // Trigger change event

          result.push({
            field_name: item.field_name,
            field_value: item.field_value
          });
        }
      }
    }

    var json = JSON.stringify(result, null, 2);
    console.info("output: " + json + '\n' + '-'.repeat(64));

    formvalues_set(json);
  };


})();