-- Aufruf:
-- psql.exe -h <SERVER> -p <PORT> -U postgres -d "<DBNAME>" -f "Terminierung2020Einspielen.sql" -q -o _messages.log 2> _error.log
-- psql.exe -h localhost -p 5434 -U postgres -d "KUNDEN-KB-LIVE-AXS" -f "Terminierung2020Einspielen.sql" -q -o _messages.log 2> _error.log


/*******************
 * Daten aufräumen *
 *******************/

/* Muss nur bei Bestandsdaten mittels DBUs gemacht werden

-- Alle offenen Bestellungen schließen, wo die bestellte Menge kleiner gleich der gelieferten Menge ist.
UPDATE ldsdok
  SET ld_done = true
WHERE NOT ld_done
  AND ld_stk_uf1 <= ld_stkl;

-- Alle offenen ABKs schließen, welche keine offenen AGe mehr haben.
UPDATE abk
  SET ab_done = true
WHERE ab_ix IN (
                  SELECT ab_ix
                    FROM abk
                  WHERE NOT ab_done
                    AND NOT EXISTS ( SELECT true FROM ab2 WHERE a2_ab_ix = ab_ix AND NOT a2_ende )
                  );

-- Alle offenen ABKs schließen, deren verknüpfter Auftrag bereits geschlossen ist.
UPDATE abk
  SET ab_done = true
WHERE ab_ix IN (
                  SELECT ab_ix
                    FROM abk
                  WHERE NOT ab_done
                    AND ab_plan_ag_id IS NOT NULL
                    AND COALESCE( ( SELECT ag_done FROM auftg WHERE ag_id = ab_plan_ag_id ), true )
                );

-- Alle offenen ABKs schließen, welche unter einem geschlossenen QAB liegen.
UPDATE abk
  SET ab_done = true
WHERE NOT ab_done
  AND ab_dbrid IN (
                      SELECT qab.dbrid
                        FROM qab
                        WHERE q_def
                  );

-- ab_inplantaf
-- alle terminierten ABK, die nicht in der Plantafel sind, sind auch nicht terminiert!
UPDATE ab2 SET a2_interm = false, a2_at = null, a2_et = null FROM abk WHERE a2_ab_ix = ab_ix AND NOT ab_inplantaf AND NOT a2_ende AND a2_interm;


-- Alle offenen AGe schließen, wo die ABK bereits geschlossen ist.
UPDATE ab2
  SET a2_ende = true
WHERE NOT a2_ende
      AND a2_ab_ix IN ( SELECT ab_ix FROM abk WHERE ab_done );

-- Bei allen Montage-Kostenstellen DLZ-Terminierung ausschalten.
ALTER TABLE ksv DISABLE TRIGGER ALL;
UPDATE ksv
  SET ks_force_dlz = false
WHERE ks_force_dlz
  AND ks_abt LIKE '%MON%';
ALTER TABLE ksv ENABLE TRIGGER ALL;

-- Puffer markieren!
UPDATE abk SET ab_stat = ENUM_SetValue(ab_stat, 'BUFFER') FROM anl WHERE an_ab_ix = ab_ix AND (an_nr LIKE '%PUFFER%' OR Upper(an_bez) LIKE Upper('%Puffer%') ); --42113
UPDATE abk SET ab_stat = ENUM_SetValue(ab_stat, 'BUFFER') WHERE ab_ap_nr LIKE 'K1000';
-- alle Puffer ans Ende der Woche!
UPDATE ab2_wkstplan SET a2w_prio = 999 FROM abk, ab2 WHERE a2_ab_ix = ab_ix AND a2_id = a2w_a2_id AND TSystem.ENUM_GetValue(ab_stat, 'BUFFER') AND a2w_prio IS DISTINCT FROM 999;

 */


/*********************
 * Daten aufbereiten *
 *********************/

 /* Ist jetzt in Datei "9000 Define\zzzz prepare_termini_data.sql". */


 /********************
 * Daten übernehmen  *
 ********************/

-- Bei der ursprünglichen Terminierung verwendete Hauptressource pro AG als Vorgabe für zukünftige Terminierungen eintragen.
DO $$
DECLARE
    r record;
    -- Exception-Handling
    _errmsg text;
    _message_text text;
    _pg_exception_context text;
    _pg_exception_detail text;
    _pg_exception_hint text;
BEGIN
    FOR r IN SELECT a2w_a2_id, ksb_ks_shorthand
                FROM ab2_wkstplan
                JOIN ksvba ON ksb_ks_shorthand = a2w_ks
                JOIN ksv ON ks_id = ksb_ks_id
                JOIN ab2 ON a2_id = a2w_a2_id
                JOIN abk ON ab_ix = a2_ab_ix
               WHERE a2w_planweek IS NOT null
                 AND a2_interm
                 AND NOT a2_ende
                 AND NOT ab_done
                 AND ab_inplantaf
                 AND NOT ks_sperr
                 AND a2w_ks NOT LIKE '% |0'
                 AND a2w_marked >= 0
               ORDER BY a2w_a2_id
    LOOP

        -- Exception-Handling-Block um eventuelle Fehler bei der Terminierung des aktuellen AG abzufangen und danach weiterarbeiten zu können.
        BEGIN

            -- Hier Funktion "ab2_wkstplan__resource_id_main_fix__move__set()" verwenden, damit beim Setzen der verwendeten Hauptressource diese auch noch als Ressourcenoption hinzugefügt wird.
            PERFORM scheduling.ab2_wkstplan__resource_id_main_fix__move__set(
                        _a2_id                    => r.a2w_a2_id
                      , _to_resource_id           => scheduling.resource__translate__ksvba__shorthand__to__resource_id( r.ksb_ks_shorthand )
                      , _all_ag_withthis_resource => false
                    );

        EXCEPTION
            WHEN OTHERS THEN
                GET STACKED DIAGNOSTICS _message_text = MESSAGE_TEXT
                                      , _pg_exception_detail = PG_EXCEPTION_DETAIL
                                      , _pg_exception_hint = PG_EXCEPTION_HINT
                                      , _pg_exception_context = PG_EXCEPTION_CONTEXT;
                _errmsg :=  'ERROR: ' || _message_text || E'\n' ||
                            'Detail:' || _pg_exception_detail || E'\n' ||
                            'Context:' || _pg_exception_context || E'\n' ||
                            'Hint:' || _pg_exception_hint || E'\n';
                RAISE WARNING '%', _errmsg;
        END;

    END LOOP;
END $$ LANGUAGE plpgsql;
--

ALTER TABLE ab2_wkstplan DISABLE TRIGGER ALL;
-- abschalten, da sonst TRIGGER ab2_wkstplan__b_u
UPDATE ab2_wkstplan SET a2w_resource_id_main_terminated = a2w_resource_id_main_fix WHERE a2w_resource_id_main_fix IS NOT null;
ALTER TABLE ab2_wkstplan ENABLE TRIGGER ALL;

SELECT TSystem.Log_Set_LogLevel( _user => 'yes', currLevel => 5 );
SELECT scheduling.resource_timeline__migrate_from_ab2_wkstplan( _timeframe => '2weeks' );
SELECT scheduling.resource_timeline__migrate_from_ab2_wkstplan( _timeframe => '4weeks' );
SELECT scheduling.resource_timeline__migrate_from_ab2_wkstplan( _timeframe => 'halfyear' );
SELECT scheduling.resource_timeline__migrate_from_ab2_wkstplan( _timeframe => 'remaining' );
SELECT scheduling.resource_timeline__finish_termination();

/* Nicht mehr notwendig. Wir Terminieren jetzt auch AGe mit Laufzeit 0.
-- Anfangs- und Endzeiten von untermineriten AGs löschen, welche keine Laufzeit besitzen
DO $$
BEGIN
  PERFORM execution_flag__aquire( _flagname => 'inTerminierung' );
  UPDATE ab2
     SET a2_at = null
       , a2_et = null
   WHERE a2_interm
     AND NOT a2_ende
     AND a2_ta = 0
     AND NOT a2_ausw
     AND NOT EXISTS (SELECT true FROM scheduling.resource_timeline WHERE ti_a2_id = a2_id)
  ;
  PERFORM execution_flag__release( _flagname => 'inTerminierung' );
END $$ LANGUAGE plpgsql;
*/

-- AG welche vorher komplett aus der Reihe waren (letzter AG Säubern) ranziehen
DO $$
DECLARE

    _ab2 ab2;
    -- Exception-Handling
    _errmsg text;
    _message_text text;
    _pg_exception_context text;
    _pg_exception_detail text;
    _pg_exception_hint text;

BEGIN

    FOR _ab2 IN SELECT ab2.* FROM ab2 WHERE a2_interm AND NOT a2_ende AND a2_ks = 'SV' -- AND a2_ab_ix = 231321
    LOOP

      -- Exception-Handling-Block um eventuelle Fehler bei der Terminierung des aktuellen AG abzufangen und danach weiterarbeiten zu können.
      BEGIN

          PERFORM scheduling.abk__termination_execute__auto(
                      _ab2.a2_ab_ix,
                      -- Mittelpunktterminierung, ab diesem AG (Vorwärts / Rückwärts). Standard: NULL (vorwärts/rückwärts alles)
                      null,
                      -- Startpunkt der Terminierung
                      ab_at,
                      -- Ergbnis nur als Vorschau? -> Rückgabe der Funktion
                      _write_to_disk => true,
                      -- Terminierungsrichtung / Art
                      _forward__backward__middle__null_auto => 'forward',
                      _a2_n__start => _ab2.a2_n,
                      _a2_n__stop => _ab2.a2_n,
                      _dlz_terminiation => true,
                      _allow_overlap => false
                  )
            FROM abk WHERE ab_ix = _ab2.a2_ab_ix; -- scheduling.ab2__prior__terminated__get(_ab2) AS _prior;

      EXCEPTION
          WHEN OTHERS THEN
              GET STACKED DIAGNOSTICS _message_text = MESSAGE_TEXT
                                    , _pg_exception_detail = PG_EXCEPTION_DETAIL
                                    , _pg_exception_hint = PG_EXCEPTION_HINT
                                    , _pg_exception_context = PG_EXCEPTION_CONTEXT;
              _errmsg :=  'ERROR: ' || _message_text || E'\n' ||
                          'Detail:' || _pg_exception_detail || E'\n' ||
                          'Context:' || _pg_exception_context || E'\n' ||
                          'Hint:' || _pg_exception_hint || E'\n';
              RAISE WARNING '%', _errmsg;
      END;

    END LOOP;

END $$ LANGUAGE plpgsql;


-- Überhänge der mit DLZ terminierten AGe als Blocktimes blockieren.
DO $$
DECLARE

    _a2_id integer;
    -- Exception-Handling
    _errmsg text;
    _message_text text;
    _pg_exception_context text;
    _pg_exception_detail text;
    _pg_exception_hint text;

BEGIN

    FOR _a2_id IN SELECT ti_a2_id
                    FROM scheduling.resource_timeline
                    JOIN ab2 ON a2_id = ti_a2_id
                    JOIN ab2_wkstplan ON a2w_a2_id = ti_a2_id
                                    AND a2w_marked >= 0
                    JOIN ksv ON ks_abt = (scheduling.resource__translate__resource_id__to__ksvba__shorthand( ti_resource_id )).ksb_ks_abt
                  WHERE ti_stat = 'dlz'
                    AND ti_type IN ( 'task', 'task.blocktime' )
                    AND ti_resource_id = a2w_resource_id_main_terminated
                    AND ks_force_dlz IS false
                    AND ks_ausw IS false
                  GROUP BY ti_a2_id
    LOOP

      -- Exception-Handling-Block um eventuelle Fehler beim Blockieren der der Überlappungen abzufangen und danach weiterarbeiten zu können.
      BEGIN

          PERFORM scheduling.resource_timeline__ab2__block_overlap( _ab2 => ab2 )
             FROM ab2
            WHERE a2_id = _a2_id;

      EXCEPTION
          WHEN OTHERS THEN
              GET STACKED DIAGNOSTICS _message_text = MESSAGE_TEXT
                                    , _pg_exception_detail = PG_EXCEPTION_DETAIL
                                    , _pg_exception_hint = PG_EXCEPTION_HINT
                                    , _pg_exception_context = PG_EXCEPTION_CONTEXT;
              _errmsg :=  'ERROR: ' || _message_text || E'\n' ||
                          'Detail:' || _pg_exception_detail || E'\n' ||
                          'Context:' || _pg_exception_context || E'\n' ||
                          'Hint:' || _pg_exception_hint || E'\n';
              RAISE WARNING '%', _errmsg;
      END;

    END LOOP;

END $$ LANGUAGE plpgsql;

SELECT do_artikel_bedarf();
SELECT TSystem.Log_Set_LogLevel( _user => 'yes' );
SELECT tabk.ab2_group__auto__by__ab_ix(ab_ix) FROM abk WHERE NOT ab_inplantaf AND NOT ab_done AND NOT (SELECT bool_or(tabk.ab2_groups__has(a2_id)) FROM ab2 WHERE a2_ab_ix = ab_ix);
--