@echo off
cls
call :init
:: Syncro-Tabellen lokal in "PSQL\9999 Syncro-Export" als CSV speichern, fr Suche in SourceCode+Erstellungsscript+SyncDaten.

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

call :exec dbupdates.csv  "SELECT '########', upd_id, upd_bez, upd_sql, 'knd:'||upd_kunde AS upd_kunde FROM dbupdates ORDER BY 2"

call :exec text0.csv      "SELECT '########', t_nr, t_feld0, t_feld3 FROM text0 WHERE t_feld0 IS DISTINCT FROM '*DELETED*' ORDER BY 2 ASC NULLS LAST"

call :exec fieldalias.csv "SELECT fa_fieldname, fa_tablename, 'txt:'||fa_textno AS fa_textno, lang_text(fa_textno), fa_constraints FROM fieldalias ORDER BY 1, 2"

call :exec mainmenu.csv   "SELECT '########', mm_id, 'txt:'||mm_textno AS mm_textno, lang_text(mm_textno), mm_formclassname, mm_description, mm_library, mm_proc, mm_sql, 'knd:'||mm_kunde AS mm_kunde FROM mainmenu WHERE mm_kunde IS DISTINCT FROM 'DELETED' ORDER BY 1"

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

call :exec systemsqlstatement.csv "SELECT '########', sql_name, sql_descr, sql_sql, sql_macro FROM systemsqlstatement WHERE NOT sql_deleted ORDER BY 2"

call :exec f2standard.csv         "SELECT '########', f2s_table, 'txt:'||f2s_name AS f2s_name, lang_text(f2s_name), f2s_query, f2s_querysub FROM f2standard WHERE NOT f2s_deleted ORDER BY 1, 2"

call :exec f2poss.csv             "SELECT '########', f2_id, 'f2s:'||f2_standard AS f2_standard, f2_query, modulname, feldname, 'txt:'||vartxtnr AS vartxtnr, lang_text(vartxtnr), 'rtf:'||runtimeforms AS runtimeforms, f2_previewfield, f2_searchedit, f2_filter, f2_config, 'knd:'||f2_kunde AS f2_kunde FROM f2poss WHERE NOT f2_deleted ORDER BY 4, 5"

call :exec f2rck.csv              "SELECT f2r_id, f2r_f2_id, modulname, feldname, f2r_f2rckfieldn, f2r_forcomponent, f2r_forfield FROM f2rck JOIN f2poss ON f2_id = f2r_f2_id ORDER BY 3, 4, 5, 6, 7"

call :exec runtimeforms.csv       "SELECT '########', rtf_id, rtf_table, 'txt:'||rtf_txtnr AS rtf_txtnr, lang_text(rtf_txtnr), rtf_text, rtf_script, rtf_textdfm FROM runtimeforms WHERE rtf_table <> 'DELETED' ORDER BY 1"

call :exec sondfunc.csv           "SELECT sf_id, sf_sqltable, sf_formclass, 'rtf:'||sf_rtf AS sf_rtf, 'txt:'||sf_txtnr AS sf_txtnr, lang_text(sf_txtnr), sf_cond, sf_sql, sf_config FROM sondfunc ORDER BY 2, 3"

call :exec olapbisettings.csv     "SELECT obi_id, obi_name, obi_bez, obi_txt, syncro_export__csv_encode(obi_config) AS obi_config FROM olapbisettings /*WHERE obi_system_sync*/ ORDER BY 2, 3"

call :exec SettingsDyn.csv        "SELECT '########', sd_id, sd_name, sd_type, sd_settingsname, 'txt:'||sd_vartxtnr AS sd_vartxtnr, lang_text(sd_vartxtnr), sd_config FROM SettingsDyn WHERE sd_deleted IS DISTINCT FROM True ORDER BY 4, 2"

call :exec dosqluserselect.csv    "SELECT '########', 'txt:'||sus_name AS sus_name, lang_text(sus_name), sus_sql FROM dosqluserselect ORDER BY 3"

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

call :exec picndoku.csv              "SELECT '########', pd_id, pd_path, pd_dokumentfile, pd_blob, pd_txt, pd_dokident AS password FROM picndoku WHERE pd_tablename='dokseals' AND insert_by='PRODAT' ORDER BY 2"

call :exec doksealsql.csv            "SELECT dss_id, dss_bez, dss_dt_id, dss_pd_id, pd_path, dss_deletesql, dss_insertsql, dss_txt FROM doksealsql LEFT JOIN picndoku ON pd_id = dss_pd_id ORDER BY 3, 5"

call :exec dokutypes.csv             "SELECT dt_id, 'txt:'||dt_txtnr AS dt_txtnr, lang_text(dt_txtnr), dt_descr, dt_linkto, dt_dokident, dt_linkforms FROM dokutypes /*WHERE dt_sync*/ ORDER BY 1"

call :exec recnocommentkategorie.csv "SELECT rck_id, rck_b, rck_gruppe, rck_column FROM recnocommentkategorie ORDER BY 1"

call :exec reports.csv               "SELECT '########', r_id, r_modulname, 'txt:'||r_descr AS r_descr, lang_text(r_descr), r_dokutype, r_sql, syncro_export__csv_encode(lo_get(r_blob)) AS r_blob, 'knd:'||r_kunde AS r_kunde, r_detail, r_beforescript, 'rtf:'||r_wherertf AS r_wherertf, 'rtf:'||r_afterrtf AS r_afterrtf, r_afterscript, r_inheritfrom, r_reportparameter, r_hlpcontxt, 'txt:'||r_shorthlptxtnr AS r_shorthlptxtnr FROM reports WHERE r_deleted IS DISTINCT FROM False AND r_blob ISNULL OR exists(SELECT true FROM pg_largeobject WHERE loid = r_blob) ORDER BY 1"

call :exec report_datasets.csv       "SELECT '########', rds_id, 'rep:'||rds_r_id AS rds_r_id, r_modulname, lang_text(r_descr), rds_name, rds_descr, rds_master, rds_linkfield, rds_masterfield, rds_sql FROM report_datasets JOIN reports ON r_id = rds_r_id ORDER BY 4, 5, 6"

call :exec report_afterrep.csv       "SELECT rla_id, 'rep:'||s.r_id AS rla_r_stamp, s.r_modulname, lang_text(s.r_descr), 'rep:'||a.r_id AS rla_after_r_stamp, a.r_modulname, lang_text(a.r_descr), rla_r_dokutypes, rla_connectdata FROM report_afterrep JOIN reports AS s ON s.r_stamp = rla_r_stamp JOIN reports AS a ON a.r_stamp = rla_after_r_stamp ORDER BY 3, 4, 5, 6, 7"

call :exec report_links.csv          "SELECT '########', rl_id, 'rep:'||r_id AS rl_r_stamp, r_modulname, lang_text(r_descr) AS r_descr, rl_modulname, rl_customsql FROM report_links JOIN reports ON r_stamp = rl_r_stamp WHERE r_kunde IS DISTINCT FROM 'DELETED' ORDER BY 4, 5"

call :exec report_translations.csv   "SELECT rt_id, 'rep:'||rt_r_id AS rt_r_id, r_modulname, lang_text(r_descr) AS r_descr, rt_varname, s_spr_key, rt_text FROM report_translations JOIN reports ON r_id = rt_r_id JOIN adkspco ON s_spco = rt_spco ORDER BY 3, 4, 5, 6"

call :exec edi.csv                   "SELECT '########', edi_name, edi_sql_statement, edi_text FROM edi ORDER BY 1"

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

call :exec settings.csv           "SELECT '########', s_vari, s_inha, s_num_inha FROM settings ORDER BY 2"

call :exec component_options.csv  "SELECT '########', co_id, co_item, il_group, il_item, co_name, co_value FROM component_options JOIN itemlist ON il_id = co_item /*WHERE co_sync*/ WHERE il_group = 'TDashboardModul' ORDER BY 4, 5, 6"

call :exec gridlayout.csv         "SELECT gl_id, gl_item, il_group, il_item, gl_minr, gl_detailview, syncro_export__csv_encode(gl_layout) AS gl_layout, gl_deleted FROM gridlayout JOIN itemlist ON il_id = gl_item /*WHERE gl_sync*/ ORDER BY 3, 4, 5, 6"

call :exec gridfilter.csv         "SELECT gf_id, gf_item, il_group, il_item, gf_minr, gf_description, gf_filterhint, syncro_export__csv_encode(gf_filter) AS gf_filter, gf_deleted FROM gridfilter JOIN itemlist ON il_id = gf_item /*WHERE gf_sync*/ ORDER BY 3, 4, 5, 6"

call :exec helpindex.csv          "SELECT hi_id, hi_item, il_group, il_item, hi_helplink, hi_anker, hi_deleted FROM helpindex JOIN itemlist ON il_id = hi_item ORDER BY 3, 4, 5, 6"

call :exec keyboard_shortcuts.csv "SELECT kbsc_id, kbsc_keycode, kbsc_keystate, kbsc_keyvalue, kbsc_comment, 'knd:'||kbsc_kunde AS kbsc_kunde, kbsc_deleted FROM keyboard_shortcuts ORDER BY 4, 2, 3"

call :exec keyboard_layouts.csv   "SELECT '########', kblay_id, kblay_name, 'knd:'||kblay_kunde AS kblay_kunde, kblay_data, kblay_deleted FROM keyboard_layouts ORDER BY 3, 4"

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

call :finish
exit /b


:init
  set host=pg.prodat-erp.de
  set port=5434
  set base=PRODAT-DEV-24
  echo DATABASE: %base% @ %host%:%port%
  set /p user=USERNAME: 
  set /p pass=PASSWORD: 
  cls
  echo DATABASE: %base%:%user% @ %host%:%port%

  set PGPASSWORD=%pass%
  set login=-h %host% -p %port% -U %user% -d %base% -q
  set psql="%~dp0..\ExternKomponenten\RUNTIME-Dirs\Administration\pgdump\psql.exe" %login%

  @for /f %%a in ('echo prompt $E^| cmd') do @set "RED=%%a[31m"
  @for /f %%a in ('echo prompt $E^| cmd') do @set "DEF=%%a[0m"

  set dest=%~dp0\9999 Syncro-Export
  md "%dest%" >nul 2>&1
  del /q /s "%dest%\*.csv" >nul 2>&1

  rem CREATE OR REPLACE FUNCTION syncro_export__csv_encode(data BYTEA) RETURNS TEXT AS $$
  rem   DECLARE txt TEXT;
  rem   DECLARE i INT;
  rem   BEGIN
  rem     txt := encode(data, 'escape');  -- vergisst #0..#31
  rem     FOR i IN 1..31 LOOP
  rem       IF (i NOT IN (9,10,13)) AND (txt LIKE '%'||chr(i)||'%') THEN  -- replace ist arschlangsam
  rem         txt := replace(txt, chr(i), to_char(i, E'FM\\000'));
  rem       END IF;
  rem     END LOOP;
  rem     RETURN txt;
  rem   END $$ LANGUAGE plpgsql STABLE;
exit /b


:finish
  rem DROP FUNCTION syncro_export__csv_encode(data BYTEA);
exit /b


:exec
  echo export %~1
  %psql% -c "\COPY ( %~2 ) TO STDOUT DELIMITER ',' CSV HEADER" > "%dest%\%~1"

  set res=%errorlevel%
  if %res% NEQ 0 ( echo Status: %res% )
  if %res% == 1 ( echo %RED%SQL-Error%DEF% & pause )
  if %res% == 2 ( echo %RED%Syntax-Error%DEF% & pause )
  if %res% == 9009 ( echo PSQL.exe not found & pause )
exit /b
