# Styleguide:

  https://github.com/prodat/sql-styleguide

# Workflow:

  https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Pull_Requests_Ablauf

# Namenskonvention für Branches:

  https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/02_Git_Branches

# Lebenslauf vom PR:

meine PRs: https://github.com/prodat/psql/pulls?q=label%3A%22DB+Update+not+Freigabe+%2F+synced%22+is%3Aclosed+author%3A%40me+

alle PRs: https://github.com/prodat/psql/pulls?q=label%3A%22DB+Update+not+Freigabe+%2F+synced%22+is%3Aclosed++
```
+---------------------------------+
| Anforderungen / Ticketerfassung |                        <--- Tickets im Redmine
+---------------------------------+----------+
|                                            |
| [] Anforderungsermittlung                  |
|                                            |
| [] Entwurf technisches Konzept             |
|                                            |
| [] Erstumsetzung im Entwicklerbranch       |
|                                            |
| [] Bewertung / Absprache mit technischen   |
|    Ansprechpartnern                        |
|                                            |
+--------------------------------------------+
                     |                     ^
                     |                     |
                     v                     |
+---------------------------------+        |
| Draft-PR ( Optional )           |        |               <--- Draft-PR auf Github
+---------------------------------+-----------+
|                                             |
| [] Vorstellung und Bewertung des Prototypen |
|                                             |
| [] technisches Feedback in Zusammenhang mit |
|    inhaltichen Anforderungen umsetzen.      |
|                                             |<---+
| [] Bei Erstellung des PR wird automatisch   |    |
|    das Label 'DB Update missing' gesetzt    |    |
|                                             |    |
+---------------------------------------------+    |
                     |                             |
                     |                             |
                     v                             |
+-------------------------------------------+      |
| Inhaltiche Abnahme ( Projektleiter )      |      |      <--- Abnahme / Rückbestätigung via Ticket
+----------------------------------------------------+         im Redmine oder persönliche
|                                                    |         Besprechung mit PL
| [] Anforderungs- / Umsetzunsabgleich               |
|                                                    |
| [] Test gegen die Oberfläche                       |
|                                                    |
| [] inhaltlicher Abschluss                          |
|                                                    |
| [] DBU in PRODAT-DEMO-21.11 hochladen              |
|                                                    |
+----------------------------------------------------+
                     |                             ^
                     |                             |
                     v                             |
+-------------------------------------------+      |
| Technsiche Abnahme ( PR )                 |      |      <--- PR auf Github. Redmine-Ticket
+-----------------------------------------------------+        auf Codereview
|                                                     |
| [] Qualitätssicherung                               |
|                                                     |
| [] Freigabe von Tests                               |
|                                                     |
| [] Einhaltung des Styleguide                        |
|                                                     |
| [] technischer Abschluss                            |
|                                                     |
| [] Merge in Repository                              |
|                                                     |
| [] DBU mit PRODAT-18.08 synchronisieren und         |
|    das Label 'DB Update missing' manuel löschen     |
|                                                     |
+-----------------------------------------------------+
```
Wiki: https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Pull_Requests_Ablauf
```
# hilfreiche Tools

DB von Console erstellen

```bash
IFS=$(echo -en "\n\b"); for i in `php -r 'foreach(glob("{00*,02*,03*,4*,8*,90*}/*.sql",GLOB_BRACE) as $s) echo $s . PHP_EOL;'`; do psql -U HER -h pg.prodat-sql.de -p 5432 beispiel -f "$i"; done;
```
