##############################
# Script-Aufruf
# C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe -f H:\git\sysadmin-scripts-git\git-scripts\aliasscripts\import_sql.ps1 -APSQLPath "S:\prodat2005\PSQL" -AHost "localhost" -ADatabase "MyDB" -APort 5434 -AUser "DEMO"
##############################
# Wichtig!!!  beim DB erstellen nicht vergessen auf korrekter Branch umzuschalten (derzeit ist dev/geo/19730-db-synchronisieren)
################################################################################
# Parameters (Script)

#Clear-Host

param
(
  [string] $APSQLPath = 'S:\Prodat2005.T\PSQL',
  #[string] $APSQLPath = 'Y:\ProdatSQL\23.04\PSQL',
  [string] $AHost = 'localhost',     #'pg.prodat-erp.de',
  [string] $ADatabase = 'PRODAT-VERTRIEB-INTERESSENTEN',
  #[string] $ADatabase = 'DROP.GEO-CSV-IMPORT',
  #[bool] $mit_demo = $false,
  [bool]   $mit_demo = $true,
  [string] $APort = '5432',
  [string] $AUser = 'root',
  #[string] $AUser = 'GEO',
  [string] $encoding = 'UTF8',
  [string] $utf8NoBom = 'New-Object System.Text.UTF8Encoding $false'

)
################################################################################

#$BaseLogFilename = "Y:\Archiv\$(get-date -f yyyy-MM-dd-HH-mm)\"
#$BaseLogFilename = "Y:\Archiv\$(get-date -f yyyy-MM-dd-HH-mm)__"

#$BaseLogFilename = "Y:\Archiv\_LOG__DB_create__$(get-date -f yyyy-MM-dd-HH-mm)\"
$BaseLogFilename = "Y:\Archiv\TestComplete_LogsRoot_AllUsers\_PSQL_Log\"
If(!(test-path -PathType container $BaseLogFilename))
{
      New-Item -ItemType Directory -Path $BaseLogFilename
}


<#
DEBUG1 .. DEBUG5  Provides successively-more-detailed information for use by developers.  DEBUG   INFORMATION
INFO  Provides information implicitly requested by the user, e.g., output from VACUUM VERBOSE.  INFO  INFORMATION
NOTICE  Provides information that might be helpful to users, e.g., notice of truncation of long identifiers.  NOTICE  INFORMATION
WARNING   Provides warnings of likely problems, e.g., COMMIT outside a transaction block.   NOTICE  WARNING
ERROR   Reports an error that caused the current command to abort.  WARNING   ERROR
LOG   Reports information of interest to administrators, e.g., checkpoint activity.   INFO  INFORMATION
FATAL   Reports an error that caused the current session to abort.  ERR   ERROR
PANIC   Reports an error that caused all database sessions to abort.  CRIT  ERROR
#>
$PSQLWARNINGLEVEL = "WARNING"

################################################################################
# "" Literale werden ausgewertet: "$Variable" -> Wert-Von-Variable-als-String
# '' Literale werden NICHT ausgewertet: "$Variable" -> $Variable
# "$(Expression)" Expression kann hier mehr als nur einfach eine Variable sein,
#   kompletter Funktionsaufruf etcpp
################################################################################

function SQL__einspielen {
  param ( $dirname )

  $datei_pfad = Join-Path -Path $APSQLPath -ChildPath $dirname

  $Files = Get-ChildItem -Path $datei_pfad -Recurse -Include '*.sql' | Where-Object { ! $_.PSIsContainer }
  ForEach ($File in $Files) {
    # $File ist ein Objekt !!!
    # "$File" 'wandelt' das Objekt zu einem String (Default -> Dateiname)
    # um den kompletten Dateinamen inklusive Pfad zu bekommen: $File.Fullname

    # Write-Host "  SQL__einspielen $($File.FullName)"

    #$Filename = '"' + "$($File.FullName)" + '"'
    $Filename =  $($File.FullName)
    $SQLQueryLogFile = "$($BaseLogFilename)$($File.BaseName).log"
    $SQLQueryLogFile = $SQLQueryLogFile.Replace(" ","_")


#   &H:\PostgreSQL\pg13\bin\psql.exe --host=$AHost --port=$APort --username=$DBUser --dbname=$ADatabase -f $Filename
    $env:PGCLIENTENCODING = 'utf-8'
    #&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off client_min_messages=$PSQLWARNINGLEVEL --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f $Filename
    #&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off client_min_messages=$PSQLWARNINGLEVEL --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f $Filename
    #&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f $Filename
    #&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off --echo-errors --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f $Filename
    #&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off -L $SQLQueryLogFile --echo-errors --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f $Filename
    #&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off client_min_messages=$PSQLWARNINGLEVEL -L $SQLQueryLogFile --echo-errors --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f $Filename
    &H:\PostgreSQL\pg13\bin\psql.exe -P pager=off --echo-errors --set=client_min_messages=$PSQLWARNINGLEVEL --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f $Filename
  }
}

########################

# DB löschen
&H:\PostgreSQL\pg13\bin\dropdb.exe --host=$AHost --port=$APort --username=$AUser --force -w --if-exists $ADatabase

# DB erstellen
&H:\PostgreSQL\pg13\bin\createdb.exe --host=$AHost --port=$APort --username=$AUser --encoding=$encoding $ADatabase


# $not_like = @('.github', '9100-customer-functions', '9700 Demodaten', '9999-ci')
#$not_like = @('.github', '9100-customer-functions', '9800 Demodaten Scripts', '9999-ci')

if( $mit_demo -eq $true){
  $not_like = @('.github', '9100-customer-functions', '9800 Demodaten Scripts', '9999-ci')
}else{
  $not_like = @('.github', '9100-customer-functions', '9800 Demodaten Scripts', '9700 Demodaten', '9999-ci')
}
$Files = Get-ChildItem -Path $APSQLPath -Directory ###| Where-Object { ! $_.PSIsContainer }
ForEach ($File in $Files) {
  # $File ist ein Objekt !!!
  # "$File" 'wandelt' das Objekt zu einem String (Default -> Dateiname)
  # um den kompletten Dateinamen inklusive Pfad zu bekommen: $File.Fullname
  if ( $not_like -notcontains $File.Name ) {
    Write-Host "  Directory   $($File.Name)"
    SQL__einspielen $File.Name
  }
}

################

# Prodat-Version speichern, Tabelle dbupdates synchronisieren und einspielen
#&H:\PostgreSQL\pg13\bin\psql.exe --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\testcomplete\Prodat-Version.cmd'

#$SQLQueryLogFile = 'S:\Prodat2005\PSQL\9100-customer-functions\z05-testcomplete.log'
#$SQLQueryLogFile = "$($BaseLogFilename)$('z05-testcomplete').log"


# TestComplete: Sql-Funktionen einspielen
#&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off --echo-errors --set=client_min_messages=$PSQLWARNINGLEVEL --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\Prodat2005\PSQL\9100-customer-functions\z05-testcomplete.sql'
#&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off client_min_messages=$PSQLWARNINGLEVEL --echo-errors --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\Prodat2005\PSQL\9100-customer-functions\z05-testcomplete.sql'
#&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\Prodat2005\PSQL\9100-customer-functions\z05-testcomplete.sql'

#$SQLQueryLogFile = 'S:\testcomplete\Prodat-Settings_Set.log'
$SQLQueryLogFile = "$($BaseLogFilename)$('Prodat-Settings_Set').log"

# PRODAT- Settings_Set
#&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off --echo-errors  --set=client_min_messages=PSQLWARNINGLEVEL --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\testcomplete\Prodat-Settings_Set.sql'
#&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off client_min_messages=$PSQLWARNINGLEVEL --echo-errors --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\testcomplete\Prodat-Settings_Set.sql'
#&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\testcomplete\Prodat-Settings_Set.sql'

# PRODAT- Settings_Set
#&H:\PostgreSQL\pg13\bin\psql.exe -P pager=off client_min_messages=$PSQLWARNINGLEVEL --echo-errors --output=$SQLQueryLogFile --host=$AHost --port=$APort --username=$AUser --dbname=$ADatabase -f 'S:\testcomplete\DB_fehlende_Daten_anlegen.sql'

################

# Regysrti anpassen
#-1 = true, 0 = false
# Formular LFS: Drukerauswahl auf true
#Set-ItemProperty -Path "HKCU:\SOFTWARE\ProdatSQL\Prodat-DEV-TESTCOMPLETE\LastVal" -Name "TFormLFSBeleg" -Type String -Value "-1"

#Set-ItemProperty -Path "HKCU:\SOFTWARE\ProdatSQL\Prodat-DEV-TESTCOMPLETE\LastVal" -Name "TFormLdsDokDoku" -Type String -Value "0"

################
