/************* SPEKTRA ***************/

    --- #10784 Anfang
      CREATE OR REPLACE FUNCTION auftg__as__a_u__stk_storno_spektra() RETURNS TRIGGER AS $$
        BEGIN
          IF /*ag_storno AND */( execution_flag__isset( _flagname => 'auftg__is_a_u_donestornosubpos' ) ) THEN
            --RAISE NOTICE 'AU_STAT_TRIGGER [OK]';
            IF sessionvar__get_varchar('auftg__agids_liste', '') <> '' THEN
              PERFORM TAuftg.auftg__folgebelege_showf2_create_spektra();
            END IF;
          ELSE
            --RAISE NOTICE 'AU_STAT_TRIGGER [%]', sessionvar__get_integer('auftg__is_a_u_donestornosubpos', 0);
            PERFORM execution_flag__release( _flagname => 'auftg__is_a_u_donestornosubpos' );
          END IF;
          RETURN new;
        END $$ LANGUAGE plpgsql;

        CREATE TRIGGER auftg__as__a_u__stk_storno_spektra
          AFTER UPDATE OF ag_storno, ag_stk
          ON public.auftg
          FOR EACH STATEMENT
          EXECUTE PROCEDURE public.auftg__as__a_u__stk_storno_spektra();
      --

      CREATE OR REPLACE FUNCTION auftg__a_u__stk_storno_spektra() RETURNS TRIGGER AS $$
        DECLARE liste VARCHAR;
                liste_add BOOLEAN; -- F2-Message-Liste erweitern
        BEGIN
          liste_add := true;
          IF old.ag_storno <> new.ag_storno AND new.ag_storno = false THEN -- Storno abheben
             liste_add := false; -- Liste nicht erweitern
          END IF;

          IF liste_add THEN -- Liste erweitern
            liste := sessionvar__get_varchar( _suffix => 'auftg__agids_liste', _default => '' );
            liste := IFTHEN(liste = '',  new.ag_id::VARCHAR, liste || ',' || new.ag_id);
            PERFORM sessionvar__set_varchar( _suffix => 'auftg__agids_liste', _value => liste );
          END IF;
          RETURN new;
        END $$ LANGUAGE plpgsql;

        CREATE TRIGGER auftg__a_u__stk_storno_spektra
          AFTER UPDATE OF ag_storno, ag_stk
          ON public.auftg
          FOR EACH ROW
          WHEN (((new.ag_storno AND (NOT old.ag_storno)) OR (new.ag_stk < old.ag_stk)))
          EXECUTE PROCEDURE public.auftg__a_u__stk_storno_spektra();
      --

      CREATE OR REPLACE FUNCTION auftg__a_u_donestornosubpos_spektra() RETURNS TRIGGER AS $$
        BEGIN
          IF (new.ag_done AND NOT old.ag_done) OR (new.ag_storno AND NOT old.ag_storno) THEN
            --locale session variable (Aufrufzähler) hochzählen
            PERFORM execution_flag__aquire( _flagname => 'auftg__is_a_u_donestornosubpos' );
          END IF;
          RETURN new;
        END $$ LANGUAGE plpgsql;

        CREATE TRIGGER auftg__a_u_donestornosubpos_spektra
          AFTER UPDATE OF ag_done, ag_storno
          ON public.auftg
          FOR EACH ROW
          WHEN (new.ag_vkptotalpos)
          EXECUTE PROCEDURE public.auftg__a_u_donestornosubpos_spektra();
      --
    --- #10784 Ende

    --- #11641 Anfang
      CREATE OR REPLACE FUNCTION tauftg.auftg__folgebelege_showf2_create_spektra() RETURNS void AS $$
        DECLARE liste VARCHAR;
        BEGIN
          liste := sessionvar__get_varchar('auftg__agids_liste', '');
          --liste := '1937,1938,1939,1940,2139';
          IF liste = '' THEN
            RETURN;
          END IF;
          --Prüfen ob Positionen in Rechnung oder Lieferschein enthalten sind. Wenn ja - zur Ergebnisstabelle hinzufügen und Benutzer benachrichtigen.
          DROP TABLE IF EXISTS metadaten_show_f2;
          CREATE TEMP TABLE metadaten_show_f2 AS
            (SELECT ag_nr, ag_pos, beld_dokunr AS lsd_dokunr, bz_be_bnr
             FROM
               auftg
               LEFT JOIN lieferschein_pos ON ag_id = belp_ag_id
               LEFT JOIN lieferschein ON belp_dokument_id = beld_id
               LEFT JOIN belzeil_auftg_lif ON bz_auftg = ag_nr AND bz_auftgpos = ag_pos
             WHERE
               ag_id = ANY (regexp_split_to_array(liste, E'[\\s,]+'))
               AND COALESCE(beld_dokunr, bz_be_bnr) IS NOT NULL
             ORDER BY
             ag_nr, ag_pos);

             --RAISE NOTICE '*** Count: %', (SELECT Count(*) FROM metadaten_show_f2);
          IF EXISTS (SELECT true FROM metadaten_show_f2 LIMIT 1) THEN
            --RAISE NOTICE '*** ShowF2 ***';
            PERFORM PRODAT_SHOW_F2(26295);
          END IF;
       END $$ LANGUAGE plpgsql VOLATILE;
    --- #11641 Ende

    /* -- #9636 - nicht mehr gewünscht, deswegen gedroppt und auskommentiert
        DROP FUNCTION IF EXISTS adk1__b_iu__spektra__adk_ad_such__not_null() CASCADE;
        DROP FUNCTION IF EXISTS adk2__b_iu__spektra__adk_ad_such__not_null() CASCADE;

        -- #9456 - wenn ad_such leer, dann Fehlermeldung, wenn Kreditoren- oder Debitorennummer vergeben ist
          CREATE OR REPLACE FUNCTION adk1__b_iu__spektra__adk_ad_such__not_null() RETURNS TRIGGER AS $$
            BEGIN
              -- WHEN (new.a1_knr IS NOT NULL AND TSystem.Settings__Get('KUNDE') LIKE 'SPEKTRA')
              IF EXISTS(SELECT true FROM adk WHERE ad_krz = new.a1_krz AND ad_such IS NULL) THEN
             RAISE EXCEPTION '%', lang_text(29269);  -- "Suchbezeichnung ist ein Pflichfeld!"
              END IF;
              RETURN new;
            END $$ LANGUAGE plpgsql;

            DROP TRIGGER IF EXISTS adk1__b_iu__spektra__adk_ad_such__not_null ON adk1;
            CREATE TRIGGER adk1__b_iu__spektra__adk_ad_such__not_null
              BEFORE INSERT OR UPDATE
              ON adk1
              FOR EACH ROW
              WHEN (new.a1_knr IS NOT NULL AND TSystem.Settings__Get('KUNDE') LIKE 'SPEKTRA')
              EXECUTE PROCEDURE adk1__b_iu__spektra__adk_ad_such__not_null();
        --

          CREATE OR REPLACE FUNCTION adk2__b_iu__spektra__adk_ad_such__not_null() RETURNS TRIGGER AS $$
            BEGIN
              -- WHEN (new.a2_knr IS NOT NULL AND TSystem.Settings__Get('KUNDE') LIKE 'SPEKTRA')
              IF EXISTS(SELECT true FROM adk WHERE ad_krz = new.a2_krz AND ad_such IS NULL) THEN
             RAISE EXCEPTION '%', lang_text(29269);  -- "Suchbezeichnung ist ein Pflichfeld!"
              END IF;
              RETURN new;
            END $$ LANGUAGE plpgsql;

            DROP TRIGGER IF EXISTS adk2__b_iu__spektra__adk_ad_such__not_null ON adk2;
            CREATE TRIGGER adk2__b_iu__spektra__adk_ad_such__not_null
              BEFORE INSERT OR UPDATE
              ON adk2
              FOR EACH ROW
              WHEN (new.a2_knr IS NOT NULL AND TSystem.Settings__Get('KUNDE') LIKE 'SPEKTRA')
              EXECUTE PROCEDURE adk2__b_iu__spektra__adk_ad_such__not_null();
        --
    */

    -- # 12284 Beginn
      CREATE EXTENSION IF NOT EXISTS odbc_fdw;
      -- Server anlegen
      -- DROP SERVER spektra_eABK CASCADE;
      CREATE SERVER spektra_eABK
        FOREIGN DATA WRAPPER odbc_fdw
        OPTIONS (dsn 'eABK', encoding 'LATIN1');

      -- notwendiges User-Mapping
      -- DROP USER MAPPING IF EXISTS FOR PUBLIC SERVER spektra_eABK;
      CREATE USER MAPPING FOR public
        SERVER spektra_eABK
        OPTIONS (odbc_UID 'eABK_reader', odbc_PWD 'https://redmine.prodat-sql.de/projects/spektra/keys');

      -- Schema anlegen
      -- DROP SCHEMA IF EXISTS eABK CASCADE;
      CREATE SCHEMA z_50_customer__eabk;

      -- Schema befüllen
      IMPORT FOREIGN SCHEMA dbo
        LIMIT TO ("eABK_Kopf", "eABK_Position","ABK_MAPPING")
        FROM SERVER spektra_eABK
        INTO z_50_customer__eabk;

    -- #12284 ENDE

    -- #12288 Beginn
    CREATE OR REPLACE VIEW z_50_customer__eabk.prodat_eabk_abk AS
    SELECT
      ag.a2_id              AS "AG zur ABK",
      abk.ab_ix             AS "ABK Nr",
      ka.ag_nr              AS "Kundenauftrag",
      ka.ag_pos             AS "Positionsnummer Kundenauftrag",
      pa.ld_auftg           AS "Produktionsauftrag",
      pa.ld_pos             AS "Positionsnummer Produktionsauftrag",
      ag.a2_at              AS "Anfangstermin",
      ag.a2_et              AS "Endtermin",
      ag.a2_subject         AS "Betreff",
      ag.a2_ks              AS "Kostenstelle",
      ag.a2_ksap            AS "Arbeitsplatz",
      ag.a2_v_ll_dbusename  AS "Veranwortlicher"
    FROM ab2            AS ag
      JOIN abk          AS abk  ON abk.ab_ix = ag.a2_ab_ix
      LEFT JOIN ldsdok  AS pa   ON pa.ld_id = abk.ab_ld_id  AND pa.ld_code = 'I'    -- ggf. Alternative: pa.ld_abk = ag.a2_ab_ix
      LEFT JOIN auftg   AS ka   ON ka.ag_id = tplanterm.abk_main_auftg_id(ag.a2_ab_ix) -- ggf. Alternative bei Fertigungsprojekt-Struktur: ka.ag_ownabk = ag.a2_ab_ix
    WHERE EXISTS(SELECT 1 FROM recnokeyword AS r WHERE r.r_dbrid = ag.dbrid); -- vorläufige Einschränkung zwecks Testdaten, besser später auf Status o.ä.

    CREATE OR REPLACE VIEW z_50_customer__eabk.prodat_eabk_prop AS
    SELECT ag.a2_id AS "AG zur ABK",
           r.r_id AS "ID Prop",
           r.r_descr AS "Beschreibung",
           r.r_value AS "Wert",
           r.r_reg_pname AS "Parametername"
    FROM recnokeyword r
    JOIN ab2 ag ON ag.dbrid = r.r_dbrid;
    -- #12288 Ende



    -- #13204 Beginn
    -- Anlage Funktion zur Rückgabe aller Eigenschafts-IDs zu einem Auftrag
    -- DROP FUNCTION recnokeyword__get__by_auftg_pos(VARCHAR, VARCHAR, NUMERIC) ;
    CREATE OR REPLACE FUNCTION z_50_customer__eabk.recnokeyword__by_agpos (
          in_agnr     varchar,  -- Auftragsnummer
          in_agstat   varchar,  -- Auftragsart (R,E,I)
          in_agpos    numeric   -- Auftragsposition
      ) RETURNS SETOF int AS $$

      WITH mapping as (
                        SELECT "PRODAT_TBL"||'.'||"PRODAT_FIELD" as field
                        FROM z_50_customer__eabk."ABK_MAPPING"
                        WHERE "PRODAT_FIELD" is not null
                      )
      SELECT r.r_id
      FROM recnokeyword r
      LEFT JOIN auftg ON r.r_dbrid = auftg.dbrid
                      AND (
                            r_descr <> 'keywordsearch'
                            OR
                            r_descr IS null
                          )
      JOIN mapping on mapping.field = r_reg_pname
      WHERE auftg.ag_nr = in_agnr
        AND auftg.ag_astat = in_agstat
        AND auftg.ag_pos = in_agpos
        AND NOT ag_storno;
    $$ LANGUAGE sql ;
    -- #13204 Ende

    -- #13205 Beginn
    -- Anlage Funktion zur Rückgabe aller Eigenschafts-IDs pro Quelle (aktuell ADK oder ART und entsprechender Wert dazu)
    CREATE OR REPLACE FUNCTION z_50_customer__eabk.recnokeyword__by_sourcetable (
        in_source_table varchar,  -- Quelltabelle zu welcher rnk gesucht wird
        in_value        varchar,  -- Quell-Objekt: ak_nr oder ad_krz
        in_is_kiz       boolean default false -- handelt es sich bei einer Adresse um einen KiZ Datensatz
      ) RETURNS SETOF int AS $$
    DECLARE
      setting_zusatzadk varchar := TSystem.Settings__Get( 'TRecnoParam.auftg__params_sync.Zusatzadresse' ) || '.%';
    BEGIN
      CASE
        WHEN in_source_table ILIKE 'art' THEN
          RETURN  QUERY
            WITH mapping as (
                              SELECT "PRODAT_TBL"||'.'||"PRODAT_FIELD" as field
                              FROM z_50_customer__eabk."ABK_MAPPING"
                              WHERE "PRODAT_FIELD" is not null
                            )
            SELECT r_id
            FROM recnokeyword
            JOIN art ON art.dbrid = r_dbrid
            JOIN mapping on mapping.field = r_reg_pname
            WHERE (
                    r_reg_pname IS NOT null
                    OR
                    (
                      r_reg_pname IS null
                      AND
                      r_kategorie IS null
                    )
                  )
              AND (
                    r_descr <> 'keywordsearch'
                    OR
                    r_descr IS null
                  )
              AND ak_nr = in_value;
        WHEN  in_source_table ILIKE 'adk' THEN
          RETURN QUERY
            WITH mapping as (
                              SELECT "PRODAT_TBL"||'.'||"PRODAT_FIELD" as field
                              FROM z_50_customer__eabk."ABK_MAPPING"
                              WHERE "PRODAT_FIELD" is not null
                            )
            SELECT r_id
            FROM recnokeyword
            JOIN adressen_view ON adressen_view.dbrid = r_dbrid
            JOIN mapping on mapping.field = r_reg_pname
            WHERE (
                    ( r_reg_pname IS NOT null )
                    OR
                    (
                      r_reg_pname IS null
                      AND
                      r_kategorie IS null
                    )
                  )
              AND (
                    r_descr <> 'keywordsearch'
                    OR
                    r_descr IS null
                  )
              AND ad_krz = in_value
              AND (
                    (
                      in_is_kiz = false
                      AND
                      r_reg_pname not like setting_zusatzadk
                    )
                    OR
                    (
                      in_is_kiz
                      AND
                      r_reg_pname Like setting_zusatzadk
                    )
                  ) ;
      END CASE ;

    END $$ LANGUAGE plpgsql ;
    -- #13205 Ende

    -- #13206 Beginn
    -- Funktion zum Abgleich der Recnokeywords zwischen AUFTG/Pos und ADK/ART/beidem
    -- DROP  FUNCTION recnokeyword__get__diffliste(VARCHAR, VARCHAR,NUMERIC, VARCHAR,  VARCHAR)
    CREATE OR REPLACE FUNCTION z_50_customer__eabk.recnokeyword__diffliste__by_agpos (
        in_agnr         varchar,                  -- Auftragsnummer
        in_agstat       varchar,                  -- Auftragsart (R/E/I)
        in_agpos        numeric DEFAULT null,     -- Auftragsposition
        in_source_table varchar DEFAULT 'all'       -- zu welcher Quelltabelle (ART/ADK/ALL)
      ) RETURNS TABLE (
          auftg_rec_id  int,
          source_rec_id int,
          auftg_pos     int
        )
      AS $$
    BEGIN

      CASE
        WHEN in_source_table ILIKE 'art' THEN
        -- Vergleich nur über den Artikel
          RETURN QUERY
          -- Differenzen
          WITH rnk_auftg as (
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                SELECT z_50_customer__eabk.recnokeyword__by_agpos(
                                                    in_agnr   => auftg.ag_nr,
                                                    in_agstat => auftg.ag_astat,
                                                    in_agpos  => auftg.ag_pos
                                                  ) as id
                                                ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                   )
                             ) ,
                 rnk_art as (
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                SELECT z_50_customer__eabk.recnokeyword__by_sourcetable(
                                                    in_source_table => 'art',
                                                    in_value        => auftg.ag_aknr
                                                  ) as id
                                                ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                   )
                            )
          -- in beiden vorhanden, jedoch abweichender WErt/Beschreibung
          SELECT r.r_id, src.r_id, rnk_auftg.pos
          FROM recnokeyword r
          JOIN LATERAL (
                         SELECT r_id, r_reg_pname, r_value , r_descr, rnk_art.pos
                         FROM recnokeyword rr
                         JOIN rnk_art ON rr.r_id = rnk_art.id
                        ) AS src ON r.r_reg_pname = src.r_reg_pname
                                 AND (
                                       r.r_value IS DISTINCT FROM src.r_value
                                       OR
                                       r.r_descr IS DISTINCT FROM src.r_descr
                                      )
          JOIN rnk_auftg ON r.r_id = rnk_auftg.id
                         AND rnk_auftg.pos = src.pos
          UNION
          -- in Auftg nicht in Quelle
          SELECT r.r_id, null, rnk_auftg.pos
          FROM recnokeyword r
          JOIN rnk_auftg ON r.r_id = rnk_auftg.id
                         AND (
                              r_descr <> 'keywordsearch'
                              OR
                              r_descr IS null
                             )
          AND NOT EXISTS (
                          SELECT 1
                          FROM recnokeyword rr
                          JOIN rnk_art ON rr.r_id = rnk_art.id
                                       AND rnk_auftg.pos = rnk_art.pos
                                       AND r.r_reg_pname = rr.r_reg_pname
                          )

          UNION
          -- in Quelle nicht jedoch in auftg
          SELECT null, r.r_id, rnk_art.pos
          FROM recnokeyword r
          JOIN rnk_art ON r.r_id = rnk_art.id
                       AND (
                            r_descr <> 'keywordsearch'
                            OR
                            r_descr IS null
                           )
          WHERE NOT EXISTS (
                            SELECT 1
                            FROM recnokeyword rr
                            JOIN rnk_auftg ON rr.r_id = rnk_auftg.id
                                           AND rnk_auftg.pos = rnk_art.pos
                                           AND r.r_reg_pname = rr.r_reg_pname
                           )
          ;

        WHEN in_source_table ILIKE 'adk' THEN
        -- Vergleich über die Adressdaten
          RETURN QUERY
          WITH rnk_auftg as (
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                SELECT z_50_customer__eabk.recnokeyword__by_agpos(
                                                    in_agnr   => auftg.ag_nr,
                                                    in_agstat => auftg.ag_astat,
                                                    in_agpos  => auftg.ag_pos
                                                  ) as id
                                                ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                    )
                               AND ag_hpos IS null -- Einschränkung bei Adresse - nur HP
                            ) ,
                 rnk_adk as (
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                SELECT z_50_customer__eabk.recnokeyword__by_sourcetable(
                                                    in_source_table => 'adk',
                                                    in_value        => auftg.ag_lkn
                                                  ) as id
                                               ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                    )
                               AND ag_hpos IS null -- Einschränkung bei Adresse - nur HP
                             UNION
                             -- die KIZ Parameter
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                WITH kiz AS (SELECT z_50_customer__eabk.eabk__kiz__get( ag_nr, ag_astat, ag_pos ) as dbrid)
                                                SELECT z_50_customer__eabk.recnokeyword__by_sourcetable(
                                                    in_source_table => 'adk',
                                                    in_value        => ad_krz,
                                                    in_is_kiz       => true
                                                  ) as id
                                                FROM adressen_view
                                                JOIN kiz on kiz.dbrid = adressen_view.dbrid
                                               ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                    )
                               AND ag_hpos IS null -- Einschränkung bei Adresse - nur HP
                            )
          -- in beiden vorhanden, jedoch abweichender WErt/Beschreibung
          SELECT r.r_id, src.r_id, rnk_auftg.pos
          FROM recnokeyword r
          JOIN LATERAL (
                        SELECT r_id, r_reg_pname, r_value , r_descr, rnk_adk.pos
                        FROM recnokeyword rr
                        JOIN rnk_adk ON rnk_adk.id = rr.r_id
                        ) AS src ON r.r_reg_pname = src.r_reg_pname
                                 AND (
                                       r.r_value IS DISTINCT FROM src.r_value
                                       OR
                                       r.r_descr IS DISTINCT FROM src.r_descr
                                     )
          JOIN rnk_auftg ON r.r_id = rnk_auftg.id
                         AND rnk_auftg.pos = src.pos
          UNION
          -- in Auftg nicht in Quelle
          SELECT r.r_id, null, rnk_auftg.pos
          FROM recnokeyword r
          JOIN rnk_auftg ON r.r_id = rnk_auftg.id
                         AND (
                              r_descr <> 'keywordsearch'
                              OR
                              r_descr IS null
                             )
          WHERE NOT EXISTS (
                            SELECT 1
                            FROM recnokeyword rr
                            JOIN rnk_adk ON rr.r_id = rnk_adk.id
                                         AND rnk_auftg.pos = rnk_adk.pos
                                         AND r.r_reg_pname = rr.r_reg_pname
                           )
          UNION
          -- in Quelle nicht jedoch in auftg
          SELECT null, r.r_id, rnk_adk.pos
          FROM recnokeyword r
          JOIN rnk_adk ON r.r_id = rnk_adk.id
                       AND (
                            r_descr <> 'keywordsearch'
                            OR
                            r_descr IS null
                            )
          WHERE NOT EXISTS (
                            SELECT 1
                            FROM recnokeyword rr
                            JOIN rnk_auftg ON rr.r_id = rnk_auftg.id
                                           AND rnk_auftg.pos = rnk_adk.pos
                                           AND r.r_reg_pname = rr.r_reg_pname
                            )
        ;

       WHEN  in_source_table  ILIKE 'all' THEN
        -- Vergleich sowohl Adress- als auch Artikelparameter
          RETURN QUERY
          -- Differenzen
          WITH rnk_auftg as (
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                SELECT z_50_customer__eabk.recnokeyword__by_agpos(
                                                    in_agnr   => auftg.ag_nr,
                                                    in_agstat => auftg.ag_astat,
                                                    in_agpos  => auftg.ag_pos
                                                  ) as id
                                                ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                   )
                             ) ,
             rnk_sources as (
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                SELECT z_50_customer__eabk.recnokeyword__by_sourcetable(
                                                    in_source_table => 'adk',
                                                    in_value        => auftg.ag_lkn
                                                  ) as id
                                               ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                    )
                               AND ag_hpos IS null  -- Einschränkung bei Adresse - nur HP
                             UNION
                             -- die KIZ Parameter
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                WITH kiz AS ( SELECT z_50_customer__eabk.eabk__kiz__get( ag_nr, ag_astat, ag_pos ) as dbrid)
                                                SELECT z_50_customer__eabk.recnokeyword__by_sourcetable(
                                                    in_source_table => 'adk',
                                                    in_value        => ad_krz,
                                                    in_is_kiz       => true
                                                  ) as id
                                                FROM adressen_view /*adk*/
                                                JOIN kiz on kiz.dbrid = adressen_view.dbrid
                                               ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                    )
                               AND ag_hpos IS null -- Einschränkung bei Adresse - nur HP
                             UNION
                             SELECT rnk.id, auftg.ag_pos as pos
                             FROM auftg
                             LEFT JOIN LATERAL (
                                                SELECT z_50_customer__eabk.recnokeyword__by_sourcetable(
                                                    in_source_table => 'art',
                                                    in_value        => auftg.ag_aknr
                                                   ) as id
                                               ) as rnk ON TRUE
                             WHERE auftg.ag_nr = in_agnr
                               AND auftg.ag_astat = in_agstat
                               AND (
                                    in_agpos IS null
                                    OR
                                    in_agpos = auftg.ag_pos
                                    )
                            )
          -- in beiden vorhanden, abweichender Wert/Beschreibung
          SELECT r.r_id, src.r_id, rnk_auftg.pos
          FROM recnokeyword r
          JOIN LATERAL (
                        SELECT r_id, r_reg_pname, r_value, r_descr, rnk_sources.pos
                        FROM recnokeyword rr
                        JOIN rnk_sources ON rr.r_id = rnk_sources.id
                       ) AS src ON r.r_reg_pname = src.r_reg_pname
                                AND (
                                      r.r_value IS DISTINCT FROM src.r_value
                                      OR
                                      r.r_descr IS DISTINCT FROM src.r_descr
                                    )
          JOIN rnk_auftg ON r.r_id = rnk_auftg.id
                         AND rnk_auftg.pos = src.pos
          UNION
          -- in Auftg nicht in Quelle
          SELECT r.r_id, null, rnk_auftg.pos
          FROM recnokeyword r
          JOIN rnk_auftg ON r.r_id = rnk_auftg.id
                         AND (
                              r_descr <> 'keywordsearch'
                              OR
                              r_descr IS null
                              )
          WHERE NOT EXISTS (
                            SELECT 1
                            FROM recnokeyword rr
                            JOIN rnk_sources ON rr.r_id = rnk_sources.id
                                             AND rnk_auftg.pos = rnk_sources.pos
                                             AND r.r_reg_pname = rr.r_reg_pname
                          )
          UNION
          -- in Quelle nicht jedoch in auftg
          SELECT null, r.r_id, rnk_sources.pos
          FROM recnokeyword r
          JOIN rnk_sources ON r.r_id = rnk_sources.id
                           AND (
                                r_descr <> 'keywordsearch'
                                OR
                                r_descr IS null
                                )
                           AND NOT EXISTS (
                                           SELECT 1
                                           FROM recnokeyword rr
                                           JOIN rnk_auftg ON rr.r_id = rnk_auftg.id
                                                          AND rnk_auftg.pos = rnk_sources.pos
                                                          AND r.r_reg_pname = rr.r_reg_pname
                                          )
          ;


        ELSE
          RETURN;
        END CASE;
    END $$ LANGUAGE plpgsql;

    -- #13206 Ende

  -- 13737 Ermittlung der in der eABK vorhandenen Parameterwerte
  CREATE OR REPLACE FUNCTION z_50_customer__eabk.eabk__parameter_for_pos(in_eabk_pos_id numeric)
    RETURNS TABLE (
      param text,
      val   text
  ) AS $$

  DECLARE
    tmp_select varchar(2000) := '';
  BEGIN

    SELECT
    ' SELECT *
      FROM   crosstab(
             ''SELECT unnest(''' || quote_literal(array_agg(attname)) || '''::text[]) AS col
                   , row_number() OVER ()
                   , unnest(ARRAY[' || string_agg( quote_ident(attname) || '::text', ',') || ']) AS val
              FROM z_50_customer__eabk."eABK_Kopf" eak
              JOIN z_50_customer__eabk."eABK_Position" eap on eak."ID" = eap."ID eABK"
              AND eap."ID" =  ' || in_eabk_pos_id || '
              ORDER  BY generate_series(1,' || count(*) || '), 2''
         ) t (col text, val text)' AS sql
    INTO tmp_select
    FROM  (
            SELECT attname
            FROM pg_attribute
            WHERE attrelid  = 'z_50_customer__eabk."eABK_Kopf"'::regclass
              AND attnum > 0
              AND NOT attisdropped
              AND EXISTS (
                          SELECT 1
                          FROM z_50_customer__eabk."ABK_MAPPING"
                          WHERE "PRODAT_TBL" IS NOT null
                            AND "EABK_TBL" = 'eABK_Kopf'
                            AND lower( "EABK_FIELD" ) = lower(attname)
                         )
            UNION
            SELECT attname
            FROM pg_attribute
            WHERE attrelid  = 'z_50_customer__eabk."eABK_Position"'::regclass
              AND attnum > 0
              AND NOT attisdropped
              AND EXISTS (
                           SELECT 1
                           FROM z_50_customer__eabk."ABK_MAPPING"
                           WHERE "PRODAT_TBL" IS NOT null
                             AND "EABK_TBL" = 'eABK_Position'
                             AND lower("EABK_FIELD") = lower(attname)
                        )
            ) as sub;

    RETURN query
      EXECUTE tmp_select;

  END $$ language plpgsql;

  -- Ermittlung der Differenzen für eine gegebene Hauptposition zu einer eabk-Positon
  CREATE OR REPLACE FUNCTION z_50_customer__eabk.eabk__get__diffliste_for_auftg_hpos(
      in_agnr        varchar,
      in_agstat      varchar,
      in_aghpos      integer,
      in_eabk_pos_id integer
  ) RETURNS TABLE (
                    pname     varchar,
                    eabk_val  varchar,
                    auftg_val varchar,
                    ag_pos    integer
                  ) AS $$

    SELECT
      coalesce( auftg.r_reg_pname,
                map."PRODAT_TBL" || '.'  || "PRODAT_FIELD") as r_regpname,
      eabk.val as "eabk_val",
      auftg.r_value as "auftg_val",
      ag_pos
    FROM z_50_customer__eabk."ABK_MAPPING" map
    LEFT JOIN z_50_customer__eabk.eabk__parameter_for_pos( in_eabk_pos_id ) eabk ON map."EABK_FIELD" = eabk.param
    LEFT JOIN ( SELECT auftg.ag_pos,
                       r.r_reg_pname,
                       r.r_descr,
                       lower( r.r_value ) as r_value
                FROM recnokeyword r
                LEFT JOIN auftg ON r.r_dbrid = auftg.dbrid
                                AND (
                                      r_descr <> 'keywordsearch'
                                      OR
                                      r_descr IS null
                                    )
                WHERE auftg.ag_nr = in_agnr
                  AND auftg.ag_astat = in_agstat
                  AND (auftg.ag_hpos = in_aghpos OR auftg.ag_pos = in_aghpos)
                  AND NOT ag_storno
              ) auftg ON auftg.r_reg_pname = map."PRODAT_TBL" ||'.'|| map."PRODAT_FIELD"
    WHERE (
            (
              coalesce( lower( eabk.val ), '') <> coalesce( r_value, '' )
              AND
              coalesce(r_value, '') NOT IN ('true', 'false')
            )
          OR
            (
              auftg.r_value = 'true'
              AND
              coalesce(lower(eabk.val), '') NOT IN ('1', 'true')
            )
          OR
            (
              auftg.r_value = 'false'
              AND
              coalesce(lower(eabk.val), '') NOT IN ('0', 'false')
            )
          )
    ORDER BY ag_pos, r_reg_pname;

  $$ LANGUAGE sql ;


  -- Ermittlung der Differenzen für eine gegebene Liste an Hauptpositionen zu einer Liste von eabk-Positonen
  CREATE OR REPLACE FUNCTION z_50_customer__eabk.eabk__get__diffliste_for_auftg__with_list(
        in_agnr          varchar,
        in_agstat        varchar,
        in_agpos_list    varchar,
        in_eabkpos_list  varchar
    ) RETURNS TABLE (
                      pname      varchar,
                      eabk_val   varchar,
                      auftg_val  varchar,
                      ag_pos_in  integer,
                      ag_pos_out integer
                    ) AS $$
    DECLARE
      i             integer;
      agpos_array   integer[];
      eabkpos_array integer[];
      tmp_sql       varchar;
    BEGIN

      agpos_array   := string_to_array(in_agpos_list, ',');
      eabkpos_array := string_to_array(in_eabkpos_list, ',');

     IF
        array_length( agpos_array,1 ) <> array_length( eabkpos_array, 1 )
        OR
        array_length( agpos_array, 1 )  IS null
        OR
        array_length( eabkpos_array, 1 ) IS null
      THEN
        RETURN;
      END IF;

      FOR i in 1 .. array_length(eabkpos_array, 1) LOOP


        IF i = 1 THEN
          tmp_sql := 'SELECT *, ' || agpos_array[i] ||
                     ' FROM z_50_customer__eabk.eabk__get__diffliste_for_auftg_hpos( '''|| in_agnr ||''', '''|| in_agstat ||''', '''|| agpos_array[i] || ''',' || eabkpos_array[i]||')';
        ELSE
          tmp_sql := tmp_sql || 'UNION SELECT *, ' || agpos_array[i] ||
                     ' FROM z_50_customer__eabk.eabk__get__diffliste_for_auftg_hpos( '''|| in_agnr ||''', '''|| in_agstat ||''', '''|| agpos_array[i] || ''','|| eabkpos_array[i]||') ';
        END IF;
      END LOOP;

     RETURN QUERY
       EXECUTE tmp_sql;

   END $$ LANGUAGE plpgsql ;


  -- Ermittlung der DBRID zur eventuell vorhandenen KiZ-Adresse
  CREATE OR REPLACE FUNCTION z_50_customer__eabk.eabk__kiz__get(
    agnr   varchar,
    agstat varchar,
    aghpos integer
  ) RETURNS varchar
  AS $$
    SELECT adk_dbrid
    FROM auftg
    JOIN LATERAL (
                  SELECT dbrid AS adk_dbrid
                  FROM adressen_view /*adk */
                  WHERE ad_krz = (
                                  SELECT r_value
                                  FROM recnokeyword
                                  WHERE r_tablename = 'auftg'
                                    AND r_dbrid = auftg.dbrid
                                    AND r_reg_pname = TSystem.Settings__Get( 'TRecnoParam.auftg__params_sync.Zusatzadresse' )
                                  ORDER BY r_id DESC LIMIT 1
                                 )
                  ) AS parameter_zusatz ON TSystem.Settings__Get( 'TRecnoParam.auftg__params_sync.Zusatzadresse' ) IS NOT NULL
    WHERE ag_astat = agstat AND ag_nr = agnr
      AND NOT ag_storno
      AND ag_hpos IS NULL
      AND ag_pos = aghpos -- Nur alle Hauptpositionen, ADressen nur von HP
    ORDER BY ag_pos;
$$ LANGUAGE sql;


-- Funktion zum Hinterlegen eines Kunden im Zertifikat
CREATE OR REPLACE FUNCTION z_50_customer__eabk.eabk__kiz__set(
    agnr   varchar,
    agstat varchar,
    aghpos integer,
    adk_krz varchar
) RETURNS VOID AS $$

  DECLARE
    auftg_dbrid     varchar;
    alter_kiz       varchar;
    alter_kiz_dbrid varchar;
    setting_zusatzadk varchar := TSystem.Settings__Get( 'TRecnoParam.auftg__params_sync.Zusatzadresse' );
  BEGIN

    SELECT z_50_customer__eabk.eabk__kiz__get(agnr, agstat, aghpos)
    INTO alter_kiz_dbrid;

    IF (SELECT adk_krz = ad_krz
        FROM adressen_view /*adk*/
        WHERE adressen_view.dbrid = alter_kiz_dbrid) THEN
        RETURN;
    END IF;

    SELECT dbrid
    INTO auftg_dbrid
    FROM auftg
    WHERE ag_nr = agnr
    AND ag_astat = agstat
    AND ag_pos = aghpos
    AND ag_hpos is null;

    -- wenn keine Hauptposition, dann ist nichts zu tun
    IF auftg_dbrid is null THEN
      RETURN;
    END IF;

    SELECT ad_krz
    INTO alter_kiz
    FROM adressen_view /*adk */
    WHERE dbrid = alter_kiz_dbrid;

    IF alter_kiz IS null THEN
      -- wenn auch kein neuer KiZ gegeben ist, muss ja nichts hinterlegt werden
      IF adk_krz IS null THEN
        RETURN;
      END IF;

      PERFORM TRecnoParam.set(pname => setting_zusatzadk, rdbrid => auftg_dbrid, rValue => adk_krz);
    ELSE
      IF adk_krz IS NOT null THEN
        -- wenn eine konkrete Adresse übergeben wurde, wird diese hinterlegt
        PERFORM TRecnoParam.set(pname => setting_zusatzadk, rdbrid => auftg_dbrid, rValue => adk_krz);
      ELSE
        -- wenn die Adresse mit NULL übergeben wird, wird der KiZ gelöscht
        PERFORM TRecnoParam.Delete(pname => setting_zusatzadk, trgDBRID => auftg_dbrid);
      END IF;
    END IF;
   RETURN;

 END $$ LANGUAGE plpgsql;

-- Funktion um aus dem eabk-Vergleich heraus prüfen zu können, an welcher Auftragsposition der Parameter einzuordnen ist,
-- wenn dieser noch nicht am Auftrag hinterlegt ist
CREATE OR REPLACE FUNCTION z_50_customer__eabk.eabk__agpos__for_auftg__by_pname__get(
    auftgnr varchar,
    agstat  varchar,
    aghpos  integer,
    pname   varchar
)  RETURNS integer AS $$

    SELECT ag_pos
    FROM auftg
    JOIN art ON ag_aknr = ak_nr
    WHERE ag_nr = auftgnr
      AND ag_astat = agstat
      AND (ag_hpos = aghpos  OR ag_pos = aghpos)
      AND EXISTS (SELECT 1
                  FROM recnokeyword
                  WHERE r_dbrid = art.dbrid
                    AND r_reg_pname = pname)
    LIMIT 1; -- Absicherung, offiziell sollte Parameter nur einmal in StüLi vorhanden sein

$$ LANGUAGE sql VOLATILE;


    -- Versand-Automatisierung Anbindung DHL #17291
    -- Custom Trigger legt bei Erstellen von Versand-Artikel im Auftrag Eigenschaften an
    CREATE OR REPLACE FUNCTION z_50_customer.auftg__a_i__external_shipping__spektra() RETURNS TRIGGER AS $$
      DECLARE
          ad_dbrid_src VARCHAR;
          ad_dbrid_src_spektra VARCHAR;
      BEGIN
          IF ( (SELECT ac_n FROM artcod JOIN art ON ak_ac = ac_n AND ak_nr = new.ag_aknr) = 'VDLE2000') THEN
              -- dbrid der Quelle ermitteln
              SELECT adk.dbrid INTO ad_dbrid_src FROM adressen_view
                  JOIN adk ON adk.ad_krz = adk_ad_krz
                  WHERE adressen_view.ad_krz = new.ag_krzf; --Rechnungsadresse, da im Lieferschein VIEW verwendet statt Besteller
              -- dbrid eigene Firma ermitteln
              SELECT dbrid INTO ad_dbrid_src_spektra FROM adk WHERE ad_krz = '#' ;

              PERFORM TRecnoParam.CopyGroup('Versand', ad_dbrid_src, new.dbrid, 'auftg');
              -- Update bestehender Datensätze ist nicht erforderlich

              -- Wenn keine Parameter zu Spediteuer-Konto.Nr in der Kundenadresse vorhanden, dann Kopiere einzelnen Parameter aus adresse # ~ redundante Datenablage wird vermieden
              IF ( TRecnoParam.GetValue('versand.konto.1', ad_dbrid_src) IS NULL ) THEN
                  PERFORM TRecnoParam.Copy('versand.konto.1', ad_dbrid_src_spektra, new.dbrid, 'auftg');
              END IF;

          END IF;

          RETURN new;
        END $$ LANGUAGE plpgsql;

        CREATE TRIGGER auftg__a_i__external_shipping__spektra
          AFTER INSERT
          ON auftg
          FOR EACH ROW
          EXECUTE PROCEDURE z_50_customer.auftg__a_i__external_shipping__spektra();
    --

    -- Versand-Automatisierung Anbindung DHL #17291
    -- Tracking ID ~ Sendungsnummer des Spediteurs ~ wird von extern geschrieben, Tool M Brückner
    CREATE OR REPLACE FUNCTION TDMS.External_Shipping__set_TrackID(agid INTEGER, external_track_id VARCHAR, OUT result BOOLEAN)
      RETURNS BOOLEAN AS $$
      DECLARE
        _rdbrid VARCHAR;
      BEGIN
        -- #17403
        ASSERT NOT TSystem.dms__notify__changes(), 'FUNCTION External_DMS__set_ID: invalid login';

        SELECT dbrid, dbrid IS NOT NULL INTO _rdbrid, result FROM auftg WHERE ag_id = agid;
        PERFORM TRecnoParam.SetValue('versand.tracking.id', _rdbrid, external_track_id);
        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    -- Versand-Automatisierung Anbindung DHL #17291
    -- VIEW für das Versand-Tool von M Brückner
    -- Aufnahme des Aufrufs je in tsystem.views__customer__create() und tsystem.views__customer__drop() im Kundensystem
    CREATE OR REPLACE FUNCTION TDMS.External_Shipping__get_Deliveries__recreate() RETURNS VOID AS $$
      BEGIN
        --
        CREATE OR REPLACE VIEW TDMS.External_Shipping__get_Deliveries AS
          SELECT
            ag_id,  --für Zuordnung Tracking ID benötigt
            ag_nr,  --#19892
            beld_dokunr,  --Lieferschein-Nummer
            --Versand--
            --Annahme es gibt nur einen Spediteur, mehrere laut Standard nich unterstützt
            TRecnoParam.GetEnum('versand.spediteur', auftg.dbrid) AS versand_spediteur_id,
            ( SELECT rege_bez FROM RecnoEnums JOIN recnogroup ON reg_pname = rege_reg_pname WHERE reg_pname = 'versand.spediteur' AND rege_code = TRecnoParam.GetEnum('versand.spediteur', auftg.dbrid) AND reg_tablename = 'auftg') AS versand_spediteur, --der Funktion TRecnoParam.Enum_ValueDescr fehlt die Einschränkung auf tablename
            COALESCE( TRecnoParam.GetValue('versand.konto.1', auftg.dbrid)::VARCHAR,
                      TRecnoParam.GetValue('versand.konto.2', auftg.dbrid)::VARCHAR,
                      TRecnoParam.GetValue('versand.konto.3', auftg.dbrid)::VARCHAR) AS  versand_kontonr,
            --Ansprechpartner-
            beld_krzlieferung AS dokument_adresse_adressant, --Ident Lieferadresse
            beld_apkrzl AS dokument_adresse_ansprechpartner_adressant_ident,
            beld_ap AS dokument_adresse_ansprechpartner_adressant,
            COALESCE(ap_tel,empfnger.ad_tel1) AS dokument_adresse_ansprechpartner_telefon,
            ap_mobil AS dokument_adresse_ansprechpartner_mobil,    -- mobilnummer
            ap_mail AS dokument_adresse_ansprechpartner_email,
            --Empfänger--
            empfnger.ad_fa1, empfnger.ad_fa2, --Firmenname
            empfnger.ad_str, -- Straße
            --Hausnummer (aus ad_str) generieren ~ kein eigenes vorhanden
            empfnger.ad_plz, -- Postleitzahl
            empfnger.ad_ort, -- Ort
            empfnger.ad_landiso -- ISO Länderkennzeichen
          FROM
            lieferschein_pos
            LEFT JOIN lieferschein ON belp_dokument_id = beld_id AND beld_belegtyp = 'LFS'
            LEFT JOIN adressen_view AS empfnger ON empfnger.ad_krz=beld_krzlieferung --Empfänger
            LEFT JOIN adkap ON empfnger.adk_ad_krz=ap_ad_krz AND ap_krzl=beld_apkrzl AND ap_krzl IS NOT NULL --Ansprechpartner extern
            LEFT JOIN adressen_view AS debitor ON debitor.ad_krz=beld_krzrechnung --Debitorendaten
            LEFT JOIN adk1 ON debitor.adk_ad_krz=a1_krz --debitorendaten zur Adresse
            LEFT JOIN auftg ON ag_id=belp_ag_id
          WHERE
            -- nur die Lfs-Pos mit dem Versandartikel holen
            ( (SELECT ac_n FROM artcod JOIN art ON ak_ac = ac_n AND ak_nr = belp_aknr) = 'VDLE2000') --für test demo 'S'  'VDLE2000' SPEKTRA
            AND NOT beld_verbucht -- Es gibt noch keine Rechnung
            AND TRecnoParam.GetValue('versand.tracking.id', auftg.dbrid) IS NULL -- Tracking-Nummer nicht angegegeben
          ORDER BY
            lieferschein.insert_date DESC;

          -- Nutzer ELO für VIEW freigeben
          GRANT SELECT ON TDMS.External_Shipping__get_Deliveries TO "ELO";
      END $$ LANGUAGE plpgsql;
    --

    -- Custom Trigger legt bei Erstellen von Artikeln mit AC VDL im Auftrag Eigenschaften an
    CREATE OR REPLACE FUNCTION z_50_customer.auftg__a_i__auftragsklasse__spektra() RETURNS TRIGGER AS $$
      DECLARE
          _rdbrid VARCHAR;
      BEGIN
          IF ( (SELECT ac_n FROM artcod JOIN art ON ak_ac = ac_n AND ak_nr = new.ag_aknr) LIKE 'VDL%'  --Wenn ak_ac mit "VDL" beginnt
               AND
               (SELECT count(ag_pos) FROM auftg WHERE ag_nr = new.ag_nr) = 1  -- Und es sich um die erste Position handelt
          ) THEN
              -- dbrid der Quelle ermitteln
              SELECT dbrid INTO _rdbrid FROM auftg WHERE ag_id = new.ag_id;

              -- „auftg.param.Auftragsart“ auf den Wert 'DL' gesetzt werden
              PERFORM TRecnoParam.SetValue('auftg.param.Auftragsart', _rdbrid, 'DL');

          END IF;

          RETURN new;
        END $$ LANGUAGE plpgsql;

        CREATE TRIGGER auftg__a_i__auftragsklasse__spektra
          AFTER INSERT
          ON auftg
          FOR EACH ROW
          WHEN (new.ag_astat = 'E')
          EXECUTE PROCEDURE z_50_customer.auftg__a_i__auftragsklasse__spektra();
    --


    -- #20850 Hilfsfunktion für das Einfügen der Standardzeiten in die Rückmeldungen
    CREATE OR REPLACE FUNCTION z_50_customer.rm__standardzeiten__insert( _ab_ix integer, _ruest boolean ) RETURNS void AS $$

      INSERT INTO rm ( r_a2_id, r_zeinh,  r_ks,   r_ruest,
                         r_std )
        SELECT           a2_id,       1, a2_ks,    _ruest,
                         CASE _ruest WHEN true THEN a2_tr_sek / 3600 ELSE a2_ta - ( a2_tr_sek / 3600 ) END
      FROM ab2
        JOIN abk ON ab_ix = a2_ab_ix
      WHERE a2_ab_ix IN ( SELECT * FROM tplanterm.get_all_child_abk( _ab_ix ))
        AND NOT EXISTS ( SELECT 1 FROM rm WHERE r_a2_id = a2_id AND r_ruest = _ruest )
        AND NOT EXISTS ( SELECT 1 FROM bdea WHERE ba_ix = ab_ix AND ba_op = a2_n )
        AND ( a2_tr_sek > 0 OR NOT _ruest );

    $$ LANGUAGE sql STRICT;
    --

    -- #20850 Bei SPEKTRA sollen Auftragspositionen für Artikel mit AC "VDLI..." bei Schließung automatisch die
    -- zugehörigen ABKs und Produktionsbestellungen schließen.
    CREATE OR REPLACE FUNCTION auftg__a_u__spektra() RETURNS TRIGGER AS $$
    DECLARE
      _ac varchar;
      _ld_id integer;
      _ab_ix integer;
    BEGIN

      _ac := ak_ac FROM art WHERE ak_nr = new.ag_aknr;
      IF _ac LIKE 'VDLI%' THEN

        FOR _ld_id IN ( SELECT ld_id FROM ldsdok WHERE ld_code = 'I' AND ld_ag_id = new.ag_id AND NOT ld_done ) LOOP
          FOR _ab_ix IN ( SELECT ab_ix FROM abk WHERE ab_ld_id = _ld_id AND NOT ab_done ) LOOP

            -- Eintrag RM, Rüstzeiten (Übernahme aus RTF 246)
            PERFORM z_50_customer.rm__standardzeiten__insert( _ab_ix, true );

            -- Eintrag RM, Haupt- und Nebenzeit (Übernahme aus RTF 246)
            PERFORM z_50_customer.rm__standardzeiten__insert( _ab_ix, false );

            UPDATE abk SET ab_done = true WHERE ab_ld_id = _ld_id AND NOT ab_done;

          END LOOP;
          UPDATE ldsdok SET ld_done = true WHERE ld_id = _ld_id;
        END LOOP;

      END IF;

      RETURN null;

    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER auftg__a_u__spektra
    AFTER UPDATE OF ag_done
    ON auftg
    FOR EACH ROW
    WHEN ( new.ag_done AND NOT old.ag_done )
    EXECUTE PROCEDURE auftg__a_u__spektra();
    --