/************* KREYENBERG ************/

    --
    CREATE OR REPLACE FUNCTION art__b_i__kreyenberg__bkrohartikel() RETURNS TRIGGER AS $$
      BEGIN
        -- WHEN (new.ak_nr LIKE '%ROH')
        IF TSystem.Settings__Get('KUNDE') = 'KREYENBERG' THEN
            new.ak_stat := COALESCE(new.ak_stat, 'BK');
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER art__b_i__kreyenberg__bkrohartikel
        BEFORE INSERT
        ON art
        FOR EACH ROW
        WHEN (new.ak_nr LIKE '%ROH')
        EXECUTE PROCEDURE art__b_i__kreyenberg__bkrohartikel();
    --

    --
    CREATE OR REPLACE FUNCTION z_50_customer.art__b_i__kreyenberg__ak_allg1() RETURNS TRIGGER AS $$
    -- Custom-Trigger für Fa. KREYENBERG z.Thema Prüflevel bei Artikelanlage vorgeben; JM - #9887
      BEGIN
        IF TSystem.Settings__Get('KUNDE') = 'KREYENBERG' THEN
          IF (new.ak_ac IN ('LFT1001', 'MED1001')) THEN
             new.ak_allg1 := '1';
          ELSE
            IF (REGEXP_REPLACE(COALESCE(new.ak_allg1, '2'), '[^0-9]*' ,'0')::INTEGER >= 2) THEN -- wenn leer, String oder zu geringes Level für diese ACs
              IF (new.ak_ac IN ('AUT1001', 'KR_KHS_BA', 'KR_ZFST', 'KR_KHS_VA', 'ART1001')) THEN
                new.ak_allg1 := '2';
              END IF;
            END IF;
          END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER art__b_i__kreyenberg__ak_allg1
        BEFORE INSERT
        ON art
        FOR EACH ROW
        EXECUTE PROCEDURE z_50_customer.art__b_i__kreyenberg__ak_allg1();
    --

    -- Kreyenberg #7537, Material-Chargen bereits im Auftrag festlegen
    CREATE OR REPLACE FUNCTION z_50_customer.auftg__a_i__90__kreyenberg_charge() RETURNS TRIGGER AS $$
      BEGIN
        -- WHEN (new.ag_astat = 'I') -- Materialbedarf
        IF TSystem.Settings__Get('KUNDE') = 'KREYENBERG' THEN
          IF (SELECT ac_i FROM art JOIN artcod ON ak_ac=ac_n WHERE new.ag_aknr=ak_nr)=3 THEN -- IC 3 = Rohmaterial
            UPDATE auftgmatinfo SET
              agmi_lg_chnr = (SELECT ag_post1 FROM auftg WHERE ag_id = tplanterm.abk_main_auftg_id(new.ag_parentabk))
              WHERE agmi_ag_id = new.ag_id;
          END IF;
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftg__a_i__90__kreyenberg_charge
        AFTER INSERT
        ON auftg
        FOR EACH ROW
        WHEN (new.ag_astat = 'I') -- Materialbedarf
        EXECUTE PROCEDURE z_50_customer.auftg__a_i__90__kreyenberg_charge();
    --

    --
    /* Entfernt: https://redmine.prodat-sql.de/issues/19008 2022-10-24
    CREATE OR REPLACE FUNCTION bestanfpos__b_iu__kreyenberg__ks__konto() RETURNS TRIGGER AS $$
      -- #9925; BANF-Pos, zur Prüfung ob Aufwandskonto & Kostenstelle gefüllt sind
      DECLARE infotxt TEXT;
      BEGIN
        IF (TSystem.Settings__Get('KUNDE') IN ('KREYENBERG')) THEN
          IF (new.bap_ks IS NULL) OR (char_length(trim(new.bap_ks)) = 0) THEN           -- Kostenstelle ist leer
            infotxt := lang_text(29297);                                                -- "Kostenstelle ist nicht gepflegt!"
          END IF;

          IF (new.bap_konto IS NULL) OR (char_length(trim(new.bap_konto)) = 0) THEN      -- Aufwandskonto ist leer
            IF (char_length(trim(infotxt)) = 0) THEN
              infotxt := lang_text(29298);                                              -- "Aufwandskonto ist nicht gepflegt!"
            ELSE
              infotxt := infotxt || E'\n' || lang_text(29298);                          -- "Kostenstelle ist nicht gepflegt!"#13"Aufwandskonto ist nicht gepflegt!"
            END IF;
          END IF;

          IF (char_length(trim(infotxt)) > 0) THEN
            PERFORM PRODAT_TEXT(infotxt);  -- Probleme mit pg_notify()
            --RAISE EXCEPTION E'%\n', infotxt;
          END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER bestanfpos__b_iu__kreyenberg__ks__konto
        BEFORE INSERT OR UPDATE
        ON bestanfpos
        FOR EACH ROW
        EXECUTE PROCEDURE bestanfpos__b_iu__kreyenberg__ks__konto();
      */
    --

      CREATE OR REPLACE FUNCTION z_50_customer.ab2__a_z90_iu__kb__pt_vf_markierung()
       RETURNS trigger
      AS $function$
        DECLARE
            _vf_grp_list  varchar[];  -- VF-Gruppen
            _marked_color integer;    -- Farbmarkierung  des Plantafel-AG
        BEGIN
          -- Trigger zum Markieren von Plantafel-AG, die "VF-konforme" NC-Programme enthalten.
          IF NOT( old.a2_ncnr IS DISTINCT FROM new.a2_ncnr OR old.a2_vfjobid IS DISTINCT FROM new.a2_vfjobid ) THEN
            RETURN new;
          END IF;
          -- alle definierten VF-Gruppen
          _vf_grp_list :=
                array_agg(
                    DISTINCT ks_kinematic_group || '%'
                )
              FROM ksv
              WHERE nullif( trim( ks_kinematic_group ), '' ) IS NOT NULL
          ;
          -- INSERT, UPDATE: Das aktuelle NC-Programm ist "VF-konform".
          IF new.a2_ncnr LIKE ANY( _vf_grp_list ) THEN
              -- Farbmarkierung des Plantafel-AG auf grell blau setzen.
              _marked_color := 4;
              -- #17854 alle definierten VF-Gruppen zum Arbeitsgang
              _vf_grp_list :=
                    array_agg(
                        DISTINCT ks_kinematic_group || '%'
                    )
                  FROM ksv
                  WHERE
                        nullif( trim( ks_kinematic_group ), '' ) IS NOT NULL
                    AND ks_abt = new.a2_ks
              ;
              IF new.a2_ncnr LIKE ANY( _vf_grp_list ) THEN
                  -- Farbmarkierung des Plantafel-AG auf dunkelblau setzen.
                  _marked_color := 7;
              END IF;
          -- UPDATE: Aktuelles NC-Programm ist nicht mehr "VF-konform".
          ELSIF tg_op = 'UPDATE' THEN
              IF
                  -- NC-Programm war vorher "VF-konform"
                      old.a2_ncnr LIKE ANY( _vf_grp_list )
                  -- und ist es nicht mehr bzw. wurde entfernt.
                  AND (
                          NOT new.a2_ncnr LIKE ANY( _vf_grp_list ) -- Achtung! NOT col LIKE ANY <> col NOT LIKE ANY
                      OR  new.a2_ncnr IS NULL
                  )
              THEN
                  -- Farbmarkierung des Plantafel-AG wieder zurücksetzen.
                  _marked_color := 0;
              END IF;
          END IF;
          -- #17854 VF bereits an AG hinterlegt
          IF new.a2_vfjobid IS NOT null THEN
              -- Farbmarkierung des Plantafel-AG auf grün setzen.
              _marked_color := 3;
          END IF;
          -- Aktualisierung der Farbmarkierung des zugehörigen Plantafel-AG-Eintrags.
          IF _marked_color IS NOT NULL THEN
              UPDATE ab2_wkstplan SET
                a2w_marked = _marked_color
              WHERE a2w_a2_id = new.a2_id
                AND a2w_marked IS DISTINCT FROM _marked_color
              ;
          ELSE
              UPDATE ab2_wkstplan SET
                a2w_marked = 1
              WHERE a2w_a2_id = new.a2_id
                AND a2w_marked IN ( 4, 7, 3 )
              ;
          END IF;
          RETURN new;

        END $function$ LANGUAGE plpgsql;

    --
      CREATE TRIGGER ab2__a_z90_iu__kb__pt_vf_markierung
        AFTER INSERT OR UPDATE OF a2_ncnr, a2_vfjobid
        ON ab2
        FOR EACH ROW
        EXECUTE PROCEDURE z_50_customer.ab2__a_z90_iu__kb__pt_vf_markierung();    --
    --

    -- Vorschlag der Prüfmittelnummer soll teilweise unterbunden werden: https://redmine.prodat-sql.de/issues/19868
    CREATE OR REPLACE FUNCTION z_50_customer.oplpm_mw__mw_pr_pmnr__last_used(
        _mw_id          integer,  -- Ausgangspunkt: die konkrete Prüfung eines Prüfpunkts (oplpm_mw.mw_id)
        OUT oplpm_mw_id integer,  -- ID der anderen Prüfung
        OUT pm_aknr     varchar,  -- Prüfmittel-Artikelnr.
        OUT pr_pmnr     varchar   -- Prüfmittelnummer
      ) RETURNS
      SETOF record
      AS $$
      DECLARE
        _src_pruefung   record;
      BEGIN

        -- Quelldaten für Suche
      SELECT
        pm_op2_id,
        -- Prüfkriterien
        row( pm_nenn, pm_tol1, pm_tol2, pm_tol3, pm_ma ) AS kriterien,
        pm_part,
        pm_a2_id
      FROM oplpm_mw
        JOIN oplpm_data ON pm_id = mw_pm_id
      WHERE mw_id = _mw_id
      INTO
        _src_pruefung
      ;

      -- Ergebnisse ermitteln
      RETURN QUERY
      SELECT
        mw_id,
        pm_part,
        mw_pr_pmnr
      FROM oplpm_mw
        JOIN oplpm_data ON pm_id = mw_pm_id
      WHERE
        -- andere Prüfung
            mw_id <> _mw_id

        -- mit Angabe einer Prüfmittelnummer
        AND mw_pr_pmnr IS NOT NULL

        -- gleicher ABK-AG
        AND pm_a2_id = _src_pruefung.pm_a2_id

        -- gleicher Prüfer für persönliches Prüfmittel
        AND mw_pruefer = currentuser()

        -- Vergleich der Prüfmittel-Artikelnr.
        AND pm_part = _src_pruefung.pm_part

      ORDER BY
        -- gleiche Prüfkriterien bevorzugen
        row( pm_nenn, pm_tol1, pm_tol2, pm_tol3, pm_ma )
        =
        _src_pruefung.kriterien
        DESC,

        -- jüngste Verwendung bevorzugen
        oplpm_mw.modified_date DESC,
        oplpm_mw.insert_date DESC,

        -- Fallback
        mw_id DESC

      LIMIT 1
      ;

      END $$ LANGUAGE plpgsql STABLE;
    --

    -- Funktion ermittelt die Anzahl der Arbeitstage in einem Zeitraum: https://redmine.prodat-sql.de/issues/19812
    CREATE OR REPLACE FUNCTION z_50_customer.workdays__series__get(
        IN _von                    date,                      -- Beginn des Betrachtungszeitraumes
        IN _bis                    date,                      -- Ende des Betrachtungszeitraumes
        IN _exclude_wochenende     boolean   DEFAULT true,    -- Wochenenden sollen keine Arbeitstage sein
        IN _exclude_betriebsurlaub boolean   DEFAULT true,    -- Betriebsurlaub soll kein Arbeitstag sein
        IN _exclude_feiertage      boolean   DEFAULT true,    -- Feiertage sollen keine Arbeitstage sein
        OUT _workdays_count        integer                    -- Ausgabe: Anzahl der Arbeitstage im Zeitraum
        )
      AS $$

      BEGIN

        SELECT count(workdays.dates)
          INTO _workdays_count
          FROM (
            SELECT days.dates
              FROM generate_series(_von, _bis, '1 day') days(dates)
            WHERE CASE WHEN _exclude_wochenende THEN extract(dow FROM days.dates) BETWEEN 1 AND 5 ELSE TRUE END
            EXCEPT
            SELECT ft_date FROM feiertag
            WHERE CASE WHEN _exclude_betriebsurlaub THEN     ft_urlaub ELSE FALSE END
                OR CASE WHEN _exclude_feiertage      THEN NOT ft_urlaub ELSE FALSE END
                ) workdays;

      END $$ LANGUAGE plpgsql;
    --

    -- Funktion ermittelt ausgehend von einem Datum den nächsten Arbeitstag: https://redmine.prodat-sql.de/issues/19812
    CREATE OR REPLACE FUNCTION z_50_customer.workday__next__get(
        IN _date                   date      DEFAULT current_date,
        IN _exclude_wochenende     boolean   DEFAULT true,    -- Wochenenden sollen keine Arbeitstage sein
        IN _exclude_betriebsurlaub boolean   DEFAULT true,    -- Betriebsurlaub soll kein Arbeitstag sein
        IN _exclude_feiertage      boolean   DEFAULT true,    -- Feiertage sollen keine Arbeitstage sein
        IN _limit                  integer   DEFAULT 30,      -- Anzahl der Tage die in die Zukunft geschaut wird
        OUT _next_workday          date                       -- Ausgabe: Datum nächster Arbeitstage
        )
      AS $$

      BEGIN

        SELECT min(workdays.dates)
          INTO _next_workday
          FROM (
            SELECT days.dates
              FROM generate_series(_date, _date + (_limit || ' days')::interval, '1 day') days(dates)
            WHERE CASE WHEN _exclude_wochenende THEN extract(dow FROM days.dates) BETWEEN 1 AND 5 ELSE TRUE END
            EXCEPT
            SELECT ft_date FROM feiertag
            WHERE CASE WHEN _exclude_betriebsurlaub THEN     ft_urlaub ELSE FALSE END
                OR CASE WHEN _exclude_feiertage      THEN NOT ft_urlaub ELSE FALSE END
                ) workdays
        WHERE workdays.dates > _date;

      END $$ LANGUAGE plpgsql;
    --

    -- Funktion gibt für einen Mitarbeiter eine Liste der Abwesenheiten aus: https://redmine.prodat-sql.de/issues/19812
    CREATE OR REPLACE FUNCTION z_50_customer.bde_abwesenheiten__get_by_minr(
        IN _minr                   integer,                                             -- Mitarbeiternummer
        IN _von                    date      DEFAULT current_date - '1 year'::interval, -- Beginn des Betrachtungszeitraumes
        IN _bis                    date      DEFAULT current_date + '1 year'::interval, -- Ende des Betrachtungszeitraumes
        IN _exclude_bdab_aus_id    integer[] DEFAULT array [101,103,110,187],           -- Ausschluss von Abwesenheitsgründen
        IN _exclude_wochenende     boolean   DEFAULT true,                              -- Wochenenden sollen keine Arbeitstage sein
        IN _exclude_betriebsurlaub boolean   DEFAULT false,                             -- Betriebsurlaub soll kein Arbeitstag sein
        IN _exclude_feiertage      boolean   DEFAULT true,                              -- Feiertage sollen keine Arbeitstage sein
        OUT anfang                 date,                                                -- Ausgabe: Beginn der Abwesenheit
        OUT ende                   date,                                                -- Ausgabe: Ende der Abwesenheit
        OUT arbeitstage            integer,                                             -- Ausgabe: Dauer der Abwesenheit (in Arbeitstagen)
        OUT bezeichnung            varchar                                              -- Ausgabe: Abwesenheitsgrund
        )
      RETURNS SETOF RECORD
      AS $$
      DECLARE
        _r                         record;
      BEGIN

        -- Alle Abwesenheitseinträge im Betrachtungszeitraum durchlaufen
        FOR _r IN (
        SELECT bdab_anf,
              bdab_end,
              ab_txt
          FROM bdepab
          LEFT JOIN bdeabgruende ON bdab_aus_id = ab_id
        WHERE bdab_minr = _minr
          AND NOT bdab_aus_id = ANY(_exclude_bdab_aus_id)
          AND NOT bdab_end <= _von
          AND NOT bdab_anf >= _bis
        ORDER BY bdab_anf ASC)
        LOOP

          -- Beginn neuer Zeitraum ist Folgetag des alten Zeitraums
          IF (z_50_customer.workday__next__get(ende, _exclude_wochenende, _exclude_betriebsurlaub, _exclude_feiertage) = _r.bdab_anf AND bezeichnung = _r.ab_txt) OR anfang IS NULL THEN

            -- Anfang + Bezeichnung setzen falls noch leer
            anfang      := COALESCE(anfang, _r.bdab_anf);
            bezeichnung := COALESCE(bezeichnung, _r.ab_txt);
            -- Ende vom alten Zeitraum wird durch neues Ende ersetzt
            ende        := _r.bdab_end;

          ELSE
            -- neuer Zeitraum beginnt ~> alter Zeitraum wird ausgegeben
            SELECT z_50_customer.workdays__series__get(anfang, ende, _exclude_wochenende, _exclude_betriebsurlaub, _exclude_feiertage) INTO arbeitstage;
            return next;

            -- alter Zeitraum wird durch neuen überschrieben
            SELECT _r.bdab_anf, _r.bdab_end, _r.ab_txt
              INTO anfang,      ende,        bezeichnung;

          END IF;

        END LOOP;

        -- letzten Eintrag ausgeben
        SELECT z_50_customer.workdays__series__get(anfang, ende, _exclude_wochenende, _exclude_betriebsurlaub, _exclude_feiertage) INTO arbeitstage;
        RETURN next;

      END $$ LANGUAGE plpgsql;
    --

/*** START: Anbindung ESL #19005 ***/

    -- Importtabelle für Rückmeldung von ESL Status
    CREATE TABLE x_950_import.esl_kb(
        kb_id                   serial PRIMARY KEY,
        kb_esl_mac              varchar(20) not null,    --- MAC-Adresse des ESL
        kb_esl_location         varchar(100),            --- aktueller Ort des ESL
        kb_esl_status           varchar(20),             --- aktueller Status des ESL
        kb_esl_sensordaten      varchar,                 --- aktuelle Sensordaten des ESL
        kb_esl_battery          integer,                 --- Ladezustand (0-100)
        kb_esl_timestamp        timestamp(0) without time zone, --- Zeitpunkt
        kb_import_status        varchar(20),             --- Import-Status
        kb_import_hinweis       varchar,                 --- Import-Hinweis
        kb_dat_id               integer                  --- importierter Datensatz
    );


    -- Importfunktion für Übertragung der ESL Status in die sysdat
    CREATE OR REPLACE FUNCTION z_50_customer.esl_kb__import__by_kb_id(
        _kb_id integer
    )
    RETURNS void AS $$
    DECLARE
        EXCEPTION_TEXT     varchar;
        EXCEPTION_DETAIL   varchar;
        EXCEPTION_HINT     varchar;
        _dat_id            integer;
    BEGIN

        IF kb_import_status = 'importiert' FROM x_950_import.esl_kb WHERE kb_id = _kb_id THEN
          RETURN;
        END IF;

        -- 1. Import in Sysdat
        -- Gesonderter Block zur Fehlerbehandlung weil Funktion in INSERT-Trigger aufgerufen wird und das Insert nicht verworfen werden darf
        BEGIN

            -- Datum in sysdat übernehmen
            INSERT INTO sysdat( dat_tablename,
                                dat_pkey,
                                dat_type_id,
                                dat_subject,
                                dat_begin,
                                dat_location,
                                dat_status_id )
                         SELECT 'werkzeug',
                                wz_id,
                                'Intralogistikstatus',
                                wzl_pkey, -- ab_ix
                                kb_esl_timestamp,
                                kb_esl_location,
                                kb_esl_status
                           FROM x_950_import.esl_kb
                           JOIN werkzeug ON wz_wznr = kb_esl_mac
                           LEFT JOIN werkzeug_link ON wzl_wz_id = wz_id
                                                  AND wzl_table = 'abk'::regclass
                          WHERE kb_id = _kb_id
                   RETURNING dat_id INTO _dat_id;

            -- Import-Status zurückschreiben
            UPDATE x_950_import.esl_kb
               SET kb_import_status  = 'importiert',
                   kb_import_hinweis = null,
                   kb_dat_id         = _dat_id
             WHERE kb_id = _kb_id;

        EXCEPTION WHEN others THEN
            --raise exception 'EXCEPTION WHEN others';
            GET STACKED DIAGNOSTICS EXCEPTION_TEXT   = MESSAGE_TEXT ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL ,EXCEPTION_HINT = PG_EXCEPTION_HINT;

            -- Fehler-Status zurückschreiben
            UPDATE x_950_import.esl_kb
               SET kb_import_status  = lang_text( 12843 ),  --- 'Fehler'
                   kb_import_hinweis = substr( coalesce( EXCEPTION_DETAIL, EXCEPTION_TEXT, EXCEPTION_HINT, 'FEHLER!!! z_50_customer.esl_kb__b_i__kb()' ), 1, 150 )
             WHERE kb_id = _kb_id;

        END;

        -- 2. Import in werkzeug (Aktualisierung Sensordaten und Ladezustand)
        -- Gesonderter Block zur Fehlerbehandlung weil Funktion in INSERT-Trigger aufgerufen wird und das Insert nicht verworfen werden darf
        BEGIN

          UPDATE werkzeug
             SET wz_txt   = kb_esl_sensordaten, -- aktuelle Sensordaten des ESL
                 wz_allg1 = kb_esl_battery      -- aktueller Ladezustand des ESL
            FROM x_950_import.esl_kb
           WHERE kb_id = _kb_id
             AND wz_wznr = kb_esl_mac;

        EXCEPTION WHEN others THEN

          GET STACKED DIAGNOSTICS EXCEPTION_TEXT   = MESSAGE_TEXT ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL ,EXCEPTION_HINT = PG_EXCEPTION_HINT;
          RAISE NOTICE '%', substr( coalesce( EXCEPTION_DETAIL, EXCEPTION_TEXT, EXCEPTION_HINT, 'FEHLER!!! z_50_customer.esl_kb__b_i__kb()' ), 1, 150 );

        END;

    END $$ LANGUAGE plpgsql;


    -- Trigger importiert neue Rückmeldung automatisch über Importfunktion
    CREATE OR REPLACE FUNCTION x_950_import.esl_kb__a_i__kb()
      RETURNS TRIGGER AS $$
      BEGIN

        PERFORM z_50_customer.esl_kb__import__by_kb_id( new.kb_id );

        RETURN new;

      END $$ LANGUAGE plpgsql;

    DROP TRIGGER IF EXISTS esl_kb__a_i__kb ON x_950_import.esl_kb;
    CREATE TRIGGER esl_kb__a_i__kb
      AFTER INSERT
      ON x_950_import.esl_kb
      FOR EACH ROW
      EXECUTE PROCEDURE x_950_import.esl_kb__a_i__kb();


    -- Funktion zur Erstelung von Views für ESL-Anbindung
    CREATE OR REPLACE FUNCTION z_50_customer.kb__esl_views__recreate()
      RETURNS VOID AS $$
      BEGIN

        -- Domains
        CREATE OR REPLACE VIEW z_50_customer.domains__kb AS
            SELECT
                'ksv'   AS domain_typ,
                ks_abt  AS domain_bez,
                ks_sort AS domain_location,
                ks_krzl AS domain_krzl
              FROM ksv

            UNION

            SELECT
                'lagerorte'         AS domain_typ,
                lgo_name            AS domain_bez,
                lgo_desc            AS domain_location,
                lgo_ad_krz_standort AS domain_krzl
              FROM lagerorte
        ;

        -- Arbeitsplan (abk) mit ESL-Zuordnung
        --DROP VIEW IF EXISTS z_50_customer.abk__kb;
        CREATE OR REPLACE VIEW z_50_customer.abk__kb AS
            SELECT
              -- ABK Daten
                ab_ix,                     --- Auftragsnummer (eindeutig)
                ab_st_uf1,
                ab_st_uf1_soll,
                ab_ap_nr,
                ab_at,
                ab_et,
                ab_done,

              -- Produktionsauftrag
                ld_code,
                ld_auftg,
                ld_pos,
                ld_aknr,
                ld_stk_uf1,
                ld_stkl,
                ld_dokunr,
                ld_kn,
                ld_term,

              -- ESL Zuordnung
                esl.macs,
                null AS esl_highlight_stat
              FROM abk
              -- Produktionsauftrag
              LEFT JOIN ldsdok ON ld_id = ab_ld_id
              -- ESL
              LEFT JOIN LATERAL ( SELECT array_agg(wz_wznr) AS macs
                                    FROM werkzeug_link
                                    JOIN werkzeug ON wz_id = wzl_wz_id
                                  WHERE wzl_table = 'abk'::regclass
                                    AND wzl_pkey  = ab_ix ) AS esl ON true
        ;

        -- Arbeitsplan (ab2) mit ESL-Zuordnung
        --DROP VIEW IF EXISTS z_50_customer.ab2__kb;
        CREATE OR REPLACE VIEW z_50_customer.ab2__kb AS
            SELECT
              -- ABK Daten
                ab2.a2_ab_ix,

              -- Arbeitsgangdaten
                ab2.a2_id,
                ab2.a2_n,
                ab2.a2_at,
                ab2.a2_et, --PLantafeltermine,
                ab2.a2_ks,
                ab2.a2_ksap, --Auswärtsbearbeiter + Status,
                ab2.a2_ncnr,
                ab2.a2_tr,
                ab2.a2_th,
                ab2.a2_tn,
                ab2.a2_ta,
                ab2.a2_subject,
                ab2.a2_ausw,
                ab2.a2_adkrz,
                ab2.a2_ende,

              -- Folgearbeitsgang
                folge_ag.*,

              -- Auswärtsbearbeiter
                ld_code,
                ld_auftg,
                ld_pos,
                ld_aknr,
                ld_stk_uf1,
                ld_dokunr,
                ld_kn,
                ld_term,

              -- ESL Zuordnung
                esl.macs,
                null AS esl_highlight_stat
              FROM ab2
              -- Folgearbeitsgang ermitteln
              LEFT JOIN LATERAL ( SELECT folge_ab2.a2_id AS folge_a2_id,
                                         folge_ab2.a2_n  AS folge_a2_n,
                                         folge_ab2.a2_at AS folge_a2_at
                                    FROM ab2 AS folge_ab2
                                   WHERE ab2.a2_n < folge_ab2.a2_n
                                     AND ab2.a2_ab_ix = folge_ab2.a2_ab_ix
                                   ORDER BY ab2.a2_n ASC
                                   LIMIT 1
                                 ) AS folge_ag ON true
              -- Auswärtsarbeitsgang-Bestellung
              LEFT JOIN ldsdok ON ld_a2_id = ab2.a2_id
              -- ESL
              LEFT JOIN LATERAL ( SELECT array_agg(wz_wznr) AS macs
                                    FROM werkzeug_link
                                    JOIN werkzeug ON wz_id = wzl_wz_id
                                  WHERE wzl_table = 'ab2'::regclass
                                    AND wzl_pkey  = ab2.a2_id ) AS esl ON true
        ;

        -- ESL
        CREATE OR REPLACE VIEW z_50_customer.esl__kb AS
            SELECT
                wz_id    AS esl_id,
                wz_wznr  AS esl_mac,
                wz_aknr  AS esl_modelname,
                wz_txt   AS esl_sensordaten,
                wz_allg1 AS esl_battery
              FROM werkzeug
              JOIN art ON art.ak_nr = werkzeug.wz_aknr
             WHERE ak_ac = 'ESL1001'
        ;

        -- ESL-Links
        CREATE OR REPLACE VIEW z_50_customer.esl_links__kb AS
            SELECT
                wz_id     AS esl_id,
                wz_wznr   AS esl_mac,
                wzl_id    AS link_id,
                wzl_table AS link_table,
                wzl_pkey  AS link_pkey
              FROM werkzeug
              JOIN werkzeug_link ON wz_id = wzl_wz_id
              JOIN art ON art.ak_nr = werkzeug.wz_aknr
             WHERE ak_ac = 'ESL1001'
        ;

    END $$ LANGUAGE plpgsql;

/*** ENDE: Anbindung ESL #19005 ***/