/************* CNC *******************/


    -- ACHTUNG: bei Änderungen CI Test prüfen!
    -- https://ci.prodat-sql.de/sources/tests/suite/29/runner/661
    CREATE OR REPLACE FUNCTION art__a_iu___cnc() RETURNS TRIGGER AS $$
      BEGIN
      -- https://redmine.prodat-sql.de/issues/2946 Feld "Kunde" im Artikelstamm: Pflichtfeld bei CNC
      -- https://redmine.prodat-sql.de/issues/16050 Feld "Kunde" zum Pflichtfeld bei der Artikelerstellung mit AC 2000 machen

        IF
              ( new.ak_fertigung OR new.ak_ac = '2000' )
          AND new.ak_kunde IS null
        THEN
            RAISE EXCEPTION '%', format( lang_text( 29183 ), lang_text( 15893 ), new.ak_nr );
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER art__a_iu___cnc
        AFTER INSERT OR UPDATE
        OF ak_bez
        ON art
        FOR EACH ROW
        EXECUTE PROCEDURE art__a_iu___cnc();
    --

    -- #6445
    CREATE OR REPLACE FUNCTION recnokeyword__a_10_iu__cnc() RETURNS TRIGGER AS $$
      BEGIN
        -- WHEN (new.r_tablename='picndoku' AND new.r_kategorie='adk' AND r_descr IN ('RUA___EURO', 'CON___ZUR'))
        IF new.r_descr = 'RUA___EURO' THEN
            PERFORM CreateRecNoKeyword('adk', 'CON___ZUR', new.r_dbrid);
        ELSIF new.r_descr = 'CON___ZUR' THEN
            PERFORM CreateRecNoKeyword('adk', 'RUA___EURO', new.r_dbrid);
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER recnokeyword__a_10_iu__cnc
        AFTER INSERT OR UPDATE
        OF r_descr, r_kategorie
        ON recnokeyword
        FOR EACH ROW
        WHEN (new.r_tablename='picndoku' AND new.r_kategorie='adk' AND new.r_descr IN ('RUA___EURO', 'CON___ZUR'))
        EXECUTE PROCEDURE recnokeyword__a_10_iu__cnc();
    --

    -- Preise im Angebot aktualisieren, wenn Preise im Artikel aktualisiert werden (CNC)
    CREATE OR REPLACE FUNCTION artstp__a_99_iud__updateauftg__cnc() RETURNS TRIGGER AS $$
      DECLARE r RECORD;
              aknr VARCHAR;
              kuklstp BOOL;
      BEGIN
        --Alt/Neu zuweisung der Arbeitsvariablen (Insert/Update, Delete)
        IF tg_op='DELETE' THEN
            aknr:=old.astp_aknr;
        ELSE
            aknr:=new.astp_aknr;
        END IF;
        --alle bestehenden offenen angebote ändern!
        --alle laufenden angebote holen und durchlaufen!
        FOR r IN SELECT ag_id, ag_waer, ag_kurs, ag_kukl FROM auftg JOIN auftgstp ON ag_id=auftgstp_agid LEFT JOIN adressen_view ON ad_krz=ag_krzf LEFT JOIN adk1 ON a1_krz=adk_ad_krz WHERE NOT ag_done AND ag_astat='A' AND ag_aknr=aknr LOOP
            DELETE FROM auftgstp WHERE auftgstp_agid=r.ag_id AND auftgstp_txt IS NULL;
            --alle Staffeln des aktuellen Artikels neu übertragen!
            kuklstp:=EXISTS(SELECT true FROM artstp WHERE astp_aknr=aknr AND astp_kukl=r.ag_kukl);
            INSERT INTO auftgstp (auftgstp_agid, auftgstp_aknr, auftgstp_menge, auftgstp_vkp)
                SELECT r.ag_id, astp_aknr, astp_menge, astp_vkp*IFTHEN(r.ag_waer=astp_waco, 1, r.ag_kurs) FROM artstp WHERE astp_aknr=aknr AND CASE WHEN kuklstp THEN astp_kukl=r.ag_kukl ELSE astp_kukl IS NULL END;
        END LOOP;
        --return old/new
        IF tg_op='DELETE' THEN
            RETURN old;
        ELSE
            RETURN new;
        END IF;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER artstp__a_99_iud__updateauftg__cnc
        AFTER INSERT OR UPDATE OR DELETE
        ON artstp
        FOR EACH ROW
        EXECUTE PROCEDURE artstp__a_99_iud__updateauftg__cnc();
    --

    -- Präsenzzeit abmelden verhindern, wenn Auftragsvolumen nicht erfüllt. #6653
    CREATE OR REPLACE FUNCTION bdep__a_99_iu_bd_end__cnc() RETURNS TRIGGER AS $$
      DECLARE llv_rec RECORD;
      BEGIN
        -- WHEN (new.bd_end IS NOT NULL)
        SELECT COALESCE(ll_abteilung, '') AS ll_abteilung, ll_auftrzeit, ll_auftrzeit_sollpr INTO llv_rec FROM llv WHERE ll_minr = new.bd_minr;

        IF NOT llv_rec.ll_auftrzeit THEN
            RETURN new;
        ELSIF EXISTS(SELECT true FROM pg_user WHERE usesysid IN (SELECT unnest(grolist) FROM pg_group WHERE groname='BDE_ADMIN') AND usename = current_user) THEN -- Wenn aktueller Nutzer in Benutzergruppe BDE_ADMIN, dann Bearbeitung vollständig erlaubt (auch eigene).
            RETURN new;
        ELSIF (SELECT ll_abteilungsleiter FROM llv WHERE COALESCE(ll_abteilung, '') = llv_rec.ll_abteilung -- Wenn aktueller Nutzer Abteilungsleiter der Abteilung des gestempelten MA und nicht er selbst, dann Bearbeitung erlaubt (keine eigenen).
            AND ll_db_usename = current_user AND ll_minr <> new.bd_minr)
        THEN
            RETURN new;
        ELSE
            IF llv_rec.ll_auftrzeit_sollpr >
                (SELECT
                    (  COALESCE(( SELECT SUM(COALESCE(ba_efftime, timediff(ba_anf_rund, currenttime()))) FROM bdea WHERE ba_minr = new.bd_minr AND ba_anf::DATE = current_date ), 0) -- Summe Auftragszeit
                       / Do1If0(SUM(CASE WHEN bd_end_rund IS NOT NULL THEN bd_saldo ELSE timediff(bd_anf_rund, currenttime()) END)) * 100 -- geteilt durch Summe Präsenzzeit * 100 (also prozentualer Anteil)
                    )::NUMERIC(10,2) -- Runden
                 FROM bdep
                 WHERE bd_minr = new.bd_minr
                   AND bd_individwt_mpl_date = current_date
                )
            THEN
                RAISE EXCEPTION '%', lang_text(16495);
            END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;
      --

      CREATE TRIGGER bdep__a_99_iu_bd_end__cnc
        AFTER INSERT OR UPDATE
        OF bd_end
        ON bdep
        FOR EACH ROW
        WHEN (new.bd_end IS NOT NULL)
        EXECUTE PROCEDURE bdep__a_99_iu_bd_end__cnc();
    --

    -- #6797 Standardaktivierung der Anhangsdokumente ABK
    CREATE OR REPLACE FUNCTION settings__b_iu__cnc() RETURNS TRIGGER AS $$
      DECLARE afterreports INTEGER[];
      BEGIN
        -- WHEN (new.s_vari LIKE 'afterprint%')
        afterreports:= array_agg(r_id) FROM reports
            WHERE r_stamp IN (
                '12.12.2007 10:03:45', -- Teileprüfprotokoll/Messmittelplan
                '12.12.2007 15:11:00'  -- Regelkarte
                );
        IF new.s_vari IN (SELECT 'afterprint_' || current_user || '~' || unnest(afterreports))
            AND new.s_inha = '-1'
        THEN
            RAISE EXCEPTION '%', lang_text(16507);
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER settings__b_iu__cnc
        AFTER INSERT OR UPDATE
        ON settings
        FOR EACH ROW
        WHEN (new.s_vari LIKE 'afterprint%')
        EXECUTE PROCEDURE settings__b_iu__cnc();
    --

    -- #6894 automatische Plantafel-Markierung anhand Artikeleigenschaften (Eigenschaft in Artikelstamm => AG in Plantafel markieren)
    CREATE OR REPLACE FUNCTION recnokeyword__a_20_iu__cnc() RETURNS TRIGGER AS $$
      BEGIN
        -- WHEN (new.r_tablename='art' AND new.r_descr IN ('Kanbanteil', 'Rahmenvertragsteil'))

        IF TG_OP = 'UPDATE' THEN
            IF old.r_descr = new.r_descr THEN -- Nur AG markieren, wenn Eigenschaft darauf geändert wurde
                RETURN new;
            END IF;
        END IF;

        IF new.r_descr = 'Rahmenvertragsteil' THEN -- Eigenschaft Rahmenvertragsteil wurde gesetzt, dann offene AG mit Sternchen markieren (a2w_ncdone).
                                                   -- Zurücksetzen der Markieren NICHT, da evtl. durch Benutzer in Plantafel markiert wurde (Unterscheidung nicht möglich).
            UPDATE ab2_wkstplan SET
              a2w_ncdone= true
              --a2w_ncby = nameAufloesen(current_user::VARCHAR)
            WHERE a2w_a2_id IN ( -- Alle AG der Fertigungen des Artikels
                SELECT a2_id
                FROM ab2
                  JOIN abk ON ab_ix = a2_ab_ix
                  JOIN ldsdok ON ld_abk = a2_ab_ix
                  JOIN art ON ak_nr = ld_aknr
                WHERE art.dbrid = new.r_dbrid
                  AND NOT ld_done)
              AND NOT a2w_ncdone -- noch nicht markiert
              AND NOT a2w_ende; -- nur offene
        END IF;

        IF new.r_descr = 'Kanbanteil' THEN -- s.o. für Eigenschaft Kanbanteil die Markierung Unterstreichen setzen.
            UPDATE ab2_wkstplan SET
              a2w_underline= true
              --a2w_underlineby = nameAufloesen(current_user::VARCHAR)
            WHERE a2w_a2_id IN (
                SELECT a2_id
                FROM ab2
                  JOIN abk ON ab_ix = a2_ab_ix
                  JOIN ldsdok ON ld_abk = a2_ab_ix
                  JOIN art ON ak_nr = ld_aknr
                WHERE art.dbrid = new.r_dbrid
                  AND NOT ld_done)
              AND NOT a2w_underline
              AND NOT a2w_ende;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER recnokeyword__a_20_iu__cnc
        AFTER INSERT OR UPDATE
        OF r_descr
        ON recnokeyword
        FOR EACH ROW
        WHEN (new.r_tablename='art' AND new.r_descr IN ('Kanbanteil', 'Rahmenvertragsteil'))
        EXECUTE PROCEDURE recnokeyword__a_20_iu__cnc();
    --

    -- #6894 automatische Plantafel-Markierung anhand Artikeleigenschaften (AG wird in Plantafel aufgenommen => Eigenschaft im Artikelstamm prüfen und entspr. markieren)
    CREATE OR REPLACE FUNCTION ab2_wkstplan__b_i__cnc() RETURNS TRIGGER AS $$
      BEGIN
        IF EXISTS( -- Wenn Fertigungsartikel die Eigenschaft Rahmenvertragsteil hat, dann AG markieren (Sternchen).
            SELECT true --get_recnoparam('art', art.dbrid, 'Rahmenvertragsteil')
            FROM ab2
              JOIN abk ON ab_ix = a2_ab_ix
              JOIN ldsdok ON ld_abk = a2_ab_ix
              JOIN art ON ak_nr = ld_aknr
              JOIN recnokeyword ON r_tablename='art' AND r_dbrid=art.dbrid AND r_descr='Rahmenvertragsteil'
            WHERE a2_id = new.a2w_a2_id)
        THEN
            new.a2w_ncdone:= true;
            --new.a2w_ncby:= nameAufloesen(current_user::VARCHAR);
        END IF;

        IF EXISTS( -- Wenn Fertigungsartikel die Eigenschaft Rahmenvertragsteil hat, dann AG markieren (unterstreichen).
            SELECT true --get_recnoparam('art', art.dbrid, 'Kanbanteil')
            FROM ab2
              JOIN abk ON ab_ix = a2_ab_ix
              JOIN ldsdok ON ld_abk = a2_ab_ix
              JOIN art ON ak_nr = ld_aknr
              JOIN recnokeyword ON r_tablename='art' AND r_dbrid=art.dbrid AND r_descr='Kanbanteil'
            WHERE a2_id = new.a2w_a2_id)
        THEN
            new.a2w_underline:= true;
            --new.a2w_underlineby:= nameAufloesen(current_user::VARCHAR);
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER ab2_wkstplan__b_i__cnc
        BEFORE INSERT
        ON ab2_wkstplan
        FOR EACH ROW
        EXECUTE PROCEDURE ab2_wkstplan__b_i__cnc();
    --

    CREATE OR REPLACE FUNCTION z_50_customer.e_folgeap_op_ix__custom_code(
        IN _e_folgeap_op_ix__disabled boolean,
        IN _e_folgeap_op_ix           integer
        )
        RETURNS integer
        AS $$
        BEGIN
            -- Im Fall der spezifischen ASK-IX: Reinigung + QS / nur Reinigung OHNE QS wird beim Deaktivieren zwischen diesen beiden Varianten unterschieden
            IF _e_folgeap_op_ix__disabled AND _e_folgeap_op_ix = 44239 THEN
               RETURN 44240;
            END IF;

            RETURN -1;
        END $$ LANGUAGE plpgsql;
--- *********************************************

 -- CNC bei a1_krz LIKE 'VAT%' a1_toltext als Fusstext nehmen
 CREATE OR REPLACE FUNCTION belkopf__b_i_cnc() RETURNS TRIGGER AS $$
  BEGIN
   IF new.be_rkrz LIKE 'VAT%' THEN
        new.be_bem2:=COALESCE((SELECT a1_toltext FROM adk1 WHERE a1_krz=new.be_rkrz),new.be_bem2);
   END IF;
   RETURN new;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER belkopf__b_i_cnc
  BEFORE INSERT
  ON belkopf
  FOR EACH ROW
  EXECUTE PROCEDURE belkopf__b_i_cnc();


-- #20300 - vorhandener Lagerbestand an Einzelteilen zu einer Baugruppe ermitteln
CREATE OR REPLACE FUNCTION z_50_customer.stv__lg_anztot__vorhanden(
  IN _ak_nr       varchar,
  IN _menge       numeric,
  IN _verfuegbar  boolean DEFAULT false,
  IN _init        boolean DEFAULT false,
  IN _ebene       varchar DEFAULT ''
  )
RETURNS TABLE (ak_nr varchar, lg_anztot numeric, lg_anztot_rest numeric ) AS $$
DECLARE
  _r         record;
  _restmenge numeric;
BEGIN

  IF _init THEN
    DROP TABLE IF EXISTS artikelbestand;
    CREATE TEMP TABLE IF NOT EXISTS artikelbestand(
      ak_nr              varchar,
      lg_anztot          numeric,
      lg_anztot_rest     numeric
    );
  END IF;

  FOR _r IN (

  SELECT st_m_uf1 * _menge AS bedarfsmenge,
         st_n AS ak_nr,
         'STK' || '-' || st_pos AS pos
    FROM stv
   WHERE stv.st_zn = _ak_nr
     AND NOT coalesce(stv.st_stat,'') IN ('BK', 'KS', 'AM')    -- keine Alternativpositionen, Kundenbeistellung, KS

   UNION

  SELECT o6_m_uf1 * _menge AS bedarfsmenge,
         o6_aknr as ak_nr,
         'MAT' || '-' || o6_pos AS pos
    FROM op6
    JOIN opl ON opl.op_ix = op6.o6_ix
   WHERE opl.op_n = _ak_nr
     AND opl.op_standard
     AND NOT op6.o6_calconly                      -- keine reinen Kalkulationspositionen
     ) LOOP

     -- Prüfung ob Lagerbestand vorhanden ist -> Aufname in temporäre Tabelle
     IF NOT EXISTS( SELECT artikelbestand.lg_anztot_rest FROM artikelbestand WHERE artikelbestand.ak_nr = _r.ak_nr) THEN
       INSERT INTO artikelbestand ( ak_nr,   lg_anztot,      lg_anztot_rest )
                   SELECT _r.ak_nr,
                          CASE WHEN _verfuegbar THEN GREATEST(art.ak_verfueg, 0) ELSE coalesce(SUM(lag.lg_anztot), 0) END,
                          CASE WHEN _verfuegbar THEN GREATEST(art.ak_verfueg, 0) ELSE coalesce(SUM(lag.lg_anztot), 0) END
                     FROM art
                     LEFT JOIN lag ON art.ak_nr = lag.lg_aknr
                    WHERE art.ak_nr = _r.ak_nr
                    GROUP BY art.ak_nr
                    LIMIT 1;
     END IF;

     -- Restmenge berechnen
     SELECT artikelbestand.lg_anztot_rest - _r.bedarfsmenge
       INTO _restmenge
       FROM artikelbestand
      WHERE artikelbestand.ak_nr = _r.ak_nr;
     --  JOIN _r ON artikelbestand.ak_nr = _r.ak_nr;

     -- Bedarfsmenge reduzieren wenn diese (teilweise) durch Restmenge bedient werden kann
     IF _restmenge >= 0 THEN
       _r.bedarfsmenge := 0;
       UPDATE artikelbestand
          SET lg_anztot_rest = _restmenge
        WHERE artikelbestand.ak_nr = _r.ak_nr;

      ELSIF _restmenge < 0 THEN
       _r.bedarfsmenge := abs(_restmenge);
       UPDATE artikelbestand
          SET lg_anztot_rest = 0
        WHERE artikelbestand.ak_nr = _r.ak_nr;

       RAISE NOTICE 'ebene: %', _ebene;
       -- Endlosschleife verhindern
       IF NOT _ebene LIKE '%' || _r.ak_nr || '.' || _r.pos || '%' THEN
         PERFORM z_50_customer.stv__lg_anztot__vorhanden(_r.ak_nr, _r.bedarfsmenge, _verfuegbar, false, _ebene || '*' || _r.ak_nr || '.' || _r.pos);
       END IF;

     END IF;


   END LOOP;

   IF _init THEN
     RETURN query SELECT * FROM artikelbestand;
     DROP TABLE IF EXISTS artikelbestand;
   END IF;

END $$ LANGUAGE plpgsql;


--- #23186
    CREATE OR REPLACE FUNCTION z_50_customer.ab2__a_90_i__ab_erstfert__cnc() RETURNS TRIGGER AS $$
      BEGIN
        UPDATE abk SET ab_erstfert = true WHERE ab_ix = new.a2_ab_ix AND NOT ab_erstfert;
        RETURN new;
      END $$ LANGUAGE plpgsql;

    CREATE TRIGGER ab2__a_90_i__ab_erstfert__cnc
        AFTER INSERT
        ON public.ab2
        FOR EACH ROW
        WHEN (new.a2_ks::text = 'PR-1'::text)
        EXECUTE FUNCTION z_50_customer.ab2__a_90_i__ab_erstfert__cnc();
