CREATE OR REPLACE FUNCTION twawi.ldsdok__ld_stat__w(
      _dbrid varchar,
      _has_w boolean = null
  ) RETURNS varchar AS $$ 
  DECLARE 
      _status varchar;
  BEGIN
      
      IF _has_w IS NULL THEN
          SELECT tsystem.enum_flipvalue( p_status, 'W' ) INTO _status FROM twawi.ldsdok_pos WHERE dbrid = _dbrid;
      ELSEIF _has_w THEN
          SELECT tsystem.enum_setvalue( p_status, 'W' ) INTO _status FROM twawi.ldsdok_pos WHERE dbrid = _dbrid;
      ELSE
          SELECT tsystem.enum_delvalue( p_status, 'W' ) INTO _status FROM twawi.ldsdok_pos WHERE dbrid = _dbrid;
      END IF;

      IF NOT FOUND THEN
          RAISE EXCEPTION 'twawi.ldsdok__ld_stat__w: NOT FOUND dbrid = %', _dbrid;
      END IF;
      
      UPDATE twawi.ldsdok_pos 
         SET p_status = upper( _status ) 
       WHERE dbrid = _dbrid;
      
      RETURN _status;
      
  END $$ LANGUAGE plpgsql;
