@ECHO OFF
ECHO(
ECHO ^>^> Gestartet von: %~dp0
ECHO ^>^> Cmd: %0 %*
ECHO(



:: -----------------------------------------------------
:: ------------------  EXITCODE  -----------------------
:: -----------------------------------------------------
:: 999 - Argument fuer auszufuehrende Operation fehlerhaft
:: 998 - Excludes-File (Arg2) existiert nicht
:: 997 - Quell-Verzeichniss (Arg3) existiert nicht
:: 996 - Ziel-Verzeichniss (Arg4) existiert nicht
:: 995 - Konfigurationsdatei nicht gefunden
:: 994 - Unquoted Pfad mit Spaces angegeben
:: -----------------------------------------------------


:: -----------------------------------------------------
:: -----------------------------------------------------
:: Arg3 und Arg4 (Quell-/Ziel-Verzeichniss)
:: MUESSEN mit Trailing Backslash uebergeben werden!!!
:: ODER es wird die Konfiguration benutzt und Local wird
:: automatisch ermittelt
:: Fuer Arg3 und Arg4 kann auch NULL angegeben werden um
:: ebenfalls Arg5 angeben zu koennen
:: in diesem Fall wird die Konfiguration benutzt und
:: Local wird automatisch ermittelt
:: -----------------------------------------------------


:: -----------------------------------------------------
:: -----------------------------------------------------
:: /EFSRAW /COPY:DATSOU /COPYALL /SECFIX
:: Diese robocopy Optionen funktionnieren nur mit
:: einem Windows Account mit entsprechenden Rechten.
:: Daher werden diese momentan nicht verwendet
:: -----------------------------------------------------
:: /IM is undocumented and stands for
:: - Include Modified files (Includes same files with
:: different times).
:: -----------------------------------------------------


:: DEBUG
:: ECHO Parameters:
:: ECHO 0^= %~dp0
:: ECHO 1^= %1
:: ECHO 2^= %~f2
:: ECHO 2^= %2
:: ECHO 3^= %~dp3
:: ECHO 3^= %3
:: ECHO 4^= %~dp4
:: ECHO 4^= %4
:: ECHO 5^= %5

SET /A VarMyERRORLEVEL=0

IF [%2] EQU [] GOTO ERR_Argument2Missing
IF NOT EXIST "%~f2" (
  GOTO ERR_ExcludeFileDoesNotExist
)

IF %1 EQU ALL (
  SET Var_UL_NextGOTOLABEL=COPY_All
) ELSE (
  IF %1 EQU UPDATEONLY (
    SET Var_UL_NextGOTOLABEL=COPY_UpdateOnly
  ) ELSE (
    IF %1 EQU SYNC (
      SET Var_UL_NextGOTOLABEL=COPY_Sync
    ) ELSE (
      IF %1 EQU TESTROBOCOPY (
        SET Var_UL_NextGOTOLABEL=COPY_TESTROBOCOPY
      ) ELSE (
        GOTO ERR_WrongOp
      )
    )
  )
)

IF [%5] EQU [DONTSTARTPRODAT] (
  SET /A VarStartProdat=0
) ELSE (
  SET /A VarStartProdat=1
)

:LOADCFGPREPARESRCDST
SET Var_ScriptDir=%~dp0
FOR %%G in ("%~dp0\..\..") do SET Var_LocalDir=%%~dpnxG\
FOR %%G in ("%~dp0\..") do SET Var_ScriptDir_Parent=%%~dpnxG\
SET Var_CfgFile=%Var_ScriptDir_Parent%RunLocal_SetCfgVariables.bat
ECHO(
ECHO Konfigurations-Datei:     "%Var_CfgFile%"

IF EXIST "%Var_CfgFile%" (
  CALL "%Var_CfgFile%"
  ECHO   Konfiguration geladen
) ELSE (
  ECHO   Konfigurations-Datei nicht gefunden.
)
SET Var_RemoteDir=%VarCfg_RemoteDir%

IF [%3] NEQ [] (
  IF NOT "%~3" == "NULL" (
    IF NOT "%~3" == "%~dp3" (
      GOTO ERR_UnquotedPathWithSpaces
    ) ELSE (
      SET Var_RemoteDir=%~dp3
      ECHO   benutze Arg3 fuer Quell-Verzeichniss: %~dp3
    )
  )
)
IF NOT EXIST "%Var_RemoteDir%" (
  GOTO ERR_SourceDoesNotExist
)

IF [%4] NEQ [] (
  IF NOT "%~4" == "NULL" (
    IF NOT "%~4" == "%~dp4" (
      GOTO ERR_UnquotedPathWithSpaces
    ) ELSE (
      SET Var_LocalDir=%~dp4
      ECHO   benutze Arg4 fuer Ziel-Verzeichniss:  %~dp4
    )
  )
)
IF NOT EXIST "%Var_LocalDir%" (
  GOTO ERR_DestinationDoesNotExist
)

IF NOT EXIST "%Var_RemoteDir%" GOTO ERR_SourceDoesNotExist
IF NOT EXIST "%Var_LocalDir%" GOTO ERR_DestinationDoesNotExist

SET Var_LocalPythonDir=%Var_LocalDir%Python3\
SET Var_RemotePythonDir=%Var_RemoteDir%Python3\

:: sanitize paths, remove backslash or else robocopy wont work with those quoted paths
SET "Var_LocalDir=%Var_LocalDir%."
FOR %%J in ("%Var_LocalDir%") do FOR %%I in ("%%~fJ.") do SET Var_LocalDir=%%~fI
SET "Var_RemoteDir=%Var_RemoteDir%%."
FOR %%J in ("%Var_RemoteDir%") do FOR %%I in ("%%~fJ.") do SET Var_RemoteDir=%%~fI
SET "Var_LocalPythonDir=%Var_LocalPythonDir%."
FOR %%J in ("%Var_LocalPythonDir%") do FOR %%I in ("%%~fJ.") do SET Var_LocalPythonDir=%%~fI
SET "Var_RemotePythonDir=%Var_RemotePythonDir%%."
FOR %%J in ("%Var_RemotePythonDir%") do FOR %%I in ("%%~fJ.") do SET Var_RemotePythonDir=%%~fI

ECHO(
ECHO   %1
ECHO     Quelle:   %Var_RemoteDir%
ECHO     Ziel:     %Var_LocalDir%
ECHO     Excludes: %~f2
ECHO     QP:       %Var_RemotePythonDir%
ECHO     DP:       %Var_LocalPythonDir%
IF [%5] NEQ [] ECHO     %5
ECHO(


IF %1 EQU TESTROBOCOPY (
  GOTO COPY_TESTROBOCOPY
)

:TERMINATEPRODAT
ECHO Beende Prodat Programm-Instanzen ...
TASKKILL /F /IM %VarCfg_StartProdat_Prog% 2>NUL
ECHO(
ECHO(
REM timeout 120
GOTO %Var_UL_NextGOTOLABEL%



:STARTPRODAT
IF %VarStartProdat% NEQ 1 GOTO _EXIT

SET StartCMD=%Var_LocalDir%^\
SET StartCMD="%StartCMD%%VarCfg_StartProdat_Prog%" %VarCfg_StartProdat_Params%
ECHO Starte: %StartCMD%
START "" %StartCMD%
GOTO _EXIT



:COPY_TESTROBOCOPY
:: Zum Testen ob RoboCopy korrekt arbeitet, darf nur 1 Kommando ausgefhrt werden (ExitCode)
SET /A VarMyERRORLEVEL=0
robocopy "%Var_RemoteDir%"       "%Var_LocalDir%"       /MIR /Z /job:"%~f2"                                 /COPY:DAT /DCOPY:DAT /MT:2 /R:3 /W:2 /ETA /IT /IM /IS >nul 2>&1
ECHO robocopy exitcode: ^<%ERRORLEVEL%^>
IF %ERRORLEVEL% GEQ 8 SET /A VarMyERRORLEVEL=%ERRORLEVEL%
IF %VarMyERRORLEVEL% GEQ 8 ( >&2 ECHO robocopy did exit with code %VarMyERRORLEVEL% )
GOTO _EXIT



:COPY_Sync
ECHO COPY_Sync
DEL /Q "%Var_LocalDir%_*.zip" "%Var_LocalDir%_*.7z" 2>NUL
SET /A VarMyERRORLEVEL=0
robocopy "%Var_RemoteDir%"       "%Var_LocalDir%"       /MIR /Z /job:"%~f2"                                 /COPY:DAT /DCOPY:DAT /MT:2 /R:3 /W:2 /ETA /IT /IM /IS
ECHO robocopy exitcode: ^<%ERRORLEVEL%^>
IF %ERRORLEVEL% GEQ 8 SET /A VarMyERRORLEVEL=%ERRORLEVEL%
robocopy "%Var_RemotePythonDir%" "%Var_LocalPythonDir%" /MIR /Z /job:"%Var_ScriptDir%exclude_noexclude.rcj" /COPY:DAT /DCOPY:DAT /MT:2 /R:3 /W:2 /ETA /IT /IM /IS
ECHO robocopy exitcode: ^<%ERRORLEVEL%^>
IF %ERRORLEVEL% GEQ 8 SET /A VarMyERRORLEVEL=%ERRORLEVEL%
IF %VarMyERRORLEVEL% GEQ 8 ( >&2 ECHO robocopy did exit with code %VarMyERRORLEVEL% )
GOTO STARTPRODAT



:COPY_All
ECHO COPY_All
DEL /Q "%Var_LocalDir%_*.zip" "%Var_LocalDir%_*.7z" 2>NUL
SET /A VarMyERRORLEVEL=0
robocopy "%Var_RemoteDir%"       "%Var_LocalDir%"       /MIR /Z /job:"%~f2"                                 /COPY:DAT /DCOPY:DAT /MT:2 /R:3 /W:2 /ETA /IT /IM /IS /XX
ECHO robocopy exitcode: ^<%ERRORLEVEL%^>
IF %ERRORLEVEL% GEQ 8 SET /A VarMyERRORLEVEL=%ERRORLEVEL%
robocopy "%Var_RemotePythonDir%" "%Var_LocalPythonDir%" /MIR /Z /job:"%Var_ScriptDir%exclude_noexclude.rcj" /COPY:DAT /DCOPY:DAT /MT:2 /R:3 /W:2 /ETA /IT /IM /IS /XX
ECHO robocopy exitcode: ^<%ERRORLEVEL%^>
IF %ERRORLEVEL% GEQ 8 SET /A VarMyERRORLEVEL=%ERRORLEVEL%
IF %VarMyERRORLEVEL% GEQ 8 ( >&2 ECHO robocopy did exit with code %VarMyERRORLEVEL% )
GOTO STARTPRODAT



:COPY_UpdateOnly
ECHO COPY_UpdateOnly
DEL /Q "%Var_LocalDir%_*.zip" "%Var_LocalDir%_*.7z" 2>NUL
SET /A VarMyERRORLEVEL=0
robocopy "%Var_RemoteDir%"       "%Var_LocalDir%"       /MIR /Z /job:"%~f2"                                 /COPY:DAT /DCOPY:DAT /MT:2 /R:3 /W:2 /ETA /XX /XO
ECHO robocopy exitcode: ^<%ERRORLEVEL%^>
IF %ERRORLEVEL% GEQ 8 SET /A VarMyERRORLEVEL=%ERRORLEVEL%
robocopy "%Var_RemotePythonDir%" "%Var_LocalPythonDir%" /MIR /Z /job:"%Var_ScriptDir%exclude_noexclude.rcj" /COPY:DAT /DCOPY:DAT /MT:2 /R:3 /W:2 /ETA /XX /XO
ECHO robocopy exitcode: ^<%ERRORLEVEL%^>
IF %ERRORLEVEL% GEQ 8 SET /A VarMyERRORLEVEL=%ERRORLEVEL%
IF %VarMyERRORLEVEL% GEQ 8 ( >&2 ECHO robocopy did exit with code %VarMyERRORLEVEL% )
GOTO STARTPRODAT



:ERR_Argument2Missing
>&2 ECHO Argument 2 missing
GOTO ERR_ExcludeFileDoesNotExist



:ERR_Argument3Missing
>&2 ECHO Argument 3 missing
GOTO ERR_SourceDoesNotExist



:ERR_Argument4Missing
>&2 ECHO Argument 4 missing
GOTO ERR_DestinationDoesNotExist



:ERR_WrongOp
SET /A VarMyERRORLEVEL=999
>&2 ECHO Argument fuer auszufuehrende Operation fehlerhaft
GOTO _EXIT



:ERR_ExcludeFileDoesNotExist
SET /A VarMyERRORLEVEL=998
>&2 ECHO Exclude-Datei (%~f2) exisitiert nicht
GOTO _EXIT



:ERR_SourceDoesNotExist
SET /A VarMyERRORLEVEL=997
>&2 ECHO Quell-Verzeichniss (%~3) exisitiert nicht oder nicht erreichbar
:: bei Netzwerkproblemen dennoch starten
TIMEOUT /t 120
GOTO STARTPRODAT



:ERR_DestinationDoesNotExist
SET /A VarMyERRORLEVEL=996
>&2 ECHO Ziel-Verzeichniss (%~4) exisitiert nicht oder nicht erreichbar
GOTO _EXIT



:ERR_ConfigNotFound
SET /A VarMyERRORLEVEL=995
>&2 ECHO Konfigurations-Datei nicht gefunden
GOTO _EXIT



:ERR_UnquotedPathWithSpaces
SET /A VarMyERRORLEVEL=994
>&2 ECHO Pfad Parameter mit Leerzeichen ohne Quotes gefunden
GOTO _EXIT



:ERR_Robocopy
>&2 ECHO robocopy did exit with code %VarMyERRORLEVEL%
GOTO _EXIT



:_EXIT
ECHO EXIT (Update)
EXIT /B %VarMyERRORLEVEL%
