/************* MERTNER ***************/

    -- http://redmine.prodat-sql.de/issues/6769 ak_txt (Zusatztext) in ag_postxt (Positionshinweis)
    CREATE OR REPLACE FUNCTION auftg__b_iu__mertner() RETURNS TRIGGER AS $$
      BEGIN
        -- WHEN (new.ag_astat IN ('A', 'E')
        IF TG_OP = 'INSERT' THEN
            IF COALESCE(new.ag_postxt, '') = '' THEN
                new.ag_postxt:= ak_txt FROM art WHERE ak_nr = new.ag_aknr;
            END IF;
        ELSE -- UPDATE
            IF old.ag_aknr <> new.ag_aknr THEN -- Bei Artikelwechsel prüfen, ob Text des alten Artikels getauscht werden kann.
                IF new.ag_postxt IS NOT DISTINCT FROM (SELECT ak_txt FROM art WHERE ak_nr = old.ag_aknr) THEN -- Text des alten Artikels im Auftrag?
                    new.ag_postxt:= ak_txt FROM art WHERE ak_nr = new.ag_aknr; -- dann mit Text des neuen Artikels ersetzen.
                END IF;
            END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftg__b_iu__mertner
        BEFORE INSERT OR UPDATE OF
        ag_aknr
        ON auftg
        FOR EACH ROW
        WHEN (new.ag_astat IN ('A', 'E'))
        EXECUTE PROCEDURE auftg__b_iu__mertner();
    --
