/************* KREYENBERG ************/

    --
    CREATE OR REPLACE FUNCTION art__b_i__kreyenberg__bkrohartikel() RETURNS TRIGGER AS $$
      BEGIN
        -- WHEN (new.ak_nr LIKE '%ROH')
        IF TSystem.Settings__Get('KUNDE') = 'KREYENBERG' THEN
            new.ak_stat := COALESCE(new.ak_stat, 'BK');
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER art__b_i__kreyenberg__bkrohartikel
        BEFORE INSERT
        ON art
        FOR EACH ROW
        WHEN (new.ak_nr LIKE '%ROH')
        EXECUTE PROCEDURE art__b_i__kreyenberg__bkrohartikel();
    --

    --
    CREATE OR REPLACE FUNCTION art__b_i__kreyenberg__ak_allg1() RETURNS TRIGGER AS $$
    -- Custom-Trigger für Fa. KREYENBERG z.Thema Prüflevel bei Artikelanlage vorgeben; JM - #9887
      BEGIN
        IF TSystem.Settings__Get('KUNDE') = 'KREYENBERG' THEN
          IF (new.ak_ac IN ('LFT1001', 'MED1001')) THEN
             new.ak_allg1 := '1';
          ELSE
            IF (REGEXP_REPLACE(COALESCE(new.ak_allg1, '2'), '[^0-9]*' ,'0')::INTEGER >= 2) THEN -- wenn leer, String oder zu geringes Level für diese ACs
              IF (new.ak_ac IN ('AUT1001', 'KR_KHS_BA', 'KR_ZFST', 'KR_KHS_VA', 'ART1001')) THEN
                new.ak_allg1 := '2';
              END IF;
            END IF;
          END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER art__b_i__kreyenberg__ak_allg1
        BEFORE INSERT
        ON art
        FOR EACH ROW
        EXECUTE PROCEDURE art__b_i__kreyenberg__ak_allg1();
    --

    -- Kreyenberg #7537, Material-Chargen bereits im Auftrag festlegen
    CREATE OR REPLACE FUNCTION auftg__a_i__90__kreyenberg_charge() RETURNS TRIGGER AS $$
      BEGIN
        -- WHEN (new.ag_astat = 'I') -- Materialbedarf
        IF TSystem.Settings__Get('KUNDE') = 'KREYENBERG' THEN
          IF (SELECT ac_i FROM art JOIN artcod ON ak_ac=ac_n WHERE new.ag_aknr=ak_nr)=3 THEN -- IC 3 = Rohmaterial
            UPDATE auftgmatinfo SET
              agmi_lg_chnr = (SELECT ag_post1 FROM auftg WHERE ag_id = tplanterm.abk_main_auftg_id(new.ag_parentabk))
              WHERE agmi_ag_id = new.ag_id;
          END IF;
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftg__a_i__90__kreyenberg_charge
        AFTER INSERT
        ON auftg
        FOR EACH ROW
        WHEN (new.ag_astat = 'I') -- Materialbedarf
        EXECUTE PROCEDURE auftg__a_i__90__kreyenberg_charge();
    --

    --
    /* Entfernt: https://redmine.prodat-sql.de/issues/19008 2022-10-24
    CREATE OR REPLACE FUNCTION bestanfpos__b_iu__kreyenberg__ks__konto() RETURNS TRIGGER AS $$
      -- #9925; BANF-Pos, zur Prüfung ob Aufwandskonto & Kostenstelle gefüllt sind
      DECLARE infotxt TEXT;
      BEGIN
        IF (TSystem.Settings__Get('KUNDE') IN ('KREYENBERG')) THEN
          IF (new.bap_ks IS NULL) OR (char_length(trim(new.bap_ks)) = 0) THEN           -- Kostenstelle ist leer
            infotxt := lang_text(29297);                                                -- "Kostenstelle ist nicht gepflegt!"
          END IF;

          IF (new.bap_konto IS NULL) OR (char_length(trim(new.bap_konto)) = 0) THEN      -- Aufwandskonto ist leer
            IF (char_length(trim(infotxt)) = 0) THEN
              infotxt := lang_text(29298);                                              -- "Aufwandskonto ist nicht gepflegt!"
            ELSE
              infotxt := infotxt || E'\n' || lang_text(29298);                          -- "Kostenstelle ist nicht gepflegt!"#13"Aufwandskonto ist nicht gepflegt!"
            END IF;
          END IF;

          IF (char_length(trim(infotxt)) > 0) THEN
            PERFORM PRODAT_TEXT(infotxt);  -- Probleme mit pg_notify()
            --RAISE EXCEPTION E'%\n', infotxt;
          END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER bestanfpos__b_iu__kreyenberg__ks__konto
        BEFORE INSERT OR UPDATE
        ON bestanfpos
        FOR EACH ROW
        EXECUTE PROCEDURE bestanfpos__b_iu__kreyenberg__ks__konto();
      */
    --

      CREATE OR REPLACE FUNCTION z_50_customer.ab2__a_z90_iu__kb__pt_vf_markierung()
       RETURNS trigger
       LANGUAGE plpgsql
      AS $function$
        DECLARE
            _vf_grp_list  varchar[];  -- VF-Gruppen
            _marked_color integer;    -- Farbmarkierung des Plantafel-AG
        BEGIN
          -- Trigger zum Markieren von Plantafel-AG, die "VF-konforme" NC-Programme enthalten.

          -- alle definierten VF-Gruppen
          _vf_grp_list :=
                array_agg(
                    DISTINCT ks_kinematic_group || '%'
                )
              FROM ksv
              WHERE nullif( trim( ks_kinematic_group ), '' ) IS NOT NULL
          ;

          -- INSERT, UPDATE: Das aktuelle NC-Programm ist "VF-konform".
          IF new.a2_ncnr LIKE ANY( _vf_grp_list ) THEN

              -- Farbmarkierung des Plantafel-AG auf grell blau setzen.
              _marked_color := 4;

          -- UPDATE: Aktuelles NC-Programm ist nicht mehr "VF-konform".
          ELSIF tg_op = 'UPDATE' THEN

              IF
                  -- NC-Programm war vorher "VF-konform"
                      old.a2_ncnr LIKE ANY( _vf_grp_list )
                  -- und ist es nicht mehr bzw. wurde entfernt.
                  AND (
                          NOT new.a2_ncnr LIKE ANY( _vf_grp_list ) -- Achtung! NOT col LIKE ANY <> col NOT LIKE ANY
                      OR  new.a2_ncnr IS NULL
                  )

              THEN

                  -- Farbmarkierung des Plantafel-AG wieder zurücksetzen.
                  _marked_color := 0;

              END IF;

          END IF;

          -- Aktualisierung der Farbmarkierung des zugehörigen Plantafel-AG-Eintrags.
          IF _marked_color IS NOT NULL THEN

              UPDATE ab2_wkstplan SET
                a2w_marked = _marked_color
              WHERE a2w_a2_id = new.a2_id
                AND a2w_marked IS DISTINCT FROM _marked_color
              ;

          END IF;

          RETURN new;

        END $function$

    --
      CREATE TRIGGER ab2__a_z90_iu__kb__pt_vf_markierung
        AFTER INSERT OR UPDATE OF a2_ncnr
        ON ab2
        FOR EACH ROW
        EXECUTE PROCEDURE z_50_customer.ab2__a_z90_iu__kb__pt_vf_markierung();
    --

    -- Vorschlag der Prüfmittelnummer soll unterbunden werden: https://redmine.prodat-sql.de/issues/19868
    CREATE OR REPLACE FUNCTION z_50_customer.oplpm_mw__mw_pr_pmnr__last_used(
        _mw_id          integer,  -- Ausgangspunkt: die konkrete Prüfung eines Prüfpunkts (oplpm_mw.mw_id)
        OUT oplpm_mw_id integer,  -- ID der anderen Prüfung
        OUT pm_aknr     varchar,  -- Prüfmittel-Artikelnr.
        OUT pr_pmnr     varchar   -- Prüfmittelnummer
      ) RETURNS
      SETOF record
      AS $$
        SELECT null::integer, null::varchar, null::varchar WHERE false
      $$ LANGUAGE sql STABLE;
    --