/************* CIMPCS ****************/

CREATE SCHEMA tredmine_sync;

    --
    CREATE TABLE reisekosten (
      rk_id                         SERIAL PRIMARY KEY,
      rk_tablename                  VARCHAR(50),                    -- Zugehörige HAuptabelle
      rk_dbrid                      VARCHAR,                        -- Auftrag, Projekt oder Adresse
      rk_db_usename                 VARCHAR(30) DEFAULT current_user_ll_db_usename(TRUE) REFERENCES llv(ll_db_usename), -- Betreffender Mitarbeiter
      rk_datum                      DATE DEFAULT current_date,      -- Datum der Abrechnung auf Beleg
      rk_definitiv                  BOOLEAN DEFAULT FALSE,          --Abgeschlossen oder nicht
      rk_apkrzl                     VARCHAR(10),                    -- Ansprechpartner Kunde --Füllen mit Adressparam
      rk_gegenstand                 VARCHAR(200),                   -- Reisegrund --Füllen mit Adressparam
      rk_anf                        DATE NOT NULL DEFAULT current_date,
      rk_anft                       TIME(0) WITHOUT TIME ZONE,      --Abfahrtszeit
      rk_end                        DATE,
      rk_endt                       TIME(0) WITHOUT TIME ZONE,      --Rückkehrzeit
      rk_hinweg                     VARCHAR(100),                   -- Hinfahrtweg --Selbstlernendes F2
      rk_ruckweg                    VARCHAR(100),                   -- Rückfahrtweg --Selbstlernendes F2
      rk_zug_hinweg                 BOOLEAN DEFAULT FALSE,          -- Zugfahrt Ja/Nein
      rk_zug_ruckweg                BOOLEAN DEFAULT FALSE,          -- Zugfahrt Ja/Nein
      rk_kostenunt                  NUMERIC(7,2),                   -- Übernachtungskosten
      rk_kostensonst                NUMERIC(7,2),                   -- Sonstige Kosten
      rk_txt                        TEXT,                           -- Anlagen
      rk_zutxt                      TEXT,                           -- Zusatztext Intern
      rk_kfz                        VARCHAR,                        -- Fahrtkosten (PKW): 'Ja' bzw. 'KFZ lt. Vertrag UEB2015-04'
      rk_kfzkz                      VARCHAR,                        -- amtliches Kennzeichen
      rk_km                         SMALLINT                        -- Gefahrene km (Privat-Pkw)
    );
    --

    CREATE OR REPLACE FUNCTION bdep__a_99_iu__cimpcs__checktimes()
      RETURNS trigger AS $$
      DECLARE
          _anwesenheits_zeit numeric(12,2);
          _arbeits_zeit      numeric(12,2);
      BEGIN

          _anwesenheits_zeit :=
              sum( mpl_saldo )
              FROM mitpln
              WHERE
                    mpl_minr = new.bd_minr
                AND mpl_date BETWEEN current_date - 5 AND current_date - 1
          ;

          _arbeits_zeit :=
              sum( ba_efftime )
              FROM bdea
              WHERE
                    ba_minr = new.bd_minr
                AND ba_anf BETWEEN current_date - 5 AND current_date - 1
          ;

          IF ( _anwesenheits_zeit = 0 ) THEN
              RETURN new;
          END IF;

          -- es müssen mindestens 70% der Arbeitszeit gestempelt sein
          IF ( _arbeits_zeit / _anwesenheits_zeit  * 100 ) < 70
          THEN
              -- Zu wenig Redmine Zeit (Letzte 5 Tage). Zeiten nachtragen. Soll: 70%%;       Ist: Präsenzzeit: %, Aufrtagszeit: % = % %%
                  RAISE EXCEPTION '%',
                    Format(
                      lang_text( 29188 ) ,
                      _anwesenheits_zeit,
                      _arbeits_zeit,
                      round( _arbeits_zeit / _anwesenheits_zeit * 100 , 2 )
                  );
          END IF;

          IF
                _arbeits_zeit IS NULL
            AND _anwesenheits_zeit > 10
          THEN
               -- Zu wenig Redmine Zeit (Letzte 5 Tage). Zeiten nachtragen. Soll: 70%%
              RAISE EXCEPTION '%', lang_text( 29189 );
          END IF;

          RETURN new;

      END $$ LANGUAGE plpgsql;



      -- DROP TRIGGER IF EXISTS bdep__a_99_iu__cimpcs__checktimes ON bdep;
      CREATE TRIGGER bdep__a_99_iu__cimpcs__checktimes
        AFTER INSERT OR UPDATE
        OF bd_anf
        ON bdep
        FOR EACH ROW
        WHEN (
               new.bd_anf::date BETWEEN current_date - 5 AND current_date
          AND  new.bd_minr <> 999
        ) EXECUTE PROCEDURE bdep__a_99_iu__cimpcs__checktimes();
    --    


CREATE OR REPLACE FUNCTION tredmine_sync.bdea__efftime__calculate(
    IN _bdea bdea
    )  
    RETURNS numeric
    AS $$
       SELECT _bdea.ba_efftime * coalesce(CASE WHEN
                                                  _bdea.ba_o2k_id = 10 THEN 1      --vor Ort
                                              WHEN
                                                  _bdea.ba_minr = 987 THEN 1.90    --DS
                                              WHEN
                                                  _bdea.ba_minr IN (508, 518) THEN 1.75    --STA, PW
                                              WHEN
                                                  _bdea.ba_minr = 507 THEN 1     --OG
                                         END
                                         , 1.34
                                        )
    $$ LANGUAGE sql STABLE;


CREATE OR REPLACE FUNCTION tredmine_sync.abk__parent_id( _ab_ix integer ) RETURNS int AS $$

      WITH RECURSIVE _tree AS (

          SELECT
            abk.ab_ix,
            abk.ab_parentabk,
            abk.ab_stat,
            array[ abk.ab_ix ] abk_path,
            array[ abk.ab_stat::text ] stat_path
          FROM abk
          WHERE ab_ix = _ab_ix

          UNION

          SELECT
              abk.ab_ix,
              abk.ab_parentabk,
              abk.ab_stat,
              _tree.abk_path || abk.ab_ix,
              _tree.stat_path || abk.ab_stat::text
          FROM abk
          JOIN _tree ON abk.ab_ix = _tree.ab_parentabk

      )

      SELECT ab_ix
      FROM _tree
      WHERE
           -- Teilprojekt oder Projekt ist die übergeordnete ABK
           tsystem.enum_getvalue( lower(ab_stat), 'p' )
        OR tsystem.enum_getvalue( lower(ab_stat), 'tp' )
           -- das ist der kürzeste Weg => somit die übergeordnete!
      ORDER BY abk_path
      LIMIT 1

  $$ LANGUAGE sql STABLE;




CREATE OR REPLACE FUNCTION tredmine_sync.db_test() RETURNS text
    LANGUAGE plpgsql STABLE
    AS $$
BEGIN
    RETURN 'host=redmine.prodat-sql.de dbname=redmine port=5433 user=postgres password=sysdba';
  END $$;


CREATE OR REPLACE FUNCTION tredmine_sync.syncro(
    _start_datum date,
    _end_datum date
) RETURNS void AS $$
  DECLARE
      _sql  varchar;
  BEGIN

      -- Rufe Synchronisierungsfunktion von Redmine.
      _sql := format(
          'PERFORM tcimpcs.syncro( '            ||
          '             _start_datum  => %L, '  ||
          '             _end_datum    => %L '   ||
          ');',
          --
          _start_datum,
          _end_datum
      );
      PERFORM * FROM dblink( tredmine_sync.db_test(), _sql ) AS t1( test text );

  END $$ LANGUAGE plpgsql;  