SELECT true;

/*
CREATE OR REPLACE FUNCTION x_20_mobile.views__drop() RETURNS void AS $$
  BEGIN

      DROP VIEW IF EXISTS x_20_mobile.abk__ab2__ksv__open__pos;
      DROP VIEW IF EXISTS x_20_mobile.abk_laufend__master;
      DROP VIEW IF EXISTS x_20_mobile.abk_laufend__detail;
      DROP VIEW IF EXISTS x_20_mobile.wawi__art__mbc;

      DROP VIEW IF EXISTS x_20_mobile.wawi__auftg_posext__master;
      DROP VIEW IF EXISTS x_20_mobile.wawi__auftg_posext__detail;

      DROP VIEW IF EXISTS x_20_mobile.wawi__inv__iv_edat_is_null;
      DROP VIEW IF EXISTS x_20_mobile.wawi__invlag__art;

      DROP VIEW IF EXISTS x_20_mobile.wawi__ldsdok__list_open__agg__pos;
      DROP VIEW IF EXISTS x_20_mobile.wawi__ldsdok__list_open__pos;

      DROP VIEW IF EXISTS x_20_mobile.wawi__liefsch__belp_termin__isnull;

      RETURN;

  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION x_20_mobile.views__recreate() RETURNS void AS $$
  BEGIN

      CREATE OR REPLACE VIEW x_20_mobile.abk__ab2__ksv__open__pos AS
         SELECT
            abk.dbrid AS dbrid_abk,
            ab_ix,                                -- ABK Index
            pa.p_aknr,                            -- Artikelnummer
            pa.p_aknr_idx,                        -- Artikelindex
            art.ak_bez AS p_akbez,                -- Artikelbezeichnung
            ka.p_adkrz,                           -- Kurzname Kunde
            a2_n,                                 -- Arbeitsgang
            ks_abt ,                              -- Kostenstelle-Ident
            ks_bks,                               -- Kostenstellen-Bezeichnung
            ks_mitnc,                             -- NC-Programm erforderlich
            false AS tooling_sheet_available,     -- Dummy Einrichteblatt vorhanden: Ja/Nein : SQL Function
            TDMS.Dokument__pd_id__standard_pd_print__by__dbrid(art.dbrid) AS pic_id_std,                 -- Dokument-ID Vorschaudkoment
            TDMS.Dokument__pd_id__by__pd_dbrid__pd_doktype(art.dbrid, 'zeichnung') AS pic_id_zeichnung,  -- Dokument-ID nur Zeichnung
            art.dbrid  AS dbrid_art
           FROM abk
             LEFT JOIN ab2            ON a2_ab_ix = ab_ix                                       -- JOIN Arbeitsgänge
             LEFT JOIN TWawi.Ldsdok_pos pa ON p_ab_ix = ab_ix                                   -- JOIN Produktionsauftrag
             LEFT JOIN twawi.Auftg_Pos  ka ON ka.p_id = tplanterm.abk_main_auftg_id(pa.p_ab_ix) -- JOIN Kundenauftrag
             LEFT JOIN art ON ak_nr = COALESCE(ab_ap_nr, pa.p_aknr)                             -- JOIN Artikel
             LEFT JOIN ksv ON a2_ks = ks_abt                                                    -- JOIN Maschine / Kostenstelle
           WHERE pa.p_code = 'I'   -- Produktionsaufträge
             AND NOT pa.p_done     -- keine erledigten Produktionsaufträge
             AND NOT a2_ende       -- keine erledigten Arbeistgänge ~ Kostenstellen
             AND NOT ks_ausw       -- keine Auswärtskostenstellen
           ORDER BY ab_ix, a2_n
      ;

      CREATE OR REPLACE VIEW x_20_mobile.abk_laufend__master AS
          SELECT
              abk.ab_ix,
              ldsdok.ld_auftg,
              subdata.ak_nr,
              subdata.ak_bez,
              abk.ab_st_uf1,
              ldsdok.ld_stk_uf1 - ldsdok.ld_stkl AS offen,
              tplanterm.abk_proz_fertig(abk.ab_ix) AS abk_proz_fertig,
              COALESCE (
                  to_char(ld_termv, 'DD.MM.YY'),                        -- Verschobener Liefertermin
                  COALESCE(to_char(ldTermDate, 'DD.MM.YY'), ldTermWeek) -- ... oder Ist- / Soll- / ABK-Termin
              )::VARCHAR(10) AS liefterm , -- angezeigtes Lieferdatum

              ksv_array
             FROM abk
               LEFT JOIN ldsdok ON ldsdok.ld_abk = abk.ab_ix
               LEFT JOIN art ON art.ak_nr::text = COALESCE(abk.ab_ap_nr, ldsdok.ld_aknr)::text
               LEFT JOIN LATERAL ( SELECT COALESCE(ldsdok.ld_terml, ldsdok.ld_term, abk.ab_et) AS ldtermdate,
                      COALESCE(ldsdok.ld_termweekl, ldsdok.ld_termweek, termweek(abk.ab_et::timestamp without time zone)::character varying) AS ldtermweek,
                      COALESCE(ldsdok.insert_by, abk.insert_by) AS insert_by,
                      COALESCE(abk.ab_ap_nr, ldsdok.ld_aknr) AS ak_nr,
                      COALESCE(abk.ab_ap_bem, ldsdok.ld_akbz, art.ak_bez) AS ak_bez,
                      COALESCE(ldsdok.ld_done, false) OR abk.ab_done AS isdone,
                      ( SELECT qab_1.q_nr
                             FROM qab qab_1
                            WHERE qab_1.q_nr::text = abk.ab_keyvalue::text AND qab_1.dbrid::text = abk.ab_dbrid::text
                            ORDER BY qab_1.q_nr
                           LIMIT 1) AS abk_q_nr) subdata ON true
               LEFT JOIN qab ON qab.q_nr = ldsdok.ld_q_nr OR qab.q_nr = subdata.abk_q_nr
               LEFT JOIN artcod ON art.ak_ac::text = artcod.ac_n::text
               LEFT JOIN LATERAL (
                  select array_agg( a2_ks ) as ksv_array FROM ab2 where a2_ab_ix = abk.ab_ix and a2_ende is false
               ) _tmp ON true
            WHERE
                     (
                         COALESCE(week_of_year(subdata.ldtermdate), subdata.ldtermweek)
                      <= termweek( ('now'::date + TSystem.Settings__GetInteger('Assistent_TFormAssFert_DayLimit', 10) ) )
                      OR COALESCE(ldsdok.ld_terml, ldsdok.ld_term, abk.ab_et) IS NULL
                  )
                  AND NOT subdata.isdone
                  AND coalesce( ldsdok.ld_code, 'I') = 'I'
                  AND (abk.ab_ld_id IS NOT NULL OR abk.ab_keyvalue = qab.q_nr)
                  AND coalesce( abk.ab_stat !~~ 'QD%', true  )
                  and ab_done is false

            ORDER BY (COALESCE(termweek(subdata.ldtermdate::timestamp without time zone)::character varying, subdata.ldtermweek)), subdata.ldtermdate NULLS FIRST, abk.ab_ix
      ;

      CREATE OR REPLACE VIEW x_20_mobile.abk_laufend__detail AS
            SELECT
                a2_ab_ix
                ,a2_n
                ,a2_at, a2_et
                ,a2_th, a2_tr
                ,a2_ks, ks_bks, ks_bz
                ,a2_ausw
                ,a2_ende
                ,((EXISTS(SELECT true FROM bdea WHERE ba_ix=a2_ab_ix AND a2_n=ba_op) OR EXISTS(SELECT true FROM ldsdok WHERE ld_a2_id=a2_id)) AND NOT a2_ende) AS a2_ende_cimgreen
            FROM ab2
            LEFT JOIN ab2_wkstplan ON a2_id=a2w_a2_id
            LEFT JOIN ksv ON ks_abt=COALESCE(a2w_oks, a2_ks)
            ORDER BY a2_ab_ix, a2_n
      ;

      CREATE OR REPLACE VIEW x_20_mobile.wawi__art__mbc AS
           SELECT art.ak_nr,
              art.ak_bez,
              COALESCE(lang_artmgc_id(art.ak_standard_mgc::integer, curr_lang()), ''::character varying) AS mengenbez
             FROM art
            ORDER BY art.ak_nr
      ;

      CREATE OR REPLACE VIEW x_20_mobile.wawi__auftg_posext__master AS
           SELECT auftg_posext.p_nummer,
              auftg_posext.p_adkrz,
              adressename(auftg_posext.p_adkrz) AS adressename,
              auftg_posext.p_datum_istsoll,
              count(1) AS p_pos__count,
              string_agg(DISTINCT auftg_posext.p_aknr::text, '; '::text)::character varying(250) AS p_aknr__agg
             FROM twawi.auftg_posext
            WHERE NOT auftg_posext.p_done AND auftg_posext.p_code::text = 'E'::text
            GROUP BY auftg_posext.p_nummer, auftg_posext.p_adkrz, (adressename(auftg_posext.p_adkrz)), auftg_posext.p_datum_istsoll
            ORDER BY auftg_posext.p_datum_istsoll NULLS FIRST, auftg_posext.p_nummer
      ;



      CREATE OR REPLACE VIEW x_20_mobile.wawi__auftg_posext__detail AS
           SELECT auftg_posext.dbrid,
              auftg_posext.p_nummer,
              auftg_posext.p_pos,
              auftg_posext.p_aknr,
              art.ak_bez,
              art.ak_mat,
              art.ak_znr,
              auftg_posext.p_menge,
              auftg_posext.p_meiso,
              auftg_posext.p_mengeo,
              auftg_posext.p_datum_istsoll,
              auftg_posext.p_status
             FROM twawi.auftg_posext
               LEFT JOIN art ON art.ak_nr::text = auftg_posext.p_aknr::text
            WHERE NOT auftg_posext.p_done AND auftg_posext.p_code::text = 'E'::text
            ORDER BY auftg_posext.p_datum_istsoll NULLS FIRST, auftg_posext.p_pos
      ;


      CREATE OR REPLACE VIEW x_20_mobile.wawi__inv__iv_edat_is_null AS
           SELECT inv.iv_nr,
              inv.iv_bdat,
              inv.iv_edat,
              inv.iv_txt
             FROM inv
            WHERE inv.iv_edat IS NULL
            ORDER BY inv.iv_bdat, inv.iv_nr
      ;


      CREATE OR REPLACE VIEW x_20_mobile.wawi__invlag__art AS
           SELECT invlag.il_id,
              invlag.il_iv_nr,
              invlag.il_aknr,
              invlag.il_lg_id,
              invlag.il_txt,
              invlag.il_txt_rtf,
              invlag.il_ort,
              invlag.il_anztot,
              invlag.il_anzist,
              invlag.il_mce,
              invlag.il_zaedat,
              invlag.il_konsdat,
              invlag.il_konsende,
              invlag.il_chnr,
              invlag.il_dim1,
              invlag.il_dim2,
              invlag.il_dim3,
              invlag.il_sperr,
              invlag.il_regalsta,
              invlag.il_delete,
              invlag.il_ak_vkpbas,
              invlag.il_ak_hest,
              invlag.il_sernrstring,
              invlag.dbrid,
              invlag.insert_date,
              invlag.insert_by,
              invlag.modified_date,
              invlag.modified_by,
              invlag.il_ak_hest / do1if0(art.ak_gewicht) AS il_ak_hest_kg,
              invlag.il_ak_vkpbas / do1if0(art.ak_gewicht) AS il_ak_vkpbas_kg,
              art.ak_bez,
              art.ak_ac,
              art.ak_dim,
              art.ak_such,
              art.ak_mat,
              art.ak_slort,
              art.ak_znr,
              art.ak_sernrreq,
              art.ak_chnrreq,
              art.ak_konsreq,
              COALESCE(lang_artmgc_id(invlag.il_mce, curr_lang()), ''::character varying) AS mengenbez
             FROM invlag
               JOIN art ON invlag.il_aknr::text = art.ak_nr::text
            ORDER BY invlag.il_aknr
      ;

      CREATE OR REPLACE VIEW x_20_mobile.wawi__ldsdok__list_open__agg__pos AS
           SELECT ldsdok_posext.p_nummer,
              ldsdok_posext.p_adkrz,
              adressename(ldsdok_posext.p_adkrz) AS adressename,
              ldsdok_posext.p_datum_istsoll,
              count(1) AS p_pos__count,
              string_agg(DISTINCT ldsdok_posext.p_aknr::text, '; '::text)::character varying(250) AS p_aknr__agg
             FROM twawi.ldsdok_posext
            WHERE true AND NOT ldsdok_posext.p_done AND COALESCE(ldsdok_posext.p_datum_istsoll, 'now'::text::date) <= ('now'::text::date + 7) AND ldsdok_posext.p_code::text = 'E'::text
            GROUP BY ldsdok_posext.p_nummer, ldsdok_posext.p_adkrz, (adressename(ldsdok_posext.p_adkrz)), ldsdok_posext.p_datum_istsoll
            ORDER BY ldsdok_posext.p_datum_istsoll NULLS FIRST
      ;

      CREATE OR REPLACE VIEW x_20_mobile.wawi__ldsdok__list_open__pos AS
           SELECT ldsdok_posext.dbrid,
              ldsdok_posext.p_nummer,
              ldsdok_posext.p_dokunr,
              ldsdok_posext.p_pos,
              ldsdok_posext.p_aknr,
              art.ak_bez,
              art.ak_mat,
              art.ak_znr,
              ldsdok_posext.p_menge,
              ldsdok_posext.p_meiso,
              tartikel.me__menge_uf1__in__menge(ldsdok_posext.p_me, ldsdok_posext.p_mengel_gme) AS p_mengel,
              ldsdok_posext.p_mengeo,
              ldsdok_posext.p_datum_istsoll,
              ldsdok_posext.p_status
             FROM twawi.ldsdok_posext
               LEFT JOIN art ON art.ak_nr::text = ldsdok_posext.p_aknr::text
            WHERE true AND ldsdok_posext.p_code::text = 'E'::text AND NOT ldsdok_posext.p_done
            ORDER BY ldsdok_posext.p_datum_istsoll NULLS FIRST, ldsdok_posext.p_pos
      ;


      CREATE OR REPLACE VIEW x_20_mobile.wawi__liefsch__belp_termin__isnull AS
           SELECT lieferschein.beld_id,
              lieferschein.beld_dokunr,
              lieferschein.beld_erstelldatum,
              lieferschein.beld_definitiv,
              lieferschein.beld_print,
              lieferschein_pos.belp_aknr,
              COALESCE(lieferschein_pos.belp_akbez, art.ak_bez) AS akbez,
              lieferschein_pos.belp_menge,
              lang_artmgc_id(lieferschein_pos.belp_mce, curr_lang()) AS lang_artmgc_id,
              array_to_string(ARRAY( SELECT DISTINCT lifsch.l_ldat
                     FROM lifsch
                    WHERE lifsch.l_belp_id = lieferschein_pos.belp_id
                    ORDER BY lifsch.l_ldat), ', '::text)::character varying(120) AS l_ldat,
              array_to_string(ARRAY( SELECT DISTINCT lifsch.l_akdat
                     FROM lifsch
                    WHERE lifsch.l_belp_id = lieferschein_pos.belp_id
                    ORDER BY lifsch.l_akdat), ', '::text)::character varying(120) AS l_akdat,
              lieferschein_pos.belp_krzlieferung,
              adressebez(lieferschein_pos.belp_krzlieferung) AS l_krzl_name,
              auftg.ag_astat,
              auftg.ag_nr,
              auftg.ag_pos,
              COALESCE(lieferschein.beld_apint, lieferschein.insert_by) AS beld__lieferschein__insert_by,
              nameaufloesen(COALESCE(lieferschein.beld_apint, lieferschein.insert_by)) AS beld__lieferschein__insert_by_name,
              lieferschein.beld_kopftext,
              lieferschein.beld_fusstext,
              lieferschein.beld_versandart,
              lieferschein.beld_versandartbem,
              ( SELECT picndoku.pd_id
                     FROM picndoku
                    WHERE picndoku.pd_dokident::text = lieferschein.beld_dokunr::text AND picndoku.pd_doktype::text = 'lfs'::text
                    ORDER BY picndoku.pd_id DESC
                   LIMIT 1) AS pd_id,
              auftg.ag_ldatum,
              auftg.ag_aldatum,
              adk1.a1_tolfrueh,
              adk1.a1_tolspaet,
              timediff_addsubstdays(COALESCE(auftg.ag_ldatum, auftg.ag_kdatum)::timestamp without time zone, ('-1'::integer * adk1.a1_tolfrueh)::numeric, true) AS ldatumfr,
              timediff_addsubstdays(COALESCE(auftg.ag_ldatum, auftg.ag_kdatum)::timestamp without time zone, adk1.a1_tolspaet::numeric, true) AS ldatums,
              lieferschein.dbrid,
              'lieferschein'::character varying(50) AS menu_tablename,
              get_record_has_note(lieferschein.dbrid) AS get_record_has_note
             FROM lieferschein
               JOIN lieferschein_pos ON lieferschein_pos.belp_dokument_id = lieferschein.beld_id
               JOIN belegart ON belegart.bela_id = lieferschein.beld_belegart
               LEFT JOIN auftg ON lieferschein_pos.belp_ag_id = auftg.ag_id
               LEFT JOIN art ON lieferschein_pos.belp_aknr::text = art.ak_nr::text
               LEFT JOIN adk1 ON adk1.a1_krz::text = lieferschein.beld_krzbesteller::text
            WHERE lieferschein_pos.belp_termin IS NULL AND lieferschein.beld_belegtyp::text = 'LFS'::text AND lieferschein.beld_belegart = 3 AND lieferschein.beld_erstelldatum > ('now'::text::date - 90)
            ORDER BY lieferschein.beld_erstelldatum, lieferschein.beld_dokunr, lieferschein_pos.belp_pos
      ;

      RETURN;

  END $$ LANGUAGE plpgsql;

*/