﻿# PRODAT-ERP  https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/4400_Python
#
# 2011-05-08: Code von Daniel Schuchardt
# 2019-05-20: Code aufgeräumt inkl. Bugfix für String-Quoting der SQL-Generierung (Anführungsstriche in Value-Variablen, wie z.B. Artikelnummern mit Index)
#             Ersatz für altes Script ohne Bugfix : siehe TFrameBt.EscapePythonString

# alter Name      aktueller Name                               Beschreibung
# ----------      --------------                               ------------
#
#                 parser_push()                                die aktuellen Parsereinstellungen speichern (Operator/ValueOperator/ValuesInStatement)
#                 parser_pop()                                 die letzten Parsereinstellungen wiederherstellen
#
#                 escape_string(value)                         escape SQL-Value (nur String)
#                 escape_value(value)                          escape SQL-Value (Integer oder String)
#                 escape_name(name)                            escape SQL-Name
#
# sql_value       get_value(field, value)                      Vergleich generieren                      ->  result = "(field) LIKE ('value')"
#                 add_and(field, value)                        Vergleich mit AND anhängen                ->  result = "# AND " + "(field) LIKE ('value')"
#                 add_or(field, value)                         Vergleich mit OR anhängen                 ->  result = "# OR "  + "(field) LIKE ('value')"
#                 add_between(field, value1, value2)           Bereich mit AND anhängen                  ->  result = "# AND " + "field BETWEEN value1 AND value2"
#                 add_between_or(field, value1, value2)        Bereich mit OR anhängen                   ->  result = "# OR "  + "field BETWEEN value1 AND value2"
# keywordsearch   get_keywordsearch(tablename, keywordlist)    Schlüsselwortesuche generieren            ->  result = "EXISTS(SELECT true FROM recnokeyword WHERE ...)"
#
#                 get_value/add_and/add_or(field, value)       WENN: Sql.Operator = '<='                 ->  result = "(field) <= ('value')"
#                                                              WENN: Sql.ValuesInStatement = 0           ->  result = "(field) LIKE (:value)"
#                                                              WENN: Sql.ValueOperator = 'AEOEUE_UPPER'  ->  result = "AEOEUE_UPPER(field) LIKE AEOEUE_UPPER('value')" 
#
#                 sql_add(string_to_add)                       Text ans SQL anhängen                              ->  sql = "sql add"
#                 custom_sql_add(string_to_add)                Text in neuer Zeile ans SQL anhängen               ->  sql = "sql # add"
#                 custom_sql_add_and(string_to_add)            Text mit AND ans SQL anhängen                      ->  sql = "sql # AND # add"
# add_where       sql_add_where()                              WHERE ins SQL einfügen, falls etwas vorhanden ist  ->  sql = "# WHERE # sql"
#
# "#"             = Zeilenumbruch
# "xxx" + "..."   = xxx ist optional/abhängig

class PySqlParse:
    Version = 1.2
    Modified = 0
    sql = ''
    
    # Parse-Beeinflussendes
    ValuesInStatement = 1  # = vordefiniert false, wird über Parameter von Delphi aus gemacht
    Operator = 'LIKE'
    ValueOperator = ''
    __oldValuesInStatement = []
    __oldOperator = []
    __oldValueOperator = []

    # die aktuellen Parsereinstellungen speichern / die Letzten wiederherstellen
    def parser_push(self):  # Aktuelles in die Liste legen
        self.__oldValuesInStatement.append(self.ValuesInStatement)
        self.__oldOperator.append(self.Operator)
        self.__oldValueOperator.append(self.ValueOperator)

    def parser_pop(self):  # Letztes von der Liste holen und dort löschen
        self.ValuesInStatement = self.__oldValuesInStatement.pop()
        self.Operator = self.__oldOperator.pop()
        self.ValueOperator = self.__oldValueOperator.pop()

    # Strings escapen/quoten
    def escape_string(self, value):  # escape SQL-Value (nur String)
        #return repr(str(value))
        return "'" + value.replace('\\', '\\\\').replace("'", "\\'").replace('\"', '\\"') + "'"

    def escape_value(self, value):  # escape SQL-Value (Integer oder String)
        #return repr(value)
        if value.lstrip('-+').isdigit() :
            return str(value)
        else :
            return self.escape_string(value)

    def escape_name(self, name):  # escape SQL-Name
        return '"' + name + '"'

    # Funktion die Vergleich erstellt  ->  result = "UPPER(field) LIKE UPPER('value')"  oder  "UPPER(field) LIKE UPPER(:value)"
    def get_value(self, field, value):
        result = ''

        if not (value=='') and not (value=='00000000') :   # es gibt Inhalt für dieses Feld
            result = result + self.ValueOperator + '(' + field + ') ' + self.Operator + ' '
            if self.ValuesInStatement :
                result = result + self.ValueOperator + '(' + self.escape_string(value) + ')'
            else :
                result = result + self.ValueOperator + '(:' + field + ')'

        return result

    def sql_value(self, field, value):  # alter Name
        return self.get_value(field, value)

    # Funktion die Felder mit AND einarbeitet  ->  result = "# AND " + "UPPER(field) LIKE UPPER('value')"  oder  "# AND " + "UPPER(field) LIKE UPPER(:value)"
    def add_and(self, field, value):
        result = self.get_value(field, value)

        if not ((result=='') or (self.sql=='')) :
            result = '\nAND ' + result  # es gibt schon Einschränkungen, dann diese dran

        return result

    # Funktion die Felder mit OR einarbeitet  ->  result = "# OR " + "UPPER(field) LIKE UPPER('value')"  oder  "# OR " + "UPPER(field) LIKE UPPER(:value)"
    def add_or(self, field, value):
        result = self.get_value(field, value)

        if not ((result=='') or (self.sql=='')) :
            result = '\nOR ' + result  # es gibt schon Einschränkungen, dann diese dran

        return result

    # Funktion die 2 Felder mit BETWEEN einarbeitet  ->  result = "# AND " + "field BETWEEN value1 AND value2"
    def add_between(self, field, value1, value2):
        if (value1=='00000000') :  # kein Inhalt vorhanden
            value1=''
        if (value2=='00000000') :
            value2 = ''

        if (value1=='') :  # andere Seite auffüllen, wenn einer der beiden Werte leer ist
            value1 = value2
        if (value2=='') :
            value2 = value1

        result1 = self.get_value(field, value1)  # nur für Test ob leer
        result2 = self.get_value(field, value2)

        result = ''

        if not ((result1=='') or (result2=='')) :
            if not (self.sql=='') : result = '\nAND '  # es gibt schon Einschränkungen, dann diese dran
            result = result + field + ' BETWEEN ' + self.escape_string(value1) + ' AND ' + self.escape_string(value2)

        return result

    # Funktion die 2 Felder mit BETWEEN einarbeitet  ->  result = "# OR " + "field BETWEEN value1 AND value2"
    def add_between_or(self, field, value1, value2):
        if (value1=='00000000') :  # kein Inhalt vorhanden
            value1=''
        if (value2=='00000000') :
            value2 = ''

        if (value1=='') :  # andere Seite auffüllen, wenn einer der beiden Werte leer ist
            value1 = value2
        if (value2=='') :
            value2 = value1

        result1 = self.get_value(field, value1)  # nur für Test ob leer
        result2 = self.get_value(field, value2)

        result = ''

        if not ((result1=='') or (result2=='')) :
            if not (self.sql=='') : result = '\nOR '  # es gibt schon Einschränkungen, dann diese dran
            result = result + field + ' BETWEEN ' + self.escape_string(value1) + ' AND ' + self.escape_string(value2)

        return result

    # Funktion die Schlüsselworte in das Sql-Statement anhängt  ->  result = "EXISTS(SELECT true FROM recnokeyword WHERE ...)"
    def get_keywordsearch(self, tablename, keywordlist):
        result = ''
        if keywordlist==[] :
            return result

        result = result + 'EXISTS (SELECT true FROM recnokeyword WHERE r_tablename=' + self.escape_string(tablename) + ' AND r_dbrid=' + tablename + '.dbrid\n'
        result = result + '  AND (\n'

        self.parser_push()
        self.Operator = 'LIKE'
        self.ValueOperator = 'AEOEUE_UPPER'
        self.ValuesInStatement = 1

        for I in range(len(keywordlist)) :  # alle gegebenen Schlüsselworte durchlaufen und aus jedem ein Statement der Where-Clause machen
            if I==0 :
                result = result + '    ' + self.get_value('r_descr', keywordlist[I]) + '\n'  # das erste steht hinter dem gesamten AND deshalb hier kein Verknüpfungsoperator
            else :
                if self.sql=='' : result = result + '    OR\n'  # es gibt schon Einschränkungen, dann diese dran
                result = result + '    ' + self.add_or('r_descr', keywordlist[I]) + '\n'  # das wird "schlüsselfeld LIKE schlüsselwort"

        self.parser_pop()

        result = result + '  )\n'  # AND (...)
        result = result + ')\n'  # EXISTS(...)
        return result

    def keywordsearch(self, tablename, keywordlist):  # alter Name
        return self.get_keywordsearch(tablename, keywordlist)

    # Funktion die dem bestehenden Sql-String etwas anhängt  ->  sql = "sql add"
    def sql_add(self, string_to_add):
        if string_to_add=='' :
            return

        self.sql = self.sql + ' ' + string_to_add
        self.Modified = 1

    # Funktion die dem bestehenden Sql-String etwas anhängt  ->  sql = "sql # add"
    def custom_sql_add(self, string_to_add):
        if string_to_add=='':
            return

        if not ((string_to_add=='') or (self.sql=='')) :
            string_to_add = '\n' + string_to_add  # es gibt schon Einschränkungen, dann diese dran

        self.sql = self.sql + string_to_add
        self.Modified = 1

    # Funktion die dem bestehenden Sql-String etwas mittels AND anhängt  ->  sql = "sql # AND # add"
    def custom_sql_add_and(self, string_to_add):
        if string_to_add=='':
            return

        if not ((string_to_add=='') or (self.sql=='')) :
            string_to_add = '\nAND ' + string_to_add  # es gibt schon Einschränkungen, dann diese dran

        self.sql = self.sql + string_to_add
        self.Modified = 1

    # Funktion die WHERE vor alle Einschränkungen schreibt, wenn welche vorhanden sind  ->  sql = "# WHERE # sql"
    def sql_add_where(self):
        if self.Modified :
            self.sql = '\nWHERE ' + self.sql

    def add_where(self):  # alter Name
        return self.sql_add_where()
