--
--------------------------------------------------------------------------------
-- CUSTOMER CNC
-- CHECKS  ---------------------------------------------------------------------
--

-------------------------------
-- example:
-- CREATE OR REPLACE FUNCTION z_50_customer.secpol_customer_check_(IN row_data <TABLE>, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD


--
--------------------------------------------------------------------------------
-- CUSTOMER CNC
-- TRIGERS ---------------------------------------------------------------------
--

-- CNC Spezische alte Spalte erhalten und spiegeln!
CREATE OR REPLACE FUNCTION z_50_customer.art__a_900__iu__copy_exact__ak_allgb2__cnc() RETURNS TRIGGER
  AS $$
  BEGIN
    IF new.ak_allgb2 IS DISTINCT FROM old.ak_allgb2 THEN
        new.ak_copy_exact := new.ak_allgb2;
    END IF;
    IF new.ak_copy_exact IS DISTINCT FROM old.ak_copy_exact THEN
        new.ak_allgb2 := new.ak_copy_exact;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS art__a_900__iu__copy_exact__ak_allgb2__cnc ON art;
CREATE TRIGGER art__a_900__iu__copy_exact__ak_allgb2__cnc
  BEFORE INSERT OR UPDATE OF ak_copy_exact, ak_allgb2
  ON art
  FOR EACH ROW
  EXECUTE PROCEDURE z_50_customer.art__a_900__iu__copy_exact__ak_allgb2__cnc();


-------------------------------
-- example:
-- DROP TRIGGER IF EXISTS <TABLE>__b_999_iud__secpol_customer_check ON <TABLE>;
-- CREATE TRIGGER <TABLE>__b_999_iud__secpol_customer_check
--   BEFORE INSERT
--   ON <TABLE>
--   FOR EACH ROW
--   EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_customer_check();
