CREATE TABLE sun_erfbogen
 (s_eb_id               SERIAL PRIMARY KEY,
  s_eb_kanf_nr          VARCHAR(20) NOT NULL REFERENCES kundanfrage ON UPDATE CASCADE,--Verlinkung zur Kundenanfrage (Adresse, Kontaktdaten usw)
  s_eb_tanlage          VARCHAR(20) DEFAULT current_date,--
  s_eb_str              VARCHAR(50),
  s_eb_plz              VARCHAR(30),
  s_eb_ort              VARCHAR(50),
  s_eb_objekttyp        VARCHAR(30),
  s_eb_denkmal          BOOL DEFAULT FALSE,
  s_eb_neubaujahr       SMALLINT,
  s_eb_dach_arteind     VARCHAR(100),
  s_eb_dach_first       NUMERIC(12,4),
  s_eb_dach_traufe      NUMERIC(12,4),
  s_eb_geru_kunde       BOOL NOT NULL DEFAULT FALSE,
  s_eb_geru_lieferant   BOOL NOT NULL DEFAULT TRUE,
  s_eb_geru_bem         VARCHAR(75),
  s_eb_bem1             TEXT,
  s_eb_dach_orient      NUMERIC(12,4),
  s_eb_dach_sued        NUMERIC(12,4),
  s_eb_dach_art         VARCHAR(100),
  s_eb_dach_neig        NUMERIC(12,4),
  s_eb_dach_schatt      VARCHAR(50),
  s_eb_dach_sonst       TEXT,
  s_eb_anl_minkwp       NUMERIC(12,4),
  s_eb_anl_jaenergie    NUMERIC(12,4),
  s_eb_anl_minflache    NUMERIC(12,4),
  s_eb_anl_everbauch    NUMERIC(12,4),
  s_eb_anl_monkost      NUMERIC(12,4),
  s_eb_anl_modeinbau    VARCHAR(100),
  s_eb_wr_ort           VARCHAR(50),
  s_eb_wr_blitz         BOOL NOT NULL DEFAULT FALSE,
  s_eb_evu              VARCHAR(50),
  s_eb_evu_knr          INTEGER,
  s_eb_ele_dc_ks_wr     NUMERIC(12,4),
  s_eb_ele_dc_via       VARCHAR(50),
  s_eb_ele_ac_wr_zs     NUMERIC(12,4),
  s_eb_ele_ac_via       VARCHAR(50),
  s_eb_zahls            BOOL NOT NULL DEFAULT FALSE,
  s_eb_zahlsfrei        BOOL NOT NULL DEFAULT FALSE,
  s_eb_ele_bzznr        VARCHAR(50),
  s_eb_bem2             TEXT
 );


CREATE TABLE sun_eb_presets             -- Vorgaben siehe sun_erfbogen
 (sebp_roofings         VARCHAR(100),   -- Eindeckung, Ref. s_eb_dach_arteind
  sebp_forms            VARCHAR(100),   -- Dachform, Ref. s_eb_dach_art
  sebp_modinstalls      VARCHAR(100)    -- Art des Moduleinbaus (Anlagentyp), Ref. s_eb_anl_modeinbau
 );

INSERT INTO sun_eb_presets (sebp_roofings) VALUES ('Dachziegel');
INSERT INTO sun_eb_presets (sebp_roofings) VALUES ('Schindel');
INSERT INTO sun_eb_presets (sebp_roofings) VALUES ('Bieberschwanz');
INSERT INTO sun_eb_presets (sebp_forms) VALUES ('Schrägdach');
INSERT INTO sun_eb_presets (sebp_forms) VALUES ('Flachdach');


CREATE TABLE sun_wechselrichter
 (wr_id                 SERIAL PRIMARY KEY,
  wr_sernr              VARCHAR(75),
  wr_we_nr              INTEGER,
  wr_l_nr               INTEGER,
  wr_an_nr              VARCHAR(50) REFERENCES anl ON UPDATE CASCADE ON DELETE NO ACTION
 );

CREATE OR REPLACE FUNCTION prepare_wrverwaltung() RETURNS VOID AS $$
DECLARE r RECORD;
BEGIN
 FOR r IN SELECT DISTINCT lak_aknr FROM lagartsernrkonf LOOP
        IF NOT column_exists(r.lak_aknr, 'sun_wechselrichter') THEN
                EXECUTE 'ALTER TABLE sun_wechselrichter ADD COLUMN "'||r.lak_aknr||'" VARCHAR(40)';
        END IF;
 END LOOP;
 --SIEHE AUCH lagsernr__a_iu
 RETURN;
END $$ LANGUAGE plpgsql;




--Auf Projekt-ABK gestempelt und IB-Datum gefüllt => Nachtragen in Projektverwaltung, wenn da noch kein IB-Datum angegeben ist
CREATE OR REPLACE FUNCTION ab2_resultparam__a_u_Update_anl() RETURNS TRIGGER AS $$
DECLARE anldbrid INTEGER;
BEGIN

  --Das ist Parameter 'IBDatum' in Standardprojektstruktur
  IF UPPER(new.a2r_vname) = 'IBDATUM' AND (new.a2r_type = 5) AND (new.a2r_value IS NOT NULL) AND (old.a2r_value IS DISTINCT FROM new.a2r_value) THEN

    PERFORM disablemodified();
      --HauptABK suchen (das ist das Projekt) und IB-Datum übernehmen
      SELECT ab_dbrid INTO anldbrid FROM abk JOIN ab2 ON ab_ix = a2_ab_ix WHERE a2_id = new.a2r_a2_id AND ab_tablename = 'anl';
      UPDATE anl SET an_hdat = CAST(new.a2r_value AS DATE) WHERE dbrid = anldbrid;
    PERFORM Enablemodified();

  END IF;

  RETURN new;
END$$LANGUAGE plpgsql;

CREATE TRIGGER ab2_resultparam__a_u_Update_anl
AFTER UPDATE
ON ab2_resultparam
FOR EACH ROW
EXECUTE PROCEDURE ab2_resultparam__a_u_Update_anl();



CREATE OR REPLACE FUNCTION TSystem.views__Project__drop() RETURNS VOID AS $$
BEGIN
  DROP VIEW IF EXISTS SunEDB_PrjView;           --SUN vergibt Rechte auf die Views, die sind hier mit weg.
  DROP VIEW IF EXISTS SunEDB_PrjParameterView;
END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION TSystem.views__project__create() RETURNS VOID AS $$
BEGIN

  IF NOT ( (TSystem.Settings__Get('KUNDE') IN ('SUNSTROM','MR-SUN'))
          OR (current_database() IN ('MR-SUN','SUNLIVE','SUNTEST'))
          OR IsDevelopSystem() ) THEN --IST AUF ANDEREN KUNDENDATENBANKEN SOMIT NICHT VORHANDEN!
     RETURN;
  END IF;

  CREATE OR REPLACE VIEW SunEDB_PrjView AS
        SELECT  an_nr           AS prjNummer,
                an_bez          AS prjBez,
                an_at           AS prjBegin,
                an_et           AS prjEnde,
                an_idat         AS prjMontagedatum,
                an_hdat         AS prjInbetriebnahmedatum,
                an_leistung     AS prjLeistung,
                an_typ          AS prjArt,
                an_done         AS prjErledigt,
                an_storno       AS prjStorniert,
                an_sortkrz      AS adrKrz,
                ad_str          AS adrStrasse,
                ad_plz          AS adrPLZ,
                ad_ort          AS adrOrt,
                l_iso           AS adrLandISO,
                ad_land         AS adrLand,
                ad_lgps         AS geolng,
                ad_bgps         AS geolat
        FROM anl LEFT JOIN adressen_view ON COALESCE(an_sortkrz,'') = ad_krz
                 LEFT JOIN laender       ON COALESCE(ad_land,'') = l_land
        WHERE true
        ORDER BY an_nr;



  CREATE OR REPLACE VIEW SunEDB_PrjParameterView AS
        SELECT  an_nr           AS parPrjNummer,
                a2r_vbez        AS parBezeichnung,
                a2r_vname       AS parVarname,
                a2r_value       AS parValue
        FROM anl JOIN abk               ON ab_tablename = 'anl' AND anl.dbrid = abk.ab_dbrid
                 JOIN ab2               ON ab_ix =a2_ab_ix
                 JOIN ab2_resultparam   ON a2_id = a2r_a2_id
        WHERE a2r_vname IN ('AUSFÜberschussESP','ESPZählerNr','ESPZählertyp','ESPZählerEinDat','ESPZählerStand')
        ORDER BY an_nr, a2r_vname;

  IF EXISTS(SELECT schema_name FROM information_schema.schemata WHERE schema_name = 'sunext') THEN
    PERFORM sunext.fn_sun_setprivileges('public', 'sunedb_prjview');
    PERFORM sunext.fn_sun_setprivileges('public', 'sunedb_prjparameterview');
  END IF;

END $$ LANGUAGE plpgsql;

SELECT TSystem.views__project__create();


-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT TRUE;
