/************* MTV *******************/

    CREATE OR REPLACE FUNCTION auftg__b_iu___MTV() RETURNS TRIGGER AS $$
      BEGIN
        -- Sicherheitshalber, falls das beim Einspielen mit reingerutscht ist.
        IF NOT TSystem.Settings__Get('KUNDE')='MTV' THEN
            RETURN new;
        END IF;
        -- Neu anlegen und interne Kennzahl noch leer
        IF (TG_OP='INSERT') AND (COALESCE(new.ag_post1,'') = '' ) AND (new.ag_astat = 'E') THEN

            --> Nächsthöhere Kennzahl (des aktuellen Jahres)
            new.ag_post1:=COALESCE(MAX(CAST(COALESCE(ag_post1, '0') AS INTEGER) + 1), 1)  FROM auftg
                WHERE ag_astat = 'E'  AND ( EXTRACT(year FROM ag_datum) = EXTRACT(year FROM COALESCE(new.ag_datum,current_Date)));
        END IF;

        --Leerzeichen entfernen, damit wir das immer als Integer Casten können, wenn jemand dicke Finger beim Tippen benutzt
        new.ag_post1:=TRIM(both ' ' FROM new.ag_post1);

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftg__b_iu___MTV
        BEFORE INSERT
        ON auftg
        FOR EACH ROW
        EXECUTE PROCEDURE auftg__b_iu___MTV();
    --

    -- Zuschnittsangaben für Halbzeug vorbereiten, #11441
    CREATE OR REPLACE FUNCTION op6__b_i___MTV() RETURNS TRIGGER AS $$
      BEGIN
        new.o6_m   := COALESCE(new.o6_m, 0); -- DEFAULT 0 simmulieren, um Fehler NOT NULL zu verhindern. Zuschnitte sind führend und bestimmen Menge.
        new.o6_zme := COALESCE(new.o6_zme, (SELECT me_cod FROM mgcode WHERE me_iso = 'mm')); -- Zuschnitte sind im Standard per mm.

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER op6__b_i___MTV
        BEFORE INSERT
        ON op6
        FOR EACH ROW
        EXECUTE PROCEDURE op6__b_i___MTV();
    --