CREATE OR REPLACE FUNCTION z_50_customer.loll__wsk_proz_get(
    _wsk_bez varchar
  )
  RETURNS numeric(12,2)
  AS $$

    SELECT wsk_proz
      FROM ( VALUES
         ('R1', 0.1),
         ('R2', 0.5),
         ('R3', 0.9),
         ('10', 0.1),
         ('25', 0.25),
         ('50', 0.5),
         ('75', 0.75),
         ('90', 0.9),
         ('0', 0)
      ) AS wsk(wsk_bez, wsk_proz)
     WHERE wsk.wsk_bez = _wsk_bez;

$$ LANGUAGE sql IMMUTABLE STRICT;


CREATE OR REPLACE FUNCTION z_50_customer.analytic__views__recreate()
  RETURNS VOID AS $$
  BEGIN

    -- Anfragen (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__anfragen;
    CREATE OR REPLACE VIEW x_900_export.analytic__anfragen AS
      SELECT kanf ->> 'kanf_nr'                                         AS p_nummer               -- Anfrage
           , kanf ->> 'kanf_ad_krz'                                     AS p_adkr                 -- Kunde
           , kanf ->> 'adressename'                                     AS ad_fa1                 -- Firmenbezeichnung
           , kanf ->> 'ad_branche'                                      AS ad_branche             -- Branche
           , z_50_customer.loll__wsk_proz_get( kanf ->> 'kanfwsk_wsk' ) AS p_kanfwsk_wsk          -- Realisierungsw.
           , ( kanf ->> 'kanfp_wert' )::numeric(12,2)                   AS p_wert_tot_netto_gwaer -- Wert
           , kanf ->> 'apintern'                                        AS p_apint                -- Ansprechpartner intern
      FROM tsystem.sql_query__execute__to_jsonb_set( tsystem.systemsqlstatement__query( 'Assistent.TFormAssVertrieb.CacheSqlKANF' ) ) AS kanf
    ;

    -- Angebote / Aufträge (aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__ang_auftg__agg;
    CREATE OR REPLACE VIEW x_900_export.analytic__ang_auftg__agg AS
      SELECT -- Angebote
             count(DISTINCT p_nummer)     FILTER (WHERE p_code = 'A') AS angebote_count
           , count(p_nummer)              FILTER (WHERE p_code = 'A') AS angebotspos_count
           , sum(p_wert_tot_netto_gwaer)  FILTER (WHERE p_code = 'E') AS angebote_netto
           , sum(p_wert_tot_brutto_gwaer) FILTER (WHERE p_code = 'E') AS angebote_brutto
           -- Aufträge
           , count(DISTINCT p_nummer)     FILTER (WHERE p_code = 'E') AS auftraege_count
           , count(p_nummer)              FILTER (WHERE p_code = 'E') AS auftraegepos_count
           , sum(p_wert_tot_netto_gwaer)  FILTER (WHERE p_code = 'E') AS auftraege_netto
           , sum(p_wert_tot_brutto_gwaer) FILTER (WHERE p_code = 'E') AS auftraege_brutto
           , sum(p_wert_tot_netto_gwaer)  FILTER (WHERE p_code = 'E' AND p_dokunr IS NOT null) AS auftraege_netto_in_auftragsdokument
      FROM twawi.auftg_posall
     WHERE NOT p_done                                            -- nur offene
       AND NOT p_storniert                                       -- keine stornierten
       AND NOT p_wert_not_werthg                                 -- nur umsatzrelevante Positionen
       AND NOT p_preis_sumsubpos                                 -- keine Summenpositionen
       AND CASE p_code
             WHEN 'A' THEN p_datum_eingang > current_date - 365  -- Angebot nur wenn in den letzten 365 Tagen angelegt
             WHEN 'I' THEN false                                 -- Aufträge intern immer ausblenden
             ELSE true                                           -- Aufträge extern immer anzeigen
           END
    ;

    -- Angebote / Aufträge (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__ang_auftg CASCADE;
    CREATE OR REPLACE VIEW x_900_export.analytic__ang_auftg AS
      SELECT -- Beleg
             p_code                                               -- Belegtyp (E..Auftrag, A..Angebot)
           , p_nummer                                             -- Belegnummer
           , p_pos                                                -- Belegposition
            -- Werte
           , p_wert_tot_netto_gwaer                               -- Wert Netto
           , p_wert_tot_brutto_gwaer                              -- Wert Brutto
           , p_menge_gme                                          -- Menge in GME
            -- Kunde
           , p_adk_ad_krz AS p_adkrz                              -- Kunde
           , ad_fa1                                               -- Firmenbezeichnung
           , ad_branche                                           -- Branche
            -- Status
           , z_50_customer.loll__wsk_proz_get( p_kanfwsk_wsk ) AS p_kanfwsk_wsk -- Realisierungswahrscheinlichkeit
           , p_status                                             -- Status
           , p_datum_eingang                                      -- Eingangsdatum
           , p_datum_erfasst                                      -- Erfassungsdatum
           , p_datum_soll                                         -- Wunschdatum
           , p_datum_ist                                          -- bestätigtes Datum
           , avor.zeiten        AS avor_zeiten_json               -- Kostenstellen und Zeiten gemäß AVOR
           , CASE
               WHEN p_code = 'R' OR ( p_code = 'E' AND p_pos = 0 ) THEN 'Rahmen'
               WHEN p_rahmen_id IS NOT NULL                        THEN 'Rahmenabruf'
               WHEN p_code = 'E' AND p_pos > 0                     THEN 'Einzelauftrag'
               ELSE null
             END AS p_status_rahmen                               -- Status Rahmenzugehörigkeit
           , ( SELECT sum( ( einzelzeiten ->> 'o2_ta' )::numeric )
                 FROM jsonb_array_elements( avor.zeiten ) AS einzelzeiten
             ) ::numeric(12,2)  AS avor_zeiten_gesamt             -- Kostenstellen und Zeiten gemäß AVOR
        FROM twawi.auftg_posall
        JOIN adk ON ad_krz = p_adk_ad_krz
        LEFT JOIN LATERAL (
                  SELECT jsonb_agg(
                           jsonb_build_object(
                            'o2_ks', o2_ks,
                            'o2_n', o2_n,
                            'o2_ta',(
                              -- Rüstzeit
                                coalesce( o2_tr_sek, 0 )
                              -- + (Hauptzeit + Nebenzeit ) * Verteilzeit %
                              + ( (  coalesce(o2_th_sek, 0)
                                   + coalesce(o2_tn_sek, 0) )
                                * ( 1 + o2_tv / 100 )
                                )
                                * ifthen( coalesce(p_menge_gme, 0) = 0, 1, p_menge_gme )
                              ) ::numeric(12,2) / 3600
                           )
                         ) AS zeiten
                    FROM op2
                    JOIN opl ON o2_ix = op_ix
                            AND op_standard
                   WHERE op_n = p_aknr ) AS avor ON true

       WHERE NOT p_done                                            -- nur offene
         AND NOT p_storniert                                       -- keine stornierten
         AND NOT p_wert_not_werthg                                 -- nur umsatzrelevante Positionen
         AND NOT p_preis_sumsubpos                                 -- keine Summenpositionen
         AND CASE p_code
               WHEN 'A' THEN p_datum_eingang > current_date - 365  -- Angebot nur wenn in den letzten 365 Tagen angelegt
               WHEN 'I' THEN false                                 -- Aufträge intrern immer ausblenden
               ELSE true                                           -- Aufträge extern immer anzeigen
             END
    ;


    -- AVOR-Zeiten zu Angebote / Aufträge (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__ang_auftg__avor;
    CREATE OR REPLACE VIEW x_900_export.analytic__ang_auftg__avor AS
      SELECT -- Beleg
             p_code                                               -- Belegtyp (E..Auftrag, A..Angebot)
           , p_nummer                                             -- Belegnummer
           , p_pos                                                -- Belegposition
             -- AVOR-Zeiten
           , avor_zeiten ->> 'o2_ks' AS o2_ks                     -- Kostenstelle
           , ( avor_zeiten ->> 'o2_n' ) ::integer AS o2_n         -- Arbeitsgang
           , ( avor_zeiten ->> 'o2_ta') ::numeric(12,2) AS o2_ta  -- Arbeitszeit
        FROM x_900_export.analytic__ang_auftg
        LEFT JOIN LATERAL jsonb_array_elements(avor_zeiten_json) as avor_zeiten ON true
    ;


    -- Angebotserfolg
    DROP VIEW IF EXISTS x_900_export.analytic__ang_erfolgreich;
    CREATE OR REPLACE VIEW x_900_export.analytic__ang_erfolgreich AS
      SELECT -- Adresse
             p_adk_ad_krz                              AS p_adkrz
           , ad_fa1
           , ad_name
           , ad_vorn
           , ad_branche
             -- Position
           , p_nummer
           , p_pos
           , coalesce( p_ak_bez, getartbez( p_aknr ) ) AS p_akbez
           , p_datum_erfasst
           , auftg_posall.p_wert_tot_netto_gwaer      AS angebot_p_wert_tot_netto_gwaer  -- Netto Angebot
           , r_auftg_pos.p_wert_tot_netto_gwaer       AS r_auftg_p_wert_tot_netto_gwaer  -- Netto realisierter Auftrag
           , pos_count                                AS r_auftg_pos_positionen          -- Anzahl realisierter Auftragspositionen
             -- Status
           , z_50_customer.loll__wsk_proz_get( p_kanfwsk_wsk ) AS p_kanfwsk_wsk          -- Realisierungsw.
           , p_absgrup
           , p_txt_int
           , p_apintname
             -- Kennzahlen
           , count( p_nummer ) OVER ()                AS angebote_pos_count
           , sum( pos_count )  OVER ()                AS r_auftg_pos_count
           , sum( auftg_posall.p_wert_tot_netto_gwaer ) OVER ()
                                                      AS angebote_netto
           , sum( r_auftg_pos.p_wert_tot_netto_gwaer ) OVER ()
                                                      AS r_auftg_netto
           , coalesce(
               sum( pos_count ) OVER () ::numeric
               / NULLIF( count( p_nummer ) OVER (), 0 )
               , 0 )                                  AS quote_angebotsrealisierung_pos
           , coalesce(
               sum( r_auftg_pos.p_wert_tot_netto_gwaer ) OVER () ::numeric
               / NULLIF( sum( auftg_posall.p_wert_tot_netto_gwaer ) OVER (), 0 )
               , 0 )                                  AS quote_angebotsrealisierung_netto
        FROM twawi.auftg_posall
        LEFT JOIN adk         ON ad_krz = auftg_posall.p_adk_ad_krz
        LEFT JOIN LATERAL (
                    SELECT auftg_posext_1.p_ang_p_id,
                           sum( auftg_posext_1.p_wert_tot_netto_gwaer ) AS p_wert_tot_netto_gwaer,
                           count( auftg_posext_1.p_id ) AS pos_count
                      FROM twawi.auftg_posall auftg_posext_1
                     WHERE auftg_posext_1.p_ang_p_id = auftg_posall.p_id
                       --AND auftg_posext_1.p_code::text = 'E'::text
                       --AND NOT auftg_posext_1.p_storniert
                       --AND NOT auftg_posext_1.p_wert_not_werthg
                       --AND auftg_posext_1.p_pos <> 0
                     GROUP BY auftg_posext_1.p_ang_p_id
                  ) AS r_auftg_pos ON true

       WHERE p_code = 'A'
         AND NOT p_storniert
         AND NOT p_wert_not_werthg
         AND NOT p_preis_sumsubpos                                 -- keine Summenpositionen
         AND p_pos <> 0
         AND p_datum_erfasst >= '2022-01-01'
    ;


    -- Umsatz (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__umsatz;
    CREATE OR REPLACE VIEW x_900_export.analytic__umsatz AS
      SELECT CASE
               WHEN be_prof = 'G' THEN -be_gesamt_net_basis_w
               ELSE be_gesamt_net_basis_w - IFTHEN( chkOhneAbschlagRechnung, 0, bel_abschlagrechbetrag_basis_w( be_bnr, false ) )
             END AS belgesamt                -- Umsatz Netto
           , bel_bezahlt(be_bnr) AS bz_beza  -- Zahlungseingang
           , be_ms                           -- Mahnstufe
           , be_bnr                          -- Belegnummer
           , be_prof                         -- Belegart
           , be_bdat                         -- Belegdatum
           , be_def                          -- Beleg definitiv
             -- Kundeninformation
           , adk.ad_krz                      -- Kunde
           , adk.ad_fa1                      -- Firmenbezeichnung
           , adk.ad_branche                  -- Branche
             -- Zusatzinformation
           , auftg_array                     -- Auftragsnummer
           , auftg_anzahl                    -- Anzahl Auftragspositionen
           , anl_array                       -- Projekt
           , abix_array                      -- ABK
        FROM belkopf
        JOIN adressen_view ON adressen_view.ad_krz = be_rkrz
        JOIN adk ON adk.ad_krz = adressen_view.adk_ad_krz
        JOIN adk1 ON a1_krz = adressen_view.adk_ad_krz
        LEFT JOIN GetBoolSetting( 'chkOhneAbschlagRechnung' ) AS chkOhneAbschlagRechnung ON true -- #10675
        -- Auftrags-/ Projekt-/ ABK-Bezug
        LEFT JOIN LATERAL (
                  SELECT string_agg( DISTINCT bz_auftg || ' Pos '|| bz_auftgpos, ', ' ) AS auftg_array
                       , count(      DISTINCT bz_auftg || ' Pos '|| bz_auftgpos )       AS auftg_anzahl
                       , string_agg( DISTINCT bz_an_nr, ', ' )                          AS anl_array
                       , string_agg( DISTINCT bz_ab_ix, ', ' )                          AS abix_array
                    FROM belzeil_grund WHERE bz_be_bnr = be_bnr
                  ) AS zusatzinfo ON true
        -- Gutschrift auf Teilrechnung?
        LEFT JOIN LATERAL (
                  SELECT EXISTS(
                                 SELECT true
                                   FROM belkopf AS refd_inv
                                  WHERE refd_inv.be_prof = 'T'
                                    AND refd_inv.be_bnr IN (
                                                             SELECT bz_bz_be_bnr
                                                               FROM belzeil_grund
                                                              WHERE bz_be_bnr = belkopf.be_bnr
                                                                AND bz_bz_be_bnr IS NOT NULL
                                                           )
                               ) AS is_g_from_t
                          ) AS refd ON belkopf.be_prof = 'G'
                                   AND chkOhneAbschlagRechnung

        -- Zeitraum Rechnung
        WHERE be_bdat >= ( date_trunc( 'year', current_date - 1 ) - interval '1 year' )::date
          AND be_bdat <= current_date
          -- keine Teilrechnungen wenn Setting aktiv
          AND (     ( chkOhneAbschlagRechnung AND be_prof <> 'T' AND COALESCE( NOT is_g_from_t, true ) )
               OR NOT chkOhneAbschlagRechnung
              )
    ;


    -- Lieferscheine ohne Rechnung (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__lieferscheine_nicht_fakturiert;
    CREATE OR REPLACE VIEW x_900_export.analytic__lieferscheine_nicht_fakturiert AS
      SELECT lief ->> 'lsd_dokunr'                AS p_dokunr               -- Belegnummer Lieferschein
           , (lief ->> 'beld_erstelldatum')::date AS p_datum_erstellt       -- Erstelldatum
           , lief ->> 'krzb'                      AS p_adkrz                -- Kunde Besteller
           , lief ->> 'l_krzb_name'               AS ad_fa1                 -- Firmenbezeichnung
           , (lief ->> 'wert')::numeric           AS p_wert_tot_netto_gwaer -- Wert Netto
             -- Status
           , lief ->> 'belp_bstat'                AS p_bstat
           , lief ->> 'belp_bstat1'               AS p_bstat1
           , lief ->> 'belp_bstat2'               AS p_bstat2
           , (lief ->> 'beld_print')::boolean     AS p_gedruckt             -- Status gedrukt
           , (lief ->> 'beld_definitiv')::boolean AS p_definitiv            -- Status definitiv
        FROM tsystem.sql_query__execute__to_jsonb_set( tsystem.systemsqlstatement__query( 'Assistent.TFormAssRechnungen.ServSqlLiefsch' ) ) AS lief
    ;


    -- Auftragseingang (aktuelles und vorletztes Jahr, nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__auftg_eingang;
    CREATE OR REPLACE VIEW x_900_export.analytic__auftg_eingang AS
      SELECT -- Kundeninformation
             p_adk_ad_krz AS p_adkrz         -- Kunde
           , ad_fa1                          -- Firmenbezeichnung
           , ad_branche                      -- Branche
             -- Auftragsinformation
           , p_nummer                        -- Belegnummer
           , p_pos                           -- Belegposition
           , p_done                          -- Beleg abgeschlossen
           , p_aknr                          -- Artikelnummer
           , p_wert_tot_netto_gwaer          -- Positionswert inkl. AbZuschläge, exkl. Steuern, in Grundwährung
           , p_datum_eingang                 -- Eingangsdatum
           , p_datum_erfasst                 -- Erfassungsdatum
           , p_datum_soll                    -- Wunschdatum
           , p_datum_ist                     -- bestätigtes Datum
             -- Status
           , p_rahmen_id                     -- Rahmen-ID
           , p_code                          -- Belegtyp
           , CASE
               WHEN p_code = 'R' OR p_pos = 0 THEN 'Rahmen'
               WHEN p_rahmen_id IS NOT NULL   THEN 'Rahmenabruf'
               ELSE 'Einzelauftrag'
             END AS p_status_rahmen          -- Status Rahmenzugehörigkeit
        FROM twawi.auftg_posall
        JOIN adk ON ad_krz = p_adk_ad_krz
       WHERE p_code IN ('E', 'R')
         AND NOT p_storniert
         AND NOT p_wert_not_werthg
         AND NOT p_preis_sumsubpos                                 -- keine Summenpositionen
         AND p_datum_erfasst >= ( date_trunc( 'year', current_date - 1 ) - interval '1 year' )::date
         AND p_datum_erfasst <= current_date
    ;


    -- offene Rahmenaufträge (aggregiert nach überfällig)
    DROP VIEW IF EXISTS x_900_export.analytic__rahmen_offen__agg;
    CREATE OR REPLACE VIEW x_900_export.analytic__rahmen_offen__agg AS
      SELECT snapshot_date                                                                                                                                             -- Auswertungszeitpunkt
           , sum( p_wert_tot_netto_gwaer * ( rahmen_info.rahmen_stko_gme / coalesce( nullif( rahmen_info.rahmen_stk_gme, 0 ), 1 ) ) )::numeric(12,2) AS p_wert_tot_netto_offen_gwaer  -- Summe Netto offen
           , coalesce( p_datum_ist, snapshot_date ) <= snapshot_date AND coalesce( laufzeit.endtermin, snapshot_date ) <= snapshot_date              AS p_ueberfaellig                    -- Rahmen ist überfällig
           , sum( p_wert_tot_netto_gwaer * ( rahmen_info.rahmen_stko_gme / coalesce( nullif( rahmen_info.rahmen_stk_gme, 0 ), 1 ) ) ) ::numeric(12,2) -
             LAG( sum( p_wert_tot_netto_gwaer * ( rahmen_info.rahmen_stko_gme / coalesce( nullif( rahmen_info.rahmen_stk_gme, 0 ), 1 ) ) ) ) OVER (
              PARTITION BY coalesce( p_datum_ist, snapshot_date ) <= snapshot_date AND coalesce( laufzeit.endtermin, snapshot_date ) <= snapshot_date
              ORDER BY snapshot_date ) ::numeric(12,2)                                                                            AS diff_p_wert_tot_netto_offen_gwaer -- Veränderung zum vorherigen Auswertungszeitpunkt
        FROM tlog.datawarehouse_auftg
        JOIN LATERAL tlog.datawarehouse_auftg__rahmen_info__by__p_id__snapshot__get(p_id, snapshot_date) AS rahmen_info ON true
        LEFT JOIN LATERAL ( SELECT -- TSystem.cast_date( ( regexp_match( p_allgv4, E'(\\d{2}\\.\\d{2}\\.\\d{4})\\s+bis\\s+(\\d{2}\\.\\d{2}\\.\\d{4})' ) )[2] ) AS endtermin,
                                   IFTHEN( IsDate( SUBSTRING ( p_allgv4 FROM '..........$' ) ), SUBSTRING (p_allgv4 FROM '..........$'), NULL)::date AS endtermin )
                          AS laufzeit ON p_allgv4 IS NOT NULL
        WHERE NOT p_done                          -- nur zum Stichtag offene Aufträge
          AND NOT p_storniert                     -- ohne stornierte
          AND NOT p_wert_not_werthg               -- nur umsatzrelevante Aufträge
          AND (      p_code = 'R'
                OR ( p_code = 'E' AND p_pos = 0 )
              )                                   -- nur Rahmen

        GROUP BY snapshot_date
               , p_ueberfaellig
        ORDER BY snapshot_date DESC NULLS LAST
    ;

    -- Produktion
    DROP VIEW IF EXISTS x_900_export.analytic__produktion;
    CREATE OR REPLACE VIEW x_900_export.analytic__produktion AS
      SELECT a2_ab_ix                                                         -- ABK-Index
           , a2_n                                                             -- Arbeitsgangnummer
           , a2_ks                                                            -- Kostenstelle
           , a2_ksap                                                          -- Arbeitsplatz
           , ak_nr                                                            -- Artikelnummer
           , ak_bez                                                           -- Artikelbezeichnung
           , coalesce(ab_st_uf1_soll, ab_st_uf1) AS ab_st_uf1                 -- ABK-Menge
           , a2_tr_sek                                                        -- Vorgabe: Zeit: Rüsten (in Sekunden)
           , a2_ta * 3600 - a2_tr_sek AS a2_tges_sek                          -- Vorgabe: Gesamtzeit ohne Rüsten (in Sekunden)
           , CASE WHEN     ba_ruest THEN ba_efftime * 3600 END AS ba_tr_sek   -- Stempelung: Zeit: Rüsten (in Sekunden)
           , CASE WHEN NOT ba_ruest THEN ba_efftime * 3600 END AS ba_tges_sek -- Stempelung: Gesamtzeit ohne Rüsten (in Sekunden)
           , ab_erstfert                                                      -- Status: Erstfertigung
           , ba_anf                                                           -- Stempelung: Buchungszeitpunkt
           , ba_minr                                                          -- Stempelung: Mitarbeiternummer
           , nameaufloesen(ba_minr)                                           -- Stempelung: Mitarbeitername
           , ba_stk                                                           -- Stempelung: Menge: Gutteil
           , ba_auss                                                          -- Stempelung: Menge: Ausschuss
           , asg_descr                                                        -- Stempelung: Ausschussgrund
           , ad_krz                                                           -- Kunde: Kürzel
           , ad_branche                                                       -- Kunde: Branche
        FROM bdea
        LEFT JOIN ab2 ON ba_ix = a2_ab_ix
                      AND ba_op = a2_n
        LEFT JOIN abk ON a2_ab_ix = ab_ix
        LEFT JOIN art ON ak_nr = ab_ap_nr
        LEFT JOIN twawi.auftg_pos ON p_id = tplanterm.abk_main_auftg_id(a2_ab_ix)
        LEFT JOIN adk ON ad_krz = p_adk_ad_krz
        LEFT JOIN bdea_ausschussgruende ON ba_asg_id = asg_id
    ;

  END $$ LANGUAGE plpgsql;

-- Drop Views
CREATE OR REPLACE FUNCTION z_50_customer.analytic__views__drop()
  RETURNS VOID AS $$
  BEGIN

    DROP VIEW IF EXISTS x_900_export.analytic__anfragen;                        -- Anfragen (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__ang_auftg__agg;                  -- Angebote / Aufträge (aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__ang_auftg CASCADE;               -- Angebote / Aufträge (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__ang_auftg__avor;                 -- AVOR-Zeiten zu Angebote / Aufträge (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__ang_erfolgreich;                 -- Angebotserfolg
    DROP VIEW IF EXISTS x_900_export.analytic__umsatz;                          -- Umsatz (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__lieferscheine_nicht_fakturiert;  -- Lieferscheine ohne Rechnung (nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__auftg_eingang;                   -- Auftragseingang (letzte 7 Tage, nicht aggregiert)
    DROP VIEW IF EXISTS x_900_export.analytic__rahmen_offen__agg;               -- offene Rahmenaufträge (aggregiert nach überfällig)
    DROP VIEW IF EXISTS x_900_export.analytic__produktion;                      -- Produktion

  END $$ LANGUAGE plpgsql;
