-- https://redmine.prodat-sql.de/issues/8908

-- REVOKE ALL ON SCHEMA tkta_connection FROM "KTA-SHOP";

-- DROP ROLE "KTA-SHOP";

-- KTA-SHOP als Nutzer anlegen PW entspricht 'KTA'

CREATE ROLE "KTA-SHOP" LOGIN

  ENCRYPTED PASSWORD 'md5268aa6ff5347affa1bd42fb67d74cafb' -- KTA

  NOSUPERUSER NOINHERIT NOCREATEDB NOCREATEROLE;

GRANT CONNECT ON DATABASE "HPCHO" TO "KTA-SHOP";

-- Schema tka_connection anlegen

CREATE SCHEMA tkta_connection

  AUTHORIZATION postgres;

-- Berechtigungen f?r Schema anpassen:

--    SYS.Administratorn -> Vollzugriff

--    KTA-SHOP -> Lesezugriff

GRANT ALL ON SCHEMA tkta_connection     TO "SYS.Administratoren" WITH GRANT OPTION;

GRANT USAGE ON SCHEMA tkta_connection   TO "KTA-SHOP";

GRANT USAGE ON SCHEMA z_50_customer  TO "KTA-SHOP";

-- GRANT SELECT ON TABLE tkta_connection.product_main_groups TO "KTA-SHOP";



-- SHOP Gruppen für Webshops : Bindung an AC
CREATE TABLE z_50_customer.artcod_shopgroups (
   acsg_id        SERIAL NOT NULL PRIMARY KEY,
   acsg_ac_n      VARCHAR NOT NULL,-- Ohne References damit freier verwendbar
   acsg_spr_key   VARCHAR(5) NOT NULL CONSTRAINT xtt4089 REFERENCES sprach,
   acsg_txt       VARCHAR(100)
  );
 --

 --jeder Sprachschlüssel darf nur einmal zur Gruppe zugeordnet werden
  CREATE UNIQUE INDEX acsg_spr_key ON z_50_customer.artcod_shopgroups (acsg_ac_n, acsg_spr_key);

--Bezeichnung der Shopgruppe mit Übersetzung
CREATE OR REPLACE FUNCTION z_50_customer.lang_artcod_shopgroups(_acn VARCHAR, _lang VARCHAR) RETURNS VARCHAR(100) AS $$
 DECLARE s    VARCHAR;
 BEGIN
  IF _acn IS NULL OR _acn = '' THEN
    RETURN 'n.a.';
  END IF;
  s := acsg_txt FROM z_50_customer.artcod_shopgroups WHERE acsg_ac_n = _acn AND acsg_spr_key = _lang;
  RETURN COALESCE(s, 'n.a.');
  --
 END $$  LANGUAGE plpgsql STABLE;






 CREATE OR REPLACE FUNCTION TSystem.views__customer__drop() RETURNS VOID AS $$
    --
    -- BITTE UNBEDINGT DIE HINWEISE BEACHTEN ---------------------------------------------------------------------------------------
    --
    -- Diese Funktion darf niemals in ein DB-Update aufgenommen werden! Die Funktion immer vor Ort beim Kunden ändern!
    --
    -- Dies ist eine Funktion, um kundenspezifische Views zu löschen. Sie werden noch vor den PORDAT-Views gelöscht.
    -- Diese Funktion darf niemals in einem DB-Update überschrieben werden. Damit würden Einstellungen beim Kunden verloren gehen!
    -- Die hier gelöschten Views müssen in FUNCTION TSystem.views__customer__create erzeugt werden.
    --
    -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/CustomView
    --
    --------------------------------------------------------------------------------------------------------------------------------
    --
  BEGIN

    --Products VIEW
    DROP VIEW IF EXISTS tkta_connection.products_webshop;--

    --Product Main-Group VIEW
    DROP VIEW IF EXISTS tkta_connection.product_main_groups;--

    --Product Group VIEW
    DROP VIEW IF EXISTS tkta_connection.product_groups;

    --Product Sub Group VIEW
    DROP VIEW IF EXISTS tkta_connection.product_sub_groups;

    --Product-Stock-Status VIEW
    DROP VIEW IF EXISTS tkta_connection.product_stock_status;

    --Product-Stock-Status VIEW Version 2
    DROP VIEW IF EXISTS tkta_connection.product_stock;
    --
    RETURN;
  END $$ LANGUAGE plpgsql;



---------



CREATE OR REPLACE FUNCTION TSystem.views__customer__create() RETURNS VOID AS $$
    --
    -- BITTE UNBEDINGT DIE HINWEISE BEACHTEN ---------------------------------------------------------------------------------------
    --
    -- Diese Funktion darf niemals in ein DB-Update aufgenommen werden! Die Funktion immer vor Ort beim Kunden ändern!
    --
    -- Dies ist eine Funktion, um kundenspezifische Views zu erzeugen. Sie werden nach den PRODAT-Views erstellt.
    -- Diese Funktion darf niemals in einem DB-Update überschrieben werden. Damit würden Einstellungen beim Kunden verloren gehen!
    -- Die hier erzeugten Views müssen in FUNCTION TSystem.views__customer__drop wieder gelöscht werden.
    --
    -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/CustomView
    --
    --------------------------------------------------------------------------------------------------------------------------------
    --
  BEGIN

   -- nötige Funktionen für LIVE-System
   --

   --
   --

   --Products VIEW
   CREATE OR REPLACE VIEW tkta_connection.products_webshop AS

     SELECT
      art.ak_nr AS Product_Code,
      (lang_artbez(art.ak_nr, 'EN')) AS Product_Name,
      art.ak_bez AS Product_Name_DE,
      --art.ak_ac,  -- Bsp:40-40-10 : Group '-' Subgroup '-' Subsubgroup
      (substring(art.ak_ac, '[^-]*')) AS Product_Main_Group,
      (substring(art.ak_ac, '-(.*)-')) AS Product_Group,
      (substring(art.ak_ac, '(?!.*-).*')) AS Product_Sub_Group,
      art.ak_vkpbasfix::numeric(9,2) AS Price,   -- Number XXXXXX.XX
      art.ak_gewicht::numeric(10,3) AS Weight, -- in kg  Number XXXXXX.XXX
      art.insert_date::timestamp AS Insert_Date_Time --  DateTime
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
     ;
   --

   --Product Main-Group VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_main_groups AS

     SELECT DISTINCT
      (substring(art.ak_ac, '[^-]*')) AS Product_Main_Group_Code,
      (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '[^-]*')), 'EN')) AS Product_Main_Group_Desc,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '[^-]*')), 'D')) AS Product_Main_Group_Desc_DE
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
     ORDER BY 1
     ;
   --

   --Product Group VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_groups AS

     SELECT DISTINCT
      (substring(art.ak_ac, '-(.*)-')) AS Product_Group_Code,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '-(.*)-')), 'EN')) AS Product_Group_Desc,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '-(.*)-')), 'D')) AS Product_Group_Desc_DE
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)-') IS NOT NULL)
     ORDER BY 1
     ;
   --

   --Product Sub Group VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_sub_groups AS

     SELECT DISTINCT
      (substring(art.ak_ac, '(?!.*-).*')) AS Product_Sub_Group_Code,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '(?!.*-).*')), 'EN')) AS Product_Sub_Group_Desc,
        (z_50_customer.lang_artcod_shopgroups( (substring(art.ak_ac, '(?!.*-).*')), 'D')) AS Product_Sub_Group_Desc_DE
     FROM art
     WHERE NOT art.ak_ac LIKE 'ZZ-%'
     AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
     ORDER BY 1
     ;
   --

   --Product-Stock-Status VIEW
   CREATE OR REPLACE VIEW tkta_connection.product_stock_status AS
   SELECT
        art.ak_nr AS Product_Code,
        art.ak_tot-art.ak_res AS Stock,
        IFTHEN(art.ak_tot-art.ak_res>5,'Available','Not available') AS Stock_Status, --( Available / Not Available)
        IFTHEN(art.ak_tot-art.ak_res>5,'Verfügbar','Nicht verfügbar') AS Stock_Status_DE,
        NULL::date AS Stock_Available,
        (SELECT modified_date FROM lag WHERE lg_aknr=ak_nr ORDER BY modified_date DESC LIMIT 1)::timestamp AS Update_Date_Time -- DateTime
       FROM art
       WHERE NOT art.ak_ac LIKE 'ZZ-%'
       AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
       UNION SELECT
        lg_aknr AS Product_Code,
        lg_anztot AS Stock,
        NULL AS Stock_Status, --( Available / Not Available)
        NULL AS Stock_Status_DE,
        lg_lagzudat::date+44 AS Stock_Available, -- including 6 weeks shipping
        lag.modified_date AS Update_Date_Time
       FROM lag
       JOIN art ON lg_aknr=ak_nr
       WHERE lg_ort LIKE 'INVO%'
       AND NOT art.ak_ac LIKE 'ZZ-%'
       AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
       ORDER BY Product_Code, Stock_Status
     ;

    --Product-Stock-Status VIEW Version 2
    CREATE OR REPLACE VIEW tkta_connection.product_stock AS
    SELECT
         art.ak_nr AS Product_Code,
         art.ak_tot AS Stock,
         art.ak_res AS Customer_Orders,
         NULL::date AS Stock_Available,
         (SELECT modified_date FROM lag WHERE lg_aknr=ak_nr ORDER BY modified_date DESC LIMIT 1)::timestamp AS Update_Date_Time -- DateTime
        FROM art
        WHERE NOT art.ak_ac LIKE 'ZZ-%'
        AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
        UNION SELECT
         lg_aknr AS Product_Code,
         lg_anztot AS Stock,
         art.ak_res AS Customer_Orders,
         lg_lagzudat::date+44 AS Stock_Available, -- including 6 weeks shipping
         lag.modified_date AS Update_Date_Time
        FROM lag
        JOIN art ON lg_aknr=ak_nr
        WHERE lg_ort LIKE 'INVO%'
        AND NOT art.ak_ac LIKE 'ZZ-%'
        AND (substring(art.ak_ac, '-(.*)') IS NOT NULL)
        ORDER BY Product_Code
      ;

      -- Zugriffe auf VIEWS und Tabellen f?r KTA-SHOP

      GRANT SELECT ON tkta_connection.products_webshop  TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_main_groups   TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_groups    TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_sub_groups  TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_stock_status  TO "KTA-SHOP";

      GRANT SELECT ON tkta_connection.product_stock   TO "KTA-SHOP";

      GRANT SELECT ON TABLE  art            TO "KTA-SHOP";

      GRANT SELECT ON TABLE  artblang           TO "KTA-SHOP";

      GRANT SELECT ON TABLE  lag      TO "KTA-SHOP";

      GRANT SELECT ON TABLE  z_50_customer.artcod_shopgroups TO "KTA-SHOP";

    --
    RETURN;
  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TSystem.RecNoKeyword__create__verpackungsmasse(
  IN _net_weight_kg    varchar,
  IN _length_mm        varchar,
  IN _width_mm         varchar,
  IN _height_mm        varchar,
  IN _rkategorie       varchar,
  IN _rtablename       varchar,
  IN _rdbrid           varchar
 ) RETURNS VOID AS $$
 BEGIN

raise notice '_rdbrid = %, _length_mm = %, _width_mm = %, _height_mm = %, _height_mm = % ', _rdbrid, _length_mm, _width_mm, _height_mm, _height_mm;
        PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(29894),    --- Nettogewicht
                                       rdbrid     => _rdbrid,
                                       rvalue     => _net_weight_kg,
                                       pname      => 'art.verpackungsmasse.net_weight_kg'
                   );

        PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(516),      --- Länge
                                       rdbrid     => _rdbrid,
                                       rvalue     => _length_mm,
                                       pname      => 'art.verpackungsmasse.length_mm'
                   );

    PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(322),      --- Breite
                                       rdbrid     => _rdbrid,
                                       rvalue     => _width_mm,
                                       pname      => 'art.verpackungsmasse.width_mm'
                   );

    PERFORM TSystem.CreateKeyword( rkategorie => _rkategorie,
                                       rtablename => _rtablename,
                                       rdescr     => lang_text(26482),    --- Höhe
                                       rdbrid     => _rdbrid,
                                       rvalue     => _height_mm,
                                       pname      => 'art.verpackungsmasse.height_mm'
                   );

  RETURN;
 END $$ LANGUAGE plpgsql;

