--############################################## #20216 Seriennummerngenerierung ohne Standardseriennummernformat

-- Generierung von Seriennummern nach https://redmine.prodat-sql.de/issues/16985
-- Muster der Seriennummern #11118, #11173
CREATE OR REPLACE FUNCTION tlager.lagsernr__presetting__create( _ld_id integer, _count integer, _w_wen integer DEFAULT null, _ak_nr varchar DEFAULT null ) RETURNS SETOF VARCHAR AS $$

  -- alle vorhandenen Vorgebeseriennummer zur Bestellposition, welche keinem LZ zugeordnet sind
  WITH

    -- nicht zugewiesene, noch vorhandene Vorgabeseriennummern
    ld_sernr AS (
      SELECT lgs_sernr
      FROM lagsernr
      JOIN mapsernr ON     ms_lgs_id = lgs_id
                       AND ms_pkey::INTEGER = _ld_id
                       AND ms_table = 'ldsdok'::REGCLASS
      WHERE lgs_w_wen IS null -- Nur nicht zugewiesene SN ausgeben
    ),

    -- Artikelnummer der Bestellung
    ld_data AS (
        SELECT COALESCE (
            (SELECT ld_aknr FROM ldsdok WHERE ld_id = _ld_id) ,
            _ak_nr
        ) AS aknr
    ),

    -- Artikelformat beim Wareneingang (true) oder das Standardformat mit führendem ~~ (false)
    -- ################# HPCHO: niemals Standardformat
    sn_vorgabe AS (
        SELECT true AS ac_sn_vorgabe FROM artcod
        JOIN art ON ak_ac = ac_n
        JOIN ld_data ON ld_data.aknr = ak_nr
    ),

    -- die Anzahl der zurückzugebenen Seriennummer wird bestimmt:
    -- entweder der übegebene Parameter _count oder die noch nicht eingelagerte Bestellmenge
    anzahl AS (
      SELECT max(
          ( SELECT count(*)::integer FROM ld_sernr ),
            coalesce( _count, ( SELECT ld_stk - ld_stkl FROM ldsdok WHERE ld_id = _ld_id ), 0 )
      ) AS anz
    ),

    -- erster Teil einer Seriennummer im Standardformat
    ident AS (
        SELECT coalesce( _w_wen :: varchar, -- Bei WE
                      ( SELECT aknr FROM ld_data ), -- Bei Vorgabeseriennummer (im Einkauf)
                        to_char( current_date, 'YYYYMMDD' ) -- Fallback auf heutiges Datum
       ) AS id
    ),

    -- kundenbezogenes Seriennummernformat
    customer_sernr AS (
        SELECT customer_lagsernr__presetting__create AS lgs_sernr
        FROM z_50_customer.customer_lagsernr__presetting__create( _ld_id, ( SELECT anz::integer FROM anzahl ) - ( SELECT count(*)::integer FROM ld_sernr ), _w_wen, _ak_nr )
        CROSS JOIN sn_vorgabe
        WHERE _w_wen IS null OR ac_sn_vorgabe
    ),

    -- artikelbezogenens Seriennummernformat
    default_sernr AS (
        SELECT tlager.sernr__ak_nr__create( aknr, ( SELECT anz::integer FROM anzahl ) - ( SELECT count(*)::integer FROM ld_sernr ) ) AS lgs_sernr
        FROM ld_data
        CROSS JOIN sn_vorgabe
        WHERE _w_wen IS null OR ac_sn_vorgabe
    )

  SELECT lgs_sernr FROM (

    -- alle vorhandenen Vorgabeseriennummern
    SELECT
      0 AS sort,
      lgs_sernr
    FROM ld_sernr


    UNION

    -- alle Kunden-Vorgabeseriennummern
    SELECT
      1 AS sort,
      lgs_sernr
    FROM customer_sernr

    UNION

    -- alle Default-Vorgabeseriennummern
    SELECT
      2 AS sort,
      lgs_sernr
    FROM default_sernr

/*
    -- Für HPCHO sollen diese Legacy-Seriennummern nicht mehr erzeugt werden.

    UNION

    -- Alle generierten Seriennummern im Standardformat bestehen aus Ident + einer laufenden Nummer
    -- Der Ident kann sein (siehe WITH Query 'ident'):
    --   1. die aktuelle WE-Nummer,
    --   2. Vorgabeseriennummer (Bestellung) oder
    --   3. das aktuelle Datum
    -- Hier prüfen wir, ob ausreichend Seriennummern generiert waren. Im Fall nein, zB es waren 10 bestellt aber 12 Lagzugang werden 2 zusätzliche erstellt.

    SELECT
      3 AS sort,
      '~~' || ident || ' #' || lpad((start_nr + generate_series( 1, ( SELECT anz FROM anzahl )))::varchar, 3, '0' )
    FROM (
           SELECT
              id AS ident,
              CASE WHEN _w_wen IS NULL
                                -- Abfrage der maximalen laufenden Nummer (nicht bei WE)
                THEN COALESCE(( SELECT
                                  RIGHT(lgs_sernr, LENGTH(lgs_sernr) - LENGTH('~~'|| id ||' #'))::INT -- Extrahieren der laufenden Nummer
                                FROM lagsernr
                                WHERE lgs_sernr LIKE '~~'|| id ||' #%'
                                ORDER BY lgs_sernr DESC
                                LIMIT 1 ),
                               0)
                ELSE 0
                END AS start_nr
           FROM ident
         ) AS q1
  */

    EXCEPT

    -- aussortiert wird alles was bereits mit einem passenden WE in Verbindung gebracht wird
    SELECT generate_series AS sort, lgs_sernr FROM generate_series( 1, 2 ), lagsernr WHERE
           lgs_w_wen = _w_wen
        OR lgs_w_wen IN (SELECT w_wen FROM wendat WHERE w_lds_id = _ld_id )
  ) AS x
  -- Sortierung: Vorgabeseriennummern haben Priorität
  ORDER BY sort ASC, lgs_sernr ASC
  -- Anzahl der Seriennummern:
  -- Maximum aus Anzahl der Vorgabeseriennummern, Bestellmenge und WE-Menge (soweit übergeben)
  LIMIT ( SELECT anz FROM anzahl )

$$ LANGUAGE sql STABLE;
