CREATE SCHEMA tcimpcs;


-- Das ist innerhalb der Redmine DB einzufügen!


--- #19302 [Redmine] Verrechenbar Prozent
--- Funktion holt custom_values-Werte für ganze Ticket oder nur für ein custom_fields_id
CREATE OR REPLACE FUNCTION tcimpcs.custom_values__Get(
    IN _customized_id       integer,         --- Ticket-Nr.
    IN _custom_field_id     integer = 0,     --- Feld-ID aus custom_fields, sonnst alle ID's
    ---
    OUT custom_field_id      integer,
    OUT custom_values_name  varchar,          --- Feld-Name
    OUT custom_values_value varchar           --- Value
    )
    RETURNS SETOF RECORD AS $$
  DECLARE rec     record;
        --  _custom_field_id integer := 36;     --- Feld-ID aus custom_fields         TODO jetzt funktioniert nur für Verrechenbar Prozent
  BEGIN

    FOR rec IN SELECT
                 cv.custom_field_id AS custom_fieldid,
                 cf.name AS name,
                 CASE WHEN cv.custom_field_id IN ( 25, 35, 36 ) AND cv.custom_field_id > 0 THEN
                         ( SELECT name
                           FROM custom_field_enumerations AS cfe
                           WHERE id = CASE WHEN length(trim(cv.value)) > 0 THEN cv.value::integer ELSE 0 END
                         )
                      ELSE
                         cv.value
                 END AS value
               FROM custom_values AS cv
                 LEFT JOIN custom_fields             AS cf  ON cf.id  = cv.custom_field_id
               WHERE customized_type    = 'Issue'
                 AND customized_id      = _customized_id
                 AND CASE WHEN _custom_field_id > 0 THEN cv.custom_field_id = _custom_field_id ELSE true END --- nur ein Feld, , sonst alle Felder
    LOOP
        custom_field_id     = rec.custom_fieldid;
        custom_values_name  = rec.name;
        custom_values_value = rec.value;
        RETURN NEXT;
    END LOOP;
 END $$ LANGUAGE plpgsql STABLE;
---
CREATE OR REPLACE FUNCTION tcimpcs.abk__update__verrechenbar_prozent( IN _customized_id integer ) RETURNS VOID AS $$
 DECLARE
      sql varchar;
      ab_allg_n1_   varchar;
 BEGIN

    SELECT custom_values_value
    INTO ab_allg_n1_
    FROM tcimpcs.custom_values__Get( _customized_id, 36 );

    sql := FORMAT( 'UPDATE abk SET ab_allg_n1 = %L WHERE ab_ix = %L', ab_allg_n1_, _customized_id );
    PERFORM * FROM dblink(tcimpcs.db_test(), sql) as t1(test text);

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tcimpcs.custom_values__a_u__abk()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
      AS $BODY$
 BEGIN

    --- #19302 Verrechenbar Prozent
    PERFORM tcimpcs.abk__update__verrechenbar_prozent( new.customized_id );

    RETURN null;
 END
    $BODY$;

ALTER FUNCTION tcimpcs.custom_values__a_u__abk()
    OWNER TO redmine;
    ---
    CREATE TRIGGER custom_values__a_u__abk
        AFTER UPDATE OF value
        ON public.custom_values
        FOR EACH ROW
        WHEN (new.custom_field_id = 36 )
        EXECUTE FUNCTION tcimpcs.custom_values__a_u__abk();
    ---
    --- redmine
CREATE OR REPLACE FUNCTION tcimpcs.issues__a_d__abk()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$

   DECLARE sql  VARCHAR;
 BEGIN
   IF tg_op='DELETE' THEN
      sql := FORMAT('DELETE FROM bdea WHERE ba_ix = %L', old.id);
      PERFORM * FROM dblink(tcimpcs.db_test(), sql) as t1(test text);
      RETURN old;
   END IF;
   RETURN old;
 END
$BODY$;

ALTER FUNCTION tcimpcs.issues__a_d__abk()
    OWNER TO redmine;


CREATE TRIGGER issues__a_d__abk
    AFTER DELETE
    ON public.issues
    FOR EACH ROW
    EXECUTE FUNCTION tcimpcs.issues__a_d__abk();
---
CREATE OR REPLACE FUNCTION tcimpcs.issues__a_i__dschuch_is_watcher()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$

BEGIN
 RETURN new; --auskommentiert DS 2019-04-04: Änderung: DS schaut 1 mal / Tag aktiv, welche Tickets beobachtet werden wollen
 IF NOT EXISTS(SELECT true FROM watchers WHERE watchable_id=new.id AND user_id=3) THEN
  INSERT INTO watchers (watchable_id, watchable_type, user_id) VALUES (new.id, 'Issue', 3);
 END IF;
 RETURN new;
END
$BODY$;

ALTER FUNCTION tcimpcs.issues__a_i__dschuch_is_watcher()
    OWNER TO redmine;

CREATE TRIGGER issues__a_i__dschuch_is_watcher
    AFTER INSERT
    ON public.issues
    FOR EACH ROW
    EXECUTE FUNCTION tcimpcs.issues__a_i__dschuch_is_watcher();
---
CREATE OR REPLACE FUNCTION tcimpcs.issues__a_i__abk__ab_allg_XX()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
  BEGIN

    --- #19302 Verrechenbar Prozent
    PERFORM tcimpcs.abk__update__verrechenbar_prozent( new.id );

    RETURN null;
  END
$BODY$;

ALTER FUNCTION tcimpcs.issues__a_i__abk__ab_allg_XX()
    OWNER TO redmine;
---
CREATE TRIGGER issues__a_i__abk__ab_allg_XX
    AFTER INSERT
    ON public.issues
    FOR EACH ROW
    EXECUTE FUNCTION tcimpcs.issues__a_i__abk__ab_allg_XX();
---
CREATE OR REPLACE FUNCTION tcimpcs.issues__b_iu__abk_axs()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
  DECLARE
      _sql varchar;
--      _l_context text;

  BEGIN

--      BEGIN

          --Neuer Resdmine-Issue wurde angelegt.
          IF tg_op='INSERT' THEN
              --  In Prodat ABK erstellen, falls noch nicht vorhanden.
              PERFORM tcimpcs.abk_erstellen_axs(
                  _issue_id         => new.id,
                  _issue_parent_id  => new.parent_id,
                  _issue_subject    => new.subject,
                  _issue_project_id => new.project_id,
                  _issue_created_on => new.created_on
              );
          END IF;

          -- Redmine-Issue hat sich geändert.
          IF tg_op='UPDATE' THEN
              -- In Prodat ABK erstellen bzw. aktualisieren.
              IF NOT  tcimpcs.abk_erstellen_axs(
                          _issue_id         => new.id,
                          _issue_parent_id  => new.parent_id,
                          _issue_subject    => new.subject,
                          _issue_project_id => new.project_id,
                          _issue_created_on => new.created_on
                      )
              THEN
                  _sql := format(
                      'UPDATE abk '             ||
                      'SET ab_parentabk = %L, ' ||
                      '    ab_ap_bem = %L, '    ||
                      '    ab_keyvalue = %L, '  ||
                      '    ab_an_nr = %L,'      ||
                      '    ab_dbrid = %L '      ||
                      'WHERE ab_ix = %L',
                      --
                      new.parent_id,                                                      -- ab_parentabk
                      new.subject::varchar(100),                                          -- ab_ap_bem
                      (tcimpcs.pName( new.project_id ) || '-REDMINE')::varchar(50),       -- ab_keyvalue
                      (tcimpcs.pName( new.project_id ) || '-REDMINE')::varchar(50),       -- ab_an_nr
                      tcimpcs.anl_dbrid( tcimpcs.pName( new.project_id ) )::varchar(100), -- ab_dbrid
                      new.id                                                              -- ab_ix (WHERE)
                  );
                  IF new.id IN ( 9193, 17194, 18669 ) THEN
                      PERFORM * FROM dblink( tcimpcs.db_test(), tcimpcs.sql_axs( _sql ) ) AS t1( test text );
                  ELSE
                      PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1( test text );
                  END IF;
              END IF;
              -- Kategorie des Redmine-Issues hat sich geändert.
              IF coalesce(old.tracker_id, -1) <> coalesce(new.tracker_id, -1) THEN
                   -- Zeiteinträge in der Prodat-Stempelung anpassen.
                  _sql := format( 'UPDATE bdea SET ba_o2k_id = %L WHERE ba_ix = %L', new.tracker_id, new.id);
                  PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1(test text);
              END IF;
          END IF;

          RETURN new;

--      EXCEPTION WHEN OTHERS THEN
--          GET STACKED DIAGNOSTICS _l_context = PG_EXCEPTION_CONTEXT;
--          RAISE NOTICE 'ERROR:%', _l_context;

--      END;

  END
$BODY$;

ALTER FUNCTION tcimpcs.issues__b_iu__abk_axs()
    OWNER TO redmine;

CREATE TRIGGER issues__b_iu__abk_axs
    BEFORE INSERT OR UPDATE
    ON public.issues
    FOR EACH ROW
    EXECUTE FUNCTION tcimpcs.issues__b_iu__abk_axs();
---
CREATE OR REPLACE FUNCTION public.sync_ticketflags_to_watchers()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
  _ticket_id int;
  _user_id   int;
  _issue     issues;
BEGIN

    raise notice 'TG_RELNAME: %', TG_RELNAME;

    IF ( TG_RELNAME = 'custom_values' ) THEN


        IF (
             -- type must be issue
             new.customized_type <> 'Issue'

             -- 17 = verantwortung
             -- 24 = zu klären mit
          OR new.custom_field_id not in ( 17, 24 )

        ) THEN
            RETURN new;
        END IF;

        SELECT * INTO _issue FROM issues WHERE id = new.customized_id;

        IF ( _issue.created_on > now() - '5'::interval ) THEN
            RETURN new;
        END IF;


        _ticket_id := new.customized_id;
        _user_id   := nullif( new.value, '' )::int;

    END IF;

    IF ( TG_RELNAME = 'issues' ) THEN

        _ticket_id := new.id;
        _user_id   := new.assigned_to_id;

        IF ( new.created_on > now() - '5'::interval ) THEN
            RETURN new;
        END IF;


    END IF;

    -- failsafe
    IF ( _user_id IS NULL OR _ticket_id IS NULL ) THEN
        RETURN new;
    END IF;

    -- insert only if not existing
    IF ( SELECT count( * ) = 0 FROM public.watchers where watchable_id = _ticket_id and user_id = _user_id ) THEN

        insert into public.watchers ( watchable_type, watchable_id, user_id ) values (
          'Issue',
          _ticket_id,
          _user_id
        );

    END IF;

    RETURN new;

END
$BODY$;

ALTER FUNCTION public.sync_ticketflags_to_watchers()
    OWNER TO redmine;

CREATE TRIGGER sync_ticketflags_to_watchers
    AFTER INSERT OR UPDATE
    ON public.issues
    FOR EACH ROW
    EXECUTE FUNCTION public.sync_ticketflags_to_watchers();
---

CREATE OR REPLACE FUNCTION tcimpcs.custom_values__b_u__abk()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$

   DECLARE sql         varchar;
           ab_allg2_   varchar;

 BEGIN
       --IF COALESCE(old.value, '') <> COALESCE(new.value, '') THEN -- UPDATE custom_values SET value = value WHERE custom_field_id = 25 AND NullIf(value,'') IS NOT NULL AND value IN ('0','1')
         --- alter Wert löschen
         sql := FORMAT('UPDATE abk SET ab_stat = TSystem.ENUM_DelValue(ab_stat, %L) WHERE ab_ix = %L',
                                        tcimpcs.custom_field_enumerations__custom_field_id__25__prefix(old.value::VARCHAR), --- alter Wert
                                        new.customized_id);
         PERFORM * FROM dblink(tcimpcs.db_test(), sql) as t1(test text);

         --- neuer Wert speichern
         sql := FORMAT('UPDATE abk SET ab_stat = TSystem.ENUM_SetValue(ab_stat, %L) WHERE ab_ix = %L',
                                       tcimpcs.custom_field_enumerations__custom_field_id__25__prefix(new.value::VARCHAR), --- alter Wert
                                       new.customized_id);
         PERFORM * FROM dblink(tcimpcs.db_test(), sql) as t1(test text);
       --END IF;
   RETURN new;
 END
$BODY$;

ALTER FUNCTION tcimpcs.custom_values__b_u__abk()
    OWNER TO redmine;

CREATE TRIGGER custom_values__b_u__abk
    BEFORE UPDATE OF value
    ON public.custom_values
    FOR EACH ROW
    WHEN (new.custom_field_id = 25)
    EXECUTE FUNCTION tcimpcs.custom_values__b_u__abk();
---
CREATE OR REPLACE FUNCTION public.sync_ticketflags_to_watchers()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
  _ticket_id int;
  _user_id   int;
  _issue     issues;
BEGIN

    raise notice 'TG_RELNAME: %', TG_RELNAME;

    IF ( TG_RELNAME = 'custom_values' ) THEN


        IF (
             -- type must be issue
             new.customized_type <> 'Issue'

             -- 17 = verantwortung
             -- 24 = zu klären mit
          OR new.custom_field_id not in ( 17, 24 )

        ) THEN
            RETURN new;
        END IF;

        SELECT * INTO _issue FROM issues WHERE id = new.customized_id;

        IF ( _issue.created_on > now() - '5'::interval ) THEN
            RETURN new;
        END IF;


        _ticket_id := new.customized_id;
        _user_id   := nullif( new.value, '' )::int;

    END IF;

    IF ( TG_RELNAME = 'issues' ) THEN

        _ticket_id := new.id;
        _user_id   := new.assigned_to_id;

        IF ( new.created_on > now() - '5'::interval ) THEN
            RETURN new;
        END IF;


    END IF;

    -- failsafe
    IF ( _user_id IS NULL OR _ticket_id IS NULL ) THEN
        RETURN new;
    END IF;

    -- insert only if not existing
    IF ( SELECT count( * ) = 0 FROM public.watchers where watchable_id = _ticket_id and user_id = _user_id ) THEN

        insert into public.watchers ( watchable_type, watchable_id, user_id ) values (
          'Issue',
          _ticket_id,
          _user_id
        );

    END IF;

    RETURN new;

END
$BODY$;

ALTER FUNCTION public.sync_ticketflags_to_watchers()
    OWNER TO redmine;

CREATE TRIGGER sync_ticketflags_to_watchers
    AFTER INSERT OR UPDATE
    ON public.custom_values
    FOR EACH ROW
    EXECUTE FUNCTION public.sync_ticketflags_to_watchers();
---
CREATE OR REPLACE FUNCTION tcimpcs.journal_details__a_iu__abk()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$

  DECLARE sql        VARCHAR;
  BEGIN
    --- 'KS Loll' aktualisieren
    PERFORM tcimpcs.abk_ks_refresh((SELECT journalized_id FROM journals WHERE id = new.journal_id));
    RETURN new;
  END
$BODY$;

ALTER FUNCTION tcimpcs.journal_details__a_iu__abk()
    OWNER TO redmine;

CREATE TRIGGER journal_details__a_iu__abk
    AFTER INSERT OR UPDATE
    ON public.journal_details
    FOR EACH ROW
    WHEN (new.prop_key::text = '27'::text)
    EXECUTE FUNCTION tcimpcs.journal_details__a_iu__abk();
---
CREATE OR REPLACE FUNCTION tcimpcs.time_entries__b_iud__bdea_axs()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
  DECLARE
      _sql              varchar;
      _tracker_id       integer;
  BEGIN

      -- Auf Redmine-Issue wurde Zeit gebucht oder angepasst.
      IF tg_op='INSERT' OR tg_op='UPDATE' THEN
          -- Die im zugehörigen Redmine-Issue verwendete TrackerID merken.
          SELECT trackers.id
          INTO _tracker_id
          FROM issues
          JOIN trackers ON issues.tracker_id = trackers.id
          WHERE issues.id = new.issue_id;
      END IF;

      -- Auf Redmine-Issue wurde Zeit gebucht.
      IF tg_op='INSERT' THEN
          -- Die gebuchte Zeit in Prodat auf die ABK stempeln.
          PERFORM tcimpcs.bdea_erstellen_axs(
              _time_entry_id        => new.id,
              _time_entry_user_id   => new.user_id,
              _time_entry_issue_id  => new.issue_id,
              _time_entry_spent_on  => new.spent_on,
              _time_entry_hours     => new.hours,
              _time_entry_comments  => new.comments,
              _issue_tracker_id     => _tracker_id
          );
      END IF;

      -- Von einem Redmine-Issue wurde der Zeitbuchungseintrag angepasst.
      IF tg_op='UPDATE' THEN
          -- Stempelung auf die ABK in Prodat anlegen bzw. aktualisieren.
          IF NOT  tcimpcs.bdea_erstellen_axs(
                      _time_entry_id        => new.id,
                      _time_entry_user_id   => new.user_id,
                      _time_entry_issue_id  => new.issue_id,
                      _time_entry_spent_on  => new.spent_on,
                      _time_entry_hours     => new.hours,
                      _time_entry_comments  => new.comments,
                      _issue_tracker_id     => _tracker_id
                  )
          THEN
              _sql := format(
                          'UPDATE bdea '                  ||
                          'SET ba_minr = %L, '            ||
                          '    ba_ix = %L, '              ||
                          '    ba_anf = %L, '             ||
                          '    ba_efftime = %L, '         ||
                          '    ba_txt = %L '              ||
                          'WHERE ba_time_entries_id = %L;',
                          --
                          coalesce( tcimpcs.llv_ll_minr( new.user_id ), '999' ),  -- ba_minr
                          new.issue_id,                                           -- ba_ix
                          new.spent_on::timestamp,                                -- ba_anf
                          new.hours::numeric(12,4),                               -- ba_efftime
                          new.comments::text,                                     -- ba_txt
                          new.id                                                  -- ba_time_entries_id (WHERE)
              );
              IF new.issue_id IN ( 9193, 17194, 18669 ) THEN
                  PERFORM * FROM dblink( tcimpcs.db_test(), tcimpcs.sql_axs( _sql ) ) AS t1( test text );
              ELSE
                  PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1( test text );
              END IF;
          END IF;
      END IF;

      -- Von einem Redmine-Issue wurde der Zeitbuchungseintrag gelöscht.
      IF tg_op='DELETE' THEN
          _sql := format( 'DELETE FROM bdea WHERE ba_time_entries_id = %L;', old.id );
          IF old.issue_id IN ( 9193, 17194, 18669 ) THEN
              PERFORM * FROM dblink( tcimpcs.db_test(), tcimpcs.sql_axs( _sql ) ) AS t1( test text );
          ELSE
              PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1( test text );
          END IF;
          RETURN old;
      END IF;

      RETURN new;

  END
$BODY$;

ALTER FUNCTION tcimpcs.time_entries__b_iud__bdea_axs()
    OWNER TO redmine;

CREATE TRIGGER time_entries__b_iud__bdea_axs
    BEFORE INSERT OR DELETE OR UPDATE
    ON public.time_entries
    FOR EACH ROW
    EXECUTE FUNCTION tcimpcs.time_entries__b_iud__bdea_axs();
---
CREATE OR REPLACE FUNCTION tcimpcs.abk_erstellen(
  abix integer)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$

   DECLARE
  sql     VARCHAR;
  issues_id   INTEGER;
  issues_parent_id  INTEGER;
  issues_subject    VARCHAR;
  issues_project_id INTEGER;
  issues_created_on DATE;

BEGIN
   IF NOT EXISTS (SELECT t FROM dblink(tcimpcs.db_test(), 'SELECT true FROM abk WHERE ab_ix = ' || abix ||'') AS t1(t BOOLEAN)) THEN

      SELECT id, parent_id, subject, project_id, created_on INTO issues_id, issues_parent_id, issues_subject, issues_project_id, issues_created_on FROM issues WHERE id = abix;

      sql := FORMAT('INSERT INTO abk (ab_ix,
                                      ab_parentabk,
              ab_ap_nr,
              ab_ap_bem,
              ab_tablename,
              ab_keyvalue,
              ab_dbrid,
              ab_dat)
                     VALUES(          %L, %L, %L, %L, %L, %L, %L)',
                                      issues_id,
                                      issues_parent_id,
                                      'REDMINE',
                                      issues_subject::VARCHAR(100),
                                      CASE WHEN tcimpcs.anl_dbrid(tcimpcs.pName(issues_project_id)) IS NOT NULL THEN 'anl' ELSE NULL END,
                                      tcimpcs.pName(issues_project_id) || '-REDMINE',
                                      tcimpcs.anl_dbrid(tcimpcs.pName(issues_project_id)),
                                      issues_created_on);
       PERFORM * FROM dblink(tcimpcs.db_test(), sql) as t1(test text);
  --RAISE NOTICE '%', sql;
   END IF;
END
$BODY$;

ALTER FUNCTION tcimpcs.abk_erstellen(integer)
    OWNER TO redmine;
---
CREATE OR REPLACE FUNCTION tcimpcs.abk_erstellen_axs(
  _issue_id integer,
  _issue_parent_id integer,
  _issue_subject character varying,
  _issue_project_id integer,
  _issue_created_on timestamp without time zone)
    RETURNS boolean
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$
  DECLARE
      _result boolean; -- Gibt zurück, ob die ABK angelegt werden musste oder mit anderen Worten, ob die ABK noch nicht exisiert hatte.
      _sql    varchar;
      _l_context text;

  BEGIN

--      BEGIN

          -- Im Prodat Projekt anlegen, falls es nicht schon angelegt ist. Dafür ProjektID aus Redmine verwenden.
          _sql := format(
              'INSERT INTO anl( an_nr , an_bez  ) ' ||
              '        VALUES ( %L    , %L      ) ' ||
              'ON CONFLICT (an_nr) ' ||
              'DO ' ||
              'NOTHING;',
              --
              (tcimpcs.pName( _issue_project_id ) || '-REDMINE')::varchar(50), -- an_nr
              (tcimpcs.pName( _issue_project_id ) || '-REDMINE')::varchar(100) -- an_bez
          );
          IF _issue_id IN ( 9193, 17194, 18669 ) THEN
              PERFORM * FROM dblink( tcimpcs.db_test() , tcimpcs.sql_axs( _sql ) ) AS t1( test text );
          ELSE
              PERFORM * FROM dblink( tcimpcs.db_test() , _sql ) AS t1( test text );
          END IF;

          -- Prüfen, ob die zum Redmine-Issue zugehörige ABK bereits in Prodat vorhanden ist.
          _sql := format( 'SELECT true FROM abk WHERE ab_ix = %L;', _issue_id );
          _result := NOT EXISTS( SELECT t FROM dblink( tcimpcs.db_test(), _sql ) AS t1( t BOOLEAN ) );

          -- Falls nicht, die ABK in Prodat anlegen.
          IF _result THEN
              _sql := format(
                          'INSERT INTO abk( ab_ix , ab_parentabk , ab_ap_nr , ab_ap_bem , ab_tablename , ab_keyvalue , ab_an_nr , ab_dbrid , ab_dat , ab_stat ) ' ||
                          '         VALUES( %L    , %L           , %L       , %L        , %L           , %L          , %L       , %L       , %L     , %L      );',
                          --
                          _issue_id,                                                                                              -- ab_ix
                          _issue_parent_id,                                                                                       -- ab_parentabk
                          'REDMINE',                                                                                              -- ab_ap_nr
                          _issue_subject::varchar(100),                                                                           -- ab_ap_bem
                          CASE WHEN tcimpcs.anl_dbrid( tcimpcs.pName( _issue_project_id ) ) IS NOT NULL THEN 'anl' ELSE NULL END, -- ab_tablename
                          (tcimpcs.pName( _issue_project_id ) || '-REDMINE')::varchar(50),                                        -- ab_keyvalue
                          (tcimpcs.pName( _issue_project_id ) || '-REDMINE')::varchar(50),                                        -- ab_an_nr
                          tcimpcs.anl_dbrid( tcimpcs.pName( _issue_project_id ) )::varchar(100),                                  -- ab_dbrid
                          _issue_created_on,                                                                                      -- ab_dat
                          coalesce(
                              (
                                  SELECT trim( substring( name, 1, position( '-' in name ) - 1 ) ) AS name_kurz
                                  FROM custom_values
                                  JOIN LATERAL (SELECT name FROM custom_field_enumerations WHERE id::VARCHAR = value::VARCHAR) AS name ON true
                                  WHERE     custom_field_id = 25  -- 'PSP Klasse'
                                        AND customized_id = _issue_id
                              ),
                              ''
                          )                                                                                                       -- ab_stat
              );
              IF _issue_id IN ( 9193, 17194, 18669 ) THEN
                  PERFORM * FROM dblink( tcimpcs.db_test(), tcimpcs.sql_axs( _sql ) ) AS t1( test text );
              ELSE
                  PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1( test text );
              END IF;
              --RAISE NOTICE '%', sql;
          END IF;

--      EXCEPTION WHEN OTHERS THEN
--          GET STACKED DIAGNOSTICS _l_context = PG_EXCEPTION_CONTEXT;
--          RAISE NOTICE 'ERROR:%', _l_context;

--      END;

          -- Zurückgeben, ob die ABK noch nicht in Prodat vorhanden war.
          RETURN _result;

  END
$BODY$;

ALTER FUNCTION tcimpcs.abk_erstellen_axs(integer, integer, character varying, integer, timestamp without time zone)
    OWNER TO redmine;
---
CREATE OR REPLACE FUNCTION tcimpcs.abk_ks_refresh(
  _issues_id integer)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$

  DECLARE sql       VARCHAR;
          ks        VARCHAR;
          abk_dbrid VARCHAR;
  BEGIN

    RAISE NOTICE '_issues_id = %', _issues_id;

    SELECT value INTO ks FROM journals AS j
                            JOIN journal_details AS jd ON j.id = journal_id
                         WHERE prop_key = '27' AND journalized_id = _issues_id
                         ORDER BY jd.id DESC
                         LIMIT 1;

    sql := FORMAT( 'UPDATE abk SET ab_txt = %L WHERE ab_ix = %s', ks, _issues_id );
    PERFORM * FROM dblink( tcimpcs.db_test(), sql ) as t1( test text );

    --- Parameter (RecNoKeyword)
    sql := FORMAT('SELECT dbrid FROM abk WHERE ab_ix = %L', _issues_id);
    SELECT abkdbrid INTO abk_dbrid FROM dblink(tcimpcs.db_test(), sql) as t1(abkdbrid VARCHAR);

    IF abk_dbrid IS NOT NULL THEN
       IF ks IS NOT NULL AND length(ks) > 0 THEN
          ---                                                                    rkategorie, rtablename,      rdescr,            rdbrid, rvalue, pname,        runit
          sql := FORMAT('SELECT TSystem.CreateKeyword(%L, %L, %L, %L, %L, %L, %L)', 'redmine', 'abk', 'KST Loll (Redmine)', abk_dbrid, ks, 'ABK.KS_LOLL', 'Kostenstelle');
          PERFORM * FROM dblink(tcimpcs.db_test(), sql) as t1(abkdbrid VARCHAR);
       ELSE   --- Parameter löschen
          ---                                                          rkategorie,   rdbrid ,           rdescr        ,      pname
          sql := FORMAT('SELECT TSystem.DeleteKeyword(%L, %L, %L, %L)', 'redmine', abk_dbrid, 'KST Loll (Redmine)', 'ABK.KS_LOLL');
          PERFORM * FROM dblink(tcimpcs.db_test(), sql) as t1(abkdbrid VARCHAR);
       END IF;
    ENd IF;
    ---
 END
$BODY$;

ALTER FUNCTION tcimpcs.abk_ks_refresh(integer)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.aeoeue_upper(
  character varying)
    RETURNS character varying
    LANGUAGE 'plpgsql'
    COST 100
    IMMUTABLE PARALLEL UNSAFE
AS $BODY$

 DECLARE s VARCHAR;
        InPut ALIAS FOR $1;
 BEGIN
  s:=InPut;
  s:=replace(s, chr(246), 'o');--ö
  s:=replace(s, chr(214), 'O');--Ö
   s:=replace(s, chr(252), 'u');--ü
  s:=replace(s, chr(220), 'U');--Ü
  s:=replace(s, chr(228), 'a');--ä
  s:=replace(s, chr(196), 'A');--Ä
  RETURN Upper(s);
 END
$BODY$;

ALTER FUNCTION tcimpcs.aeoeue_upper(character varying)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.anl_dbrid(
  _project_name character varying)
    RETURNS character varying
    LANGUAGE 'plpgsql'
    COST 100
    IMMUTABLE PARALLEL UNSAFE
AS $BODY$

 DECLARE result VARCHAR;
  prname  VARCHAR   := _project_name || '-REDMINE';
 BEGIN
  SELECT dbrid INTO result
            FROM dblink(tcimpcs.db_test(), 'SELECT dbrid FROM anl WHERE an_nr = ''' || prname || '''') AS t1(dbrid VARCHAR);
  RETURN result;
 END
$BODY$;

ALTER FUNCTION tcimpcs.anl_dbrid(character varying)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.bdea_erstellen_axs(
  _time_entry_id integer,
  _time_entry_user_id integer,
  _time_entry_issue_id integer,
  _time_entry_spent_on date,
  _time_entry_hours double precision,
  _time_entry_comments character varying,
  _issue_tracker_id integer)
    RETURNS boolean
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$
  DECLARE
      _result boolean; -- Gibt zurück, ob die BDE Auftragszeitstempelung angelegt werden musste oder mit anderen Worten, ob die BDE Auftragszeitstempelung noch nicht exisiert hatte.
      _sql    varchar;
  BEGIN

      -- Falls in Prodat noch nicht vorhanden, die zur zu erstellenden BDE Auftragszeitstempelung zugehörige ABK anlegen.
      PERFORM tcimpcs.abk_erstellen_axs(
                  _issue_id         => issues.id,
                  _issue_parent_id  => issues.parent_id,
                  _issue_subject    => issues.subject,
                  _issue_project_id => issues.project_id,
                  _issue_created_on => issues.created_on
              )
      FROM issues
      WHERE id = _time_entry_issue_id;

      -- Prüfen, ob die zum Redmine-Time Entry zugehörige BDE Auftragszeitstempelung bereits in Prodat vorhanden ist.
      _sql := format( 'SELECT true FROM bdea WHERE ba_time_entries_id = %L;', _time_entry_id );
      _result := NOT EXISTS( SELECT t FROM dblink( tcimpcs.db_test(), _sql ) AS t1( t BOOLEAN ) );

      -- Falls nicht, die BDE Auftragszeitstempelung in Prodat anlegen.
      IF _result THEN
          _sql := format(
                      'INSERT INTO bdea( ba_time_entries_id , ba_minr , ba_ks , ba_ix , ba_op , ba_o2k_id , ba_anf, ba_efftime , ba_txt ) ' ||
                      '          VALUES( %L                 , %L      , %L    , %L    , %L    , %L        , %L    , %L         , %L     );',
                      --
                      _time_entry_id,                                                 -- ba_time_entries_id
                      coalesce( tcimpcs.llv_ll_minr( _time_entry_user_id ), '999' ),  -- ba_minr
                      'PROG',                                                         -- ba_ks
                      _time_entry_issue_id,                                           -- ba_ix
                      10,                                                             -- ba_op
                      _issue_tracker_id,                                              -- ba_o2k_id
                      _time_entry_spent_on::timestamp,                                -- ba_anf
                      _time_entry_hours::numeric(12,4),                               -- ba_efftime
                      _time_entry_comments::text                                      -- ba_txt
          );
          IF _time_entry_issue_id IN ( 9193, 17194, 18669 ) THEN
              PERFORM * FROM dblink( tcimpcs.db_test(), tcimpcs.sql_axs( _sql ) ) AS t1( test text );
          ELSE
              PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1( test text );
          END IF;
          --RAISE NOTICE '%', sql;
      END IF;

      -- Zurückgeben, ob die ABK noch nicht in Prodat vorhanden war.
      RETURN _result;

  END
$BODY$;

ALTER FUNCTION tcimpcs.bdea_erstellen_axs(integer, integer, integer, date, double precision, character varying, integer)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.cimpcs_pname(
  _project_id integer DEFAULT 0)
    RETURNS character varying
    LANGUAGE 'plpgsql'
    COST 100
    IMMUTABLE PARALLEL UNSAFE
AS $BODY$

 BEGIN
  RETURN (SELECT upper(name) FROM projects WHERE id = _project_id);
 END
$BODY$;

ALTER FUNCTION tcimpcs.cimpcs_pname(integer)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.custom_field_enumerations__custom_field_id__25__prefix(
  _custom_values__value character varying)
    RETURNS character varying
    LANGUAGE 'plpgsql'
    COST 100
    STABLE PARALLEL UNSAFE
AS $BODY$

  BEGIN
   RETURN (SELECT trim(substring(name, 1, position('-' in name) - 1)) AS name_kurz FROM custom_field_enumerations WHERE id::VARCHAR = _custom_values__value::VARCHAR);
  END
$BODY$;

ALTER FUNCTION tcimpcs.custom_field_enumerations__custom_field_id__25__prefix(character varying)
    OWNER TO redmine;

---


CREATE OR REPLACE FUNCTION tcimpcs.db_test(
  )
    RETURNS text
    LANGUAGE 'plpgsql'
    COST 100
    STABLE PARALLEL UNSAFE
AS $BODY$

BEGIN
    RETURN 'host=pg.prodat-sql.de dbname=CIMPCS port=5433 user=postgres password=sysdba';
  END
$BODY$;

ALTER FUNCTION tcimpcs.db_test()
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.llv_ll_minr(
  _usert_id integer DEFAULT 0)
    RETURNS integer
    LANGUAGE 'plpgsql'
    COST 100
    IMMUTABLE PARALLEL UNSAFE
AS $BODY$

 BEGIN
  RETURN(SELECT t FROM dblink(tcimpcs.db_test(), 'SELECT ll_minr FROM llv WHERE ll_allg1 = ''' || (SELECT login FROM users WHERE id = _usert_id) ||'''') AS t1(t INTEGER));
 END
$BODY$;

ALTER FUNCTION tcimpcs.llv_ll_minr(integer)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.pname(
  _project_id integer DEFAULT 0)
    RETURNS character varying
    LANGUAGE 'plpgsql'
    COST 100
    IMMUTABLE PARALLEL UNSAFE
AS $BODY$

 BEGIN
  RETURN (SELECT upper(tcimpcs.aeoeue_upper(name)) FROM projects WHERE id = _project_id);
 END
$BODY$;

ALTER FUNCTION tcimpcs.pname(integer)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.sql_axs(
  _sql text)
    RETURNS text
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$
  DECLARE
      _return text;

  BEGIN

      _return := format( 'SELECT tredmine_sync.wrapper_axs( %L );', _sql );

      RETURN _return;

  END
$BODY$;

ALTER FUNCTION tcimpcs.sql_axs(text)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.syncro(
  _start_datum date,
  _end_datum date)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$
  DECLARE
      _sql    varchar;
  BEGIN

      -- Issues synchronisieren.
      -- Rufe dafür über das folgende Update-Kommando die Triggerfunktion tcimpcs.issues__b_iu__abk() für die entsprechenden Redmine-Issues im gegebenen Zeitfenster.
      UPDATE issues
      SET id = id
      WHERE EXISTS ( SELECT 1 FROM time_entries WHERE issue_id = issues.id AND time_entries.spent_on BETWEEN _start_datum AND _end_datum );

      -- Lösche alle Stempelungen auf entsprechende ABKs im gegebenen Zeitfenster.
      _sql := format(
          'DELETE FROM bdea '                                                     ||
          'WHERE ba_ix IN (SELECT ab_ix FROM abk WHERE ab_ap_nr = ''REDMINE'') '  ||
          '  AND ba_anf BETWEEN %L AND %L;',
          --
          _start_datum,
          _end_datum
      );
      PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1( test text );

      -- Zeitbuchungen synchronisieren.
      -- Rufe dafür über das folgende Update-Kommando die Triggerfunktion tcimpcs.time_entries__b_iud__bdea() für die entsprechenden Redmine-Zeitbuchungen im gegebenen Zeitfenster.
      UPDATE time_entries
      SET id = id
      WHERE     spent_on BETWEEN _start_datum AND _end_datum;

  END
$BODY$;

ALTER FUNCTION tcimpcs.syncro(date, date)
    OWNER TO redmine;

---
CREATE OR REPLACE FUNCTION tcimpcs.syncro_axs(
  _start_datum date,
  _end_datum date,
  _ticket_nr integer)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$
  DECLARE
      _sql    varchar;
  BEGIN

      -- Issues synchronisieren.
      -- Rufe dafür über das folgende Update-Kommando die Triggerfunktion tcimpcs.issues__b_iu__abk() für die entsprechenden Redmine-Issues im gegebenen Zeitfenster.
      UPDATE issues
      SET id = id
      WHERE EXISTS ( SELECT 1 FROM time_entries WHERE issue_id = issues.id AND time_entries.spent_on BETWEEN _start_datum AND _end_datum AND time_entries.issue_id = _ticket_nr );

      -- Lösche alle Stempelungen auf entsprechende ABKs im gegebenen Zeitfenster.
      _sql := format(
          'DELETE FROM bdea '                                                     ||
          'WHERE ba_ix IN (SELECT ab_ix FROM abk WHERE ab_ap_nr = ''REDMINE'') '  ||
          '  AND ba_anf BETWEEN %L AND %L '                                       ||
          '  AND ba_ix = %L;',
          --
          _start_datum,
          _end_datum,
          _ticket_nr
      );
      IF _ticket_nr IN ( 9193, 17194, 18669 ) THEN
          PERFORM * FROM dblink( tcimpcs.db_test(), tcimpcs.sql_axs( _sql ) ) AS t1( test text );
      ELSE
          PERFORM * FROM dblink( tcimpcs.db_test(), _sql ) AS t1( test text );
      END IF;


      -- Zeitbuchungen synchronisieren.
      -- Rufe dafür über das folgende Update-Kommando die Triggerfunktion tcimpcs.time_entries__b_iud__bdea() für die entsprechenden Redmine-Zeitbuchungen im gegebenen Zeitfenster.
      UPDATE time_entries
      SET id = id
      WHERE     spent_on BETWEEN _start_datum AND _end_datum
            AND issue_id = _ticket_nr;

  END
$BODY$;

ALTER FUNCTION tcimpcs.syncro_axs(date, date, integer)
    OWNER TO redmine;