CREATE OR REPLACE FUNCTION tdms.picndoku__dokuments__from__ab2__by__a2_id(
      _ab2_a2_id int
  ) RETURNS SETOF picndoku
  AS $$
  DECLARE
      _artikel_nr text;
      _kostenstelle text;
  BEGIN
  

      SELECT ab_ap_nr, a2_ks
        INTO _artikel_nr, _kostenstelle
        FROM ab2
        JOIN abk ON ab2.a2_ab_ix = abk.ab_ix
       WHERE a2_id = _ab2_a2_id
      ;
  
      
      RETURN QUERY
      
          -- default documents from picndoku
          SELECT picndoku.*
            FROM picndoku
           WHERE pd_dokident = _ab2_a2_id
        
        UNION
        
          -- documents linked against ksv and art
          SELECT picndoku.*
            FROM tdms.dokument__pd_ids__by__keyword_list(
                    array[ 
                      ( 'art', _artikel_nr ),
                      ( 'ksv', _kostenstelle )
                    ]::tdms.dokument__kategorie__descr[],
                    'picture.ab2'
                 ) AS _documents
            JOIN picndoku on _documents.pdid = picndoku.pd_id
      ;

  END $$ LANGUAGE plpgsql STABLE;
